import { EVENT_STATE_UPDATE, PLAYBACK_PAUSED, PLAYBACK_ENDED } from '../state-tracker';

export class PlayerUIState {

    constructor(root, state) {
        this._root = root;
        this._state = state;
        this._state.addEventListener(EVENT_STATE_UPDATE, this.handleEvent.bind(this));
    }

    handleEvent() {
        $(this._root).attr({
            'data-paused': this._state.playback === PLAYBACK_PAUSED,
            'data-ended': this._state.playback === PLAYBACK_ENDED,
            'data-loading': this._state.isLoading,
        });
    }

    /**
     *
     */
    destroy() {
    }
}
