import { EVENT_STATE_UPDATE } from '../state-tracker';

export class PlayerUIStats {
    constructor (root, state) {
        this._state = state;
        this._root = root;
        $(this._root).on('click', '.js-stats-toggle', e => {
            e.preventDefault();
            this.toggleStats();
        });
        this._state.addEventListener(EVENT_STATE_UPDATE, this.handleEvent.bind(this));
    }

    handleEvent() {
        $('.js-stat-buffer-size', this._root).text(this._state.stats.bufferSize);
        $('.js-stat-display-resolution', this._root).text(this._state.stats.displayResolution);
        $('.js-stat-skipped-frames', this._root).text(this._state.stats.skippedFrames);
        $('.js-stat-fps', this._root).text(this._state.stats.fps);
        $('.js-stat-hls-latency-broadcaster', this._root).text(this._state.stats.hlsLatencyBroadcaster);
        $('.js-stat-hls-latency-encoder', this._root).text(this._state.stats.hlsLatencyEncoder);
        $('.js-stat-memory-usage', this._root).text(this._state.stats.memoryUsage);
        $('.js-stat-playback-rate', this._root).text(this._state.stats.playbackRate);
        $('.js-stat-player-volume', this._root).text(this._state.stats.playerVolume);
        $('.js-stat-video-resolution', this._root).text(this._state.stats.videoResolution);
    }

    toggleStats() {
        var statsElem = $('.js-playback-stats', this._root);
        var toggleElem = $('.js-stats-toggle-text', this._root);

        // toggle visibility; if on, become off, and vice versa
        const enabled = statsElem.attr('data-state') !== 'on';

        statsElem.attr('data-state', enabled ? 'on' : 'off');
        toggleElem.text(enabled ? 'Hide Video Stats' : 'Show Video Stats');
    }

    /**
     *
     */
    destroy() {
        $(this._root).off('click');
    }
}
