import { EVENT_STATE_UPDATE } from '../state-tracker';
import { twitchHost } from '../settings';

const SUBSCRIBER_ONLY_TEXT = 'This video is only available to subscribers. Subscribe now to watch and support %s.';

// Shows an overlay for channels with paywalled VODs.
export class PlayerUISubscribeOverlay {
    constructor(root, state) {
        this._root = root;
        this._state = state;
        this._state.addEventListener(EVENT_STATE_UPDATE, this.handleEvent.bind(this));
    }

    handleEvent() {
        if (this._state.videoID && this._state.isVODRestricted()) {
            this._showVODOverlay();
        }
    }

    _showVODOverlay() {
        $('.js-player-product-overlay', this._root).attr('data-active', true);
        $('.js-player-product-close', this._root).attr('data-active', false);

        this._state.getVideoInfo(this._state.videoID).
            then(videoInfo => {
                const message = this._state.i18n.translate(SUBSCRIBER_ONLY_TEXT, {
                    replacements: {
                        '%s': videoInfo.channel.name,
                    },
                });
                $('.js-player-product p', this._root).text(message);
                $('.js-player-product .purchase_button', this._root).attr('href', `${twitchHost}/${videoInfo.channel.name}/subscribe?ref=chansub_overlay_subscribe`);
            });
    }

    /**
     *
     */
    destroy() { }
}
