import * as cookie from 'cookie_js';
import * as UniqueId from './unique-id';
import * as Settings from '../settings';

// Returns either the device_id or session_device_id from cookies.
// If none exists, then we generate and store one.
export function get(session) {
    var key = session ? 'session_unique_id' : 'unique_id';
    var uniqueId = cookie.get(key);
    if (uniqueId) {
        return uniqueId;
    }

    uniqueId = UniqueId.generate();

    // These cookie settings are VERY important.
    // "" = session cookie, otherwise expire the cookie in 10 years.
    var expires = session ? '' : 10 * 365;
    cookie.set(key, uniqueId, {
        expires: expires,
        domain: `.${Settings.domain}`,
        path: '/',
        secure: false,
    });

    return uniqueId;
}
