function ExtendableTimeout(callback, duration, estimate) {
    this._estimate = estimate;
    this._handle = setTimeout(callback, duration);
}

// Given a previous timeout, creates or returns the latest timeout.
// This works by estimating the millisecond when a timeout will fire.
// If the old timeout will occur sooner than the new timeout, cancel it.
//
// example:
//   var timeout;
//   timeout = extendTimeout(timeout, callback, 1000);
//   timeout = extendTimeout(timeout, callback, 5000);
//   timeout = extendTimeout(timeout, callback, 3000);
//
// "callback" will fire once 5 seconds later.
export function extendTimeout(exTimeout, callback, duration) {
    var now;
    if (Date.now) {
        now = Date.now();
    } else {
        // IE8 support
        now = (new Date()).getTime();
    }

    var estimate = now + duration;

    if (exTimeout && exTimeout._estimate > estimate) {
        return exTimeout;
    } else {
        if (exTimeout) {
            clearTimeout(exTimeout._handle);
        }

        return new ExtendableTimeout(callback, duration, estimate);
    }
}
