// Parse the query params into an object.
export function parse(query) {
    var params = {};

    var parts = query.split('&');
    for (var i = 0; i < parts.length; i++) {
        // support key=value, key, !key, key=true, key=false
        var result = /^(.+?)(?:=(.+))?$/.exec(parts[i]);
        if (!result) continue;

        var key = result[1];
        var value = result[2];

        // Parse all of the possible options; order matters.
        if (value === 'true') {
            // key=true
            value = true;
        } else if (value === 'false') {
            // key=false
            value = false;
        } else if (value !== undefined) {
            // key=value
            value = decodeURIComponent(value);
        } else if (key[0] === '!') {
            // !key
            key = key.substring(1);
            value = false;
        } else {
            // key
            value = true;
        }

        params[key] = value;
    }

    return params;
}

// Reverse operation of the above, convert an object into a string.
export function toString(options) {
    var parts = [];

    for (var key in options) {
        if (options.hasOwnProperty(key)) {
            var value = options[key];
            key = encodeURIComponent(key);

            if (value === true) {
                parts.push(key);
            } else if (value === false) {
                parts.push(`!${key}`);
            } else {
                value = encodeURIComponent(value);
                parts.push(`${key}=${value}`);
            }
        }
    }

    return parts.join('&');
}
