/* global Twitch */
import { isTwitchEmbed } from './twitch-embed';

export const PLAYER_SITE = 'site';
export const PLAYER_EMBED = 'embed';
export const PLAYER_POPOUT = 'popout';
export const PLAYER_FRONTPAGE = 'frontpage';
// other known types, but without known ways to deduce them:
// export const PLAYER_HIGHLIGHTER = "highlighter";
// export const PLAYER_FACEBOOK = "facebook";

/**
 * Deduce the type of the player from the context of the page.
 *
 * @return {String}
 */
export function getPlayerType() {
    // Weird name, but only good way of detecting our include mode.
    var isScript = !Twitch.notScript;
    var isEmbed = function() {
        try {
            return window.self !== window.top;
        } catch (e) {
            // Access was denied, which means we are an iframe.
            return true;
        }
    };

    if (isScript) {
        return PLAYER_SITE;
    } else if (isEmbed() && !isTwitchEmbed()) {
        return PLAYER_EMBED;
    } else {
        return PLAYER_POPOUT;
    }
}
