// Wrapper around window.sessionStorage that JSON encodes/decodes objects.
var sessionStorageJSON = {};

export default sessionStorageJSON;

(function() {
    var self = sessionStorageJSON;

    self.key = function(index) {
        return sessionStorage.key(index);
    };

    self.getItem = function(key) {
        var data = sessionStorage.getItem(key);
        if (!data) {
            return;
        }

        return JSON.parse(data);
    };

    self.setItem = function(key, value) {
        var data = JSON.stringify(value);
        sessionStorage.setItem(key, data);
    };

    self.removeItem = function(key) {
        sessionStorage.removeItem(key);
    };

    self.clear = function() {
        sessionStorage.clear();
    };

    Object.defineProperty(self, 'length', {
        get() {
            return sessionStorage.length;
        },
    });
})();
