/**
 * Supports "12h34m56s", "12:34:56", and just "45296".
 *
 * @param {String} str The time to parse.
 * @return {Int}
 */
export function parse(str) {
    var regex = /^(?:(\d+)[h])?(?:(\d+)[m])?(?:(\d+)[s])?$/;
    var match = regex.exec(str);

    if (!match) {
        return null;
    }

    var value = 0;
    for (var i = 1; i < match.length; i++) {
        var num = parseInt(match[i], 10) || 0;
        value = value * 60 + num;
    }

    return value;
}

/**
 * Returns a time broken into array values from.
 *
 * @param {Int} time The time to parse in seconds.
 * @param {Boolean} clean If the array should remove values of 0.
 * @return {Array}
 */
export function toArray(time, clean) {
    var parts = [
        (time / 3600), // hours
        (time / 60) % 60, // minutes
        time % 60, // seconds
    ];

    if (clean) {
        while (parts.length && parts[0] < 1) {
            parts.shift();
        }
    }

    for (var i = 0; i < parts.length; i++) {
        var rounded = Math.floor(parts[i]);
        parts[i] = (rounded < 10) ? `0${rounded}` : rounded;
    }

    return parts;
}

/**
 * Returns a time in seconds in the format "xx:yy:zz"
 *
 * @param {Int} time The time to parse in seconds.
 * @param {Boolean} clean If the array should remove values of 0.
 * @return {String}
 */
export function toString(time, clean) {
    var parts = toArray(time, clean);

    return parts.join(':');
}

/**
 * Returns a time in seconds as a URL ready string. "11h22m33s"
 *
 * @param {Int} time The time to parse in seconds.
 * @return {String}
 */
export function toURLString(time) {
    var parts = toArray(time, true);
    var times = ['h', 'm', 's'];
    var output = '';

    parts = parts.reverse();
    times = times.reverse();
    for (var i = 0; i < parts.length; i++) {
        output = parts[i] + times[i] + output;
    }

    return output;
}
