import { parseUri } from './parseuri';
import * as Settings from '../settings';

// Returns true if we are embedded or running on twitch.tv
export function isTwitchEmbed() {
    // Get the window or referral url.
    var url;
    if (window.self !== window.parent) {
        url = document.referrer;
    } else {
        url = window.location.href;
    }

    var uri = parseUri(url);

    // Get the last two parts of the domain.
    // TODO Move this into another library.
    var topLevelHost = uri.host.split('.').slice(-2).join('.');

    // Make sure we're a subdomain of twitch.tv
    return topLevelHost === Settings.domain;
}
