# Variables
variable "env" {
  default = "video-playback"
}

# UPDATE ME
variable "owner" {
  default = "video-playback"
}

# Module that creates AWS resources: see https://git-aws.internal.justin.tv/web/web-stage
module "staging" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/web-stage.git?ref=v1.1"
  env = "${var.env}"
  app_env = "staging"
  count = 2 
  owner = "${var.owner}"
  vpc_id = "vpc-230f5e46"
  subnet_ids = "subnet-b0af88d5,subnet-1c76336b,subnet-c1d54a98"
  security_group_id = "sg-c06b03a4"
  profile = "twitch-web-dev"
  dns_profile = "twitch-aws"
}

# Output section
# DNS Records
output "dns-api" {
 value = "${module.staging.api}"
}

output "dns-www" {
 value = "${module.staging.www}"
}

output "dns-secure" {
 value = "${module.staging.secure}"
}

output "dns-www-cdn" {
 value = "${module.staging.www-cdn}"
}

output "dns-admin" {
 value = "${module.staging.admin}"
}

output "dns-web-client" {
 value = "${module.staging.web-client-elb}"
}

output "instance-app" {
  value = "${module.staging.app}"
}

output "instance-web" {
  value = "${module.staging.web}"
}

output "instance-web-client" {
  value = "${module.staging.web-client}"
}
