import Player from 'player'; // eslint-disable-line no-unused-vars

QUnit.testIf = function(predicate, desc, callback) {
    if (predicate) {
        return QUnit.test(desc, callback);
    } else {
        return QUnit.skip(desc, callback);
    }
};
const inHeadlessBrowser = /PhantomJS/.test(window.navigator.userAgent);

QUnit.module('captions', function (hooks) {
    hooks.beforeEach(function() {
        $('#qunit-fixture').append('<div id="root"></div>');
    });

    QUnit.testIf(!inHeadlessBrowser, 'can display caption data', function (assert) {
        new Twitch.Player('root', { captions: true });
        var es = [
            {
                event: 'captions',
                data: {
                    format: 'eia608',
                    mode: 'pop-on',
                    rollUp: 0,
                    data: [
                        { row: 0, col: 0, char: 'L', style: 'white' },
                        { row: 0, col: 1, char: 'a', style: 'white' },
                        { row: 0, col: 3, char: 'n', style: 'white' },
                        { row: 0, col: 4, char: 'd', style: 'white' },
                        { row: 0, col: 5, char: 'o', style: 'white' },

                    ],
                },
            },
        ];
        // Fire first caption, to signal captions enabled
        window._BackendFlash_emitEvents('0', es);

        var done = assert.async();
        // Wait for player to render
        setTimeout(function() {
            // Turn on captions
            $('.js-control-cc', '#root').trigger('click');

            // Fire our next caption event
            window._BackendFlash_emitEvents('0', es);

            var actualCaption = $('.js-player-captions').text();
            var expectedCaption = 'Lando'; // great pig
            assert.equal(actualCaption, expectedCaption);
            done();
        }, 200);
    });
});
