import Player from 'player'; // eslint-disable-line no-unused-vars

QUnit.module('player', function (hooks) {
    hooks.beforeEach(function() {
        $('#qunit-fixture').append('<div id="root"></div>');
    });

    QUnit.test('can instantiate player within root div', function(assert) {
        var options = {
            width: 854,
            height: 480,
            channel: 'monstercat',
        };
        var player = new Twitch.Player('root', options);
        player.setVolume(0.5);
        assert.ok(player, 'Player was instantiated!');
    });

    QUnit.test('can destroy the player instance', function(assert) {
        let options = {
            width: 854,
            height: 480,
            channel: 'monstercat',
        };
        let player = new Twitch.Player('root', options);
        assert.notDeepEqual(player.getEventEmitter()._getEvents(), {}, 'Player has events to destroy!');
        player.destroy();
        assert.deepEqual(player.getEventEmitter()._getEvents(), {}, 'All player events were fully destroyed!');
    });
});
