import { State,
    EVENT_AD_START,
    EVENT_AD_END,
    EVENT_CAPTION_UPDATE,
} from 'state-tracker';

QUnit.module('State', function (hooks) {
    hooks.beforeEach(function () {
        var caption = {
            format: 'eia608',
            mode: 'pop-on',
            rollUp: 0,
            data: [
                { row: 0, col: 0, char: 'F', style: 'white' },
            ],
        };
        this.caption = caption;
        this.backend = {
            getCaption() {
                return caption;
            },
            addEventListener() {
                return;
            },
        };
        this.pubsub = {
            addEventListener() {
                return;
            },
        };
        this.fullscreen = {
            addEventListener() {
                return;
            },
        };
        this.options = {};
        this.state = new State(this.backend, this.pubsub, this.fullscreen, null, this.options);
    });

    QUnit.test('clears captions on ad_start events', function (assert) {
        this.state.setCaptionsEnabled(true);
        assert.deepEqual(this.state.getCaption(), this.caption);

        this.state.handleEvent(EVENT_AD_START);
        assert.equal(this.state.getCaption(), null);

        this.state.handleEvent(EVENT_AD_END);
        assert.deepEqual(this.state.getCaption(), this.caption);
    });

    QUnit.test('sets a flag upon receiving caption stream', function (assert) {
        assert.equal(this.state.hasCaptions(), false);
        this.state.handleEvent(EVENT_CAPTION_UPDATE);
        assert.equal(this.state.hasCaptions(), true);
    });

    QUnit.module('getting and setting captionsEnabled', function() {
        QUnit.test('defaults to captions disabled', function(assert) {
            assert.equal(this.state.getCaptionsEnabled(), false);
        });

        QUnit.test('can change value of captionsEnabled', function(assert) {
            assert.equal(this.state.getCaptionsEnabled(), false);

            this.state.setCaptionsEnabled(true);
            assert.equal(this.state.getCaptionsEnabled(), true);
        });
    });

    QUnit.module('getCaption', function() {
        QUnit.test('shows no captions if captions are disabled', function(assert) {
            assert.equal(this.state.getCaption(), null);
        });
    });
});
