import { EVENT_STATE_UPDATE }   from 'state-tracker';
import { PlayerUIClosedCaption } from 'ui/closed-caption';

QUnit.module('PlayerUIClosedCaption', function (hooks) {
    hooks.beforeEach(function () {
        this.state = {
            getCaption() {
                return;
            },
            addEventListener(_, callback) {
                this.callback = callback;
            },
            emitFakeEvent(eventName) {
                this.callback(eventName);
            },
            hasCaptions() {
                return false;
            },
            getCaptionsEnabled() {
                return !!(this._captionsEnabled);
            },
            setCaptionsEnabled(bool) {
                this._captionsEnabled = bool;
                this.emitFakeEvent(EVENT_STATE_UPDATE);
            },
        };

        var template =  '<div class="js-player-captions"></div>' +
                        '<button class="js-control-cc">' +
                            '<svg class="js-player-icon-cc"></svg>' +
                            '<svg class="js-player-icon-cc-deactivated"></svg>' +
                        '</button>';

        $('#qunit-fixture').append(template);

        this.root = $('#qunit-fixture');
    });
    QUnit.module('displaying captions on the video when captions present', function(hooks) {
        hooks.beforeEach(function() {
            this.state.getCaption = function () {
                return {
                    format: 'eia608',
                    mode: 'pop-on',
                    rollUp: 0,
                    data: [
                        { row: 0, col: 0, char: 'K', style: 'white' },
                        { row: 0, col: 1, char: 'i', style: 'white' },
                        { row: 0, col: 3, char: 't', style: 'white' },
                        { row: 0, col: 4, char: ' ', style: 'white' },
                        { row: 0, col: 5, char: 'K', style: 'white' },
                        { row: 0, col: 6, char: 'a', style: 'white' },
                        { row: 0, col: 7, char: 't', style: 'white' },
                        { row: 1, col: 0, char: 'D', style: 'white' },
                        { row: 1, col: 1, char: 'o', style: 'white' },
                        { row: 1, col: 2, char: 'g', style: 'white' },
                    ],
                };
            };
            new PlayerUIClosedCaption(this.state, this.root);
            this.state.emitFakeEvent(EVENT_STATE_UPDATE);
        });

        QUnit.test('returns caption on state event update', function (assert) {
            var actualCaption = $('.js-player-captions').text();
            assert.equal(actualCaption, 'Kit Kat Dog');
        });

        QUnit.test('clears caption data when null caption received', function(assert) {
            var actualCaption = $('.js-player-captions').text();
            assert.equal(actualCaption, 'Kit Kat Dog');

            this.state.getCaption = function() {
                return;
            };
            this.state.emitFakeEvent(EVENT_STATE_UPDATE);

            actualCaption = $('.js-player-captions').text();
            assert.equal(actualCaption, '');
        });
    });

    QUnit.test('handles null caption data', function (assert) {
        new PlayerUIClosedCaption(this.state, this.root);
        this.state.emitFakeEvent(EVENT_STATE_UPDATE);

        var actualCaption = $('.js-player-captions').text();
        assert.equal(actualCaption, '');
    });

    QUnit.module('displaying cc icon when captions are available', function (hooks) {
        hooks.beforeEach(function () {
            this.state.hasCaptions = function () {
                return true;
            };

            new PlayerUIClosedCaption(this.state, this.root);
            this.state.emitFakeEvent(EVENT_STATE_UPDATE);
        });

        QUnit.test('displays the CC icon once we receive a caption event', function (assert) {
            var ccIcon = $('.js-control-cc').css('display');
            assert.equal(ccIcon, 'inline-block');
        });

        QUnit.module('toggling the CC icon', function () {
            QUnit.test('the icon is initially in the off state', function(assert) {
                var ccIconOffDisplayValue = $('.js-player-icon-cc-deactivated').css('display');
                assert.equal(ccIconOffDisplayValue, 'inline');

                var ccIconOnDisplayValue = $('.js-player-icon-cc').css('display');
                assert.equal(ccIconOnDisplayValue, 'none');

            });

            QUnit.test('clicking the icon turns it on', function(assert) {
                $('.js-control-cc', this.root).trigger('click');

                var ccIconOnDisplayValue = $('.js-player-icon-cc').css('display');
                assert.equal(ccIconOnDisplayValue, 'inline');

                var ccIconOffDisplayValue = $('.js-player-icon-cc-deactivated').css('display');
                assert.equal(ccIconOffDisplayValue, 'none');

            });

            QUnit.test('clicking the icon twice turns it off', function(assert) {
                $('.js-control-cc', this.root).trigger('click');
                $('.js-control-cc', this.root).trigger('click');

                var ccIconOnDisplayValue = $('.js-player-icon-cc').css('display');
                assert.equal(ccIconOnDisplayValue, 'none');

                var ccIconOffDisplayValue = $('.js-player-icon-cc-deactivated').css('display');
                assert.equal(ccIconOffDisplayValue, 'inline');
            });
        });
    });

    QUnit.test('hides the CC icon until we receive a caption event', function (assert) {
        new PlayerUIClosedCaption(this.state, this.root);
        this.state.emitFakeEvent(EVENT_STATE_UPDATE);

        var ccIcon = $('.js-control-cc').css('display');
        assert.equal(ccIcon, 'none');
    });
});
