import * as Timestamp from 'util/timestamp';

QUnit.module('timestamp', function() {
    QUnit.test('Timestamp parsing parses string into seconds', function (assert) {
        assert.equal(Timestamp.parse('1h1m1s'), 3661);
    });

    QUnit.test('Hours are optional in timestamp parsing', function (assert) {
        assert.equal(Timestamp.parse('1m1s'), 61);
    });

    QUnit.test('Minutes are optional in timestamp parsing', function (assert) {
        assert.equal(Timestamp.parse('1h1s'), 3601);
    });

    QUnit.test('Seconds are optional in timestamp parsing', function (assert) {
        assert.equal(Timestamp.parse('1h1m'), 3660);
    });
});
