import { DAGResources } from "../lib";
import { createBasicProjectResources } from "./utils";
import { mockClient } from "aws-sdk-client-mock";
import { MWAA, GetEnvironmentCommand } from "@aws-sdk/client-mwaa";

const mwaaMock = mockClient(MWAA);
beforeEach(() => {
  mwaaMock.reset();
  mwaaMock.on(GetEnvironmentCommand).resolves({
    Environment: {
      ExecutionRoleArn: "arn:aws:iam::123456:role/airflow-execution-role",
    },
  });
});

test("dag ID", async () => {
  const project = await createBasicProjectResources();
  const dagResources = new DAGResources("test-dag", project);
  expect(dagResources.dagId()).toEqual(
    "test-project.test-env.test-dag.test-branch"
  );
});

test("s3 url", async () => {
  const project = await createBasicProjectResources();
  const dagResources = new DAGResources("test-dag", project);
  expect(dagResources.s3UrlForPath([])).toEqual(
    "s3://test-project.test-env.123456/test-branch/test-dag/{{run_id}}"
  );
  expect(dagResources.s3UrlForPath(["", "", ""])).toEqual(
    "s3://test-project.test-env.123456/test-branch/test-dag/{{run_id}}"
  );
  expect(dagResources.s3UrlForPath(["some", "path", "segments"])).toEqual(
    "s3://test-project.test-env.123456/test-branch/test-dag/{{run_id}}/some/path/segments"
  );

  expect(
    dagResources.s3UrlForPath(["some", "path", "segments"], false)
  ).toEqual(
    "s3://test-project.test-env.123456/test-branch/test-dag/some/path/segments"
  );
});
