import argparse


def add_deploy_parser(subparsers) -> None:
    parser = subparsers.add_parser(
        "deploy",
        help="Deploy CDK resources for given project, "
        "then compile and upload all DAG definitions to target Airflow cluster.",
    )
    parser.add_argument(
        "--dag",
        type=str,
        help="Name of DAG to deploy. If specified, will only compile upload definition of selected DAG.",
    )


def add_init_parser(subparsers) -> None:
    subparsers.add_parser("init", help="Initialize a new Conductor project.")


def add_mwaa_login_parser(subparsers) -> None:
    subparsers.add_parser(
        "mwaa-login", help="Generate a login URL for your MWAA environment."
    )


def add_clean_parser(subparsers) -> None:
    parser = subparsers.add_parser(
        "clean", help="Delete AWS resources associated with closed Git branches."
    )
    parser.add_argument(
        "--dry-run",
        action="store_true",
        help="Execute the clean function without making changes to AWS Resources",
    )


def build_arg_parser():
    parser = argparse.ArgumentParser(description="Conductor CLI")
    parser.add_argument("--env", type=str, default="staging")
    subparsers = parser.add_subparsers(dest="command")
    add_deploy_parser(subparsers)
    add_init_parser(subparsers)
    add_mwaa_login_parser(subparsers)
    add_clean_parser(subparsers)
    return parser
