import os
from pathlib import Path

import toml

PROJECT_CONFIG_TEMPLATE = Path(
    os.path.dirname(__file__), "templates", "project_config.py.txt"
)
DAG_TEMPLATE = Path(os.path.dirname(__file__), "templates", "dag.py.txt")


def init(project_root) -> None:
    # Set up build paths.
    pyproject_config = Path(project_root, "pyproject.toml")
    project_name = toml.load(pyproject_config)["tool"]["poetry"]["name"]

    project_config_file_contents = PROJECT_CONFIG_TEMPLATE.read_text().format(
        project_name=project_name
    )
    Path(project_root, "project_config.py").write_text(project_config_file_contents)

    dags_dir = Path(project_root, "dags")
    dags_dir.mkdir()
    dag_file_contents = DAG_TEMPLATE.read_text().format(project_name=project_name)
    dag_file = Path(dags_dir, "dag.py")
    dag_file.write_text(dag_file_contents)
