import importlib
import os


def main() -> None:
    model_cls_module = os.environ["MODEL_CLS_MODULE"]
    model_cls_name = os.environ["MODEL_CLS_NAME"]

    module = importlib.import_module(model_cls_module)
    model_cls = getattr(module, model_cls_name)
    model = model_cls()
    model.train()
    model.dump()


if __name__ == "__main__":
    main()
