---
title: "Developer Guide"
page-category: "searchable"
---

Conductor packages live under [https://git.xarth.tv/ml](https://git.xarth.tv/ml) 

## Local Build

The packages `conductor` and `twitch-airflow-components` can be built by running `poetry build -f wheel`. This outputs wheels into the `dist` directory at the root of the project.

For `conductor-cdk`, build is handled by `jsii`. After pulling the repository, install dependencies with `npm install`, then run `npm run build && npm run package`.
Wheels will be output in the `dist/python` directory at the root of the project.


## Unit Testing

For `conductor` and `twitch-safety-components` run `poetry install` and then `poetry run pytest`.


## Integration Testing

To integration test with a Conductor test project: 

1. Pull and make some changes to the [Conductor codebase](https://git.xarth.tv/ml/conductor).

2. In the Conductor directory, uptick the project version to force a reinstall later on.
```bash 
poetry version patch
```

3. Build the Conductor `.whl` file, following the instructions in [Local Build](#Local Build).

4. Copy the wheel to your test project, for example
```bash
cp dist/twitch-conductor-0.2.0-py3-none-any.whl ~/my-project/twitch-conductor-0.2.0-py3-none-any.whl
```

5. Within your test project, use Poetry to reinstall the Conductor package from the locally built .whl
```bash
poetry add ./twitch-conductor-0.2.0-py3-none-any.whl
```

> **Note:** Currently, Poetry will not update a dependency unless it has a different version than the currently installed one.
Make sure to run `poetry version patch` before testing any change to upgrade the `.whl` version for testing.
{:.note}
