---
title: "Local Airflow Environment"
page-category: "searchable"
description: "Local Environment"
---

- [x] Install Airflow Constraints
- [x] Initialize Database
- [x] Create Airflow User
- [x] Start Airflow Processes

### 1. Install Airflow Constraints:
Installing `conductor` also installs the compatible version of `airflow` with your `poetry` virtual environment. To verify run

```bash
poetry run airflow version
```
> **Note:** From here onwards, the preceding `poetry run` will be omitted from commands.
{:.note}

However, the Airflow processes cannot run without some additional dependencies specified by their constraints file.
To install these dependencies, set run the following:
```bash
AIRFLOW_VERSION=<version shown above e.g. 2.0.1>
PYTHON_VERSION="$(poetry run python --version | cut -d " " -f 2 | cut -d "." -f 1-2)"
CONSTRAINT_URL="https://raw.githubusercontent.com/apache/airflow/constraints-${AIRFLOW_VERSION}/constraints-${PYTHON_VERSION}.txt"
poetry run python -m pip install "apache-airflow==${AIRFLOW_VERSION}" --constraint "${CONSTRAINT_URL}"
```

For the constraints to install properly, some non-python dependencies may need to be installed:
```
brew install leveldb postgresql
```

### 2. Initialize Database:
```bash
airflow db init
```

### 3. Create Airflow User:
Create a local Airflow user to log in to the UI.
```bash
airflow users create \
    --username admin \
    --firstname Peter \
    --lastname Parker \
    --role Admin \
    --email spiderman@superhero.org
```

### 4. Start Airflow Processes:
Start the scheduler process, making sure to set the `AWS_PROFILE` so that the scheduler will have access to your account's resources.
```bash
OBJC_DISABLE_INITIALIZE_FORK_SAFETY=YES AWS_PROFILE=my-aws-account airflow scheduler
```
The `OBJC_DISABLE_INITIALIZE_FORK_SAFETY=YES` setting prevents a thread forking bug in OSX, more context [here](https://github.com/apache/airflow/issues/12808).

Then, in a separate tab, start the webserver.
```bash
airflow webserver
```
This launches the Airflow UI, which is bound by default to `localhost:8080`.
