---
title: "Create New Project"
page-category: "searchable"
description: "Create New Project"
---

- [x] Setup Environment
- [x] Initialize Poetry Project
- [x] Initialize Conductor Project
- [x] Verify Project Setup

### 1. Setup Environment

- Install [poetry](https://python-poetry.org/docs/#installation).
- Install [node](https://nodejs.org/en/download/package-manager/#macos).
- Install python 3.7.10. You can manage multiple python versions using:
   - [pyenv](https://github.com/pyenv/pyenv#homebrew-on-macos). (Recommended)
   - Homebrew: `brew install python@3.7`

### 2. Initialize Poetry Project

- Initialize your project with poetry. 

If you don't have a folder that you wish you use as your repository and want to create one, run the following command. This will generate a folder with several sub folders and a `pyproject.toml`: 

```bash
poetry new <project name>
```

If you already have a repository to use, run the following command in the repository. This will generate `pyproject.toml` file in your repository:
```bash
poetry init
```

During the initialization process, use python 3.7.10

> **Warning:** Make sure to set the above python version **exactly** during poetry setup, as it is the only python 3.7 version that has patched a [major security vulnerability](https://python-security.readthedocs.io/vuln/ctypes-buffer-overflow-pycarg_repr.html).
{:.danger}

- Verify the poetry environment

```bash
poetry run python --version
```

This should show python version 3.7.10.
If it does not, you may need to link the 3.7.10 binary manually. To do so, run:
```bash
poetry env list
```
to list your current environments. Run:
```bash
poetry env remove <env name>
```
to delete each of them, and finally run:
```bash
poetry env use <path to python3.7.10 binary>
```

For example, if you installed python with pyenv, the binary is typically located at
```bash
poetry env use ~/.pyenv/versions/3.7.10/bin/python
```

If you used Homebrew, the binary is typically located at
```bash
poetry env use /usr/local/opt/python@3.7/bin/python3.7
```



### 3. Initialize Conductor Project

- To resolve internal pypi repository, add the following lines to your project's `pyproject.toml`

```toml
[[tool.poetry.source]]
name = "twitch"
url = "https://pypi.pkgs.xarth.tv/simple/"
```

- Ensure python version is set correctly

```toml
[tool.poetry.dependencies]
python = "3.7.10"
```

> **Warning:** Make sure you are on the Twitch VPN when running `poetry add` or `poetry install`, or you will not be able to resolve the internal PyPI repository.
{:.warning}

- Install conductor:

```bash
poetry add twitch-conductor
```
**Note:** This step can take multiple minutes for first install as poetry is resolving a large dependency list. This is normal. Subsequent installs will be faster since poetry caches the results.

> **Warning:** Be sure to install the correct package `twitch-conductor` and not the external `conductor` PyPI package.
{:.warning}

- If you have not already done so, initialize your project with git and commit all existing files.

```bash
git init
git add .
git commit -m "init"
```

- Initialize conductor project.

```bash
poetry run conductor init
```

> **Note:** We recommend that you alias the above by adding `alias conductor="poetry run conductor"` to your `.bashrc` or `.bash_profile`.
{:.note}

### 4. Verify Project Setup
After running the above steps, your project directory should contain the following files.

```
pyproject.toml
poetry.lock
project_config.py
dags/
|---dag.py
```

Open `project_config.py` and update the values to match your team's AWS account configuration. 

* `account_id`: the account id - you can copy from [isengard](https://isengard.amazon.com/console-access)
* `account_name`: the account name should match the profile you configured under ~/.aws/credentials for the account

If your team does not have an Airflow environment, replace `staging_airflow_config = AirflowConfig(mwaa_environment_name=...)`with an empty one `staging_airflow_config = AirflowConfig()`.

You can then run `conductor deploy` to build and deploy the placeholder DAG that is included in `dags/dag.py`.
