import sys
from pathlib import Path

import pytest

from conductor.docker.conductor_entrypoints.process import main
from tests.docker.test_files import FIXTURE_DIR


@pytest.mark.datafiles(Path(FIXTURE_DIR, "test_project"))
@pytest.mark.no_auto_env
def test_process(datafiles, mocker, monkeypatch):
    monkeypatch.setenv("CONDUCTOR_ENV", "test-env")
    monkeypatch.setenv("CONDUCTOR_GIT_BRANCH", "test-branch")
    monkeypatch.setenv("CONDUCTOR_COMMIT_HASH", "test-commit-hash")
    monkeypatch.setenv("CDK_OUTDIR", "cdk")

    sys.path.append(str(datafiles))
    mocker.patch.object(
        sys, "argv", ["process", "my-dag", "process", "--project_root", str(datafiles)]
    )
    main()

    with pytest.raises(ValueError):
        mocker.patch.object(
            sys,
            "argv",
            ["process", "missing-dag", "process", "--project_root", str(datafiles)],
        )
        main()
