import os
import sys
from dataclasses import dataclass
from pathlib import Path

import pytest

from conductor.docker.conductor_entrypoints.serve import start_server
from tests.docker.test_files import FIXTURE_DIR


@dataclass
class MockProcess:
    pid: str


@pytest.mark.datafiles(Path(FIXTURE_DIR, "test_project"))
def test_serve(datafiles, mocker):
    os.chdir(datafiles)
    sys.path.append(str(datafiles))
    call_mock = mocker.patch("conductor.docker.conductor_entrypoints.serve.check_call")
    mocker.patch(
        "conductor.docker.conductor_entrypoints.serve.os.wait", return_value=("a", "b")
    )
    mocker.patch("conductor.docker.conductor_entrypoints.serve.os.kill")
    popen_mock = mocker.patch(
        "conductor.docker.conductor_entrypoints.serve.Popen",
        return_value=MockProcess(pid="a"),
    )
    with pytest.raises(SystemExit):
        start_server()

    call_mock.assert_any_call(["ln", "-sf", "/dev/stderr", "/var/log/nginx/error.log"])
    call_mock.assert_any_call(["ln", "-sf", "/dev/stdout", "/var/log/nginx/access.log"])

    popen_mock.assert_any_call(["nginx", "-c", "/opt/program/nginx.conf"])
