from conductor.config import AirflowConfig
from conductor.internal.utils import get_dags_s3_path


def test_dags_path_mwaa(mocker) -> None:
    config = AirflowConfig(mwaa_environment_name="test")
    mocker.patch(
        "conductor.internal.utils.get_airflow_env",
        return_value={
            "SourceBucketArn": "arn:aws:s3:::mwaa-bucket",
            "DagS3Path": "some/path/",
        },
    )

    bucket, path = get_dags_s3_path(config)
    assert bucket == "mwaa-bucket"
    assert path == "some/path"


def test_dags_path_s3():
    config = AirflowConfig(dags_s3_path="s3://custom-bucket/path/")
    bucket, path = get_dags_s3_path(config)
    assert bucket == "custom-bucket"
    assert path == "path"

    config = AirflowConfig(dags_s3_path="s3://custom-bucket/")
    bucket, path = get_dags_s3_path(config)
    assert bucket == "custom-bucket"
    assert path == ""
