def test_badger_export(c) -> None:
    test_badger_op = c.operators.BadgerExportOperator(
        task_id="badger-export",
        dataset_name="test-model-name",
        version="1.0",
        key_field="somekey",
        input_s3_url="s3://somebucket/somekey",
    )
    assert (
        "s3://test-project.test-env.123456789012/test-branch/test-dag/{{run_id}}/badger-export"
        == test_badger_op.outputs.data_s3_url
    )
    assert (
        "s3://test-project.test-env.123456789012/test-branch/test-dag/badger-export/manifests/test-model-name/1.0"
        == test_badger_op.outputs.manifest_s3_url
    )

    assert test_badger_op.task.config == {
        "ProcessingJobName": "badger-export-test-dag-{{(macros.time.time() * 1000) | int}}",
        "AppSpecification": {
            "ImageUri": "851170259539.dkr.ecr.us-west-2.amazonaws.com/safety-ml-docker-badger-processor",
            "ContainerEntrypoint": ["processor"],
            "ContainerArguments": [
                "-key=somekey",
                "-name=test-model-name",
                "-version=1.0",
                "-environment=test-env",
                "-timestamp={{ts}}",
                "-manifests3uri=s3://test-project.test-env.123456789012/test-branch/test-dag/{{run_id}}/badger-export",
            ],
        },
        "ProcessingInputs": [
            {
                "AppManaged": False,
                "InputName": "inputdata",
                "S3Input": {
                    "LocalPath": "/opt/ml/processing/inputdata",
                    "S3CompressionType": "None",
                    "S3DataDistributionType": "FullyReplicated",
                    "S3DataType": "S3Prefix",
                    "S3InputMode": "File",
                    "S3Uri": "s3://somebucket/somekey",
                },
            }
        ],
        "ProcessingOutputConfig": {
            "Outputs": [
                {
                    "OutputName": "outputdata",
                    "S3Output": {
                        "LocalPath": "/opt/ml/processing/outputdata",
                        "S3UploadMode": "EndOfJob",
                        "S3Uri": "s3://test-project.test-env.123456789012/test-branch/test-dag/{{run_id}}/badger-export",
                    },
                },
                {
                    "OutputName": "manifest",
                    "S3Output": {
                        "LocalPath": "/opt/ml/processing/manifest",
                        "S3UploadMode": "EndOfJob",
                        "S3Uri": "s3://test-project.test-env.123456789012/test-branch/test-dag/badger-export/manifests/test-model-name/1.0",
                    },
                },
            ]
        },
        "Environment": {
            "AWS_DEFAULT_REGION": "us-west-2",
            "ENV": "test-env",
            "GIT_BRANCH": "test-branch",
        },
        "ProcessingResources": {
            "ClusterConfig": {
                "InstanceCount": 1,
                "InstanceType": "ml.m5.4xlarge",
                "VolumeSizeInGB": 128,
            }
        },
        "RoleArn": "arn:aws:iam::123456789012:role/0EKirPILJEXjpsva-sm-execution-role-us-west-2",
    }
