def test_sagemaker_endpoint(c):
    test_endpoint_op = c.operators.SageMakerEndpointOperator(
        task_id="endpoint",
        model_name="test-model",
        endpoint_name="classify-test",
    )

    assert test_endpoint_op.task.children["endpoint.config"].config == {
        "EndpointConfigName": "classify-test-{{(macros.time.time() * 1000) | int}}",
        "ProductionVariants": [
            {
                "VariantName": "main",
                "ModelName": "test-model",
                "InitialInstanceCount": 1,
                "InstanceType": "ml.t2.medium",
            }
        ],
    }

    xcom_config_name = "{{ti.xcom_pull(task_ids='endpoint.config')['EndpointConfig']['EndpointConfigName']}}"
    assert test_endpoint_op.task.children["endpoint.endpoint"].config == {
        "EndpointName": "classify-test",
        "EndpointConfigName": xcom_config_name,
    }

    assert test_endpoint_op.outputs.endpoint_config_name == xcom_config_name
