def test_func():
    pass


def test_sagemaker_processing(c):
    test_processing_op = c.operators.SageMakerProcessingOperator(
        task_id="processing", entrypoint=test_func, other_args=1
    )

    assert test_processing_op.task.config == {
        "ProcessingJobName": "test-project-processing-test-dag-{{(macros.time.time() * 1000) | int}}",
        "ProcessingResources": {
            "ClusterConfig": {
                "InstanceCount": 1,
                "InstanceType": "ml.t3.medium",
                "VolumeSizeInGB": 1,
            }
        },
        "AppSpecification": {
            "ImageUri": "123456789012.dkr.ecr.us-west-2.amazonaws.com/test-project.test-env:test-branch-test-commit-hash",
            "ContainerEntrypoint": ["process"],
            "ContainerArguments": [
                "test-dag",
                "processing",
            ],
        },
        "Environment": {
            "CONDUCTOR_ENV": "test-env",
            "CONDUCTOR_GIT_BRANCH": "test-branch",
            "CONDUCTOR_COMMIT_HASH": "test-commit-hash",
            "CDK_OUTDIR": "/opt/program/cdk",
            "AWS_DEFAULT_REGION": "us-west-2",
        },
        "RoleArn": "arn:aws:iam::123456789012:role/0EKirPILJEXjpsva-sm-execution-role-us-west-2",
    }
    assert test_processing_op.outputs is None

    assert c.task_container_params["processing"].entrypoint == test_func
    assert c.task_container_params["processing"].kwargs == {"other_args": 1}
