def test_sagemaker_transform(c):

    test_model_op = c.operators.SageMakerTransformOperator(
        task_id="transform",
        model_name="test-model",
    )

    assert test_model_op.task.config == {
        "TransformJobName": "transform-test-dag-{{(macros.time.time() * 1000) | int}}",
        "ModelName": "test-model",
        "TransformResources": {"InstanceType": "ml.m4.xlarge", "InstanceCount": 1},
        "TransformOutput": {
            "S3OutputPath": "s3://test-project.test-env.123456789012/test-branch/test-dag/{{run_id}}/transform",
            "AssembleWith": "Line",
            "Accept": "text/csv",
        },
        "MaxPayloadInMB": 4,
    }

    assert (
        test_model_op.outputs.s3_url
        == "s3://test-project.test-env.123456789012/test-branch/test-dag/{{run_id}}/transform"
    )
