from twitch_airflow_components.dag_utils import pagerduty_on_failure_callback

from conductor.config import PagerdutyConfig
from tests.utils import create_conductor_instance


def test_on_failure_callback(mocker):
    c = create_conductor_instance(prod=True)
    assert c.dag.on_failure_callback == pagerduty_on_failure_callback

    c = create_conductor_instance(
        prod=True, pagerduty=PagerdutyConfig(conn_id="custom-conn-id")
    )
    assert c.dag.params["pagerduty_conn_id"] == "custom-conn-id"
