import re

import airflow

from conductor.config import AirflowConfig, EnvironmentConfig, Project
from conductor.core import Conductor


def create_test_project(**kwargs):
    airflow_config = AirflowConfig(dags_s3_path="s3://test-mwaa-bucket/dags")
    test_env = EnvironmentConfig(
        account_name="test",
        account_id="123456789012",
        default_region="us-west-2",
        airflow=airflow_config,
        **kwargs,
    )
    return Project(name="test-project", environments={"test-env": test_env})


def create_conductor_instance(**kwargs):
    project = create_test_project(**kwargs)
    default_args = {
        "owner": "tester",
        "start_date": airflow.utils.dates.days_ago(2),
    }
    return Conductor(
        "test-dag",
        project,
        default_args=default_args,
        schedule_interval="@daily",
    )


class MockValidator(object):
    def __init__(self, validator):
        self.validator = validator

    def __eq__(self, other):
        return bool(self.validator(other))


class RegexValidator(object):
    def __init__(self, regex):
        self.regex = regex

    def __eq__(self, other):
        return re.search(self.regex, other) is not None
