<?php
// äüö - UTF8 FTW
$global_curl = curl_init();
$use_redis = true;
$check_subject_after_pull = true;
$offer_case_distribution = true;
$show_session_stats = true;
$enable_whisper_report_stats = true;
$evil_report_text = false;
$preload_all_pages = false;
$enable_session_logging_to_DB = true;
$DESK_API_DOMAIN = 'https://help.twitch.tv';
$DESK_API_KEY = 'QIpVTAyrppviIfEKg5Nj';
$DESK_API_SECRET = 'fM3KQ8MUovELgKofqA4l4HVZgdnSIJxrb1S9Ht1E';
if(isset($_SESSION['login_method']) && $_SESSION['login_method'] === 'oauth')
{
	try {
		$global_oauth = new OAuth($DESK_API_KEY, $DESK_API_SECRET, OAUTH_SIG_METHOD_HMACSHA1);
		$global_oauth->setToken($_SESSION['user']['oauth_token'], $_SESSION['user']['oauth_token_secret']);
	} catch(OAuthException $E) {
		// print_r($E);
	}
}

function apply_curl_defaults(&$ch)
{
	curl_reset($ch);
	curl_setopt($ch, CURLOPT_TIMEOUT, 10);
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
	curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/json'));
	curl_setopt($ch, CURLOPT_ENCODING, '');
	if(isset($_SESSION['login_method']) && $_SESSION['login_method'] === 'user_pwd')
	{
		// Only add this header if it's the "normal" user_pwd auth
		curl_setopt($ch, CURLOPT_USERPWD, $_SESSION['user']['email'].':'.$_SESSION['user']['pwd']);
	}
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
	curl_setopt($ch, CURLOPT_AUTOREFERER, false);
	curl_setopt($ch, CURLOPT_USERAGENT, 'Better Desk by commanderroot@twitch.tv');
	// SSL stuff
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
	curl_setopt($ch, CURLOPT_CAINFO, __DIR__.'/cacert.pem');
	curl_setopt($ch, CURLOPT_CAPATH, __DIR__);
	curl_setopt($ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);
	// TCP NO DELAY
	// curl_setopt($ch, CURLOPT_TCP_NODELAY, 1);

	curl_setopt($ch, CURLOPT_HEADER, true);
}

function parse_desk_curl_output($curl_output)
{
	$curl_explode = explode("\r", $curl_output);
	$is_still_header = true;
	$header = '';
	$content = '';
	$header_array = array();
	// Split into header and content
	foreach($curl_explode as $row)
	{
		if($is_still_header === true)
		{
			if($row != "\r" && $row != "\r\n" && $row != '' && $row != "\n")
			{
				$header .= trim($row).PHP_EOL;
				$header_array[] = trim($row);
			}
			else
			{
				// It wasn't a normal header therefor we are now at the border to content
				$is_still_header = false;
			}
		}
		else
		{
			// If it's not the header it's the content
			$content .= trim($row).PHP_EOL;
		}
	}

	// Parse headers into an array
	$header_array_parsed = array();
	for($i = 0; $i < count($header_array); $i++)
	{
		if($i == 0)
		{
			// First line in HTTP is always the HTTP status code
			// Example: HTTP/1.1 200 OK
			$pos = strpos($header_array[$i], ' ');
			if($pos !== false)
			{
				$header_array_parsed['HTTP_CODE'] = substr($header_array[$i], ($pos + 1));
			}
			else
			{
				// log_output('Error while parsing HTTP header 0! ('.$header_array[$i].')', 2);
			}
		}
		else
		{
			// Example: X-Rate-Limit-Limit: 300
			$pos = strpos($header_array[$i], ': ');
			if($pos !== false)
			{
				$header_array_parsed[substr($header_array[$i], 0, $pos)] = substr($header_array[$i], ($pos + 2));
			}
			else
			{
				// log_output('Error while parsing HTTP headers > 0! ('.$header_array[$i].')', 2);
			}
		}
	}

	// Log desk rate limits
	log_desk_rate_limits($header_array_parsed);

	// Return the parsed info as array
	return array('header' => $header, 'content' => $content, 'header_array' => $header_array, 'header_array_parsed' => $header_array_parsed);
}

function log_desk_rate_limits($header_array_parsed)
{
	// Only log it if the request has this data
	if(isset($header_array_parsed['X-Rate-Limit-Limit'], $header_array_parsed['X-Rate-Limit-Remaining'], $header_array_parsed['X-Rate-Limit-Reset']))
	{
		$log_array = array(
			'limit' => $header_array_parsed['X-Rate-Limit-Limit'],
			'remaining' => $header_array_parsed['X-Rate-Limit-Remaining'],
			'reset' => $header_array_parsed['X-Rate-Limit-Reset'],
			'date' => strtotime($header_array_parsed['Date'])
		);
		file_put_contents(__DIR__ . '/../rate_limit.log', json_encode($log_array).PHP_EOL, FILE_APPEND | LOCK_EX);
	}
}

function check_for_valid_login($type, $credentials)
{
	$ch = &$GLOBALS['global_curl'];
	$return = false;

	$request_url = $GLOBALS['DESK_API_DOMAIN'].'/api/v2/users/current';
	apply_curl_defaults($ch);
	curl_setopt($ch, CURLOPT_URL, $request_url);
	if($type == 'user_pwd')
	{
		curl_setopt($ch, CURLOPT_USERPWD, $credentials);
	}
	elseif($type == 'oauth')
	{
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/json', 'Authorization: '.$credentials));
	}
	else
	{
		return $return;
	}
	$curl_output = curl_exec($ch);
	$curl_info = curl_getinfo($ch);
	if($curl_output === false)
	{
		echo 'Curl error on "'.$curl_info['url'].'" => '.curl_error($ch);
		exit();
	}
	else
	{
		$curl_parse = parse_desk_curl_output($curl_output);
		if($curl_info['http_code'] >= 200 && $curl_info['http_code'] <= 204)
		{
			// Request was successful
			$return = true;
		}
		elseif($curl_info['http_code'] == 304)
		{
			// Never happens as I don't use ETAG's but if I did it would be successful
			$return = true;
		}
		elseif($curl_info['http_code'] == 429)
		{
			echo 'DESK: hit rate limit on URL: '.$curl_info['url'];
			exit();
		}
		elseif($curl_info['http_code'] == 401)
		{
			$return = false;
		}
		else
		{
			// Some other HTTP error => Try again
			echo 'CURL: HTTP ERROR: '.$curl_info['url'].PHP_EOL.print_r($curl_parse, true);
			exit();
		}

		if($return === true)
		{
			$json_decode = json_decode($curl_parse['content'], true);
			if($json_decode !== NULL && isset($json_decode['id']) && isset($json_decode['email']))
			{
				$_SESSION['user']['desk_ID'] = $json_decode['id'];
				$_SESSION['user']['username'] = ucfirst(strtolower(explode('@', $json_decode['email'])[0]));
				$return = true;
			}
			else
			{
				$return = false;
			}
		}
	}
	return $return;
}

function get_new_cases_overview()
{
	$ch = &$GLOBALS['global_curl'];
	$return = false;
	$page = 1;
	$per_page = 100;
	$already_to_array_added_DeskIDs = array();
	$whisper_report_folder = ',Whisper Reports';
	$channel_feed_report_folder = ',Channel Feed Reports';
	$clip_report_folder = ',Clip Reports';
	if(isset($_SESSION['whisper_reports_disabled']) && $_SESSION['whisper_reports_disabled'] === true)
	{
		// Remove the folder because we don't want to see any whispers reports
		$whisper_report_folder = '';
	}
	if(isset($_SESSION['channel_feed_reports_disabled']) && $_SESSION['channel_feed_reports_disabled'] === true)
	{
		// Remove the folder because we don't want to see any channel feed reports
		$channel_feed_report_folder = '';
	}
	if(isset($_SESSION['clip_reports_disabled']) && $_SESSION['clip_reports_disabled'] === true)
	{
		// Remove the folder because we don't want to see any clip reports
		$clip_report_folder = '';
	}


	request_start:
	if(isset($_COOKIE['fade_resolved']) && $_COOKIE['fade_resolved'] == 'on')
	{
		// Both inboxes, sorted by priority
		$request_url = $GLOBALS['DESK_API_DOMAIN'].'/api/v2/cases/search?q='.rawurlencode('group:"Moderation Escalations,User Reports'.$whisper_report_folder.$channel_feed_report_folder.$clip_report_folder.'" status:new,open,pending assigned:"NONE"').'&sort_field=priority&sort_direction=desc&per_page='.$per_page.'&page='.$page;
	}
	else
	{
		// Normal search with both inboxes and sorted by created_at
		$request_url = $GLOBALS['DESK_API_DOMAIN'].'/api/v2/cases/search?q='.rawurlencode('group:"Moderation Escalations,User Reports'.$whisper_report_folder.$channel_feed_report_folder.$clip_report_folder.'" status:new,open,pending assigned:"NONE"').'&sort_field=created_at&sort_direction=asc&per_page='.$per_page.'&page='.$page;
	}


	apply_curl_defaults($ch);
	curl_setopt($ch, CURLOPT_URL, $request_url);
	// A bit higher timeout here because if we have a lot of open / new cases it can take longer than ususal
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
	if(isset($_SESSION['login_method']) && $_SESSION['login_method'] === 'oauth')
	{
		$oauth_request_header = $GLOBALS['global_oauth']->getRequestHeader('GET', $request_url);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/json', 'Authorization: '.$oauth_request_header));
	}
	$curl_output = curl_exec($ch);
	$curl_info = curl_getinfo($ch);
	if($curl_output === false)
	{
		echo 'Curl error on "'.$curl_info['url'].'" => '.curl_error($ch);

		// Add a 5 sec javascript auto reload here so it still continue to update
		echo PHP_EOL.'<script type="text/javascript">setTimeout(function () { window.location.reload(); }, 5000);</script>';
		exit();
	}
	else
	{
		$curl_parse = parse_desk_curl_output($curl_output);
		if($curl_info['http_code'] >= 200 && $curl_info['http_code'] <= 204)
		{
			// Request was successful
		}
		elseif($curl_info['http_code'] == 304)
		{
			// Never happens as I don't use ETAG's but if I did it would be successful
		}
		elseif($curl_info['http_code'] == 429)
		{
			echo 'DESK: hit rate limit on URL: '.$curl_info['url'];

			// Add a 10 sec javascript auto reload here so it still continue to update
			echo PHP_EOL.'<script type="text/javascript">setTimeout(function () { window.location.reload(); }, 10000);</script>';
			exit();
		}
		elseif($curl_info['http_code'] == 401)
		{
			echo 'Invalid desk credentials!<br>'.PHP_EOL;
			do_logout(false);
		}
		elseif($curl_info['http_code'] == 404 && $page > 1)
		{
			// No more cases found on a higher page, go to sorting and end now
			$GLOBALS['curl_request_info_string'] .= '<!-- '.htmlspecialchars($curl_info['url'], ENT_QUOTES|ENT_HTML5).' (404 Not Found) took => DNS: '.htmlspecialchars($curl_info['namelookup_time'], ENT_QUOTES|ENT_HTML5).' / Connect: '.htmlspecialchars($curl_info['connect_time'], ENT_QUOTES|ENT_HTML5).' / Total: '.htmlspecialchars($curl_info['total_time'], ENT_QUOTES|ENT_HTML5).' seconds -->'.PHP_EOL;
			$GLOBALS['global_api_request_time'] = $GLOBALS['global_api_request_time'] + $curl_info['total_time'];
			goto sorting_and_end;
		}
		else
		{
			// Some other HTTP error => Try again
			echo 'CURL: HTTP ERROR ('.$curl_info['http_code'].'): '.$curl_info['url'].PHP_EOL; // print_r($curl_parse, true);

			// Add a 5 sec javascript auto reload here so it still continue to update
			echo PHP_EOL.'<script type="text/javascript">setTimeout(function () { window.location.reload(); }, 5000);</script>';
			exit();
		}

		$GLOBALS['curl_request_info_string'] .= '<!-- '.htmlspecialchars($curl_info['url'], ENT_QUOTES|ENT_HTML5).' took => DNS: '.htmlspecialchars($curl_info['namelookup_time'], ENT_QUOTES|ENT_HTML5).' / Connect: '.htmlspecialchars($curl_info['connect_time'], ENT_QUOTES|ENT_HTML5).' / Total: '.htmlspecialchars($curl_info['total_time'], ENT_QUOTES|ENT_HTML5).' seconds -->'.PHP_EOL;
		$GLOBALS['global_api_request_time'] = $GLOBALS['global_api_request_time'] + $curl_info['total_time'];

		$json_decode = json_decode($curl_parse['content'], true);
		if($json_decode !== NULL)
		{
			if($GLOBALS['use_redis'] === true && $GLOBALS['offer_case_distribution'] === true && isset($_SESSION['case_distribution_enabled']) && $_SESSION['case_distribution_enabled'] === true)
			{
				// load the distrib lib
				if(!class_exists('Distrib', false))
				{
					require_once '_distrib.php';
				}

				// Check if we already have a destrib object, no need to create a new one for each page
				if(!isset($distrib))
				{
					// Connect to redis for the current distributer list
					$redis = get_redis_connection()['redis'];
					$redis_is_connected = get_redis_connection()['redis_is_connected'];
					if($redis_is_connected === true)
					{
						$redis->setOption(Redis::OPT_PREFIX, $redis_prefix);

						// Now get the current list of all users
						$case_distribution_enabled_user = array();
						$case_distribution_array = array();
						$redis_case_distribution_enabled_user_overview = $redis->keys('twitch-desk-distribution:*');
						foreach($redis_case_distribution_enabled_user_overview as $redis_key)
						{
							$redis_response = $redis->get($redis_key);
							if($redis_response !== false)
							{
								// Get weight for users
								$redis_response2 = $redis->get('twitch-desk-distribution-weight:'.$redis_response['desk_ID']);
								if($redis_response2 !== false)
								{
									$user_weight = $redis_response2;
								}
								else
								{
									// Default weight
									$user_weight = 10;
								}
								$case_distribution_enabled_user[$redis_response['desk_ID']] = $redis_response['username'];
								$case_distribution_array[($redis_response['username'].':'.$redis_response['desk_ID'])] = $user_weight;
							}
							unset($redis_response, $redis_response2);
						}
						unset($redis_case_distribution_enabled_user_overview);

						$GLOBALS['curl_request_info_string'] .= '<!-- $case_distribution_enabled_user => '.htmlspecialchars(print_r($case_distribution_enabled_user, true), ENT_QUOTES|ENT_HTML5).' -->'.PHP_EOL;
						$GLOBALS['curl_request_info_string'] .= '<!-- $case_distribution_array => '.htmlspecialchars(print_r($case_distribution_array, true), ENT_QUOTES|ENT_HTML5).' -->'.PHP_EOL;
						$distrib = new Distrib('consistent', $case_distribution_array);
					}
				}
			}

			if(!isset($case_id_array)) $case_id_array = array();
			foreach($json_decode['_embedded']['entries'] as $case)
			{
				// Remove the stupid VOD thing from the subject (if it exists)
				if(($vod_string_pos = strpos($case['subject'], ' (vod id: ')) !== false)
				{
					$case['subject'] = substr($case['subject'], 0, $vod_string_pos);
				}

				// Create session arrays if they don't already exist
				if(!isset($_SESSION['auto_resolve_by_subject_array']))
				{
					$_SESSION['auto_resolve_by_subject_array'] = array();
				}
				if(!isset($_SESSION['hold_caseID_array']))
				{
					$_SESSION['hold_caseID_array'] = array();
				}

				// Check for "hold" cases
				if(isset($_SESSION['hold_caseID_array'][$case['id']]))
				{
					// Skip the loop for this case then
					$GLOBALS['curl_request_info_string'] .= '<!-- Skipped "'.htmlspecialchars($case['id'], ENT_QUOTES|ENT_HTML5).'" because it\'s on the $hold_caseID_array -->'.PHP_EOL;
					continue;
				}

				if($GLOBALS['use_redis'] === true && $GLOBALS['offer_case_distribution'] === true && isset($_SESSION['case_distribution_enabled']) && $_SESSION['case_distribution_enabled'] === true && isset($distrib))
				{
					$map_key = get_channel_from_subject($case['subject']);
					if(empty($map_key) || $map_key == 'escalation-case' /* It's not a normal report */)
					{
						$map_key = $case['subject'];
					}
					$map = $distrib->map(hash('sha256', $map_key, false));
					unset($map_key);
					// If this case subject is not mapped for the current user then "skip" it
					if($map != ($_SESSION['user']['username'].':'.$_SESSION['user']['desk_ID']))
					{
						$GLOBALS['curl_request_info_string'] .= '<!-- '.htmlspecialchars($case['subject'], ENT_QUOTES|ENT_HTML5).' ('.htmlspecialchars($case['id'], ENT_QUOTES|ENT_HTML5).') => skipped ('.htmlspecialchars($map, ENT_QUOTES|ENT_HTML5).') -->'.PHP_EOL;
						continue;
					}
					else
					{
						$GLOBALS['curl_request_info_string'] .= '<!-- '.htmlspecialchars($case['subject'], ENT_QUOTES|ENT_HTML5).' ('.htmlspecialchars($case['id'], ENT_QUOTES|ENT_HTML5).') => NOT skipped -->'.PHP_EOL;
					}
				}

				// Only display cases that are not already resolved (because the search api is a bit behind sometimes)
				if((!isset($case['status']) || empty($case['status']) || $case['status'] != 'resolved') && (!isset($case['_links']['assigned_user']) || $case['_links']['assigned_user'] === NULL) && isset($case['_links']['assigned_group']['href']) && in_array($case['_links']['assigned_group']['href'], array('/api/v2/groups/396524' /* User Reports */, '/api/v2/groups/396525' /* Moderation Escalations */, '/api/v2/groups/557131' /* Whisper Reports */, '/api/v2/groups/584265' /* Channel Feed Reports */, '/api/v2/groups/599060' /* Clip Reports */))
					&& !isset($already_to_array_added_DeskIDs[$case['id']]))
				{
					if((($GLOBALS['check_subject_after_pull'] === false || ($GLOBALS['check_subject_after_pull'] === true && $GLOBALS['use_redis'] === false)) && isset($_SESSION['auto_resolve_by_subject_array'][$case['subject']]) && !in_array('report - global mod', $case['labels']))
						|| $case['subject'] == 'Delivery Status Notification (Delay)' || $case['subject'] == 'Delivery Status Notification (Failure)' || $case['subject'] == 'Google Dashboard: Your Account Activity')
					{
						// Only if it's in the list => resolve and assign case
						if(strpos($case['subject'], 'Abuse report concerning ') !== false || strpos($case['subject'], 'Strike concerning ') !== false || strpos($case['subject'], 'Whisper Report concerning ') !== false || strpos($case['subject'], 'Channel feed report concerning ') !== false || strpos($case['subject'], 'Channel feed comment report concerning ') !== false || strpos($case['subject'], 'Clip report concerning ') !== false)
						{
							// It's an report so we will add it with a link
							$subject_explode = explode(' ', trim($case['subject']));
							for($i = 0; $i < (count($subject_explode) - 1); $i++)
							{
								$GLOBALS['warning_string'] .= htmlspecialchars($subject_explode[$i], ENT_QUOTES|ENT_HTML5).' ';
							}
							$GLOBALS['warning_string'] .= '<a href="https://player.twitch.tv/?channel='.rawurlencode($subject_explode[(count($subject_explode) - 1)]).'" target="_blank" rel="noreferrer">'.htmlspecialchars($subject_explode[(count($subject_explode) - 1)], ENT_QUOTES|ENT_HTML5).'</a> => ';
							unset($subject_explode);
						}
						else
						{
							$GLOBALS['warning_string'] .= htmlspecialchars($case['subject'], ENT_QUOTES|ENT_HTML5).' => ';
						}
						$GLOBALS['warning_string'] .= htmlspecialchars(do_assign_and_resolve($case['id'], true, array('report - autoresolve', 'autoresolve - subject')), ENT_QUOTES|ENT_HTML5);
						$GLOBALS['warning_string'] .= '<br>'.PHP_EOL;

						// Session Stats
						if($GLOBALS['show_session_stats'] === true)
						{
							$_SESSION['session_stats']['cases_overall'][$case['id']] = true;
							$_SESSION['session_stats']['auto_resolved_subject_cases'][$case['id']] = true;
							if(strpos($case['subject'], 'Abuse report concerning ') !== false || strpos($case['subject'], 'Strike concerning ') !== false)
							{
								$_SESSION['session_stats']['report_cases'][$case['id']] = true;
							}
							elseif(strpos($case['subject'], 'Whisper Report concerning ') !== false)
							{
								$_SESSION['session_stats']['whisper_cases'][$case['id']] = true;
							}
							elseif(strpos($case['subject'], 'Channel feed report concerning ') !== false || strpos($case['subject'], 'Channel feed comment report concerning ') !== false)
							{
								$_SESSION['session_stats']['channel_feed_cases'][$case['id']] = true;
							}
							elseif(strpos($case['subject'], 'Clip report concerning ') !== false)
							{
								$_SESSION['session_stats']['clip_cases'][$case['id']] = true;
							}
						}
					}
					else
					{
						if(isset($case['_links']['notes']['count']) && !empty($case['_links']['notes']['count']))
						{
							$case_notes_exist = true;
						}
						else
						{
							$case_notes_exist = false;
						}
						$case_id_array[] = array('id' => $case['id'], 'subject' => $case['subject'], 'status' => $case['status'], 'labels' => $case['labels'], 'assigned_user' => $case['_links']['assigned_user'],
															'assigned_group' => $case['_links']['assigned_group'], 'priority' => $case['priority'], 'notes' => $case_notes_exist);
						$already_to_array_added_DeskIDs[$case['id']] = true;

						// Session Stats
						if($GLOBALS['show_session_stats'] === true)
						{
							$_SESSION['session_stats']['cases_overall'][$case['id']] = true;
							if(strpos($case['subject'], 'Abuse report concerning ') !== false || strpos($case['subject'], 'Strike concerning ') !== false)
							{
								$_SESSION['session_stats']['report_cases'][$case['id']] = true;
							}
							elseif(strpos($case['subject'], 'Whisper Report concerning ') !== false)
							{
								$_SESSION['session_stats']['whisper_cases'][$case['id']] = true;
							}
							elseif(strpos($case['subject'], 'Channel feed report concerning ') !== false || strpos($case['subject'], 'Channel feed comment report concerning ') !== false)
							{
								$_SESSION['session_stats']['channel_feed_cases'][$case['id']] = true;
							}
							elseif(strpos($case['subject'], 'Clip report concerning ') !== false)
							{
								$_SESSION['session_stats']['clip_cases'][$case['id']] = true;
							}
						}
					}
				}
			}

			// Check if multi mode is enabled and if we have enough cases for the current user. If we don't then check if this page was "full" and if there is a next page to load cases from
			if($GLOBALS['use_redis'] === true && $GLOBALS['offer_case_distribution'] === true && isset($_SESSION['case_distribution_enabled']) && $_SESSION['case_distribution_enabled'] === true)
			{
				if((count($case_id_array) < 55 || $GLOBALS['preload_all_pages'] === true) && isset($json_decode['total_entries']) && $json_decode['total_entries'] >= ($page * $per_page))
				{
					// Get the next page to get more results
					$page = $page + 1;
					goto request_start;
				}
			}
			elseif($GLOBALS['preload_all_pages'] === true && isset($json_decode['total_entries']) && $json_decode['total_entries'] >= ($page * $per_page))
			{
				// Get the next page to get more results
				$page = $page + 1;
				goto request_start;
			}
		}
		else
		{
			echo 'Json decode error while getting cases!<br>'.PHP_EOL;
			exit();
		}

		sorting_and_end:
		// Sort the cases better (group them by subject (channel))
		$case_id_array = better_sort_order_for_cases($case_id_array);

		return $case_id_array;
	}
}

function better_sort_order_for_cases($case_id_array)
{
	$sorted_case_id_array = array();
	$case_id_array_count = count($case_id_array);
	for($i = 0; $i < $case_id_array_count; $i++)
	{
		if(isset($case_id_array[$i]))
		{
			// Add it to the array
			$sorted_case_id_array[] = $case_id_array[$i];
			// Check if more cases are in the $case_id_array with the same subject
			for($o = $i+1; $o < $case_id_array_count; $o++)
			{
				if(isset($case_id_array[$o]))
				{
					if($case_id_array[$o]['subject'] == $case_id_array[$i]['subject'])
					{
						$sorted_case_id_array[] = $case_id_array[$o];
						// Remove it from the list so we don't add it a later time again
						unset($case_id_array[$o]);
					}
				}
			}
		}
	}

	// Now limit it to 50 ish (aka 50 + rest of the reports against the 50th channel)
	$sorted_case_id_array_count = count($sorted_case_id_array);
	if($sorted_case_id_array_count > 50)
	{
		for($i = 49; $i < $sorted_case_id_array_count; $i++)
		{
			if(isset($last_subject) && $last_subject != $sorted_case_id_array[$i]['subject'])
			{
				$split_at_count = $i;
				break;
			}
			$last_subject = $sorted_case_id_array[$i]['subject'];
		}

		if(isset($split_at_count))
		{
			$sorted_case_id_array = array_slice($sorted_case_id_array, 0, $split_at_count);
		}
	}

	return $sorted_case_id_array;
}

function check_for_resolve_based_on_current_better_desk_user($case_reporter)
{
	static $report_name_to_deskID_array = array('xangold' => 21288400, 'commanderroot' => 21812684, 'sournothardcore' => 21812799, 'imsammy' => 21812838, 'debunk' => 21812849, 'pipe' => 21812860,
										'logan' => 21812866, 'fire' => 21812870, 'itaku' => 21812873, 'zombiejill' => 21812877, 's0n0s' => 21812880, 'duffmana' => 21822639, 'klutch' => 21822648,
										'george' => 21822651, 'jhnnycrwsh' => 21822652, 'truthful' => 21837642, 'kazzy' => 22379478, 'ancientpriest' => 22379483, 'rapid' => 22379487,
										'kanthes' => 22623519, 'tarfu' => 22665955, 'squishy' => 22763533, 'shannonzkiller' => 22932549, 'visual' => 23196671, 'darkbase' => 23260108,
										'simple' => 23803097, 'distortednet' => 23891402, 'healthytofu' => 23891407, '3ventic' => 23891420, 'vespher' => 23892534, 'aeo' => 23892549,
										'boomliam' => 24294620, 'brokonaut' => 24294623, 'goat_herd' => 24294625, 'moblord' => 24294627, 'mrfig19' => 24294629, 'netstormuk' => 24294631,
										'wolfyy' => 24294632, 'nox' => 24381055, 'chyadosensei' => 24430003, 'moorlly' => 24710148, 'girlonduty' => 24824270, 'loljenkins' => 24824291,
										'lucky_misfit' => 24824293, 'thorlar' => 24824296, 'trainwreckjp' => 24824309);
	$case_reporter = strtolower($case_reporter);

	if(isset($report_name_to_deskID_array[$case_reporter]) && $report_name_to_deskID_array[$case_reporter] == $_SESSION['user']['desk_ID'])
	{
		return true;
	}
	else
	{
		return false;
	}
}

function load_desk_notes($case_ID)
{
	$return = '<br>'.PHP_EOL;
	$ch = &$GLOBALS['global_curl'];
	// First get the note "overwiew" because there can be more than 1 note
	$request_url = $GLOBALS['DESK_API_DOMAIN'].'/api/v2/cases/'.$case_ID.'/notes';
	apply_curl_defaults($ch);
	curl_setopt($ch, CURLOPT_URL, $request_url);
	if(isset($_SESSION['login_method']) && $_SESSION['login_method'] === 'oauth')
	{
		$oauth_request_header = $GLOBALS['global_oauth']->getRequestHeader('GET', $request_url);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/json', 'Authorization: '.$oauth_request_header));
	}
	$curl_output = curl_exec($ch);
	$curl_info = curl_getinfo($ch);
	if($curl_output === false)
	{
		echo 'Curl error on "'.$curl_info['url'].'" => '.curl_error($ch);
		exit();
	}
	else
	{
		$curl_parse = parse_desk_curl_output($curl_output);
		if($curl_info['http_code'] >= 200 && $curl_info['http_code'] <= 204)
		{
			// Request was successful
		}
		elseif($curl_info['http_code'] == 304)
		{
			// Never happens as I don't use ETAG's but if I did it would be successful
		}
		elseif($curl_info['http_code'] == 429)
		{
			header('HTTP/1.1 429 Desk Rate Limit', true, 429);
			echo 'DESK: hit rate limit on URL: '.$curl_info['url'];
			exit();
		}
		elseif($curl_info['http_code'] == 401)
		{
			echo 'Invalid desk credentials!<br>'.PHP_EOL;
			do_logout(false);
		}
		else
		{
			// Some other HTTP error => Try again
			echo 'CURL: HTTP ERROR ('.$curl_info['http_code'].'): '.$curl_info['url'].PHP_EOL; // print_r($curl_parse, true);
			exit();
		}

		$json_decode = json_decode($curl_parse['content'], true);
		if($json_decode !== NULL)
		{
			foreach($json_decode['_embedded']['entries'] as $note)
			{
				$return .= nl2br(htmlspecialchars($note['body'], ENT_QUOTES|ENT_HTML5), false).'<hr><br>';
			}

			if(count($json_decode['_embedded']['entries']) == 0)
			{
				$return .= 'No notes found for this case'.PHP_EOL.'<hr><br>';
			}
		}
		else
		{
			echo 'Json decode error while getting notes!'.PHP_EOL;
			exit();
		}
	}
	return $return;
}

function check_for_email_headers_in_body_top_line($json_decode)
{
	if(strpos($json_decode['subject'], 'Abuse report concerning ') !== false || strpos($json_decode['subject'], 'Strike concerning ') !== false || strpos($json_decode['subject'], 'Clip report concerning ') !== false)
	{
		if(!isset($json_decode['body_text']) || empty($json_decode['body_text']))
		{
			$mail_body_content = $json_decode['body'];
			$mail_content_type = 'body';
		}
		else
		{
			$mail_body_content = $json_decode['body_text'];
			$mail_content_type = 'body_text';
		}

		// Check if the first char is the right char for a json string
		if(substr($mail_body_content, 0, 1) == '{')
		{
			$line_end = strpos($mail_body_content, "\n");
			if($line_end !== false)
			{
				$json_line = trim(substr($mail_body_content, 0, $line_end));
				$json_line_decode = json_decode($json_line, true);
				if($json_line_decode !== NULL && isset($json_line_decode['Date']) && isset($json_line_decode['Message-ID']))
				{
					$json_decode['modified_by_root'] = true;
					$json_decode['headers']['Date'] = $json_line_decode['Date'];
					$json_decode['headers']['Message-ID'] = $json_line_decode['Message-ID'];

					// Now remove the json part from the report message
					$Abuse_report_start = strpos($mail_body_content, 'Abuse report');
					$Clips_Abuse_Report_start = strpos($mail_body_content, 'Clips Abuse Report');
					if($Abuse_report_start !== false)
					{
						$json_decode[$mail_content_type] = substr($mail_body_content, $Abuse_report_start);
					}
					elseif($Clips_Abuse_Report_start !== false)
					{
						$json_decode[$mail_content_type] = substr($mail_body_content, $Clips_Abuse_Report_start);
					}
				}
			}
		}
	}

	return $json_decode;
}

function get_full_open_cases($open_cases_overview)
{
	$ch = &$GLOBALS['global_curl'];
	if($GLOBALS['use_redis'] === true)
	{
		// Connect to redis
		$redis = get_redis_connection()['redis'];
		$redis_is_connected = get_redis_connection()['redis_is_connected'];
		$redis_ttl = (8 * 60 * 60);
		$redis_messageID_ttl = (3 * 24 * 60 * 60);
		$redis_prefix = 'twitch-desk-case:';
		$redis_prefix_messageID = 'twitch-desk-case-messageID:';
		if($redis_is_connected === true)
		{
			$redis->setOption(Redis::OPT_PREFIX, $redis_prefix);
		}
	}

	$full_case_array = array();
	$already_added_for_display_MessageID = array();

	if(!isset($_SESSION['caseMessage_cache_array']))
	{
		$_SESSION['caseMessage_cache_array'] = array();
	}

	foreach($open_cases_overview as $case)
	{
		// Check if it's already cached
		if(isset($json_decode)) unset($json_decode);
		if($GLOBALS['use_redis'] === true)
		{
			if($redis_is_connected === true)
			{
				$redis_response_time_start = microtime(true);
				$redis_response = $redis->get($case['id']);
				if($redis_response !== false)
				{
					$json_decode = $redis_response;
					// Reset the TTL of the key
					$redis->setTimeout($case['id'], $redis_ttl);
					$GLOBALS['curl_request_info_string'] .= '<!-- Found case message for ID: "'.htmlspecialchars($case['id'], ENT_QUOTES|ENT_HTML5).'" in cache (redis ('.(microtime(true) - $redis_response_time_start).')) -->'.PHP_EOL;
				}
				unset($redis_response);
			}
		}
		else
		{
			foreach($_SESSION['caseMessage_cache_array'] as $cache_entry)
			{
				if($cache_entry['caseID'] == $case['id'])
				{
					$json_decode = $cache_entry['response'];
					$GLOBALS['curl_request_info_string'] .= '<!-- Found case message for ID: "'.htmlspecialchars($case['id'], ENT_QUOTES|ENT_HTML5).'" in cache -->'.PHP_EOL;
					break;
				}
			}
		}

		if(!isset($json_decode) || empty($json_decode))
		{
			// Need to do this way because Desk is returning HTTP 500 on some cases if we ask for it so we don't in the retry
			$headers_url_string = 'headers,';
			$request_counter = 0;
			redo_request:
			$request_counter = $request_counter + 1;
			$request_url = $GLOBALS['DESK_API_DOMAIN'].'/api/v2/cases/'.$case['id'].'/message?fields=subject,'.$headers_url_string.'body_text,body';
			$headers_url_string = '';
			apply_curl_defaults($ch);
			curl_setopt($ch, CURLOPT_URL, $request_url);
			if(isset($_SESSION['login_method']) && $_SESSION['login_method'] === 'oauth')
			{
				$oauth_request_header = $GLOBALS['global_oauth']->getRequestHeader('GET', $request_url);
				curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/json', 'Authorization: '.$oauth_request_header));
			}
			$curl_output = curl_exec($ch);
			$curl_info = curl_getinfo($ch);
			if($curl_output === false)
			{
				$GLOBALS['curl_error_string'] .= 'Curl error on '.htmlspecialchars('"'.$curl_info['url'].'"', ENT_QUOTES|ENT_HTML5).' => '.htmlspecialchars(curl_error($ch), ENT_QUOTES|ENT_HTML5).'<br>'.PHP_EOL;
				goto redo_request;
			}

			$curl_parse = parse_desk_curl_output($curl_output);
			if($curl_info['http_code'] >= 200 && $curl_info['http_code'] <= 204)
			{
				// Request was successful
			}
			elseif($curl_info['http_code'] == 304)
			{
				// Never happens as I don't use ETAG's but if I did it would be successful
			}
			elseif($curl_info['http_code'] == 429)
			{
				header('HTTP/1.1 429 Desk Rate Limit', true, 429);
				echo 'DESK: hit rate limit on URL: '.$curl_info['url'];

				// Add a 5 sec javascript auto reload here so it still continue to update
				echo PHP_EOL.'<script type="text/javascript">setTimeout(function () { window.location.reload(); }, 5000);</script>';
				exit();
			}
			elseif($curl_info['http_code'] == 401)
			{
				echo 'Invalid desk credentials!<br>'.PHP_EOL;
				do_logout(false);
			}
			elseif($curl_info['http_code'] == 500)
			{
				// Internal Server error
				if($request_counter >= 2)
				{
					echo 'CURL: HTTP ERROR ('.$curl_info['http_code'].'): '.$curl_info['url'].PHP_EOL;
					exit();
				}
				goto redo_request;
			}
			else
			{
				// Some other HTTP error => Try again
				echo 'CURL: HTTP ERROR ('.$curl_info['http_code'].'): '.$curl_info['url'].PHP_EOL; // print_r($curl_parse, true);

				// Add a 5 sec javascript auto reload here so it still continue to update
				echo PHP_EOL.'<script type="text/javascript">setTimeout(function () { window.location.reload(); }, 5000);</script>';
				exit();
			}

			$GLOBALS['curl_request_info_string'] .= '<!-- '.htmlspecialchars($curl_info['url'], ENT_QUOTES|ENT_HTML5).' took => DNS: '.htmlspecialchars($curl_info['namelookup_time'], ENT_QUOTES|ENT_HTML5).' / Connect: '.htmlspecialchars($curl_info['connect_time'], ENT_QUOTES|ENT_HTML5).' / Total: '.htmlspecialchars($curl_info['total_time'], ENT_QUOTES|ENT_HTML5).' seconds -->'.PHP_EOL;
			$GLOBALS['global_api_request_time'] = $GLOBALS['global_api_request_time'] + $curl_info['total_time'];

			$json_decode = json_decode($curl_parse['content'], true);
			if($json_decode !== NULL && (!isset($json_decode['headers']['Message-ID']) || !isset($json_decode['headers']['Date'])))
			{
				// Doesn't have the email headers I need so I need to check if they are json encoded in the top line of the body (and add them if they are there)
				$json_decode = check_for_email_headers_in_body_top_line($json_decode);
			}

			if($GLOBALS['use_redis'] === true)
			{
				if($redis_is_connected === true && $json_decode !== NULL)
				{
					$redis->setex($case['id'], $redis_ttl, $json_decode);
				}
			}
			else
			{
				// Check if it's already cached
				$already_cached = false;
				foreach($_SESSION['caseMessage_cache_array'] as $cache_entry)
				{
					if($cache_entry['caseID'] == $case['id'])
					{
						$already_cached = true;
						break;
					}
				}
				// Only add it to the array if it's not already cached
				if($already_cached === false && $json_decode !== NULL)
				{
					$_SESSION['caseMessage_cache_array'][] = array('caseID' => $case['id'], 'response' => $json_decode);
				}

				// Keep cache limited to X (250) entries
				if(count($_SESSION['caseMessage_cache_array']) > 250)
				{
					$_SESSION['caseMessage_cache_array'] = array_slice($_SESSION['caseMessage_cache_array'], (count($_SESSION['caseMessage_cache_array']) - 250));
				}
			}
		}

		if($json_decode !== NULL)
		{
			// print_r($json_decode);
			// exit();
			if(!isset($_SESSION['auto_resolve_by_reporter_array']))
			{
				$_SESSION['auto_resolve_by_reporter_array'] = array();
			}
			if(!isset($_SESSION['do_not_autoresolve_by_reporter_array']))
			{
				$_SESSION['do_not_autoresolve_by_reporter_array'] = array();
			}


			if(!isset($json_decode['body_text']) || empty($json_decode['body_text']))
			{
				$mail_body_content = $json_decode['body'];
			}
			else
			{
				$mail_body_content = $json_decode['body_text'];
			}
			$case_reporter = get_case_reporter($mail_body_content, true);


			if(!isset($json_decode['created_at']) || empty($json_decode['created_at']))
			{
				// Get the whisper created_at from the whisper body
				$json_decode['created_at'] = get_report_date_from_body($mail_body_content);
			}

			// Whisper stats in redis
			if($GLOBALS['use_redis'] === true && $GLOBALS['enable_whisper_report_stats'] === true && strpos($case['subject'], 'Whisper Report concerning ') !== false)
			{
				add_whisper_stats(get_channel_from_subject($case['subject']), $case_reporter['short'], $json_decode['created_at']);
			}

			// Add Message-ID to the list so if another case has the same ID it gets resolved for duplicate
			if(isset($json_decode['headers']['Message-ID']) && !empty($json_decode['headers']['Message-ID']))
			{
				// Add it into redis (messageID => caseID)
				if($GLOBALS['use_redis'] === true && $redis_is_connected === true)
				{
					// Set the prefix for Message-ID entries
					$redis->setOption(Redis::OPT_PREFIX, $redis_prefix_messageID);
					$redis_response = $redis->exists($json_decode['headers']['Message-ID']);
					if($redis_response === false)
					{
						// Only add it if the Message-ID not already exists
						$redis->setex($json_decode['headers']['Message-ID'], $redis_messageID_ttl, $case['id']);
					}
					unset($redis_response);
					// Reset the prefix to the normal one
					$redis->setOption(Redis::OPT_PREFIX, $redis_prefix);
				}
			}

			$add_case_to_array = true;
			if(isset($json_decode['headers']['Message-ID']) && !empty($json_decode['headers']['Message-ID']) && in_array($json_decode['headers']['Message-ID'], $already_added_for_display_MessageID))
			{
				// Resolve because it will already be displayed and its a duplicate
				if(isset($_SESSION['show_debug']) && $_SESSION['show_debug'] === true)
				{
					$subject_explode = explode(' ', trim($case['subject']));
					for($i = 0; $i < (count($subject_explode) - 1); $i++)
					{
						$GLOBALS['warning_string'] .= htmlspecialchars($subject_explode[$i], ENT_QUOTES|ENT_HTML5).' ';
					}
					$GLOBALS['warning_string'] .= '<a href="https://player.twitch.tv/?channel='.rawurlencode($subject_explode[(count($subject_explode) - 1)]).'" target="_blank" rel="noreferrer">'.htmlspecialchars($subject_explode[(count($subject_explode) - 1)], ENT_QUOTES|ENT_HTML5).'</a> (Duplicate) => ';
					unset($subject_explode);
					$GLOBALS['warning_string'] .= htmlspecialchars(do_assign_and_resolve($case['id'], true, array('report - autoresolve', 'autoresolve - duplicate')), ENT_QUOTES|ENT_HTML5);
					$GLOBALS['warning_string'] .= '<br>'.PHP_EOL;
				}
				else
				{
					$unused_var = do_assign_and_resolve($case['id'], true, array('report - autoresolve', 'autoresolve - duplicate'));
					unset($unused_var);
				}
				$add_case_to_array = false;
				// Session Stats
				if($GLOBALS['show_session_stats'] === true)
				{
					$_SESSION['session_stats']['cases_overall'][$case['id']] = true;
					$_SESSION['session_stats']['duplicate_cases'][$case['id']] = true;
					if(strpos($case['subject'], 'Abuse report concerning ') !== false || strpos($case['subject'], 'Strike concerning ') !== false)
					{
						$_SESSION['session_stats']['report_cases'][$case['id']] = true;
					}
					elseif(strpos($case['subject'], 'Whisper Report concerning ') !== false)
					{
						$_SESSION['session_stats']['whisper_cases'][$case['id']] = true;
					}
					elseif(strpos($case['subject'], 'Channel feed report concerning ') !== false || strpos($case['subject'], 'Channel feed comment report concerning ') !== false)
					{
						$_SESSION['session_stats']['channel_feed_cases'][$case['id']] = true;
					}
					elseif(strpos($case['subject'], 'Clip report concerning ') !== false)
					{
						$_SESSION['session_stats']['clip_cases'][$case['id']] = true;
					}
				}
			}
			elseif(isset($json_decode['headers']['Message-ID']) && !empty($json_decode['headers']['Message-ID']) && $GLOBALS['use_redis'] === true && $redis_is_connected === true)
			{
				// Set the prefix for Message-ID entries
				$redis->setOption(Redis::OPT_PREFIX, $redis_prefix_messageID);
				$redis_response = $redis->get($json_decode['headers']['Message-ID']);
				if($redis_response !== false)
				{
					if($redis_response != $case['id'])
					{
						// Resolve because we already displayed the same case with a different Desk case ID
						if(isset($_SESSION['show_debug']) && $_SESSION['show_debug'] === true)
						{
							$subject_explode = explode(' ', trim($case['subject']));
							for($i = 0; $i < (count($subject_explode) - 1); $i++)
							{
								$GLOBALS['warning_string'] .= htmlspecialchars($subject_explode[$i], ENT_QUOTES|ENT_HTML5).' ';
							}
							$GLOBALS['warning_string'] .= '<a href="https://player.twitch.tv/?channel='.rawurlencode($subject_explode[(count($subject_explode) - 1)]).'" target="_blank" rel="noreferrer">'.htmlspecialchars($subject_explode[(count($subject_explode) - 1)], ENT_QUOTES|ENT_HTML5).'</a> (Duplicate) => ';
							unset($subject_explode);
							$GLOBALS['warning_string'] .= htmlspecialchars(do_assign_and_resolve($case['id'], true, array('report - autoresolve', 'autoresolve - duplicate')), ENT_QUOTES|ENT_HTML5);
							$GLOBALS['warning_string'] .= '<br>'.PHP_EOL;
						}
						else
						{
							$unused_var = do_assign_and_resolve($case['id'], true, array('report - autoresolve', 'autoresolve - duplicate'));
							unset($unused_var);
						}
						$add_case_to_array = false;
						// Session Stats
						if($GLOBALS['show_session_stats'] === true)
						{
							$_SESSION['session_stats']['cases_overall'][$case['id']] = true;
							$_SESSION['session_stats']['duplicate_cases'][$case['id']] = true;
							if(strpos($case['subject'], 'Abuse report concerning ') !== false || strpos($case['subject'], 'Strike concerning ') !== false)
							{
								$_SESSION['session_stats']['report_cases'][$case['id']] = true;
							}
							elseif(strpos($case['subject'], 'Whisper Report concerning ') !== false)
							{
								$_SESSION['session_stats']['whisper_cases'][$case['id']] = true;
							}
							elseif(strpos($case['subject'], 'Channel feed report concerning ') !== false || strpos($case['subject'], 'Channel feed comment report concerning ') !== false)
							{
								$_SESSION['session_stats']['channel_feed_cases'][$case['id']] = true;
							}
							elseif(strpos($case['subject'], 'Clip report concerning ') !== false)
							{
								$_SESSION['session_stats']['clip_cases'][$case['id']] = true;
							}
						}
					}
				}
				unset($redis_response);
				// Reset the prefix to the normal one
				$redis->setOption(Redis::OPT_PREFIX, $redis_prefix);
			}
			// If it's still $add_case_to_array === true then check further
			if($add_case_to_array === true)
			{
				if($GLOBALS['check_subject_after_pull'] === true && isset($_SESSION['auto_resolve_by_subject_array'][$case['subject']]) && empty($case_reporter['admin_type']) && (empty($case_reporter['short']) || !isset($_SESSION['do_not_autoresolve_by_reporter_array'][$case_reporter['short']])))
				{
					// Resolve by subject here if the option for it is enabled
					if(strpos($case['subject'], 'Abuse report concerning ') !== false || strpos($case['subject'], 'Strike concerning ') !== false || strpos($case['subject'], 'Whisper Report concerning ') !== false || strpos($case['subject'], 'Channel feed report concerning ') !== false || strpos($case['subject'], 'Channel feed comment report concerning ') !== false || strpos($case['subject'], 'Clip report concerning ') !== false)
					{
						// It's an report so we will add it with a link
						$subject_explode = explode(' ', trim($case['subject']));
						for($i = 0; $i < (count($subject_explode) - 1); $i++)
						{
							$GLOBALS['warning_string'] .= htmlspecialchars($subject_explode[$i], ENT_QUOTES|ENT_HTML5).' ';
						}
						$GLOBALS['warning_string'] .= '<a href="https://player.twitch.tv/?channel='.rawurlencode($subject_explode[(count($subject_explode) - 1)]).'" target="_blank" rel="noreferrer">'.htmlspecialchars($subject_explode[(count($subject_explode) - 1)], ENT_QUOTES|ENT_HTML5).'</a> => ';
						unset($subject_explode);
					}
					else
					{
						$GLOBALS['warning_string'] .= htmlspecialchars($case['subject'], ENT_QUOTES|ENT_HTML5).' => ';
					}
					$GLOBALS['warning_string'] .= htmlspecialchars(do_assign_and_resolve($case['id'], true, array('report - autoresolve', 'autoresolve - subject')), ENT_QUOTES|ENT_HTML5);
					$GLOBALS['warning_string'] .= '<br>'.PHP_EOL;
					$add_case_to_array = false;
					// Session Stats
					if($GLOBALS['show_session_stats'] === true)
					{
						$_SESSION['session_stats']['cases_overall'][$case['id']] = true;
						$_SESSION['session_stats']['auto_resolved_subject_cases'][$case['id']] = true;
						if(strpos($case['subject'], 'Abuse report concerning ') !== false || strpos($case['subject'], 'Strike concerning ') !== false)
						{
							$_SESSION['session_stats']['report_cases'][$case['id']] = true;
						}
						elseif(strpos($case['subject'], 'Whisper Report concerning ') !== false)
						{
							$_SESSION['session_stats']['whisper_cases'][$case['id']] = true;
						}
						elseif(strpos($case['subject'], 'Channel feed report concerning ') !== false || strpos($case['subject'], 'Channel feed comment report concerning ') !== false)
						{
							$_SESSION['session_stats']['channel_feed_cases'][$case['id']] = true;
						}
						elseif(strpos($case['subject'], 'Clip report concerning ') !== false)
						{
							$_SESSION['session_stats']['clip_cases'][$case['id']] = true;
						}
					}
				}
				elseif(!empty($case_reporter['short']) && isset($_SESSION['auto_resolve_by_reporter_array'][$case_reporter['short']]) && !isset($_SESSION['do_not_autoresolve_by_reporter_array'][$case_reporter['short']]))
				{
					// Only if it's in the list => resolve and assign case
					$subject_explode = explode(' ', trim($case['subject']));
					for($i = 0; $i < (count($subject_explode) - 1); $i++)
					{
						$GLOBALS['warning_string'] .= htmlspecialchars($subject_explode[$i], ENT_QUOTES|ENT_HTML5).' ';
					}
					$GLOBALS['warning_string'] .= '<a href="https://player.twitch.tv/?channel='.rawurlencode($subject_explode[(count($subject_explode) - 1)]).'" target="_blank" rel="noreferrer">'.htmlspecialchars($subject_explode[(count($subject_explode) - 1)], ENT_QUOTES|ENT_HTML5).'</a> (Reporter: <a href="https://www-origin.twitch.tv/'.rawurlencode($case_reporter['short']).'?bttvAnonChat=true&amp;tmi_host=false" target="_blank" rel="noreferrer">'.htmlspecialchars($case_reporter['short'], ENT_QUOTES|ENT_HTML5).'</a>) => ';
					unset($subject_explode);
					$GLOBALS['warning_string'] .= htmlspecialchars(do_assign_and_resolve($case['id'], true, array('report - autoresolve', 'autoresolve - reporter')), ENT_QUOTES|ENT_HTML5);
					$GLOBALS['warning_string'] .= '<br>'.PHP_EOL;
					$add_case_to_array = false;
					// Session Stats
					if($GLOBALS['show_session_stats'] === true)
					{
						$_SESSION['session_stats']['cases_overall'][$case['id']] = true;
						$_SESSION['session_stats']['auto_resolved_reporter_cases'][$case['id']] = true;
						if(strpos($case['subject'], 'Abuse report concerning ') !== false || strpos($case['subject'], 'Strike concerning ') !== false)
						{
							$_SESSION['session_stats']['report_cases'][$case['id']] = true;
						}
						elseif(strpos($case['subject'], 'Whisper Report concerning ') !== false)
						{
							$_SESSION['session_stats']['whisper_cases'][$case['id']] = true;
						}
						elseif(strpos($case['subject'], 'Channel feed report concerning ') !== false || strpos($case['subject'], 'Channel feed comment report concerning ') !== false)
						{
							$_SESSION['session_stats']['channel_feed_cases'][$case['id']] = true;
						}
						elseif(strpos($case['subject'], 'Clip report concerning ') !== false)
						{
							$_SESSION['session_stats']['clip_cases'][$case['id']] = true;
						}
					}
				}
				elseif(strpos($case['subject'], 'Strike concerning ') !== false && !empty($case_reporter['short']) && check_for_resolve_based_on_current_better_desk_user($case_reporter['short']) === true && !isset($_SESSION['do_not_autoresolve_by_reporter_array'][$case_reporter['short']]))
				{
					// Current Better Desk Admin TOS report
					$subject_explode = explode(' ', trim($case['subject']));
					for($i = 0; $i < (count($subject_explode) - 1); $i++)
					{
						$GLOBALS['warning_string'] .= htmlspecialchars($subject_explode[$i], ENT_QUOTES|ENT_HTML5).' ';
					}
					$GLOBALS['warning_string'] .= '<a href="https://player.twitch.tv/?channel='.rawurlencode($subject_explode[(count($subject_explode) - 1)]).'" target="_blank" rel="noreferrer">'.htmlspecialchars($subject_explode[(count($subject_explode) - 1)], ENT_QUOTES|ENT_HTML5).'</a> (Your TOS report) => ';
					unset($subject_explode);
					$GLOBALS['warning_string'] .= htmlspecialchars(do_assign_and_resolve($case['id'], true, array('report - autoresolve', 'autoresolve - own strike')), ENT_QUOTES|ENT_HTML5);
					$GLOBALS['warning_string'] .= '<br>'.PHP_EOL;
					$add_case_to_array = false;
					// Session Stats
					if($GLOBALS['show_session_stats'] === true)
					{
						$_SESSION['session_stats']['cases_overall'][$case['id']] = true;
						$_SESSION['session_stats']['auto_resolved_own_tos_cases'][$case['id']] = true;
						if(strpos($case['subject'], 'Abuse report concerning ') !== false || strpos($case['subject'], 'Strike concerning ') !== false)
						{
							$_SESSION['session_stats']['report_cases'][$case['id']] = true;
						}
						elseif(strpos($case['subject'], 'Whisper Report concerning ') !== false)
						{
							$_SESSION['session_stats']['whisper_cases'][$case['id']] = true;
						}
						elseif(strpos($case['subject'], 'Channel feed report concerning ') !== false || strpos($case['subject'], 'Channel feed comment report concerning ') !== false)
						{
							$_SESSION['session_stats']['channel_feed_cases'][$case['id']] = true;
						}
						elseif(strpos($case['subject'], 'Clip report concerning ') !== false)
						{
							$_SESSION['session_stats']['clip_cases'][$case['id']] = true;
						}
					}
				}
				elseif(isset($_SESSION['auto_resolve_by_reporter_array']['*']) && isset($json_decode['headers']['Date']) && strtotime($json_decode['headers']['Date']) <= (time() - (20 * 60)) && !isset($_SESSION['do_not_autoresolve_by_reporter_array'][$case_reporter['short']]))
				{
					// Resolve every case that's older than 20 min if the option is set
					if(strpos($case['subject'], 'Abuse report concerning ') !== false || strpos($case['subject'], 'Strike concerning ') !== false || strpos($case['subject'], 'Whisper Report concerning ') !== false)
					{
						// It's an report so we will add it with a link
						$subject_explode = explode(' ', trim($case['subject']));
						for($i = 0; $i < (count($subject_explode) - 1); $i++)
						{
							$GLOBALS['warning_string'] .= htmlspecialchars($subject_explode[$i], ENT_QUOTES|ENT_HTML5).' ';
						}
						$GLOBALS['warning_string'] .= '<a href="https://player.twitch.tv/?channel='.rawurlencode($subject_explode[(count($subject_explode) - 1)]).'" target="_blank" rel="noreferrer">'.htmlspecialchars($subject_explode[(count($subject_explode) - 1)], ENT_QUOTES|ENT_HTML5).'</a> (Older than 20 minutes) => ';
						unset($subject_explode);
					}
					else
					{
						$GLOBALS['warning_string'] .= htmlspecialchars($case['subject'], ENT_QUOTES|ENT_HTML5).' => ';
					}
					$GLOBALS['warning_string'] .= htmlspecialchars(do_assign_and_resolve($case['id'], true, array('report - autoresolve', 'autoresolve - age')), ENT_QUOTES|ENT_HTML5);
					$GLOBALS['warning_string'] .= '<br>'.PHP_EOL;
					$add_case_to_array = false;
					// Session Stats
					if($GLOBALS['show_session_stats'] === true)
					{
						$_SESSION['session_stats']['cases_overall'][$case['id']] = true;
						$_SESSION['session_stats']['auto_resolved_by_age_cases'][$case['id']] = true;
						if(strpos($case['subject'], 'Abuse report concerning ') !== false || strpos($case['subject'], 'Strike concerning ') !== false)
						{
							$_SESSION['session_stats']['report_cases'][$case['id']] = true;
						}
						elseif(strpos($case['subject'], 'Whisper Report concerning ') !== false)
						{
							$_SESSION['session_stats']['whisper_cases'][$case['id']] = true;
						}
						elseif(strpos($case['subject'], 'Channel feed report concerning ') !== false || strpos($case['subject'], 'Channel feed comment report concerning ') !== false)
						{
							$_SESSION['session_stats']['channel_feed_cases'][$case['id']] = true;
						}
						elseif(strpos($case['subject'], 'Clip report concerning ') !== false)
						{
							$_SESSION['session_stats']['clip_cases'][$case['id']] = true;
						}
					}
				}
			}


			// Only add the case to the array if it's not set to false because another action was already taken
			if($add_case_to_array === true)
			{
				if(isset($json_decode['headers']['Date']) && !empty($json_decode['headers']['Date']))
				{
					$json_report_date = $json_decode['headers']['Date'];
				}
				elseif(($report_date_from_body = get_report_date_from_body($mail_body_content)) !== false)
				{
					$json_report_date = $report_date_from_body;
					unset($report_date_from_body);
				}
				else
				{
					$json_report_date = null;
				}

				$full_case_array[] = array('id' => $case['id'], 'subject' =>  $case['subject'], 'status' => $case['status'], 'body' => $mail_body_content,
										'labels' => $case['labels'], 'assigned_user' => $case['assigned_user'], 'assigned_group' => $case['assigned_group'],
										'report_date' => $json_report_date, 'notes' => $case['notes'], 'priority' => $case['priority']);

				// Add Message-ID to the list so if another case has the same ID it gets resolved for duplicate
				if(isset($json_decode['headers']['Message-ID']) && !empty($json_decode['headers']['Message-ID']))
				{
					// Do the normal array stuff here
					if($GLOBALS['use_redis'] === false || !isset($redis_is_connected) || $redis_is_connected === false)
					{
						// Do the normal array stuff
						$already_added_for_display_MessageID[] = $json_decode['headers']['Message-ID'];
					}
				}
			}
		}
		else
		{
			echo 'Json decode error while getting cases!<br>'.PHP_EOL;
			goto redo_request;
		}
	}

	return $full_case_array;
}

function get_report_date_from_body($mail_body)
{
	$mail_in_rows = explode("\n", $mail_body);
	$mail_in_rows_count = count($mail_in_rows);
	// If it's a user report
	if(substr($mail_in_rows[0], 0, 12) == 'Abuse report')
	{
		for($u = 1; $u < $mail_in_rows_count; $u++)
		{
			if(substr($mail_in_rows[$u], 0, 13) == 'Reported At: ')
			{
				return trim(substr($mail_in_rows[$u], 13));
			}
		}
	}
	// Whisper or channel feed
	elseif(substr($mail_in_rows[0], 0, 10) == 'Reporter: ')
	{
		for($u = 1; $u < $mail_in_rows_count; $u++)
		{
			if(substr($mail_in_rows[$u], 0, 13) == 'Reported At: ')
			{
				return trim(substr($mail_in_rows[$u], 13));
			}
		}
	}
	return false;
}

function get_case_reporter($mail_body_text, $as_array = false)
{
	$mail_in_rows = explode("\n", $mail_body_text);
	$from_admin = false;
	$admin_type = '';
	if(substr($mail_in_rows[0], 0, 12) == 'Abuse report')
	{
		$return = '';
		$return2 = '';
		// Is a normal Twitch report
		// Reporter
		for($u = 1; $u < count($mail_in_rows); $u++)
		{
			if(substr($mail_in_rows[$u], 0, 10) == 'Reporter: ')
			{
				if(substr($mail_in_rows[$u], 0, 11) == 'Reporter: [')
				{
					$row_explode = explode(' ', substr($mail_in_rows[$u], strpos($mail_in_rows[$u], '] ')));
					for($i = 0; $i < count($row_explode); $i++)
					{
						if($i == 1)
						{
							$return = $row_explode[$i];
						}

						if($as_array === true && $i == 0)
						{
							$return2 .= substr($mail_in_rows[$u], strpos($mail_in_rows[$u], '['), strpos($mail_in_rows[$u], ']') - strpos($mail_in_rows[$u], '[') + 1);
						}
						elseif($as_array === true && $i >= 1)
						{
							$return2 .= ' '.$row_explode[$i];
						}
					}
					$from_admin = true;
					$admin_type = substr($mail_in_rows[$u], (strpos($mail_in_rows[$u], '[') + 1), strpos($mail_in_rows[$u], ']') - strpos($mail_in_rows[$u], '[') - 1);
				}
				else
				{
					$row_explode = explode(' ', trim($mail_in_rows[$u]));
					for($i = 0; $i < count($row_explode); $i++)
					{
						if($i == 1)
						{
							$return = $row_explode[$i];
						}
						if($as_array === true && $i >= 1)
						{
							$return2 .= ' '.$row_explode[$i];
						}
					}
				}
				unset($row_explode);
				break;
			}
		}
	}
	elseif(substr($mail_in_rows[0], 0, 10) == 'Reporter: ')
	{
		$return = '';
		$return2 = '';
		// Is a Whisper Report or a Channel feed report
		// Reporter
		$row_explode = explode(',', substr($mail_in_rows[0], 10));
		$reporter = trim($row_explode[0]);
		$reporterID = trim($row_explode[1]);

		$return = $reporter;
		$return2 = 'Username: '.$reporter.', UserID: '.$reporterID;
	}
	elseif(substr($mail_in_rows[0], 0, 18) == 'Clips Abuse Report' && substr($mail_in_rows[1], 0, 10) == 'Reporter: ')
	{
		$return = '';
		$return2 = '';
		// Is a Clip report
		// Reporter
		$row_explode = explode(',', substr($mail_in_rows[1], 10));
		$reporter = trim($row_explode[0]);
		$reporterID = trim($row_explode[1]);

		$return = $reporter;
		$return2 = 'Username: '.$reporter.', UserID: '.$reporterID;
	}
	else
	{
		// Couldn't find reporter so just return an empty string
		$return = '';
		$return2 = '';
	}

	if($as_array === true)
	{
		if(!empty($return2))
		{
			$full_return = $return2;
		}
		else
		{
			$full_return = '';
		}

		return array('short' => $return, 'full' => $full_return, 'from_admin' => $from_admin, 'admin_type' => $admin_type);
	}
	else
	{
		return $return;
	}
}

function labels_to_string($labels)
{
	$string = '';

	return $string;
}

function assigned_user_to_string($assigned_user)
{
	$string = '';
	if($assigned_user !== NULL)
	{
		$string = $assigned_user['href'];
	}

	return $string;
}

function get_color_based_on_labels($case_label_array)
{
	if(count($case_label_array) > 0)
	{
		if(in_array('Report - developer', $case_label_array))
		{
			return ' class="btn btn-xs btn-info"';
		}
		elseif(in_array('report - global mod', $case_label_array))
		{
			return ' class="btn btn-xs btn-success"';
		}
		return '';
	}
	else
	{
		return '';
	}
}

function get_color_based_on_admin_type($admin_type)
{
	$admin_type = strtolower($admin_type);
	if($admin_type == 'staff')
	{
		return ' class="btn btn-xs btn-danger"';
	}
	elseif($admin_type == 'admin')
	{
		return ' class="btn btn-xs btn-warning"';
	}
	elseif($admin_type == 'global mod')
	{
		return ' class="btn btn-xs btn-success"';
	}
	return '';
}

function get_color_for_report_reason($reason)
{
	if($reason == 'Kind of abuse: tos_ban_evasion')
	{
		return '<b>Reason:</b> <span style="color:#009933">'.htmlspecialchars(substr($reason, 15), ENT_QUOTES|ENT_HTML5).'</span>'; // Green
	}
	elseif($reason == 'Kind of abuse: chat_ban_evasion')
	{
		return '<b>Reason:</b> <span style="color:#33cc33">'.htmlspecialchars(substr($reason, 15), ENT_QUOTES|ENT_HTML5).'</span>'; // Light Green
	}
	elseif($reason == 'Kind of abuse: selfharm')
	{
		return '<b>Reason:</b> <span style="color:#cc3333">'.htmlspecialchars(substr($reason, 15), ENT_QUOTES|ENT_HTML5).'</span>'; // Red
	}
	elseif($reason == 'Kind of abuse: harm')
	{
		return '<b>Reason:</b> <span style="color:#ff6600; background-color:#009900">'.htmlspecialchars(substr($reason, 15), ENT_QUOTES|ENT_HTML5).'</span>'; // Orange with Green background
	}
	elseif($reason == 'Kind of abuse: hate_speech')
	{
		return '<b>Reason:</b> <span style="color:#663300; background-color:#ffffff">'.htmlspecialchars(substr($reason, 15), ENT_QUOTES|ENT_HTML5).'</span>'; // Brown with White background
	}
	elseif($reason == 'Kind of abuse: offensive_username')
	{
		return '<b>Reason:</b> <span style="color:#0099ff; background-color:#ffffff">'.htmlspecialchars(substr($reason, 15), ENT_QUOTES|ENT_HTML5).'</span>'; // Light blue with White background
	}
	elseif($reason == 'Kind of abuse: impersonation')
	{
		return '<b>Reason:</b> <span style="color:#e5e619">'.htmlspecialchars(substr($reason, 15), ENT_QUOTES|ENT_HTML5).'</span>'; // Yellow
	}
	elseif($reason == 'Kind of abuse: spam')
	{
		return '<b>Reason:</b> <span style="color:#ff9900">'.htmlspecialchars(substr($reason, 15), ENT_QUOTES|ENT_HTML5).'</span>'; // Orange
	}
	elseif($reason == 'Kind of abuse: porn')
	{
		return '<b>Reason:</b> <span style="color:#000000; background-color:#ff0000">'.htmlspecialchars(substr($reason, 15), ENT_QUOTES|ENT_HTML5).'</span>'; // Black on Red background
	}
	elseif($reason == 'Kind of abuse: gore')
	{
		return '<b>Reason:</b> <span style="color:#7f00ff">'.htmlspecialchars(substr($reason, 15), ENT_QUOTES|ENT_HTML5).'</span>'; // Darker Pink
	}
	elseif($reason == 'Kind of abuse: underaged')
	{
		return '<b>Reason:</b> <span style="color:#000066; background-color:#99ccff">'.htmlspecialchars(substr($reason, 15), ENT_QUOTES|ENT_HTML5).'</span>'; // Very Dark Blue on Light Blue
	}
	elseif($reason == 'Kind of abuse: cheating')
	{
		return '<b>Reason:</b> <span style="color:#ff66ff">'.htmlspecialchars(substr($reason, 15), ENT_QUOTES|ENT_HTML5).'</span>'; // Rosa
	}
	elseif($reason == 'Kind of abuse: prohibited')
	{
		return '<b>Reason:</b> <span style="color:#ab87a8">'.htmlspecialchars(substr($reason, 15), ENT_QUOTES|ENT_HTML5).'</span>'; // Grey pink ish
	}
	elseif($reason == 'Kind of abuse: nongaming')
	{
		return '<b>Reason:</b> <span style="color:#007fff">'.htmlspecialchars(substr($reason, 15), ENT_QUOTES|ENT_HTML5).'</span>'; // Blue
	}
	elseif($reason == 'Kind of abuse: creative_conduct')
	{
		return '<b>Reason:</b> <span style="color:#669980">'.htmlspecialchars(substr($reason, 15), ENT_QUOTES|ENT_HTML5).'</span>';
	}
	elseif($reason == 'Kind of abuse: music_conduct')
	{
		return '<b>Reason:</b> <span style="color:#669999">'.htmlspecialchars(substr($reason, 15), ENT_QUOTES|ENT_HTML5).'</span>';
	}

	return '<b>Reason:</b> '.htmlspecialchars(substr($reason, 15), ENT_QUOTES|ENT_HTML5);
}

function gen_fancy_subject_string($subject)
{
	if(strpos($subject, 'Abuse report concerning ') !== false || strpos($subject, 'Strike concerning ') !== false || strpos($subject, 'Whisper Report concerning ') !== false || strpos($subject, 'Channel feed report concerning ') !== false || strpos($subject, 'Channel feed comment report concerning ') !== false || strpos($subject, 'Clip report concerning ') !== false)
	{
		$return = '';
		$subject_explode = explode(' ', trim($subject));
		for($i = 0; $i < (count($subject_explode) - 1); $i++)
		{
			$return .= htmlspecialchars($subject_explode[$i], ENT_QUOTES|ENT_HTML5).' ';
		}
		$return .= '<b><a href="https://www-origin.twitch.tv/'.rawurlencode($subject_explode[(count($subject_explode) - 1)]).'?bttvAnonChat=true&amp;tmi_host=false" target="_blank" rel="noreferrer">'.htmlspecialchars($subject_explode[(count($subject_explode) - 1)], ENT_QUOTES|ENT_HTML5).'</a></b>';
		return $return;
	}
	else
	{
		return htmlspecialchars($subject, ENT_QUOTES|ENT_HTML5);
	}
}

function get_channel_from_subject($subject)
{
	if(strpos($subject, 'Abuse report concerning ') !== false || strpos($subject, 'Strike concerning ') !== false || strpos($subject, 'Whisper Report concerning ') !== false || strpos($subject, 'Channel feed report concerning ') !== false || strpos($subject, 'Channel feed comment report concerning ') !== false || strpos($subject, 'Clip report concerning ') !== false)
	{
		$return = '';
		$subject_explode = explode(' ', trim($subject));
		$return .= htmlspecialchars($subject_explode[(count($subject_explode) - 1)], ENT_QUOTES|ENT_HTML5);
		return $return;
	}
	else
	{
		return 'escalation-case';
	}
}

function check_for_do_not_ban($channel, $is_subject = false)
{
	static $do_not_ban_channel_array = 'GET IT';
	if($do_not_ban_channel_array == 'GET IT')
	{
		$file_content = json_decode(file_get_contents('do_not_ban_list.json'), true);
		if($file_content !== NULL)
		{
			$do_not_ban_channel_array = $file_content;
		}
		unset($file_content);
	}


	if($is_subject === true)
	{
		if(strpos($channel, 'Abuse report concerning ') !== false || strpos($channel, 'Strike concerning ') !== false || strpos($channel, 'Whisper Report concerning ') !== false || strpos($channel, 'Channel feed report concerning ') !== false || strpos($channel, 'Channel feed comment report concerning ') !== false || strpos($channel, 'Clip report concerning ') !== false)
		{
			$subject_explode = explode(' ', trim($channel));
			$channel = strtolower($subject_explode[(count($subject_explode) - 1)]);
		}
	}

	if(isset($do_not_ban_channel_array[$channel]))
	{
		return ' | <b>DO NOT BAN!</b> for "'.htmlspecialchars($do_not_ban_channel_array[$channel]['reason'], ENT_QUOTES|ENT_HTML5).'"';
	}
	else
	{
		return '';
	}
}

function gen_html_output_for_cases($open_full_cases)
{
	if(!isset($_SESSION['already_TOSd_array']))
	{
		$_SESSION['already_TOSd_array'] = array();
	}
	if(!isset($_SESSION['already_Staffed_array']))
	{
		$_SESSION['already_Staffed_array'] = array();
	}

	$html_output = '';
	foreach($open_full_cases as $case)
	{
		$additional_case_class = '';
		if(isset($case['assigned_group']['href']) && $case['assigned_group']['href'] == '/api/v2/groups/396525') // If it's a Moderation Escalation
		{
			// Add sound notification for escalation reports
			$html_output .= '<audio autoplay><source src="alarm_moderation_escalation.mp3" type="audio/mpeg"></audio>'.PHP_EOL;
			$additional_case_class = ' escalation-case';
		}

		$case_reporter = get_case_reporter($case['body']);
		if(!empty($case_reporter) && $case_reporter == 'commanderbot')
		{
			// CommanderBot reports get 0 priority
			if(strpos($case['body'], 'Hello admin,') !== false)
			{
				$case['priority'] = 7;
			}
			else
			{
				$case['priority'] = 0;
			}
		}

		$html_output .= '<div class="panel panel-default'.$additional_case_class.'" id="desk_case_'.$case['id'].'" data-priority="'.htmlspecialchars($case['priority'], ENT_QUOTES|ENT_HTML5).'" data-channel="'.rawurlencode(get_channel_from_subject($case['subject'])).'">'.PHP_EOL;
		$html_output .= '<div class="panel-heading">'.PHP_EOL;
		// Channel status
		$html_output .= '<div id="channel_status_'.$case['id'].'" style="display: inline"></div>';
		// Case subject
		$html_output .= gen_fancy_subject_string($case['subject']);
		// Username translate button for the report targer user
		if(get_channel_from_subject($case['subject']) !== 'escalation-case')
		{
			$html_output .= ' <a href="https://translate.google.com/#auto/en/'.rawurlencode(get_channel_from_subject($case['subject'])).'" target="_blank" rel="noreferrer" onclick="return translate_popup(this.href, \'target_user_'.$case['id'].'\');"><img src="chatlogs/translate.png" title="Translate" alt=""></a>';
			// Display name
			$display_name = get_display_names_from_report($case['body'], $case['subject']);
			if(isset($display_name['target']) && !empty($display_name['target']))
			{
				$html_output .= ' ('.htmlspecialchars($display_name['target'], ENT_QUOTES|ENT_HTML5).')';
				$html_output .= ' <a href="https://translate.google.com/#auto/en/'.rawurlencode($display_name['target']).'" target="_blank" rel="noreferrer" onclick="return translate_popup(this.href, \'target_user_display_name_'.$case['id'].'\');"><img src="chatlogs/translate.png" title="Translate" alt=""></a>';
			}
			unset($display_name);
		}
		$html_output .= ' | ';
		// Button group for the auto resolve / hold
		$html_output .= '<div class="btn-group">';
		// Auto resolve drop down ----------------------------------------------------------------
		$html_output .= '<div class="btn-group"><button type="button" data-toggle="dropdown" class="btn btn-default dropdown-toggle"><span class="glyphicon glyphicon-ok"></span> <span class="caret"></span></button>';
		$html_output .= '<ul class="dropdown-menu bullet">';
		$html_output .= '<li><p class="text-center"><b>Autoresolve duration:</b></p></li>';
		// Only give "expert" options to experts *Kappa*
		if(in_array($_SESSION['user']['desk_ID'], array(21812684 /* CommanderRoot */)))
		{
			$html_output .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_subject_add='.rawurlencode($case['subject']).'&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">Session</a></li>';
		}
		$html_output .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_subject_add='.rawurlencode($case['subject']).'&amp;resolve_time=5&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">5 sec</a></li>';
		$html_output .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_subject_add='.rawurlencode($case['subject']).'&amp;resolve_time=300&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">5 min</a></li>';
		$html_output .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_subject_add='.rawurlencode($case['subject']).'&amp;resolve_time=600&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">10 min</a></li>';
		$html_output .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_subject_add='.rawurlencode($case['subject']).'&amp;resolve_time=900&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">15 min</a></li>';
		if(in_array($_SESSION['user']['desk_ID'], array(21812684 /* CommanderRoot */)))
		{
			$html_output .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_subject_add='.rawurlencode($case['subject']).'&amp;resolve_time=1800&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">30 min</a></li>';
			$html_output .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_subject_add='.rawurlencode($case['subject']).'&amp;resolve_time=3600&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">1 hour</a></li>';
		}
		$html_output .= '</ul></div>';
		// Hold drop down ------------------------------------------------------------------------
		$html_output .= '<div class="btn-group"><button type="button" data-toggle="dropdown" class="btn btn-default dropdown-toggle"><span class="glyphicon glyphicon-tag"></span> <span class="caret"></span></button>';
		$html_output .= '<ul class="dropdown-menu bullet">';
		$html_output .= '<li><p class="text-center"><b>Hold duration:</b></p></li>';
		// Only give "expert" options to experts *Kappa*
		if(in_array($_SESSION['user']['desk_ID'], array(21812684 /* CommanderRoot */)))
		{
			$html_output .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?hold_caseID_add='.rawurlencode($case['id']).'&amp;hold_subject='.rawurlencode($case['subject']).'&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">Session</a></li>';
		}
		$html_output .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?hold_caseID_add='.rawurlencode($case['id']).'&amp;hold_subject='.rawurlencode($case['subject']).'&amp;hold_time=300&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">5 min</a></li>';
		$html_output .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?hold_caseID_add='.rawurlencode($case['id']).'&amp;hold_subject='.rawurlencode($case['subject']).'&amp;hold_time=600&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">10 min</a></li>';
		$html_output .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?hold_caseID_add='.rawurlencode($case['id']).'&amp;hold_subject='.rawurlencode($case['subject']).'&amp;hold_time=900&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">15 min</a></li>';
		$html_output .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?hold_caseID_add='.rawurlencode($case['id']).'&amp;hold_subject='.rawurlencode($case['subject']).'&amp;hold_time=1800&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">30 min</a></li>';
		if(in_array($_SESSION['user']['desk_ID'], array(21812684 /* CommanderRoot */)) || true)
		{
			$html_output .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?hold_caseID_add='.rawurlencode($case['id']).'&amp;hold_subject='.rawurlencode($case['subject']).'&amp;hold_time=3600&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">1 hour</a></li>';
		}
		$html_output .= '</ul></div>';
		// Button group for the auto resolve / hold
		$html_output .= '</div>';
		// Do not ban subject line check
		$html_output .= check_for_do_not_ban($case['subject'], true).PHP_EOL;
		// Show X to remove the case if fade on resolve is enabled
		if(isset($_COOKIE['fade_resolved']) && $_COOKIE['fade_resolved'] == 'on')
		{
			$html_output .= '<a href="javascript:remove_case_and_resort('.$case['id'].');"><span class="glyphicon glyphicon-remove pull-right"></span></a>'.PHP_EOL;
		}
		$html_output .= '</div>'.PHP_EOL;

		$html_output .= '<div class="panel-body" style="word-wrap: normal;">'.PHP_EOL;
		// Mail Body
		$mail_body_parse = parse_mail_body($case['body'], $case['report_date'], $case['labels'], $case['notes'], $case['id'], $case['subject']);
		if(is_array($mail_body_parse))
		{
			$html_output .= $mail_body_parse['return_string'];
		}
		else
		{
			$html_output .= $mail_body_parse;
		}

		if(!empty($case_reporter) && $case_reporter == 'commanderbot' && strpos($case['body'], 'Be advised human,') !== false)
		{
			// Auto load channel image if reported from the bot
			if(strpos($case['body'], 'rules offending profile image:') !== false)
			{
				$html_output .= '<a class="violating_content_preview_link" href="javascript:create_profile_image_preview('.$case['id'].',\''.rawurlencode(get_channel_from_subject($case['subject'])).'\',true);"></a>';
			}
			elseif(strpos($case['body'], 'rules offending profile banner:') !== false)
			{
				$html_output .= '<a class="violating_content_preview_link" href="javascript:create_profile_banner_preview('.$case['id'].',\''.rawurlencode(get_channel_from_subject($case['subject'])).'\',true);"></a>';
			}
			elseif(strpos($case['body'], 'rules offending offline image:') !== false)
			{
				$html_output .= '<a class="violating_content_preview_link" href="javascript:create_offline_image_preview('.$case['id'].',\''.rawurlencode(get_channel_from_subject($case['subject'])).'\',true);"></a>';
			}
			elseif(strpos($case['body'], 'rules offending profile bio:') !== false)
			{
				$html_output .= '<a class="violating_content_preview_link" href="javascript:create_user_bio_preview('.$case['id'].',\''.rawurlencode(get_channel_from_subject($case['subject'])).'\',true);"></a>';
			}
		}
		elseif(!empty($case_reporter) && $case_reporter == 'commanderroot' && strpos($case['body'], 'possible porn link in bio') !== false)
		{
			$html_output .= '<a class="violating_content_preview_link" href="javascript:create_user_bio_preview('.$case['id'].',\''.rawurlencode(get_channel_from_subject($case['subject'])).'\',true);"></a>';
		}
		elseif(preg_match('/http[s]?:\/\/static\-cdn\.jtvnw\.net\/jtv_user_pictures\/[a-z0-9_]+\-profile_image\-[a-z0-9]+\-[0-9]+x[0-9]+\.[a-z]{3,4}/i', $case['body']) === 1)
		{
			// User reports which have a profile image url
			$html_output .= '<a class="violating_content_preview_link" href="javascript:create_profile_image_preview('.$case['id'].',\''.rawurlencode(get_channel_from_subject($case['subject'])).'\',true);"></a>';
		}
		elseif(preg_match('/http[s]?:\/\/static\-cdn\.jtvnw\.net\/jtv_user_pictures\/[a-z0-9_]+\-profile_banner\-[a-z0-9]+\-[0-9]+\.[a-z]{3,4}/i', $case['body']) === 1)
		{
			// User reports which have a profile banner url
			$html_output .= '<a class="violating_content_preview_link" href="javascript:create_profile_banner_preview('.$case['id'].',\''.rawurlencode(get_channel_from_subject($case['subject'])).'\',true);"></a>';
		}
		elseif(preg_match('/http[s]?:\/\/static\-cdn\.jtvnw\.net\/jtv_user_pictures\/[a-z0-9_]+\-channel_offline_image\-[a-z0-9]+\-[0-9]+x[0-9]+\.[a-z]{3,4}/i', $case['body']) === 1)
		{
			// User reports which have a channel offline image url
			$html_output .= '<a class="violating_content_preview_link" href="javascript:create_offline_image_preview('.$case['id'].',\''.rawurlencode(get_channel_from_subject($case['subject'])).'\',true);"></a>';
		}


		// Only show assign buttons for cases from "User Reports", "Whisper Reports", "Channel Feed Reports" or "Clip Reports"
		if(isset($case['assigned_group']['href']) && in_array($case['assigned_group']['href'], array('/api/v2/groups/396524' /* User Reports */, '/api/v2/groups/557131' /* Whisper Reports */, '/api/v2/groups/584265' /* Channel Feed Reports */, '/api/v2/groups/599060' /* Clip Reports */)) && (strpos($case['subject'], 'Abuse report concerning ') !== false || strpos($case['subject'], 'Strike concerning ') !== false || strpos($case['subject'], 'Whisper Report concerning ') !== false || strpos($case['subject'], 'Channel feed report concerning ') !== false || strpos($case['subject'], 'Channel feed comment report concerning ') !== false || strpos($case['subject'], 'Clip report concerning ') !== false))
		{
			$html_output .= '<div class="col-md-7">'.PHP_EOL;
			$html_output .= '<div class="pull-right">'.PHP_EOL;
			$html_output .= '<div class="btn-group">'.PHP_EOL;

			// Go to next case button
			if(!isset($_COOKIE['fade_resolved']) || $_COOKIE['fade_resolved'] != 'on')
			{
				$html_output .= '<button type="button" class="btn btn-default" onclick="scroll_to_next_case('.$case['id'].');" title="Scroll to next case"><span class="glyphicon glyphicon-arrow-down"></span></button>'.PHP_EOL;
			}
			// Assign and Resolve
			$html_output .= '<button type="button" class="btn btn-success" id="assign_and_resolve_'.$case['id'].'" onclick="assign_and_resolve('.$case['id'].');">Resolve</button>'.PHP_EOL;
			// Resolve as Whisper Report
			if(strpos($case['subject'], 'Abuse report concerning ') !== false)
			{
				// Assign and Resolve with label
				$html_output .= '<div class="btn-group">'.PHP_EOL;
				$html_output .= '<button type="button" data-toggle="dropdown" class="btn btn-success dropdown-toggle" id="assign_and_resolve_with_label_'.$case['id'].'"><span class="caret"></span></button>'.PHP_EOL;
				$html_output .= '<ul class="dropdown-menu bullet">'.PHP_EOL;
				// $html_output .= '<li><a class="btn btn-default" onclick="bootbox.confirm(\'Are you sure you want to resolve this case as a &quot;Whisper Report&quot;?\', function(result) { if(result === true) { assign_and_resolve_with_label('.$case['id'].', \'whisper\'); } });">Resolve as &quot;Whisper Report&quot;</a></li>'.PHP_EOL;
				$html_output .= '<li><a class="btn btn-default" onclick="assign_and_resolve_with_label('.$case['id'].', \'whisper\');">Resolve as &quot;Whisper Report&quot;</a></li>'.PHP_EOL;
				$html_output .= '</ul>'.PHP_EOL;
				$html_output .= '</div>'.PHP_EOL;
			}
			// Resolve other cases against this channel
			if(strpos($case['subject'], 'Whisper Report concerning ') !== false)
			{
				$html_output .= '<button type="button" class="btn btn-default" id="resolve_others_'.$case['id'].'" onclick="resolve_other_case_against_channel(\''.rawurlencode(get_channel_from_subject($case['subject'])).'\', '.$case['id'].');this.disabled=true;">Resolve others</button>'.PHP_EOL;
			}
			// Global TOS'd macro
			if(check_if_channel_is_partner_via_subject($case['subject']) === false)
			{
				if(!isset($_SESSION['already_TOSd_array'][$case['subject']]))
				{
					$html_output .= '<button type="button" class="btn btn-danger" id="macro_global_tosed_'.$case['id'].'" onclick="macro_global_tosed('.$case['id'].', \''.rawurlencode($case['subject']).'\');">Banned</button>'.PHP_EOL;
				}
				else
				{
					$html_output .= '<button type="button" class="btn btn-success" disabled="disabled">Already TOS&#039;d</button>'.PHP_EOL;
				}
			}
			// Assign to Staff
			if(!in_array($case['subject'], $_SESSION['already_Staffed_array']))
			{
				$html_output .= '<div class="btn-group">'.PHP_EOL;
				$html_output .= '<button type="button" data-toggle="dropdown" class="btn btn-default dropdown-toggle" id="assign_to_staff_'.$case['id'].'">Assign to Staff <span class="caret"></span></button>'.PHP_EOL;
				$html_output .= '<ul class="dropdown-menu bullet pull-right">'.PHP_EOL;
				if(strpos($case['subject'], 'Abuse report concerning ') !== false)
				{
					$html_output .= '<li><a class="btn btn-default" onclick="bootbox.confirm(\'Are you sure you want to assign this case for a PM Check?\', function(result) { if(result === true) { assign_to_staff_for_pm_check('.$case['id'].', \''.rawurlencode($case['subject']).'\'); } });">PM Check</a></li>'.PHP_EOL;
				}
				$html_output .= '<li><a class="btn btn-default" onclick="bootbox.confirm(\'Are you sure you want to escalate this case to Staff?\', function(result) { if(result === true) { assign_to_staff_for_escalation('.$case['id'].'); } });">Escalate to Staff</a></li>'.PHP_EOL;
				$html_output .= '</ul>'.PHP_EOL;
				$html_output .= '</div>'.PHP_EOL;
			}
			else
			{
				$html_output .= '<button type="button" class="btn btn-success" disabled="disabled">Already Staff&#039;d</button>'.PHP_EOL;
			}

			$html_output .= '</div>'.PHP_EOL;
			$html_output .= '</div>'.PHP_EOL;
			$html_output .= '</div>'.PHP_EOL;

			$html_output .= '</div>'.PHP_EOL; // class="row"
		}

		$html_output .= '</div>'.PHP_EOL; // class="panel-body"
		$html_output .= '</div>'.PHP_EOL; // class="panel panel-default" id="desk_case_'.$case['id'].'"
		$html_output .= '<div id="desk_case_'.$case['id'].'_hr"><hr><br></div>'.PHP_EOL;
	}
	return $html_output;
}

function check_if_channel_is_partner_via_subject($subject)
{
	if(strpos($subject, 'Abuse report concerning [P] ') !== false || strpos($subject, 'Strike concerning [P] ') !== false || strpos($subject, 'Whisper Report concerning [P] ') !== false || strpos($subject, 'Channel feed report concerning [P] ') !== false || strpos($subject, 'Channel feed comment report concerning [P] ') !== false || strpos($subject, 'Clip report concerning [P] ') !== false)
	{
		return true;
	}
	else
	{
		return false;
	}
}

function sec_to_nice_time($seconds, $skip_sec = false)
{
	$days = floor($seconds/60/60/24);
	$hours = floor(($seconds/60/60)%24);
	$min = floor(($seconds/60)%60);
	$sec = floor($seconds%60);

	$string = '';
	$started = false;
	if($days > 0)
	{
		$string .= $days.'d ';
		$started = true;
	}

	if($hours > 0 || $started == true)
	{
		$string .= $hours.'h ';
		$started = true;
	}

	if($min > 0 || $started == true)
	{
		$string .= $min.'m ';
		$started = true;
	}

	if(($sec > 0 || $started == true) && $skip_sec == false)
	{
		$string .= $sec.'s';
	}

	return $string; 
}

function get_display_names_from_report($mail_body, $case_Subject)
{
	$return = array('target' => null, 'reporter' => null);
	$mail_in_rows = explode("\n", $mail_body);
	$mail_in_rows_count = count($mail_in_rows);
	if(substr($mail_in_rows[0], 0, 12) == 'Abuse report' && (strpos($case_Subject, 'Abuse report concerning ') !== false || strpos($case_Subject, 'Strike concerning ') !== false))
	{
		for($i = 0; $i < $mail_in_rows_count; $i++)
		{
			if(substr($mail_in_rows[$i], 0, 23) == 'Reporter display name: ' && $return['reporter'] === null)
			{
				$return['reporter'] = trim(substr($mail_in_rows[$i], 23));
			}
			elseif(substr($mail_in_rows[$i], 0, 21) == 'Target display name: ' && $return['target'] === null)
			{
				$return['target'] = trim(substr($mail_in_rows[$i], 21));
			}
			elseif(substr($mail_in_rows[$i], 0, 12) == 'Description:')
			{
				// If we find the description the report "header" is over so we need to stop our search
				break;
			}
		}
	}
	elseif(strpos($case_Subject, 'Channel feed report concerning ') !== false || strpos($case_Subject, 'Channel feed comment report concerning ') !== false)
	{
		for($i = 0; $i < $mail_in_rows_count; $i++)
		{
			if(substr($mail_in_rows[$i], 0, 10) == 'Reporter: ' && $return['reporter'] === null)
			{
				// Reporter
				$row_explode = explode(',', substr($mail_in_rows[$i], 10));
				if(isset($row_explode[2]))
				{
					$return['reporter'] = trim($row_explode[2]);
				}
			}
			elseif(substr($mail_in_rows[$i], 0, 8) == 'Target: ' && $return['target'] === null)
			{
				// Target
				$row_explode = explode(',', substr($mail_in_rows[$i], 8));
				if(isset($row_explode[2]))
				{
					$return['target'] = trim($row_explode[2]);
				}
			}
		}
	}

	return $return;
}

function parse_mail_body($mail_body, $mail_date, $case_label_array, $case_notes, $case_ID, $case_Subject)
{
	$case_reporter = get_case_reporter($mail_body, true);

	$mail_in_rows = explode("\n", $mail_body);
	if(substr($mail_in_rows[0], 0, 12) == 'Abuse report' && (strpos($case_Subject, 'Abuse report concerning ') !== false || strpos($case_Subject, 'Strike concerning ') !== false))
	{
		// Is a normal Twitch report
		// Target user
		$target_user = get_channel_from_subject($case_Subject);

		// Kind of Abuse
		for($u = 0; $u < count($mail_in_rows); $u++)
		{
			if(substr($mail_in_rows[$u], 0, 15) == 'Kind of abuse: ')
			{
				$report_reason = get_color_for_report_reason(trim($mail_in_rows[$u]));
				break;
			}
		}

		// Get report description
		$description_text = '';
		$description_start_found = false;
		$description_text_array = array();
		for($u = 0; $u < count($mail_in_rows); $u++)
		{
			if($description_start_found === true)
			{
				$description_text_array[] = trim($mail_in_rows[$u]);
			}
			elseif(substr($mail_in_rows[$u], 0, 12) == 'Description:')
			{
				$description_start_found = true;
			}
		}
		$description_text .= parse_urls_to_ahref($description_text_array);
		$description_for_translate = '';
		foreach($description_text_array as $line)
		{
			$description_for_translate .= $line.PHP_EOL;
		}
		unset($description_text_array);

		$return = '<div class="btn-group">'.PHP_EOL;
		// Chatlogs
		if(!isset($_COOKIE['root_chatlogs']) || $_COOKIE['root_chatlogs'] == 'true')
		{
			// Chatlogs by Root
			$return .= '<a class="btn btn-default btn-link" href="/chatlogs/?table='.get_date_for_chatlog_link($mail_date).'&amp;username='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Chatlogs</a>'.PHP_EOL;
		}
		else
		{
			// George's chatlogs
			$return .= '<a class="btn btn-default btn-link" href="https://tools.tmod.xyz/chatlog/?table%5B%5D='.get_date_for_chatlog_link($mail_date).'&amp;username='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Chatlogs</a>'.PHP_EOL;
		}
		// Video poput
		$return .= '<a class="btn btn-default btn-link" href="https://player.twitch.tv/?channel='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Popout</a>'.PHP_EOL;
		// Stream preview
		if(strpos($case_Subject, 'Abuse report concerning ') !== false || strpos($case_Subject, 'Strike concerning ') !== false || strpos($case_Subject, 'Whisper Report concerning ') !== false)
		{
			$subject_explode = explode(' ', trim($case_Subject));
			$case_channel = $subject_explode[(count($subject_explode) - 1)];
			$return .= '<a class="btn btn-default btn-link" href="javascript:create_stream_preview('.$case_ID.', \''.rawurlencode($case_channel).'\');">Stream Preview</a>'.PHP_EOL;
		}
		// Case notes
		if($case_notes === true)
		{
			$return .= '<a class="btn btn-default btn-link" href="javascript:load_desk_notes('.$case_ID.');">Case Notes</a>'.PHP_EOL;
			// Auto load case notes
			if(!isset($GLOBALS['desk_notes_string']))
			{
				$GLOBALS['desk_notes_string'] = '';
			}
			$GLOBALS['desk_notes_string'] .= 'load_desk_notes('.$case_ID.');'.PHP_EOL;
		}
		// Translate
		$return .= '<a class="btn btn-default btn-link" href="https://translate.google.com/#auto/en/'.rawurlencode($description_for_translate).'" target="_blank" rel="noreferrer" onclick="return translate_popup(this.href, '.$case_ID.');">Translate</a>'.PHP_EOL;
		// VOD's
		$return .= '<a class="btn btn-default btn-link" href="https://www-origin.twitch.tv/'.rawurlencode($target_user).'/manager/past_broadcasts" target="_blank" rel="noreferrer">VOD&#039;s</a>'.PHP_EOL;
		// Desk case link
		$return .= '<a class="btn btn-default btn-link" href="https://help.twitch.tv/agent/case/'.rawurlencode($case_ID).'" target="_blank" rel="noreferrer">Desk Link</a>'.PHP_EOL;
		// Profile viewer
		// $return .= '<a class="btn btn-default btn-link" href="https://bashtech.net/twitch/profile.php?stream='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Profile Viewer</a>'.PHP_EOL;
		// Channel content preview
		if(strpos($case_Subject, 'Abuse report concerning ') !== false || strpos($case_Subject, 'Strike concerning ') !== false || strpos($case_Subject, 'Whisper Report concerning ') !== false || strpos($case_Subject, 'Channel feed report concerning ') !== false || strpos($case_Subject, 'Channel feed comment report concerning ') !== false || strpos($case_Subject, 'Clip report concerning ') !== false)
		{
			$subject_explode = explode(' ', trim($case_Subject));
			$case_channel = $subject_explode[(count($subject_explode) - 1)];
			$return .= '<div class="btn-group">'.PHP_EOL;
			$return .= '<button type="button" data-toggle="dropdown" class="btn btn-default dropdown-toggle">Channel content <span class="caret"></span></button>'.PHP_EOL;
			$return .= '<ul class="dropdown-menu bullet pull-right">'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_profile_image_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">Profile Image</a></li>'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_profile_banner_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">Profile Banner</a></li>'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_offline_image_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">Offline Image</a></li>'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_profile_image_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');create_profile_banner_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');create_offline_image_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">Show all</a></li>'.PHP_EOL;
			$return .= '<li class="divider"></li>'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_user_bio_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">User bio</a></li>'.PHP_EOL;
			$return .= '</ul>'.PHP_EOL;
			$return .= '</div>';
		}
		// Report history
		$return .= '<a class="tos_history_link" href="javascript:load_report_history_auto(\''.$case_ID.'\',\''.rawurlencode($target_user).'\');"></a><a class="btn btn-default btn-link" href="javascript:load_report_history(\''.$case_ID.'\', \''.rawurlencode($target_user).'\');">TOS History</a>'.PHP_EOL;
		// Screenshot
		$return .= '<a class="btn btn-default btn-link" href="/screenshot_upload.php?channel='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Add Screenshot</a>'.PHP_EOL;
		if(check_if_channel_is_partner_via_subject($case_Subject) === false)
		{
			$extra_report_string = '';
			if(isset($case_reporter['short']) && !empty($case_reporter['short']) && $case_reporter['short'] == 'commanderbot')
			{
				if(strpos($mail_body, 'Hello human,') !== false)
				{
					// Add reason "offensive_username" and description "Inappropriate name"
					$extra_report_string = '&amp;content=general&amp;reason=offensive_username&amp;detailed_reason=inappropriate_username';
				}
				elseif(strpos($mail_body, 'Hello you,') !== false)
				{
					// Add reason "other"
					$extra_report_string = '&amp;content=live&amp;reason=other';
				}
				else
				{
					// Keep it normal
				}
			}
			// Report link (Only show for non-partners)
			$return .= '<a class="btn btn-default btn-link" href="https://www-origin.twitch.tv/'.rawurlencode($target_user).'/report_form?tos_ban=true'.$extra_report_string.'" target="_blank" rel="noreferrer">Report Link</a>'.PHP_EOL;
		}
		else
		{
			// PartnerConduct report
			$return .= '<a class="btn btn-default btn-link" href="/index.php?partnerconduct_report=true&amp;target_user='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">PartnerConduct Link</a>'.PHP_EOL;
		}
		$return .= '</div>'.PHP_EOL;
		$return .= '<hr>'.PHP_EOL;
		// Desk notes
		$return .= '<div id="desk_notes_'.$case_ID.'" style="word-wrap: break-word;"></div>'.PHP_EOL;
		// Report history
		$return .= '<div id="report_history_'.$case_ID.'"></div>'.PHP_EOL;
		// Stream preview image
		$return .= '<div class="stream-preview-image" id="stream_preview_image_'.$case_ID.'" data-channel="'.rawurlencode($target_user).'"></div>'.PHP_EOL;
		// Profile image preview
		$return .= '<div id="profile_image_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Profile banner preview
		$return .= '<div id="profile_banner_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Offline image preview
		$return .= '<div id="offline_image_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Bio preview
		$return .= '<div id="user_bio_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Video preview
		$return .= '<div id="stream_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Reason and description
		$return .= '<div class="well">'.PHP_EOL;
		// Request VOD link button
		$return .= '<b>VOD:</b> <span id="vod_link_'.$case_ID.'"><a class="btn btn-xs btn-default btn-link" href="javascript:get_vod_timestamp_url('.$case_ID.', \''.rawurlencode($target_user).'\', '.strtotime($mail_date).');">Get VOD timestamp URL</a></span><br>'.PHP_EOL;
		// Request Clip history button
		$return .= '<b>Clips:</b> <span id="clip_link_'.$case_ID.'"><a class="btn btn-xs btn-default btn-link" href="javascript:show_clips_timestamp_history(\''.rawurlencode($target_user).'\', '.strtotime($mail_date).');">Check Clips around the report time</a></span><br>'.PHP_EOL;
		// Report Reason
		$return .= $report_reason.'<br>'.PHP_EOL;
		$return .= '<b>Description:</b><br>'.PHP_EOL;
		$return .= '<div id="report_description_'.$case_ID.'" class="report-description" style="word-wrap: break-word;">'.PHP_EOL;
		$return .= $description_text;
		$return .= '</div>'.PHP_EOL;
		$return .= '</div>'.PHP_EOL;
		$return .= '<hr>'.PHP_EOL;
		$return .= '<div class="row">'.PHP_EOL;
		$return .= '<div class="col-md-5">'.PHP_EOL;

		// Only show the reporter if there is one (looking at you PS4)
		if(isset($case_reporter['short']) && !empty($case_reporter['short']))
		{
			$reporter_color = get_color_based_on_admin_type($case_reporter['admin_type']);
			if(empty($reporter_color))
			{
				$reporter_color = get_color_based_on_labels($case_label_array);
			}
			$return .= 'Reporter: ';
			if(!empty($case_reporter['admin_type']))
			{
				$return .= '['.htmlspecialchars($case_reporter['admin_type'], ENT_QUOTES|ENT_HTML5).'] ';
			}
			elseif(in_array('report - global mod', $case_label_array))
			{
				$return .= '[ALT] ';
			}
			$return .= '<a href="https://www-origin.twitch.tv/'.rawurlencode($case_reporter['short']).'?bttvAnonChat=true&amp;tmi_host=false" title="'.htmlspecialchars($case_reporter['full'], ENT_QUOTES|ENT_HTML5).'" target="_blank" rel="noreferrer"'.$reporter_color.'>';
			$return .= htmlspecialchars($case_reporter['short'], ENT_QUOTES|ENT_HTML5);
			$return .= '</a> ';
			// Translate reporter username button
			$return .= '<a href="https://translate.google.com/#auto/en/'.rawurlencode($case_reporter['short']).'" target="_blank" rel="noreferrer" onclick="return translate_popup(this.href, \'reporter_'.$case_ID.'\');"><img src="chatlogs/translate.png" title="Translate" alt=""></a> ';
			// Display name
			$display_name = get_display_names_from_report($mail_body, $case_Subject);
			if(isset($display_name['reporter']) && !empty($display_name['reporter']))
			{
				$return .= '('.htmlspecialchars($display_name['reporter'], ENT_QUOTES|ENT_HTML5).') ';
				$return .= '<a href="https://translate.google.com/#auto/en/'.rawurlencode($display_name['reporter']).'" target="_blank" rel="noreferrer" onclick="return translate_popup(this.href, \'reporter_display_name_'.$case_ID.'\');"><img src="chatlogs/translate.png" title="Translate" alt=""></a> ';
			}
			unset($display_name);
			// Ban reporter button
			$return .= '<a href="https://www-origin.twitch.tv/'.rawurlencode($case_reporter['short']).'/report_form?tos_ban=true" title="Report" target="_blank" rel="noreferrer"><span class="glyphicon glyphicon-remove-circle"></span></a> | ';
			// Auto resolve reporter drop down
			$return .= '<div class="btn-group"><button type="button" data-toggle="dropdown" class="btn btn-default dropdown-toggle"><span class="glyphicon glyphicon-ok"></span> <span class="caret"></span></button>';
			$return .= '<ul class="dropdown-menu pull-middle pull-right bullet">';
			$return .= '<li><p class="text-center"><b>Autoresolve duration:</b></p></li>';
			if(in_array($_SESSION['user']['desk_ID'], array(21812684 /* CommanderRoot */)))
			{
				$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">Session</a></li>';
			}
			$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=5&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">5 sec</a></li>';
			$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=300&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">5 min</a></li>';
			$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=600&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">10 min</a></li>';
			$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=900&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">15 min</a></li>';
			if(in_array($_SESSION['user']['desk_ID'], array(21812684 /* CommanderRoot */)))
			{
				$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=1800&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">30 min</a></li>';
				$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=3600&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">1 hour</a></li>';
			}
			$return .= '</ul></div>';
			$return .= '<br>'.PHP_EOL;
		}
		// Report time
		$return .= '<div class="time-exact" id="time_exact_'.$case_ID.'" data-unixtime="'.strtotime($mail_date).'">'.time_to_pst_time($mail_date).'</div>'.PHP_EOL;
		$return .= '<div class="time-friendly" id="time_friendly_'.$case_ID.'">('.sec_to_nice_time(time() - strtotime($mail_date)).' ago)</div>'.PHP_EOL;

		$return .= '</div>'.PHP_EOL;

		// Generate array
		$return_array = array('return_string' => $return, 'report_description' => $description_for_translate);
	}
	elseif(strpos($case_Subject, 'Whisper Report concerning ') !== false)
	{
		// It's a "Whisper Report"
		// Target user
		$target_user = get_channel_from_subject($case_Subject);

		// Report Time
		for($u = 0; $u < count($mail_in_rows); $u++)
		{
			if(substr($mail_in_rows[$u], 0, 13) == 'Reported At: ')
			{
				$report_time = trim(substr($mail_in_rows[$u], 13));
				break;
			}
		}
		// Category
		for($u = 0; $u < count($mail_in_rows); $u++)
		{
			if(substr($mail_in_rows[$u], 0, 10) == 'Category: ')
			{
				$report_reason = trim($mail_in_rows[$u]);
				break;
			}
		}

		// Get report description
		$description_text = '';
		$description_start_found = false;
		$description_text_array = array();
		for($u = 0; $u < count($mail_in_rows); $u++)
		{
			if($description_start_found === true)
			{
				$description_text_array[] = trim($mail_in_rows[$u]);
			}
			elseif(substr($mail_in_rows[$u], 0, 16) == 'Recent Messages:')
			{
				$description_start_found = true;
				$u++;
			}
		}
		$description_text .= parse_whisper_report_to_table($description_text_array, $target_user);
		$description_for_translate = '';
		$description_for_report_form = '';
		foreach($description_text_array as $line => $line_content)
		{
			if($line != 0)
			{
				$line_content_pos = strpos($line_content, '	');
				if($line_content_pos !== false)
				{
					$description_for_translate .= substr($line_content, ($line_content_pos + 1)).PHP_EOL.PHP_EOL;
				}
				else
				{
					$description_for_translate .= $line_content.PHP_EOL.PHP_EOL;
				}
				$description_for_report_form .= $line_content.PHP_EOL;
			}
		}
		unset($description_text_array);

		// Check if it's whisper spam
		$is_whisper_spam = false;
		static $whisper_spam_regex_array = array('/dream\-software\.org/i', '/lolground\.net/i', '/bo3points\.com/i', '/gtavgenerator\.com/i', '/type=2&theate[r]?/i', '/coconline\.ga/i',
												'/FIFA 16 Coins, and that for free/i', '/gta5astuces\.com/i', '/Google Play, Facebook etc .* Thank me later/i',
												'/was curious if you played 2K16 and want some locker codes/i', '/cs\.getfree\-stuff\.com/i', '/mobilehacks\.info/i',
												'/HearthStone\.gq/i', '/csgopolygon/i', '/you can get Riot Points for FREE/i', '/dreamed that you were able to grab RP/i',
												'/dailymotion\.com\/video\//i', '/ now here: >>>> /i', '/ out here: >>>> /i', '/ today here: >>>> /i',
												'/fut16generator\.com/i', '/gtavonlinemunten\.com/i', '/psnfreecodes\.co/i', '/gtavfreemoney\.co/i',
												'/ [\-]?\-\-\->>>[>]? /i', '/fifa2016coins\.co/i', '/ FAUSSE DONATIONS sur /i', '/ the web generator is /i',
												'/iphone6sgiveaway\.com/i', '/\/generator\/Overwatch/i', '/m=weblogin/i', '/fut16pieces\.com/i', '/50% Off for /i',
												'/ Riot Points .* free/i', '/ League of Legends Online Hack /i', '/ :O http:\/\//i', '/ minutes ago .* RP/i',
												'/ mins ago .* RP .* http:\/\//i', '/hackmygames\.org/i', '/sub\-gifts\.com/i', '/Come check out my channel at /i',
												'/csgo4fun\.com/i', '/g2a\.com\/r\/kappadiscount/i', '/twitchplay\.gamerwin\.com/i', '/zybersmite\.com/i',
												'/EndTimeGaming\.com/i', '/Get\-The\-Key\.com/i', '/lolskinshop\.com/i', '/twitch\.tv\/xtrafalgarx/i',
												'/csgomassive\.com/i', '/tiny\.cc\//i', '/tinyurl\.com\/league50\-rp\//i', '/\/\?type=3&theate[r]?/i',
												'/astucesbo3\.com/i', '/go\-skins net/i', '/TwitchLoot/i', '/razer\-zona\.com/i', '/esportdrafts\.com/i',
												'/>>>> .* <<<</i', '/ Reddem /i', '/item\.blue/i', '/csgokappa/i', '/CSGODOUBLE/i', '/csgodep\.com/i',
												'/boosting\.pro/i', '/dreare\.org/i', '/bring skins goo\.gl\//i', '/skins2\.com/i', '/csgodiamonds/i',
												'/csgohouse\.com/i', '/vk\.com\/oneleday/i', '/csgostrong\.com/i', '/pokertool\.blogspot\.com/i', '/twitch\.tv\/zadr0nik/i',
												'/\(pokerstars\).*\(ganja869\)/i', '/Professor Brain/i', '/stream[ ]?booster/i', '/Clash Royal gems/i',
												'/freecsgoskins/i', '/twitch\.tv\/vinzzard/i', '/FUT 16 ou FUT 15/i', '/Black Ops III POINTS/i',
												'/csgowinline\.su/i', '/http:\/\/bit\.ly\//i', '/\brektmine\b/i', '/\bCSGOPOT\.COM\b/i',
												'/Battlefield 1 Beta Key/i', '/bestgamehacks\.org/i', '/veteranboosters\.com/i',
												'/freecsgocheats\.com/i', '/\bcheck it out at\b/i', '/overwatchhacks\.org/i', '/kappaskins\.tk/i',
												'/cs\-skins\.tk/i', '/clashroyalecheat\.org/i', '/\bcsgoscares\b/i', '/twitchviewerbot\.net/i',
												'/bit\.ly\/LoLRpLCS/i', '/facebook\.com\/twitchwerbungeu/i', '/Come to watch my channel where I stream/i',
												'/bit\.ly\/DzikiGon/i', '/bit\.ly\/SkinyCsGoIzakoo/i', '/moneyfromlol/i', '/bit\.ly\/CreateCommunityPdf/i',
												'/bit\.ly\/CsGoIzakooo/i', '/bit\.ly\/LoLRpNerva/i', '/bit\.ly\/RpNervarien/i', '/OyunKentim\.COM/i',
												'/\/lolbuilder/i', '/\/IzakoooSkin/i', '/bit\.ly\/KonkursRp/i', '/bit\.ly\/Dis10Days/i', '/nulled\.to\/topic\//i',
												'/bit\.ly\/RiotPointtsCode[s]?/i', '/g2a\.com/i', '/bit\.ly\/WakacyjneRp/i', '/bit\.ly\/SkinIzakooo/i',
												'/PokemonGoCoinsNow\.com/i', '/bit\.ly\/RiotSierpien/i', '/10\$.*50\$/i', '/lolgiveway\.xn\.pl/i',
												'/bit\.ly\/CsSkins/i', '/bit\.ly\/KonkursIzakOOO/i', '/bit\.ly\/OlofIphoneGiveaway/i',
												'/bit\.ly\/IzakOOO_Skiny/i', '/bit\.ly\/izakOOOSkiny/i', '/bit\.ly\/TwitchGiftCards/i', '/1000 Euro/i',
												'/bit\.ly\/IzakSkins/i');
		foreach($whisper_spam_regex_array as $whisper_regex)
		{
			if(preg_match($whisper_regex, $description_for_report_form) === 1)
			{
				$is_whisper_spam = true;
				break;
			}
		}

		// Report link content
		$extra_report_string_content = '&amp;description=';
		$extra_report_string_content .= rawurlencode('Original Case ID: '.$case_ID.PHP_EOL);
		if(strlen(rawurlencode($description_for_report_form)) <= 4925)
		{
			$extra_report_string_content .= rawurlencode($description_for_report_form);
		}
		$extra_report_string = $extra_report_string_content;
		unset($extra_report_string_content, $description_for_report_form);

		$return = '<div class="btn-group">'.PHP_EOL;
		// Chatlogs
		if(!isset($_COOKIE['root_chatlogs']) || $_COOKIE['root_chatlogs'] == 'true')
		{
			// Chatlogs by Root
			$return .= '<a class="btn btn-default btn-link" href="/chatlogs/?table='.get_date_for_chatlog_link($report_time).'&amp;username='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Chatlogs</a>'.PHP_EOL;
		}
		else
		{
			// George's chatlogs
			$return .= '<a class="btn btn-default btn-link" href="https://tools.tmod.xyz/chatlog/?table%5B%5D='.get_date_for_chatlog_link($report_time).'&amp;username='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Chatlogs</a>'.PHP_EOL;
		}
		// Video poput
		$return .= '<a class="btn btn-default btn-link" href="https://player.twitch.tv/?channel='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Popout</a>'.PHP_EOL;
		// Stream preview
		if(strpos($case_Subject, 'Abuse report concerning ') !== false || strpos($case_Subject, 'Strike concerning ') !== false || strpos($case_Subject, 'Whisper Report concerning ') !== false)
		{
			$subject_explode = explode(' ', trim($case_Subject));
			$case_channel = $subject_explode[(count($subject_explode) - 1)];
			$return .= '<a class="btn btn-default btn-link" href="javascript:create_stream_preview('.$case_ID.', \''.rawurlencode($case_channel).'\');">Stream Preview</a>'.PHP_EOL;
		}
		// Case notes
		if($case_notes === true)
		{
			$return .= '<a class="btn btn-default btn-link" href="javascript:load_desk_notes('.$case_ID.');">Case Notes</a>'.PHP_EOL;
			// Auto load case notes
			if(!isset($GLOBALS['desk_notes_string']))
			{
				$GLOBALS['desk_notes_string'] = '';
			}
			$GLOBALS['desk_notes_string'] .= 'load_desk_notes('.$case_ID.');'.PHP_EOL;
		}
		// Translate
		$return .= '<a class="btn btn-default btn-link" href="https://translate.google.com/#auto/en/'.rawurlencode($description_for_translate).'" target="_blank" rel="noreferrer" onclick="return translate_popup(this.href, '.$case_ID.');">Translate</a>'.PHP_EOL;
		// VOD's
		$return .= '<a class="btn btn-default btn-link" href="https://www-origin.twitch.tv/'.rawurlencode($target_user).'/manager/past_broadcasts" target="_blank" rel="noreferrer">VOD&#039;s</a>'.PHP_EOL;
		// Desk case link
		$return .= '<a class="btn btn-default btn-link" href="https://help.twitch.tv/agent/case/'.rawurlencode($case_ID).'" target="_blank" rel="noreferrer">Desk Link</a>'.PHP_EOL;
		// Profile viewer
		// $return .= '<a class="btn btn-default btn-link" href="https://bashtech.net/twitch/profile.php?stream='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Profile Viewer</a>'.PHP_EOL;
		// Channel content preview
		if(strpos($case_Subject, 'Abuse report concerning ') !== false || strpos($case_Subject, 'Strike concerning ') !== false || strpos($case_Subject, 'Whisper Report concerning ') !== false || strpos($case_Subject, 'Channel feed report concerning ') !== false || strpos($case_Subject, 'Channel feed comment report concerning ') !== false || strpos($case_Subject, 'Clip report concerning ') !== false)
		{
			$subject_explode = explode(' ', trim($case_Subject));
			$case_channel = $subject_explode[(count($subject_explode) - 1)];
			$return .= '<div class="btn-group">'.PHP_EOL;
			$return .= '<button type="button" data-toggle="dropdown" class="btn btn-default dropdown-toggle">Channel content <span class="caret"></span></button>'.PHP_EOL;
			$return .= '<ul class="dropdown-menu bullet pull-right">'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_profile_image_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">Profile Image</a></li>'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_profile_banner_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">Profile Banner</a></li>'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_offline_image_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">Offline Image</a></li>'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_profile_image_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');create_profile_banner_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');create_offline_image_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">Show all</a></li>'.PHP_EOL;
			$return .= '<li class="divider"></li>'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_user_bio_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">User bio</a></li>'.PHP_EOL;
			$return .= '</ul>'.PHP_EOL;
			$return .= '</div>';
		}
		// Report history
		$return .= '<a class="tos_history_link" href="javascript:load_report_history_auto(\''.$case_ID.'\',\''.rawurlencode($target_user).'\');"></a><a class="btn btn-default btn-link" href="javascript:load_report_history(\''.$case_ID.'\', \''.rawurlencode($target_user).'\');">TOS History</a>'.PHP_EOL;
		// Screenshot
		$return .= '<a class="btn btn-default btn-link" href="/screenshot_upload.php?channel='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Add Screenshot</a>'.PHP_EOL;
		if(check_if_channel_is_partner_via_subject($case_Subject) === false)
		{
			if(!isset($extra_report_string)) $extra_report_string = '';
			$report_detailed_reason = '';
			if(isset($is_whisper_spam) && $is_whisper_spam === true)
			{
				$report_detailed_reason = '&amp;detailed_reason=spam_bots';
			}
			// Report link (Only show for non-partners)
			$return .= '<a class="btn btn-default btn-link" href="https://www-origin.twitch.tv/'.rawurlencode($target_user).'/report_form?tos_ban=true&amp;content=whisper&amp;reason=spam'.$report_detailed_reason.$extra_report_string.'" target="_blank" rel="noreferrer">Report Link</a>'.PHP_EOL;
		}
		else
		{
			// Partnerconduct report
			if(!isset($extra_report_string)) $extra_report_string = '';
			$report_detailed_reason = '';
			if(isset($is_whisper_spam) && $is_whisper_spam === true)
			{
				$report_detailed_reason = '&amp;detailed_reason=spam_bots';
			}
			$return .= '<a class="btn btn-default btn-link" href="/index.php?partnerconduct_report=true&amp;target_user='.rawurlencode($target_user).'&amp;content=whisper&amp;reason=spam'.$report_detailed_reason.$extra_report_string.'" target="_blank" rel="noreferrer">PartnerConduct Link</a>'.PHP_EOL;
		}
		$return .= '</div>'.PHP_EOL;
		$return .= '<hr>'.PHP_EOL;
		// Desk notes
		$return .= '<div id="desk_notes_'.$case_ID.'" style="word-wrap: break-word;"></div>'.PHP_EOL;
		// Report history
		$return .= '<div id="report_history_'.$case_ID.'"></div>'.PHP_EOL;
		// Stream preview image
		$return .= '<div class="stream-preview-image" id="stream_preview_image_'.$case_ID.'" data-channel="'.rawurlencode($target_user).'"></div>'.PHP_EOL;
		// Profile image preview
		$return .= '<div id="profile_image_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Profile banner preview
		$return .= '<div id="profile_banner_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Offline image preview
		$return .= '<div id="offline_image_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Bio preview
		$return .= '<div id="user_bio_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Video preview
		$return .= '<div id="stream_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Reason and description
		$return .= '<div class="well">'.PHP_EOL;
		if($GLOBALS['use_redis'] === true && $GLOBALS['enable_whisper_report_stats'] === true)
		{
			$return .= 'Reports against in the past 24h: '.get_whisper_stats_for_target($target_user).'<br>'.PHP_EOL;
		}
		$return .= 'Case ID: '.$case_ID.'<br>'.PHP_EOL;
		$return .= htmlspecialchars($report_reason, ENT_QUOTES|ENT_HTML5).'<br>'.PHP_EOL;
		$return .= '<b>Recent Messages:</b><br>'.PHP_EOL;
		$return .= '<div id="report_description_'.$case_ID.'" class="report-description" style="word-wrap: break-word;">'.PHP_EOL;
		$return .= $description_text;
		$return .= '</div>'.PHP_EOL;
		$return .= '</div>'.PHP_EOL;
		$return .= '<hr>'.PHP_EOL;
		$return .= '<div class="row">'.PHP_EOL;
		$return .= '<div class="col-md-5">'.PHP_EOL;

		// Only show the reporter if there is one (looking at you PS4)
		if(isset($case_reporter['short']) && !empty($case_reporter['short']))
		{
			$return .= 'Reporter: ';
			$return .= '<a href="https://www-origin.twitch.tv/'.rawurlencode($case_reporter['short']).'?bttvAnonChat=true&amp;tmi_host=false" title="'.htmlspecialchars($case_reporter['full'], ENT_QUOTES|ENT_HTML5).'" target="_blank" rel="noreferrer">';
			$return .= htmlspecialchars($case_reporter['short'], ENT_QUOTES|ENT_HTML5);
			$return .= '</a> ';
			if($GLOBALS['use_redis'] === true && $GLOBALS['enable_whisper_report_stats'] === true)
			{
				$return .= '<span title="Overall whisper reports from this user in the past 24h">('.get_whisper_stats_for_reporter($case_reporter['short']).')</span> ';
			}
			// Translate reporter username button
			$return .= '<a href="https://translate.google.com/#auto/en/'.rawurlencode($case_reporter['short']).'" target="_blank" rel="noreferrer" onclick="return translate_popup(this.href, \'reporter_'.$case_ID.'\');"><img src="chatlogs/translate.png" title="Translate" alt=""></a> ';
			// Ban reporter button
			$return .= '<a href="https://www-origin.twitch.tv/'.rawurlencode($case_reporter['short']).'/report_form?tos_ban=true" title="Report" target="_blank" rel="noreferrer"><span class="glyphicon glyphicon-remove-circle"></span></a> | ';
			// Auto resolve reporter drop down
			$return .= '<div class="btn-group"><button type="button" data-toggle="dropdown" class="btn btn-default dropdown-toggle"><span class="glyphicon glyphicon-ok"></span> <span class="caret"></span></button>';
			$return .= '<ul class="dropdown-menu pull-middle pull-right bullet">';
			$return .= '<li><p class="text-center"><b>Autoresolve duration:</b></p></li>';
			if(in_array($_SESSION['user']['desk_ID'], array(21812684 /* CommanderRoot */)))
			{
				$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">Session</a></li>';
			}
			$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=5&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">5 sec</a></li>';
			$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=300&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">5 min</a></li>';
			$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=600&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">10 min</a></li>';
			$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=900&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">15 min</a></li>';
			if(in_array($_SESSION['user']['desk_ID'], array(21812684 /* CommanderRoot */)))
			{
				$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=1800&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">30 min</a></li>';
				$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=3600&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">1 hour</a></li>';
			}
			$return .= '</ul></div>';
			$return .= '<br>'.PHP_EOL;
		}
		// Report time
		$return .= '<div class="time-exact" id="time_exact_'.$case_ID.'" data-unixtime="'.strtotime($report_time).'">'.time_to_pst_time($report_time).'</div>'.PHP_EOL;
		$return .= '<div class="time-friendly" id="time_friendly_'.$case_ID.'">('.sec_to_nice_time(time() - strtotime($report_time)).' ago)</div>'.PHP_EOL;

		$return .= '</div>'.PHP_EOL;

		// Generate array
		$return_array = array('return_string' => $return, 'report_description' => $description_for_translate);
	}
	elseif(strpos($case_Subject, 'Channel feed report concerning ') !== false)
	{
		// It's a "Channel feed post report"
		// Target user
		$target_user = get_channel_from_subject($case_Subject);

		// Report Time
		for($u = 0; $u < count($mail_in_rows); $u++)
		{
			if(substr($mail_in_rows[$u], 0, 13) == 'Reported At: ')
			{
				$report_time = trim(substr($mail_in_rows[$u], 13));
				break;
			}
		}
		// Reason
		for($u = 0; $u < count($mail_in_rows); $u++)
		{
			if(substr($mail_in_rows[$u], 0, 8) == 'Reason: ')
			{
				$report_reason = trim($mail_in_rows[$u]);
				break;
			}
		}
		// Category
		for($u = 0; $u < count($mail_in_rows); $u++)
		{
			if(substr($mail_in_rows[$u], 0, 10) == 'Category: ')
			{
				$report_category = trim($mail_in_rows[$u]);
				break;
			}
		}
		// Post ID
		for($u = 0; $u < count($mail_in_rows); $u++)
		{
			if(substr($mail_in_rows[$u], 0, 9) == 'Post ID: ')
			{
				$report_postID = trim(substr($mail_in_rows[$u], 9));
				break;
			}
		}

		// Get report description
		$description_text = '';
		$description_start_found = false;
		$description_text_array = array();
		for($u = 0; $u < count($mail_in_rows); $u++)
		{
			if($description_start_found === true)
			{
				$description_text_array[] = trim($mail_in_rows[$u]);
			}
			elseif(substr($mail_in_rows[$u], 0, 13) == 'Post Content:')
			{
				$description_start_found = true;
				$description_text_array[] = trim(substr($mail_in_rows[$u], 13));
			}
		}
		foreach($description_text_array as $description_line)
		{
			$description_text .= htmlspecialchars($description_line, ENT_QUOTES|ENT_HTML5).'<br>'.PHP_EOL;
		}
		$description_text = substr($description_text, 0, (strlen($description_text) - strlen('<br>'.PHP_EOL)));
		$description_for_translate = implode(PHP_EOL, $description_text_array);
		$description_for_report_form = implode(PHP_EOL, $description_text_array);
		unset($description_text_array);

		// Report link content
		$extra_report_string_content = '&amp;description=';
		$extra_report_string_content .= rawurlencode('Original Case ID: '.$case_ID.PHP_EOL.PHP_EOL.'Feed content:'.PHP_EOL);
		if(strlen(rawurlencode($description_for_report_form)) <= 4925)
		{
			$extra_report_string_content .= rawurlencode($description_for_report_form);
		}
		$extra_report_string = $extra_report_string_content;
		unset($extra_report_string_content, $description_for_report_form);

		$return = '<div class="btn-group">'.PHP_EOL;
		// Chatlogs
		if(!isset($_COOKIE['root_chatlogs']) || $_COOKIE['root_chatlogs'] == 'true')
		{
			// Chatlogs by Root
			$return .= '<a class="btn btn-default btn-link" href="/chatlogs/?table='.get_date_for_chatlog_link($report_time).'&amp;username='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Chatlogs</a>'.PHP_EOL;
		}
		else
		{
			// George's chatlogs
			$return .= '<a class="btn btn-default btn-link" href="https://tools.tmod.xyz/chatlog/?table%5B%5D='.get_date_for_chatlog_link($report_time).'&amp;username='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Chatlogs</a>'.PHP_EOL;
		}
		// Video poput
		$return .= '<a class="btn btn-default btn-link" href="https://player.twitch.tv/?channel='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Popout</a>'.PHP_EOL;
		// Stream preview
		if(strpos($case_Subject, 'Abuse report concerning ') !== false || strpos($case_Subject, 'Strike concerning ') !== false || strpos($case_Subject, 'Whisper Report concerning ') !== false || strpos($case_Subject, 'Channel feed report concerning ') !== false || strpos($case_Subject, 'Channel feed comment report concerning ') !== false || strpos($case_Subject, 'Clip report concerning ') !== false)
		{
			$subject_explode = explode(' ', trim($case_Subject));
			$case_channel = $subject_explode[(count($subject_explode) - 1)];
			$return .= '<a class="btn btn-default btn-link" href="javascript:create_stream_preview('.$case_ID.', \''.rawurlencode($case_channel).'\');">Stream Preview</a>'.PHP_EOL;
		}
		// Case notes
		if($case_notes === true)
		{
			$return .= '<a class="btn btn-default btn-link" href="javascript:load_desk_notes('.$case_ID.');">Case Notes</a>'.PHP_EOL;
			// Auto load case notes
			if(!isset($GLOBALS['desk_notes_string']))
			{
				$GLOBALS['desk_notes_string'] = '';
			}
			$GLOBALS['desk_notes_string'] .= 'load_desk_notes('.$case_ID.');'.PHP_EOL;
		}
		// Translate
		$return .= '<a class="btn btn-default btn-link" href="https://translate.google.com/#auto/en/'.rawurlencode($description_for_translate).'" target="_blank" rel="noreferrer" onclick="return translate_popup(this.href, '.$case_ID.');">Translate</a>'.PHP_EOL;
		// VOD's
		$return .= '<a class="btn btn-default btn-link" href="https://www-origin.twitch.tv/'.rawurlencode($target_user).'/manager/past_broadcasts" target="_blank" rel="noreferrer">VOD&#039;s</a>'.PHP_EOL;
		// Desk case link
		$return .= '<a class="btn btn-default btn-link" href="https://help.twitch.tv/agent/case/'.rawurlencode($case_ID).'" target="_blank" rel="noreferrer">Desk Link</a>'.PHP_EOL;
		// Profile viewer
		// $return .= '<a class="btn btn-default btn-link" href="https://bashtech.net/twitch/profile.php?stream='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Profile Viewer</a>'.PHP_EOL;
		// Channel content preview
		if(strpos($case_Subject, 'Abuse report concerning ') !== false || strpos($case_Subject, 'Strike concerning ') !== false || strpos($case_Subject, 'Whisper Report concerning ') !== false || strpos($case_Subject, 'Channel feed report concerning ') !== false || strpos($case_Subject, 'Channel feed comment report concerning ') !== false || strpos($case_Subject, 'Clip report concerning ') !== false)
		{
			$subject_explode = explode(' ', trim($case_Subject));
			$case_channel = $subject_explode[(count($subject_explode) - 1)];
			$return .= '<div class="btn-group">'.PHP_EOL;
			$return .= '<button type="button" data-toggle="dropdown" class="btn btn-default dropdown-toggle">Channel content <span class="caret"></span></button>'.PHP_EOL;
			$return .= '<ul class="dropdown-menu bullet pull-right">'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_profile_image_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">Profile Image</a></li>'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_profile_banner_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">Profile Banner</a></li>'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_offline_image_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">Offline Image</a></li>'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_profile_image_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');create_profile_banner_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');create_offline_image_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">Show all</a></li>'.PHP_EOL;
			$return .= '<li class="divider"></li>'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_user_bio_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">User bio</a></li>'.PHP_EOL;
			$return .= '</ul>'.PHP_EOL;
			$return .= '</div>';
		}
		// Report history
		$return .= '<a class="tos_history_link" href="javascript:load_report_history_auto(\''.$case_ID.'\',\''.rawurlencode($target_user).'\');"></a><a class="btn btn-default btn-link" href="javascript:load_report_history(\''.$case_ID.'\', \''.rawurlencode($target_user).'\');">TOS History</a>'.PHP_EOL;
		// Screenshot
		$return .= '<a class="btn btn-default btn-link" href="/screenshot_upload.php?channel='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Add Screenshot</a>'.PHP_EOL;
		if(check_if_channel_is_partner_via_subject($case_Subject) === false)
		{
			// Report link (Only show for non-partners)
			$return .= '<a class="btn btn-default btn-link" href="https://www-origin.twitch.tv/'.rawurlencode($target_user).'/report_form?tos_ban=true&amp;content=feed'.$extra_report_string.'" target="_blank" rel="noreferrer">Report Link</a>'.PHP_EOL;
		}
		else
		{
			// Partnerconduct report
			$return .= '<a class="btn btn-default btn-link" href="/index.php?partnerconduct_report=true&amp;target_user='.rawurlencode($target_user).'&amp;content=feed'.$extra_report_string.'" target="_blank" rel="noreferrer">PartnerConduct Link</a>'.PHP_EOL;
		}
		$return .= '</div>'.PHP_EOL;
		$return .= '<hr>'.PHP_EOL;
		// Desk notes
		$return .= '<div id="desk_notes_'.$case_ID.'" style="word-wrap: break-word;"></div>'.PHP_EOL;
		// Report history
		$return .= '<div id="report_history_'.$case_ID.'"></div>'.PHP_EOL;
		// Stream preview image
		$return .= '<div class="stream-preview-image" id="stream_preview_image_'.$case_ID.'" data-channel="'.rawurlencode($target_user).'"></div>'.PHP_EOL;
		// Profile image preview
		$return .= '<div id="profile_image_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Profile banner preview
		$return .= '<div id="profile_banner_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Offline image preview
		$return .= '<div id="offline_image_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Bio preview
		$return .= '<div id="user_bio_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Video preview
		$return .= '<div id="stream_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Reason and description
		$return .= '<div class="well">'.PHP_EOL;
		$return .= 'Case ID: '.$case_ID.'<br>'.PHP_EOL;
		$return .= 'Post ID: <a href="https://www-origin.twitch.tv/'.rawurlencode($target_user).'/p/'.rawurlencode($report_postID).'" target="_blank" rel="noreferrer">'.htmlspecialchars($report_postID, ENT_QUOTES|ENT_HTML5).'</a><br>'.PHP_EOL;
		$return .= htmlspecialchars($report_reason, ENT_QUOTES|ENT_HTML5).'<br>'.PHP_EOL;
		$return .= '<b>Feed content:</b><br>'.PHP_EOL;
		$return .= '<div id="report_description_'.$case_ID.'" class="report-description" style="word-wrap: break-word;">'.PHP_EOL;
		$return .= $description_text;
		$return .= '</div>'.PHP_EOL;
		$return .= '</div>'.PHP_EOL;
		$return .= '<hr>'.PHP_EOL;
		$return .= '<div class="row">'.PHP_EOL;
		$return .= '<div class="col-md-5">'.PHP_EOL;

		// Only show the reporter if there is one (looking at you PS4)
		if(isset($case_reporter['short']) && !empty($case_reporter['short']))
		{
			$return .= 'Reporter: ';
			$return .= '<a href="https://www-origin.twitch.tv/'.rawurlencode($case_reporter['short']).'?bttvAnonChat=true&amp;tmi_host=false" title="'.htmlspecialchars($case_reporter['full'], ENT_QUOTES|ENT_HTML5).'" target="_blank" rel="noreferrer">';
			$return .= htmlspecialchars($case_reporter['short'], ENT_QUOTES|ENT_HTML5);
			$return .= '</a> ';
			// Translate reporter username button
			$return .= '<a href="https://translate.google.com/#auto/en/'.rawurlencode($case_reporter['short']).'" target="_blank" rel="noreferrer" onclick="return translate_popup(this.href, \'reporter_'.$case_ID.'\');"><img src="chatlogs/translate.png" title="Translate" alt=""></a> ';
			// Display name
			$display_name = get_display_names_from_report($mail_body, $case_Subject);
			if(isset($display_name['reporter']) && !empty($display_name['reporter']))
			{
				$return .= '('.htmlspecialchars($display_name['reporter'], ENT_QUOTES|ENT_HTML5).') ';
				$return .= '<a href="https://translate.google.com/#auto/en/'.rawurlencode($display_name['reporter']).'" target="_blank" rel="noreferrer" onclick="return translate_popup(this.href, \'reporter_display_name_'.$case_ID.'\');"><img src="chatlogs/translate.png" title="Translate" alt=""></a> ';
			}
			unset($display_name);
			// Ban reporter button
			$return .= '<a href="https://www-origin.twitch.tv/'.rawurlencode($case_reporter['short']).'/report_form?tos_ban=true" title="Report" target="_blank" rel="noreferrer"><span class="glyphicon glyphicon-remove-circle"></span></a> | ';
			// Auto resolve reporter drop down
			$return .= '<div class="btn-group"><button type="button" data-toggle="dropdown" class="btn btn-default dropdown-toggle"><span class="glyphicon glyphicon-ok"></span> <span class="caret"></span></button>';
			$return .= '<ul class="dropdown-menu pull-middle pull-right bullet">';
			$return .= '<li><p class="text-center"><b>Autoresolve duration:</b></p></li>';
			if(in_array($_SESSION['user']['desk_ID'], array(21812684 /* CommanderRoot */)))
			{
				$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">Session</a></li>';
			}
			$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=5&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">5 sec</a></li>';
			$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=300&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">5 min</a></li>';
			$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=600&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">10 min</a></li>';
			$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=900&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">15 min</a></li>';
			if(in_array($_SESSION['user']['desk_ID'], array(21812684 /* CommanderRoot */)))
			{
				$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=1800&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">30 min</a></li>';
				$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=3600&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">1 hour</a></li>';
			}
			$return .= '</ul></div>';
			$return .= '<br>'.PHP_EOL;
		}
		// Report time
		$return .= '<div class="time-exact" id="time_exact_'.$case_ID.'" data-unixtime="'.strtotime($report_time).'">'.time_to_pst_time($report_time).'</div>'.PHP_EOL;
		$return .= '<div class="time-friendly" id="time_friendly_'.$case_ID.'">('.sec_to_nice_time(time() - strtotime($report_time)).' ago)</div>'.PHP_EOL;

		$return .= '</div>'.PHP_EOL;

		// Generate array
		$return_array = array('return_string' => $return, 'report_description' => $description_for_translate);
	}
	elseif(strpos($case_Subject, 'Channel feed comment report concerning ') !== false)
	{
		// It's a "Channel feed comment report"
		// Target user
		$target_user = get_channel_from_subject($case_Subject);

		// Report Time
		for($u = 0; $u < count($mail_in_rows); $u++)
		{
			if(substr($mail_in_rows[$u], 0, 13) == 'Reported At: ')
			{
				$report_time = trim(substr($mail_in_rows[$u], 13));
				break;
			}
		}
		// Reason
		for($u = 0; $u < count($mail_in_rows); $u++)
		{
			if(substr($mail_in_rows[$u], 0, 8) == 'Reason: ')
			{
				$report_reason = trim($mail_in_rows[$u]);
				break;
			}
		}
		// Category
		for($u = 0; $u < count($mail_in_rows); $u++)
		{
			if(substr($mail_in_rows[$u], 0, 10) == 'Category: ')
			{
				$report_category = trim($mail_in_rows[$u]);
				break;
			}
		}
		// Post ID
		for($u = 0; $u < count($mail_in_rows); $u++)
		{
			if(substr($mail_in_rows[$u], 0, 9) == 'Post ID: ')
			{
				$report_postID = trim(substr($mail_in_rows[$u], 9));
				break;
			}
		}
		// Comment ID
		for($u = 0; $u < count($mail_in_rows); $u++)
		{
			if(substr($mail_in_rows[$u], 0, 12) == 'Comment ID: ')
			{
				$report_commentID = trim(substr($mail_in_rows[$u], 12));
				break;
			}
		}
		// Feed owner
		for($u = 0; $u < count($mail_in_rows); $u++)
		{
			if(substr($mail_in_rows[$u], 0, 12) == 'Post Owner: ')
			{
				$row_explode = explode(',', substr($mail_in_rows[$u], 12));
				$report_feed_owner_user_username = trim($row_explode[0]);
				$report_feed_owner_user_ID = trim($row_explode[1]);
				$report_feed_owner_user_display_name = null;
				if(isset($row_explode[2]))
				{
					$report_feed_owner_user_display_name = trim($row_explode[2]);
				}
				unset($row_explode);
				break;
			}
		}

		// Get report description
		$description_text = '';
		$description_start_found = false;
		$description_text_array = array();
		for($u = 0; $u < count($mail_in_rows); $u++)
		{
			if($description_start_found === true)
			{
				$description_text_array[] = trim($mail_in_rows[$u]);
			}
			elseif(substr($mail_in_rows[$u], 0, 17) == 'Comment Content: ')
			{
				$description_start_found = true;
				$description_text_array[] = trim(substr($mail_in_rows[$u], 17));
			}
		}
		foreach($description_text_array as $description_line)
		{
			$description_text .= htmlspecialchars($description_line, ENT_QUOTES|ENT_HTML5).'<br>'.PHP_EOL;
		}
		$description_text = substr($description_text, 0, (strlen($description_text) - strlen('<br>'.PHP_EOL)));
		$description_for_translate = implode(PHP_EOL, $description_text_array);
		$description_for_report_form = implode(PHP_EOL, $description_text_array);
		unset($description_text_array);

		// Report link content
		$extra_report_string_content = '&amp;description=';
		$extra_report_string_content .= rawurlencode('Original Case ID: '.$case_ID.PHP_EOL.PHP_EOL.'Feed comment content:'.PHP_EOL);
		if(strlen(rawurlencode($description_for_report_form)) <= 4925)
		{
			$extra_report_string_content .= rawurlencode($description_for_report_form);
		}
		$extra_report_string = $extra_report_string_content;
		unset($extra_report_string_content, $description_for_report_form);

		$return = '<div class="btn-group">'.PHP_EOL;
		// Chatlogs
		if(!isset($_COOKIE['root_chatlogs']) || $_COOKIE['root_chatlogs'] == 'true')
		{
			// Chatlogs by Root
			$return .= '<a class="btn btn-default btn-link" href="/chatlogs/?table='.get_date_for_chatlog_link($report_time).'&amp;username='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Chatlogs</a>'.PHP_EOL;
		}
		else
		{
			// George's chatlogs
			$return .= '<a class="btn btn-default btn-link" href="https://tools.tmod.xyz/chatlog/?table%5B%5D='.get_date_for_chatlog_link($report_time).'&amp;username='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Chatlogs</a>'.PHP_EOL;
		}
		// Video poput
		$return .= '<a class="btn btn-default btn-link" href="https://player.twitch.tv/?channel='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Popout</a>'.PHP_EOL;
		// Stream preview
		if(strpos($case_Subject, 'Abuse report concerning ') !== false || strpos($case_Subject, 'Strike concerning ') !== false || strpos($case_Subject, 'Whisper Report concerning ') !== false || strpos($case_Subject, 'Channel feed report concerning ') !== false || strpos($case_Subject, 'Channel feed comment report concerning ') !== false || strpos($case_Subject, 'Clip report concerning ') !== false)
		{
			$subject_explode = explode(' ', trim($case_Subject));
			$case_channel = $subject_explode[(count($subject_explode) - 1)];
			$return .= '<a class="btn btn-default btn-link" href="javascript:create_stream_preview('.$case_ID.', \''.rawurlencode($case_channel).'\');">Stream Preview</a>'.PHP_EOL;
		}
		// Case notes
		if($case_notes === true)
		{
			$return .= '<a class="btn btn-default btn-link" href="javascript:load_desk_notes('.$case_ID.');">Case Notes</a>'.PHP_EOL;
			// Auto load case notes
			if(!isset($GLOBALS['desk_notes_string']))
			{
				$GLOBALS['desk_notes_string'] = '';
			}
			$GLOBALS['desk_notes_string'] .= 'load_desk_notes('.$case_ID.');'.PHP_EOL;
		}
		// Translate
		$return .= '<a class="btn btn-default btn-link" href="https://translate.google.com/#auto/en/'.rawurlencode($description_for_translate).'" target="_blank" rel="noreferrer" onclick="return translate_popup(this.href, '.$case_ID.');">Translate</a>'.PHP_EOL;
		// VOD's
		$return .= '<a class="btn btn-default btn-link" href="https://www-origin.twitch.tv/'.rawurlencode($target_user).'/manager/past_broadcasts" target="_blank" rel="noreferrer">VOD&#039;s</a>'.PHP_EOL;
		// Desk case link
		$return .= '<a class="btn btn-default btn-link" href="https://help.twitch.tv/agent/case/'.rawurlencode($case_ID).'" target="_blank" rel="noreferrer">Desk Link</a>'.PHP_EOL;
		// Profile viewer
		// $return .= '<a class="btn btn-default btn-link" href="https://bashtech.net/twitch/profile.php?stream='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Profile Viewer</a>'.PHP_EOL;
		// Channel content preview
		if(strpos($case_Subject, 'Abuse report concerning ') !== false || strpos($case_Subject, 'Strike concerning ') !== false || strpos($case_Subject, 'Whisper Report concerning ') !== false || strpos($case_Subject, 'Channel feed report concerning ') !== false || strpos($case_Subject, 'Channel feed comment report concerning ') !== false || strpos($case_Subject, 'Clip report concerning ') !== false)
		{
			$subject_explode = explode(' ', trim($case_Subject));
			$case_channel = $subject_explode[(count($subject_explode) - 1)];
			$return .= '<div class="btn-group">'.PHP_EOL;
			$return .= '<button type="button" data-toggle="dropdown" class="btn btn-default dropdown-toggle">Channel content <span class="caret"></span></button>'.PHP_EOL;
			$return .= '<ul class="dropdown-menu bullet pull-right">'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_profile_image_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">Profile Image</a></li>'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_profile_banner_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">Profile Banner</a></li>'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_offline_image_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">Offline Image</a></li>'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_profile_image_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');create_profile_banner_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');create_offline_image_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">Show all</a></li>'.PHP_EOL;
			$return .= '<li class="divider"></li>'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_user_bio_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">User bio</a></li>'.PHP_EOL;
			$return .= '</ul>'.PHP_EOL;
			$return .= '</div>';
		}
		// Report history
		$return .= '<a class="tos_history_link" href="javascript:load_report_history_auto(\''.$case_ID.'\',\''.rawurlencode($target_user).'\');"></a><a class="btn btn-default btn-link" href="javascript:load_report_history(\''.$case_ID.'\', \''.rawurlencode($target_user).'\');">TOS History</a>'.PHP_EOL;
		// Screenshot
		$return .= '<a class="btn btn-default btn-link" href="/screenshot_upload.php?channel='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Add Screenshot</a>'.PHP_EOL;
		if(check_if_channel_is_partner_via_subject($case_Subject) === false)
		{
			// Report link (Only show for non-partners)
			$return .= '<a class="btn btn-default btn-link" href="https://www-origin.twitch.tv/'.rawurlencode($target_user).'/report_form?tos_ban=true&amp;content=feed'.$extra_report_string.'" target="_blank" rel="noreferrer">Report Link</a>'.PHP_EOL;
		}
		else
		{
			// Partnerconduct report
			$return .= '<a class="btn btn-default btn-link" href="/index.php?partnerconduct_report=true&amp;target_user='.rawurlencode($target_user).'&amp;content=feed'.$extra_report_string.'" target="_blank" rel="noreferrer">PartnerConduct Link</a>'.PHP_EOL;
		}
		$return .= '</div>'.PHP_EOL;
		$return .= '<hr>'.PHP_EOL;
		// Desk notes
		$return .= '<div id="desk_notes_'.$case_ID.'" style="word-wrap: break-word;"></div>'.PHP_EOL;
		// Report history
		$return .= '<div id="report_history_'.$case_ID.'"></div>'.PHP_EOL;
		// Stream preview image
		$return .= '<div class="stream-preview-image" id="stream_preview_image_'.$case_ID.'" data-channel="'.rawurlencode($target_user).'"></div>'.PHP_EOL;
		// Profile image preview
		$return .= '<div id="profile_image_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Profile banner preview
		$return .= '<div id="profile_banner_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Offline image preview
		$return .= '<div id="offline_image_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Bio preview
		$return .= '<div id="user_bio_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Video preview
		$return .= '<div id="stream_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Reason and description
		$return .= '<div class="well">'.PHP_EOL;
		$return .= 'Case ID: '.$case_ID.'<br>'.PHP_EOL;
		$return .= 'Post ID: <a href="https://www-origin.twitch.tv/'.rawurlencode($report_feed_owner_user_username).'/p/'.rawurlencode($report_postID).'" target="_blank" rel="noreferrer">'.htmlspecialchars($report_postID, ENT_QUOTES|ENT_HTML5).'</a><br>'.PHP_EOL;
		$return .= 'Comment ID: '.htmlspecialchars($report_commentID, ENT_QUOTES|ENT_HTML5).'<br>'.PHP_EOL;
		$return .= htmlspecialchars($report_reason, ENT_QUOTES|ENT_HTML5).'<br>'.PHP_EOL;
		$return .= '<b>Feed comment content:</b><br>'.PHP_EOL;
		$return .= '<div id="report_description_'.$case_ID.'" class="report-description" style="word-wrap: break-word;">'.PHP_EOL;
		$return .= $description_text;
		$return .= '</div>'.PHP_EOL;
		$return .= '</div>'.PHP_EOL;
		$return .= '<hr>'.PHP_EOL;
		$return .= '<div class="row">'.PHP_EOL;
		$return .= '<div class="col-md-5">'.PHP_EOL;

		// Only show the reporter if there is one (looking at you PS4)
		if(isset($case_reporter['short']) && !empty($case_reporter['short']))
		{
			$return .= 'Reporter: ';
			$return .= '<a href="https://www-origin.twitch.tv/'.rawurlencode($case_reporter['short']).'?bttvAnonChat=true&amp;tmi_host=false" title="'.htmlspecialchars($case_reporter['full'], ENT_QUOTES|ENT_HTML5).'" target="_blank" rel="noreferrer">';
			$return .= htmlspecialchars($case_reporter['short'], ENT_QUOTES|ENT_HTML5);
			$return .= '</a> ';
			// Translate reporter username button
			$return .= '<a href="https://translate.google.com/#auto/en/'.rawurlencode($case_reporter['short']).'" target="_blank" rel="noreferrer" onclick="return translate_popup(this.href, \'reporter_'.$case_ID.'\');"><img src="chatlogs/translate.png" title="Translate" alt=""></a> ';
			// Ban reporter button
			$return .= '<a href="https://www-origin.twitch.tv/'.rawurlencode($case_reporter['short']).'/report_form?tos_ban=true" title="Report" target="_blank" rel="noreferrer"><span class="glyphicon glyphicon-remove-circle"></span></a> | ';
			// Auto resolve reporter drop down
			$return .= '<div class="btn-group"><button type="button" data-toggle="dropdown" class="btn btn-default dropdown-toggle"><span class="glyphicon glyphicon-ok"></span> <span class="caret"></span></button>';
			$return .= '<ul class="dropdown-menu pull-middle pull-right bullet">';
			$return .= '<li><p class="text-center"><b>Autoresolve duration:</b></p></li>';
			if(in_array($_SESSION['user']['desk_ID'], array(21812684 /* CommanderRoot */)))
			{
				$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">Session</a></li>';
			}
			$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=5&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">5 sec</a></li>';
			$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=300&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">5 min</a></li>';
			$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=600&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">10 min</a></li>';
			$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=900&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">15 min</a></li>';
			if(in_array($_SESSION['user']['desk_ID'], array(21812684 /* CommanderRoot */)))
			{
				$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=1800&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">30 min</a></li>';
				$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=3600&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">1 hour</a></li>';
			}
			$return .= '</ul></div>';
			$return .= '<br>'.PHP_EOL;
		}
		// Report time
		$return .= '<div class="time-exact" id="time_exact_'.$case_ID.'" data-unixtime="'.strtotime($report_time).'">'.time_to_pst_time($report_time).'</div>'.PHP_EOL;
		$return .= '<div class="time-friendly" id="time_friendly_'.$case_ID.'">('.sec_to_nice_time(time() - strtotime($report_time)).' ago)</div>'.PHP_EOL;

		$return .= '</div>'.PHP_EOL;

		// Generate array
		$return_array = array('return_string' => $return, 'report_description' => $description_for_translate);
	}
	elseif(strpos($case_Subject, 'Clip report concerning ') !== false && substr($mail_in_rows[0], 0, 18) == 'Clips Abuse Report')
	{
		// It's a "Clip report"
		// Target user
		$target_user = get_channel_from_subject($case_Subject);

		// Report Time
		for($u = 0; $u < count($mail_in_rows); $u++)
		{
			if(substr($mail_in_rows[$u], 0, 13) == 'Reported at: ')
			{
				$report_time = trim(preg_replace('/\.[0-9]+ &#43;/i', ' +', substr($mail_in_rows[$u], 13)));
				break;
			}
		}
		// Kind of Abuse
		for($u = 0; $u < count($mail_in_rows); $u++)
		{
			if(substr($mail_in_rows[$u], 0, 15) == 'Kind of abuse: ')
			{
				$report_reason = get_color_for_report_reason(trim($mail_in_rows[$u]));
				break;
			}
		}
		// Target clip
		for($u = 0; $u < count($mail_in_rows); $u++)
		{
			if(substr($mail_in_rows[$u], 0, 8) == 'Target: ')
			{
				$target_clip = trim(substr($mail_in_rows[$u], 8));
				break;
			}
		}
		// Get report description
		$description_text = '';
		$description_start_found = false;
		$description_text_array = array();
		for($u = 0; $u < count($mail_in_rows); $u++)
		{
			if($description_start_found === true)
			{
				$description_text_array[] = html_entity_decode(trim($mail_in_rows[$u]), ENT_QUOTES|ENT_HTML5);
			}
			elseif(substr($mail_in_rows[$u], 0, 12) == 'Description:')
			{
				$description_start_found = true;
			}
		}
		$description_text .= parse_urls_to_ahref($description_text_array);
		$description_for_translate = '';
		foreach($description_text_array as $line)
		{
			$description_for_translate .= $line.PHP_EOL;
		}
		unset($description_text_array);


		$return = '<div class="btn-group">'.PHP_EOL;
		// Chatlogs
		if(!isset($_COOKIE['root_chatlogs']) || $_COOKIE['root_chatlogs'] == 'true')
		{
			// Chatlogs by Root
			$return .= '<a class="btn btn-default btn-link" href="/chatlogs/?table='.get_date_for_chatlog_link($report_time).'&amp;username='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Chatlogs</a>'.PHP_EOL;
		}
		else
		{
			// George's chatlogs
			$return .= '<a class="btn btn-default btn-link" href="https://tools.tmod.xyz/chatlog/?table%5B%5D='.get_date_for_chatlog_link($report_time).'&amp;username='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Chatlogs</a>'.PHP_EOL;
		}
		// Video poput
		$return .= '<a class="btn btn-default btn-link" href="https://player.twitch.tv/?channel='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Popout</a>'.PHP_EOL;
		// Stream preview
		if(strpos($case_Subject, 'Abuse report concerning ') !== false || strpos($case_Subject, 'Strike concerning ') !== false || strpos($case_Subject, 'Whisper Report concerning ') !== false || strpos($case_Subject, 'Channel feed report concerning ') !== false || strpos($case_Subject, 'Channel feed comment report concerning ') !== false /* || strpos($case_Subject, 'Clip report concerning ') !== false */)
		{
			$subject_explode = explode(' ', trim($case_Subject));
			$case_channel = $subject_explode[(count($subject_explode) - 1)];
			$return .= '<a class="btn btn-default btn-link" href="javascript:create_stream_preview('.$case_ID.', \''.rawurlencode($case_channel).'\');">Stream Preview</a>'.PHP_EOL;
		}
		// Clip preview
		if(strpos($case_Subject, 'Clip report concerning ') !== false)
		{
			$return .= '<a class="btn btn-default btn-link" href="javascript:show_clip_preview('.$case_ID.',\''.str_replace('clips.twitch.tv/', '', $target_clip).'\');">Clip Preview</a>'.PHP_EOL;
		}
		// Case notes
		if($case_notes === true)
		{
			$return .= '<a class="btn btn-default btn-link" href="javascript:load_desk_notes('.$case_ID.');">Case Notes</a>'.PHP_EOL;
			// Auto load case notes
			if(!isset($GLOBALS['desk_notes_string']))
			{
				$GLOBALS['desk_notes_string'] = '';
			}
			$GLOBALS['desk_notes_string'] .= 'load_desk_notes('.$case_ID.');'.PHP_EOL;
		}
		// Translate
		$return .= '<a class="btn btn-default btn-link" href="https://translate.google.com/#auto/en/'.rawurlencode($description_for_translate).'" target="_blank" rel="noreferrer" onclick="return translate_popup(this.href, '.$case_ID.');">Translate</a>'.PHP_EOL;
		// VOD's
		$return .= '<a class="btn btn-default btn-link" href="https://www-origin.twitch.tv/'.rawurlencode($target_user).'/manager/past_broadcasts" target="_blank" rel="noreferrer">VOD&#039;s</a>'.PHP_EOL;
		// Desk case link
		$return .= '<a class="btn btn-default btn-link" href="https://help.twitch.tv/agent/case/'.rawurlencode($case_ID).'" target="_blank" rel="noreferrer">Desk Link</a>'.PHP_EOL;
		// Profile viewer
		// $return .= '<a class="btn btn-default btn-link" href="https://bashtech.net/twitch/profile.php?stream='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Profile Viewer</a>'.PHP_EOL;
		// Channel content preview
		if(strpos($case_Subject, 'Abuse report concerning ') !== false || strpos($case_Subject, 'Strike concerning ') !== false || strpos($case_Subject, 'Whisper Report concerning ') !== false || strpos($case_Subject, 'Channel feed report concerning ') !== false || strpos($case_Subject, 'Channel feed comment report concerning ') !== false || strpos($case_Subject, 'Clip report concerning ') !== false)
		{
			$subject_explode = explode(' ', trim($case_Subject));
			$case_channel = $subject_explode[(count($subject_explode) - 1)];
			$return .= '<div class="btn-group">'.PHP_EOL;
			$return .= '<button type="button" data-toggle="dropdown" class="btn btn-default dropdown-toggle">Channel content <span class="caret"></span></button>'.PHP_EOL;
			$return .= '<ul class="dropdown-menu bullet pull-right">'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_profile_image_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">Profile Image</a></li>'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_profile_banner_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">Profile Banner</a></li>'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_offline_image_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">Offline Image</a></li>'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_profile_image_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');create_profile_banner_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');create_offline_image_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">Show all</a></li>'.PHP_EOL;
			$return .= '<li class="divider"></li>'.PHP_EOL;
			$return .= '<li><a class="btn btn-default" href="javascript:create_user_bio_preview('.$case_ID.',\''.rawurlencode($case_channel).'\');">User bio</a></li>'.PHP_EOL;
			$return .= '</ul>'.PHP_EOL;
			$return .= '</div>';
		}
		// Report history
		$return .= '<a class="tos_history_link" href="javascript:load_report_history_auto(\''.$case_ID.'\',\''.rawurlencode($target_user).'\');"></a><a class="btn btn-default btn-link" href="javascript:load_report_history(\''.$case_ID.'\', \''.rawurlencode($target_user).'\');">TOS History</a>'.PHP_EOL;
		// Screenshot
		$return .= '<a class="btn btn-default btn-link" href="/screenshot_upload.php?channel='.rawurlencode($target_user).'" target="_blank" rel="noreferrer">Add Screenshot</a>'.PHP_EOL;
		if(check_if_channel_is_partner_via_subject($case_Subject) === false)
		{
			// Report link (Only show for non-partners)
			$return .= '<a class="btn btn-default btn-link" href="https://www-origin.twitch.tv/'.rawurlencode($target_user).'/report_form?tos_ban=true&amp;content=feed'.$extra_report_string.'" target="_blank" rel="noreferrer">Report Link</a>'.PHP_EOL;
		}
		else
		{
			// Partnerconduct report
			$return .= '<a class="btn btn-default btn-link" href="/index.php?partnerconduct_report=true&amp;target_user='.rawurlencode($target_user).'&amp;content=feed'.$extra_report_string.'" target="_blank" rel="noreferrer">PartnerConduct Link</a>'.PHP_EOL;
		}
		$return .= '</div>'.PHP_EOL;
		$return .= '<hr>'.PHP_EOL;
		// Desk notes
		$return .= '<div id="desk_notes_'.$case_ID.'" style="word-wrap: break-word;"></div>'.PHP_EOL;
		// Report history
		$return .= '<div id="report_history_'.$case_ID.'"></div>'.PHP_EOL;
		// Stream preview image
		$return .= '<div class="stream-preview-image" id="stream_preview_image_'.$case_ID.'" data-channel="'.rawurlencode($target_user).'"></div>'.PHP_EOL;
		// Profile image preview
		$return .= '<div id="profile_image_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Profile banner preview
		$return .= '<div id="profile_banner_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Offline image preview
		$return .= '<div id="offline_image_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Bio preview
		$return .= '<div id="user_bio_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Video preview
		$return .= '<div id="stream_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Clip preview
		$return .= '<div id="clip_preview_'.$case_ID.'"></div>'.PHP_EOL;
		// Reason and description
		$return .= '<div class="well">'.PHP_EOL;
		$return .= '<b>Target clip:</b> <a href="https://'.$target_clip.'" target="_blank" rel="noreferrer">'.htmlspecialchars('https://'.$target_clip, ENT_QUOTES|ENT_HTML5).'</a> <span id="clip_status_'.$case_ID.'"><a class="violating_content_preview_link" href="javascript:check_clip_status('.$case_ID.',\''.str_replace('clips.twitch.tv/', '', $target_clip).'\');"></a></span><br>'.PHP_EOL;
		// Request Clip history button
		$return .= '<b>Clips:</b> <span id="clip_link_'.$case_ID.'"><a class="btn btn-xs btn-default btn-link" href="javascript:show_clips_timestamp_history2(\''.rawurlencode($target_user).'\', \''.rawurlencode(str_replace('clips.twitch.tv/', '', $target_clip)).'\');">Check for other clips around the reported one</a></span><br>'.PHP_EOL;
		$return .= $report_reason.'<br>'.PHP_EOL;
		$return .= '<b>Description:</b><br>'.PHP_EOL;
		$return .= '<div id="report_description_'.$case_ID.'" class="report-description" style="word-wrap: break-word;">'.PHP_EOL;
		$return .= $description_text;
		$return .= '</div>'.PHP_EOL;
		$return .= '</div>'.PHP_EOL;
		$return .= '<hr>'.PHP_EOL;
		$return .= '<div class="row">'.PHP_EOL;
		$return .= '<div class="col-md-5">'.PHP_EOL;

		// Only show the reporter if there is one (looking at you PS4)
		if(isset($case_reporter['short']) && !empty($case_reporter['short']))
		{
			$return .= 'Reporter: ';
			$return .= '<a href="https://www-origin.twitch.tv/'.rawurlencode($case_reporter['short']).'?bttvAnonChat=true&amp;tmi_host=false" title="'.htmlspecialchars($case_reporter['full'], ENT_QUOTES|ENT_HTML5).'" target="_blank" rel="noreferrer">';
			$return .= htmlspecialchars($case_reporter['short'], ENT_QUOTES|ENT_HTML5);
			$return .= '</a> ';
			// Translate reporter username button
			$return .= '<a href="https://translate.google.com/#auto/en/'.rawurlencode($case_reporter['short']).'" target="_blank" rel="noreferrer" onclick="return translate_popup(this.href, \'reporter_'.$case_ID.'\');"><img src="chatlogs/translate.png" title="Translate" alt=""></a> ';
			// Display name
			$display_name = get_display_names_from_report($mail_body, $case_Subject);
			if(isset($display_name['reporter']) && !empty($display_name['reporter']))
			{
				$return .= '('.htmlspecialchars($display_name['reporter'], ENT_QUOTES|ENT_HTML5).') ';
				$return .= '<a href="https://translate.google.com/#auto/en/'.rawurlencode($display_name['reporter']).'" target="_blank" rel="noreferrer" onclick="return translate_popup(this.href, \'reporter_display_name_'.$case_ID.'\');"><img src="chatlogs/translate.png" title="Translate" alt=""></a> ';
			}
			unset($display_name);
			// Ban reporter button
			$return .= '<a href="https://www-origin.twitch.tv/'.rawurlencode($case_reporter['short']).'/report_form?tos_ban=true" title="Report" target="_blank" rel="noreferrer"><span class="glyphicon glyphicon-remove-circle"></span></a> | ';
			// Auto resolve reporter drop down
			$return .= '<div class="btn-group"><button type="button" data-toggle="dropdown" class="btn btn-default dropdown-toggle"><span class="glyphicon glyphicon-ok"></span> <span class="caret"></span></button>';
			$return .= '<ul class="dropdown-menu pull-middle pull-right bullet">';
			$return .= '<li><p class="text-center"><b>Autoresolve duration:</b></p></li>';
			if(in_array($_SESSION['user']['desk_ID'], array(21812684 /* CommanderRoot */)))
			{
				$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">Session</a></li>';
			}
			$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=5&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">5 sec</a></li>';
			$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=300&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">5 min</a></li>';
			$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=600&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">10 min</a></li>';
			$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=900&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">15 min</a></li>';
			if(in_array($_SESSION['user']['desk_ID'], array(21812684 /* CommanderRoot */)))
			{
				$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=1800&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">30 min</a></li>';
				$return .= '<li><a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_add='.rawurlencode($case_reporter['short']).'&amp;resolve_time=3600&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" target="_self">1 hour</a></li>';
			}
			$return .= '</ul></div>';
			$return .= '<br>'.PHP_EOL;
		}
		// Report time
		$return .= '<div class="time-exact" id="time_exact_'.$case_ID.'" data-unixtime="'.strtotime($report_time).'">'.time_to_pst_time($report_time).'</div>'.PHP_EOL;
		$return .= '<div class="time-friendly" id="time_friendly_'.$case_ID.'">('.sec_to_nice_time(time() - strtotime($report_time)).' ago)</div>'.PHP_EOL;

		$return .= '</div>'.PHP_EOL;

		// Generate array
		$return_array = array('return_string' => $return, 'report_description' => $description_for_translate);
	}
	else
	{
		// Something else so just give out as is
		$return = nl2br(str_replace('&NewLine;', '<br>', htmlspecialchars($mail_body, ENT_QUOTES|ENT_HTML5)), false);

		// Options
		$return .= '<hr>'.PHP_EOL;
		$return .= '<div class="row">'.PHP_EOL;
		$return .= '<div class="col-md-8">'.PHP_EOL;
		$return .= '<div class="pull-right">'.PHP_EOL;
		$return .= '<div class="btn-group">'.PHP_EOL;


		// Assigne and Resolve
		$return .= '<button type="button" class="btn btn-success" id="assign_and_resolve_'.$case_ID.'" onclick="assign_and_resolve('.$case_ID.');">Assign &amp; Resolve</button>'.PHP_EOL;

		// Remove from view
		// $return .= '<button type="button" class="btn btn-default" onclick="remove_case('.$case_ID.'); case_counter = case_counter - 1; check_for_reload();">Remove from view</button>'.PHP_EOL;

		// View in Desk
		$return .= '<a class="btn btn-default" href="https://help.twitch.tv/agent/case/'.rawurlencode($case_ID).'" target="_blank" rel="noreferrer">Open in Desk</a>'.PHP_EOL;

		$return .= '</div>'.PHP_EOL;
		$return .= '</div>'.PHP_EOL;
		$return .= '</div>'.PHP_EOL;
		$return .= '</div>'.PHP_EOL; // class="row"
	}

	if(isset($return_array)) return $return_array;
	return $return;
}

function parse_whisper_report_to_table($description_text_array, $target_user)
{
	$return = '';
	if(count($description_text_array) >= 2)
	{
		$return .= '<table class="table table-condensed" style="table-layout: fixed;">'.PHP_EOL;
		$return .= '<colgroup>'.PHP_EOL;
		$return .= '<col class="col-md-3 text-nowrap">'.PHP_EOL;
		$return .= '<col class="col-md-2 text-nowrap">'.PHP_EOL;
		$return .= '<col class="col-md-7" style="word-wrap: break-word;">'.PHP_EOL;
		$return .= '</colgroup>'.PHP_EOL;
		// Output as formatted table
		foreach($description_text_array as $line_num => $line_content)
		{
			$line_content_explode = explode('	', $line_content, 3);
			if($line_num == 0)
			{
				// Header
				$return .= '<thead>'.PHP_EOL.'<tr>'.PHP_EOL;
				foreach($line_content_explode as $line_part)
				{
					$return .= '<th>'.htmlspecialchars($line_part, ENT_QUOTES|ENT_HTML5).'</th>'.PHP_EOL;
				}
				$return .= '</tr>'.PHP_EOL.'</thead>'.PHP_EOL.'<tbody>'.PHP_EOL;
			}
			else
			{
				$return .= '<tr>'.PHP_EOL;
				// Body
				foreach($line_content_explode as $line_part_num => $line_part)
				{
					if($line_part_num == 0)
					{
						// Add mouse over for xx time ago
						$return .= '<td><abbr title="'.sec_to_nice_time(time() - strtotime($line_part)).' ago">'.htmlspecialchars($line_part, ENT_QUOTES|ENT_HTML5).'</abbr></td>'.PHP_EOL;
					}
					elseif($line_part_num == 1)
					{
						// Add links to the channel
						$return .= '<td>';
						if($line_part == $target_user)
						{
							$return .= '[T] ';
						}
						$return .= '<a href="https://www-origin.twitch.tv/'.rawurlencode($line_part).'?bttvAnonChat=true&amp;tmi_host=false" target="_blank" rel="noreferrer">'.htmlspecialchars($line_part, ENT_QUOTES|ENT_HTML5).'</a></td>'.PHP_EOL;
					}
					elseif($line_part_num == 2)
					{
						// Parse content for links
						$return .= '<td>'.parse_urls_to_ahref(array($line_part), true).'</td>'.PHP_EOL;
					}
					else
					{
						$return .= '<td>'.htmlspecialchars($line_part, ENT_QUOTES|ENT_HTML5).'</td>'.PHP_EOL;
					}
				}
				$return .= '</tr>'.PHP_EOL;
			}
		}
		$return .= '</tbody>'.PHP_EOL;
		$return .= '</table>'.PHP_EOL;
	}
	else
	{
		foreach($description_text_array as $line)
		{
			$return .= htmlspecialchars($line, ENT_QUOTES|ENT_HTML5).'<br>'.PHP_EOL;
		}
	}
	return $return;
}

function string_to_ahref($string)
{
	// Only if it's not Sour
	if(!in_array($_SESSION['user']['desk_ID'], array(21812799 /* Sournothardcore */, 21812873 /* Itaku */)))
	{
		$return = '<a href="'.$string.'" target="_blank" rel="noreferrer">'.htmlspecialchars($string, ENT_QUOTES|ENT_HTML5).'</a>';
	}
	else
	{
		$return = $string;
	}
	return $return;
}

function parse_urls_to_ahref($array, $no_new_line = false)
{
	$return = '';
	foreach($array as $line)
	{
		$words = explode(' ', $line);
		foreach($words as $word)
		{
			if(($parsed_word = parse_url($word)) !== false)
			{
				if(isset($parsed_word['scheme']) && isset($parsed_word['host']) && !empty($parsed_word['scheme']) && !empty($parsed_word['host']))
				{
					// http://blalba.com
					if($parsed_word['scheme'] == 'http' || $parsed_word['scheme'] == 'https')
					{
						$return .= string_to_ahref($word);
					}
					else
					{
						if($no_new_line === false && $GLOBALS['evil_report_text'] === true)
						{
							$return .= htmlspecialchars(random_case($word), ENT_QUOTES|ENT_HTML5);
						}
						else
						{
							$return .= htmlspecialchars($word, ENT_QUOTES|ENT_HTML5);
						}
					}
				}
				else
				{
					if($no_new_line === false&& $GLOBALS['evil_report_text'] === true)
					{
						$return .= htmlspecialchars(random_case($word), ENT_QUOTES|ENT_HTML5);
					}
					else
					{
						$return .= htmlspecialchars($word, ENT_QUOTES|ENT_HTML5);
					}
				}
			}
			else
			{
				if($no_new_line === false && $GLOBALS['evil_report_text'] === true)
				{
					$return .= htmlspecialchars(random_case($word), ENT_QUOTES|ENT_HTML5);
				}
				else
				{
					$return .= htmlspecialchars($word, ENT_QUOTES|ENT_HTML5);
				}
			}
			$return .= ' ';
		}
		if($no_new_line === false)
		{
			$return .= '<br>'.PHP_EOL;
		}
	}
	return $return;
}

function do_assign_and_resolve($case_id, $return_as_string = false, $add_labels_array = NULL)
{
	// Try this to stop whatever is doing long php run times
	if($return_as_string === false) set_time_limit(30);

	$ch = &$GLOBALS['global_curl'];
	// Create the post content
	$post_content_array = array();
	$post_content_array['status'] = 'resolved';
	if($add_labels_array !== NULL && is_array($add_labels_array) && count($add_labels_array) > 0)
	{
		$post_content_array['labels'] = $add_labels_array;
		$post_content_array['label_action'] = 'append';
	}
	$post_content_array['_links']['assigned_user'] = array('class' => 'user', 'href' => '/api/v2/users/'.$_SESSION['user']['desk_ID']);
	$post_content = json_encode($post_content_array);
	unset($post_content_array);

	$request_url = $GLOBALS['DESK_API_DOMAIN'].'/api/v2/cases/'.$case_id;
	apply_curl_defaults($ch);
	curl_setopt($ch, CURLOPT_URL, $request_url);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/json', 'Content-Type: application/json'));
	if(isset($_SESSION['login_method']) && $_SESSION['login_method'] === 'oauth')
	{
		$oauth_request_header = $GLOBALS['global_oauth']->getRequestHeader('PATCH', $request_url);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/json', 'Content-Type: application/json', 'Authorization: '.$oauth_request_header));
	}
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PATCH');
	curl_setopt($ch, CURLOPT_POSTFIELDS, $post_content);

	$curl_output = curl_exec($ch);
	$curl_info = curl_getinfo($ch);
	if($curl_output === false)
	{
		if($return_as_string === false)
		{
			echo 'Curl error on "'.$curl_info['url'].'" => '.curl_error($ch);
		}
		else
		{
			$GLOBALS['curl_error_string'] .= 'Curl error on '.htmlspecialchars('"'.$curl_info['url'].'"', ENT_QUOTES|ENT_HTML5).' => '.htmlspecialchars(curl_error($ch), ENT_QUOTES|ENT_HTML5).'<br>'.PHP_EOL;
		}
	}
	else
	{
		$curl_parse = parse_desk_curl_output($curl_output);
		if($curl_info['http_code'] >= 200 && $curl_info['http_code'] <= 204)
		{
			// Request was successful
		}
		elseif($curl_info['http_code'] == 304)
		{
			// Never happens as I don't use ETAG's but if I did it would be successful
		}
		elseif($curl_info['http_code'] == 429)
		{
			header('HTTP/1.1 429 Desk Rate Limit', true, 429);
			echo 'DESK: hit rate limit on URL: '.$curl_info['url'];
			if($return_as_string === true)
			{
				// Add a 5 sec javascript auto reload here so it still continue to update
				echo PHP_EOL.'<script type="text/javascript">setTimeout(function () { window.location.reload(); }, 5000);</script>';
			}
			exit();
		}
		elseif($curl_info['http_code'] == 422)
		{
			header('HTTP/1.1 422 Unprocessable Entity', true, 422);
			echo 'CURL HTTP error 422 while updating the case'.PHP_EOL;
			if($return_as_string === true)
			{
				// Add a 5 sec javascript auto reload here so it still continue to update
				echo PHP_EOL.'<script type="text/javascript">setTimeout(function () { window.location.reload(); }, 5000);</script>';
			}
			exit();
		}
		elseif($curl_info['http_code'] == 409)
		{
			if($return_as_string !== true)
			{
				echo 'DESK: Conflict: '.$curl_info['url'].PHP_EOL;
			}
		}
		else
		{
			header('HTTP/1.1 503 Service Unavailable', true, 503);
			// Some other HTTP error => Try again
			echo 'CURL: HTTP ERROR ('.$curl_info['http_code'].'): '.$curl_info['url'].PHP_EOL;
			if($return_as_string === true)
			{
				// Add a 5 sec javascript auto reload here so it still continue to update
				echo PHP_EOL.'<script type="text/javascript">setTimeout(function () { window.location.reload(); }, 5000);</script>';
			}
			exit();
		}

		// Parse response
		$json_decode = json_decode($curl_parse['content'], true);
		if($json_decode !== NULL)
		{
			if(isset($json_decode['id']))
			{
				// Seems like it worked
				if($return_as_string === true)
				{
					$GLOBALS['curl_request_info_string'] .= '<!-- '.htmlspecialchars($curl_info['url'], ENT_QUOTES|ENT_HTML5).' (PATCH) took => DNS: '.htmlspecialchars($curl_info['namelookup_time'], ENT_QUOTES|ENT_HTML5).' / Connect: '.htmlspecialchars($curl_info['connect_time'], ENT_QUOTES|ENT_HTML5).' / Total: '.htmlspecialchars($curl_info['total_time'], ENT_QUOTES|ENT_HTML5).' seconds -->'.PHP_EOL;
					$GLOBALS['global_api_request_time'] = $GLOBALS['global_api_request_time'] + $curl_info['total_time'];

					return 'DESK: case ('.$json_decode['id'].') updated'.PHP_EOL;
				}
				else
				{
					echo 'Case updated'.PHP_EOL;
					// Session Stats (Only count it here if it's not already counted, which is the case if it's as string)
					if($GLOBALS['show_session_stats'] === true)
					{
						$_SESSION['session_stats']['cases_overall'][$json_decode['id']] = true;
						$_SESSION['session_stats']['resolved_cases'][$json_decode['id']] = true;
					}
				}
			}
			else
			{
				// Do it again
				if($return_as_string === true)
				{
					$GLOBALS['curl_request_info_string'] .= '<!-- '.htmlspecialchars($curl_info['url'], ENT_QUOTES|ENT_HTML5).' (PATCH) took => DNS: '.htmlspecialchars($curl_info['namelookup_time'], ENT_QUOTES|ENT_HTML5).' / Connect: '.htmlspecialchars($curl_info['connect_time'], ENT_QUOTES|ENT_HTML5).' / Total: '.htmlspecialchars($curl_info['total_time'], ENT_QUOTES|ENT_HTML5).' seconds -->'.PHP_EOL;
					$GLOBALS['global_api_request_time'] = $GLOBALS['global_api_request_time'] + $curl_info['total_time'];

					return 'DESK: had an error while updating a case (Empty ID in response): '.$curl_info['url'].PHP_EOL;
				}
				else
				{
					echo 'DESK: had an error while updating a case (Empty ID in response): '.$curl_info['url'].PHP_EOL;
				}
			}
		}
		else
		{
			echo 'CURL: Json decode error while desk_update_case'.PHP_EOL;
		}
	}
}

function do_macro_global_tosed($case_id)
{
	$ch = &$GLOBALS['global_curl'];
	// echo 'Updating case: '.$case_id;
	// exit();
	// Create the post content
	$post_content_array = array();
	$post_content_array['status'] = 'resolved';
	$post_content_array['labels'][] = 'AAAdmin Suspension';
	$post_content_array['label_action'] = 'append';
	$post_content_array['_links']['assigned_user'] = array('class' => 'user', 'href' => '/api/v2/users/'.$_SESSION['user']['desk_ID']);
	$post_content = json_encode($post_content_array);
	unset($post_content_array);

	$request_url = $GLOBALS['DESK_API_DOMAIN'].'/api/v2/cases/'.$case_id;
	apply_curl_defaults($ch);
	curl_setopt($ch, CURLOPT_URL, $request_url);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/json', 'Content-Type: application/json'));
	if(isset($_SESSION['login_method']) && $_SESSION['login_method'] === 'oauth')
	{
		$oauth_request_header = $GLOBALS['global_oauth']->getRequestHeader('PATCH', $request_url);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/json', 'Content-Type: application/json', 'Authorization: '.$oauth_request_header));
	}
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PATCH');
	curl_setopt($ch, CURLOPT_POSTFIELDS, $post_content);

	$curl_output = curl_exec($ch);
	$curl_info = curl_getinfo($ch);
	if($curl_output === false)
	{
		echo 'Curl error on "'.$curl_info['url'].'" => '.curl_error($ch);
	}
	else
	{
		$curl_parse = parse_desk_curl_output($curl_output);
		if($curl_info['http_code'] >= 200 && $curl_info['http_code'] <= 204)
		{
			// Request was successful
		}
		elseif($curl_info['http_code'] == 304)
		{
			// Never happens as I don't use ETAG's but if I did it would be successful
		}
		elseif($curl_info['http_code'] == 429)
		{
			header('HTTP/1.1 429 Desk Rate Limit', true, 429);
			echo 'DESK: hit rate limit on URL: '.$curl_info['url'];
			exit();
		}
		elseif($curl_info['http_code'] == 422)
		{
			header('HTTP/1.1 422 Unprocessable Entity', true, 422);
			echo 'CURL HTTP error 422 while updating the case'.PHP_EOL;
			exit();
		}
		elseif($curl_info['http_code'] == 409)
		{
			echo 'DESK: Conflict: '.$curl_info['url'].PHP_EOL;
		}
		else
		{
			header('HTTP/1.1 503 Service Unavailable', true, 503);
			// Some other HTTP error => Try again
			echo 'CURL: HTTP ERROR ('.$curl_info['http_code'].'): '.$curl_info['url'].PHP_EOL;
		}

		// Parse response
		$json_decode = json_decode($curl_parse['content'], true);
		if($json_decode !== NULL)
		{
			if(isset($json_decode['id']))
			{
				// Session Stats
				if($GLOBALS['show_session_stats'] === true)
				{
					$_SESSION['session_stats']['cases_overall'][$json_decode['id']] = true;
					$_SESSION['session_stats']['TOSd_cases'][$json_decode['id']] = true;
				}

				// Seems like it worked
				echo 'Case updated'.PHP_EOL;
			}
			else
			{
				// Do it again
				echo 'DESK: had an error while updating a case (Empty ID in response): '.$curl_info['url'].PHP_EOL;
			}
		}
		else
		{
			echo 'CURL: Json decode error while desk_update_case'.PHP_EOL;
		}
	}
}

function do_assign_to_staff_for_escalation($case_id)
{
	$ch = &$GLOBALS['global_curl'];
	// echo 'Updating case: '.$case_id;
	// exit();
	// Create the post content
	$post_content_array = array();
	$post_content_array['status'] = 'open';
	$post_content_array['labels'][] = 'Report - Escalation';
	$post_content_array['label_action'] = 'append';
	// $post_content_array['_links']['assigned_user'] = array('class' => 'user', 'href' => '/api/v2/users/23803097'); // PIPe: 21812860 , S0N0S: 21812880 , Thruthful: 21837642 , Root: 21812684 , Squishy: 22763533 , Simple: 23803097
	$post_content_array['_links']['assigned_group'] = array('class' => 'group', 'href' => '/api/v2/groups/589914');
	$post_content = json_encode($post_content_array);
	unset($post_content_array);

	$request_url = $GLOBALS['DESK_API_DOMAIN'].'/api/v2/cases/'.$case_id;
	apply_curl_defaults($ch);
	curl_setopt($ch, CURLOPT_URL, $request_url);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/json', 'Content-Type: application/json'));
	if(isset($_SESSION['login_method']) && $_SESSION['login_method'] === 'oauth')
	{
		$oauth_request_header = $GLOBALS['global_oauth']->getRequestHeader('PATCH', $request_url);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/json', 'Content-Type: application/json', 'Authorization: '.$oauth_request_header));
	}
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PATCH');
	curl_setopt($ch, CURLOPT_POSTFIELDS, $post_content);

	$curl_output = curl_exec($ch);
	$curl_info = curl_getinfo($ch);
	if($curl_output === false)
	{
		echo 'Curl error on "'.$curl_info['url'].'" => '.curl_error($ch);
	}
	else
	{
		$curl_parse = parse_desk_curl_output($curl_output);
		if($curl_info['http_code'] >= 200 && $curl_info['http_code'] <= 204)
		{
			// Request was successful
		}
		elseif($curl_info['http_code'] == 304)
		{
			// Never happens as I don't use ETAG's but if I did it would be successful
		}
		elseif($curl_info['http_code'] == 429)
		{
			header('HTTP/1.1 429 Desk Rate Limit', true, 429);
			echo 'DESK: hit rate limit on URL: '.$curl_info['url'];
			exit();
		}
		elseif($curl_info['http_code'] == 422)
		{
			echo 'CURL HTTP error 422 while updating the case'.PHP_EOL;
			exit();
		}
		elseif($curl_info['http_code'] == 409)
		{
			echo 'DESK: Conflict: '.$curl_info['url'].PHP_EOL;
		}
		else
		{
			// Some other HTTP error => Try again
			echo 'CURL: HTTP ERROR ('.$curl_info['http_code'].'): '.$curl_info['url'].PHP_EOL;
		}

		// Parse response
		$json_decode = json_decode($curl_parse['content'], true);
		if($json_decode !== NULL)
		{
			if(isset($json_decode['id']))
			{
				// Seems like it worked
				echo 'Case updated'.PHP_EOL;
			}
			else
			{
				// Do it again
				echo 'DESK: had an error while updating a case (Empty ID in response): '.$curl_info['url'].PHP_EOL;
			}
		}
		else
		{
			echo 'CURL: Json decode error while desk_update_case'.PHP_EOL;
		}
	}
}

function do_assign_to_staff_for_pm_check($case_id)
{
	$ch = &$GLOBALS['global_curl'];
	// echo 'Updating case: '.$case_id;
	// exit();
	// Create the post content
	$post_content_array = array();
	$post_content_array['status'] = 'open';
	$post_content_array['labels'][] = 'PM Check';
	$post_content_array['label_action'] = 'append';
	// $post_content_array['_links']['assigned_user'] = array('class' => 'user', 'href' => '/api/v2/users/21812880'); // PIPe: 21812860 , S0N0S: 21812880 , Thruthful: 21837642 , Root: 21812684, Fire: 21812870
	$post_content_array['_links']['assigned_group'] = array('class' => 'group', 'href' => '/api/v2/groups/515707');
	$post_content = json_encode($post_content_array);
	unset($post_content_array);

	$request_url = $GLOBALS['DESK_API_DOMAIN'].'/api/v2/cases/'.$case_id;
	apply_curl_defaults($ch);
	curl_setopt($ch, CURLOPT_URL, $request_url);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/json', 'Content-Type: application/json'));
	if(isset($_SESSION['login_method']) && $_SESSION['login_method'] === 'oauth')
	{
		$oauth_request_header = $GLOBALS['global_oauth']->getRequestHeader('PATCH', $request_url);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/json', 'Content-Type: application/json', 'Authorization: '.$oauth_request_header));
	}
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PATCH');
	curl_setopt($ch, CURLOPT_POSTFIELDS, $post_content);

	$curl_output = curl_exec($ch);
	$curl_info = curl_getinfo($ch);
	if($curl_output === false)
	{
		echo 'Curl error on "'.$curl_info['url'].'" => '.curl_error($ch);
	}
	else
	{
		$curl_parse = parse_desk_curl_output($curl_output);
		if($curl_info['http_code'] >= 200 && $curl_info['http_code'] <= 204)
		{
			// Request was successful
		}
		elseif($curl_info['http_code'] == 304)
		{
			// Never happens as I don't use ETAG's but if I did it would be successful
		}
		elseif($curl_info['http_code'] == 429)
		{
			header('HTTP/1.1 429 Desk Rate Limit', true, 429);
			echo 'DESK: hit rate limit on URL: '.$curl_info['url'];
			exit();
		}
		elseif($curl_info['http_code'] == 422)
		{
			header('HTTP/1.1 422 Unprocessable Entity', true, 422);
			echo 'CURL HTTP error 422 while updating the case'.PHP_EOL;
			exit();
		}
		elseif($curl_info['http_code'] == 409)
		{
			echo 'DESK: Conflict: '.$curl_info['url'].PHP_EOL;
		}
		else
		{
			header('HTTP/1.1 503 Service Unavailable', true, 503);
			// Some other HTTP error => Try again
			echo 'CURL: HTTP ERROR ('.$curl_info['http_code'].'): '.$curl_info['url'].PHP_EOL;
		}

		// Parse response
		$json_decode = json_decode($curl_parse['content'], true);
		if($json_decode !== NULL)
		{
			if(isset($json_decode['id']))
			{
				// Session Stats
				if($GLOBALS['show_session_stats'] === true)
				{
					$_SESSION['session_stats']['cases_overall'][$json_decode['id']] = true;
					$_SESSION['session_stats']['staff_assigned_pm_check_cases'][$json_decode['id']] = true;
				}

				// Seems like it worked
				echo 'Case ('.$json_decode['id'].') updated'.PHP_EOL;
			}
			else
			{
				// Do it again
				echo 'DESK: had an error while updating a case (Empty ID in response): '.$curl_info['url'].PHP_EOL;
			}
		}
		else
		{
			echo 'CURL: Json decode error while desk_update_case'.PHP_EOL;
		}
	}
}

function do_logout($redirect = true)
{
	// If the user had multi user distribution 
	if(isset($_SESSION['case_distribution_enabled']) && $_SESSION['case_distribution_enabled'] === true)
	{
		remove_redis_entry_for_multi_user_distribution();
		update_redis_key_for_case_distribution_last_modified();
	}
	session_destroy();
	unset($_SESSION);
	if($redirect === true)
	{
		header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	}
	exit();
}

function get_date_for_chatlog_link($report_time)
{
	$dateTime = new DateTime(date('c', strtotime($report_time)), new DateTimeZone(date_default_timezone_get()));
	$dateTime->setTimezone(new DateTimeZone('America/Los_Angeles'));

	$return = $dateTime->format('Y_m_d');
	return $return;
}

function get_current_hour_in_pacific_time()
{
	$dateTime = new DateTime(date('c'), new DateTimeZone(date_default_timezone_get()));
	$dateTime->setTimezone(new DateTimeZone('America/Los_Angeles'));

	return $dateTime->format('G');
}

function get_current_day_in_pacific_time()
{
	$dateTime = new DateTime(date('c'), new DateTimeZone(date_default_timezone_get()));
	$dateTime->setTimezone(new DateTimeZone('America/Los_Angeles'));

	return $dateTime->format('D');
}

function get_redis_connection()
{
	static $redis = NULL;
	static $redis_is_connected = false;
	if($redis === NULL)
	{
		$redis = new Redis();
		if($redis->connect('better-desk.8rs2gm.0001.usw1.cache.amazonaws.com', 6379, 2.5) === false)
		{
			$redis_is_connected = false;
		}
		else
		{
			$redis_is_connected = true;
			$redis->setOption(Redis::OPT_SERIALIZER, Redis::SERIALIZER_PHP);
			$redis->setOption(Redis::OPT_PREFIX, '');
		}
	}
	else
	{
		// reset the settings
		$redis->setOption(Redis::OPT_SERIALIZER, Redis::SERIALIZER_PHP);
		$redis->setOption(Redis::OPT_PREFIX, '');
	}

	return array('redis' => $redis, 'redis_is_connected' => $redis_is_connected);
}

function remove_redis_entry_for_multi_user_distribution()
{
	if($GLOBALS['use_redis'] === true && isset($_SESSION['user']['desk_ID']))
	{
		// Connect to redis
		$redis = get_redis_connection()['redis'];
		$redis_is_connected = get_redis_connection()['redis_is_connected'];

		if($redis_is_connected === true)
		{
			// Delete the possible key
			$redis->delete('twitch-desk-distribution:'.$_SESSION['user']['desk_ID']);
		}
	}
}

function get_user_of_multi_user_distribution()
{
	if($GLOBALS['use_redis'] === true)
	{
		// Connect to redis
		$redis = get_redis_connection()['redis'];
		$redis_is_connected = get_redis_connection()['redis_is_connected'];

		if($redis_is_connected === true)
		{
			// Get all that use it
			$case_distribution_enabled_user = array();
			$redis_case_distribution_enabled_user_overview = $redis->keys('twitch-desk-distribution:*');
			foreach($redis_case_distribution_enabled_user_overview as $redis_key)
			{
				$redis_response = $redis->get($redis_key);
				if($redis_response !== false)
				{
					// Get weight for users
					$redis_response2 = $redis->get('twitch-desk-distribution-weight:'.$redis_response['desk_ID']);
					if($redis_response2 !== false)
					{
						$user_weight = $redis_response2;
					}
					else
					{
						// Default weight
						$user_weight = 10;
					}
					$case_distribution_enabled_user[$redis_response['desk_ID']] = array('username' => $redis_response['username'], 'weight' => $user_weight);
				}
				unset($redis_response, $redis_response2);
			}

			return $case_distribution_enabled_user;
		}
		else
		{
			return array();
		}
	}
	else
	{
		return array();
	}
}

function get_redis_distribution_current_user_weight()
{
	if($GLOBALS['use_redis'] === true && $GLOBALS['offer_case_distribution'] === true && isset($_SESSION['case_distribution_enabled']) && $_SESSION['case_distribution_enabled'] === true)
	{
		// Connect to redis
		$redis = get_redis_connection()['redis'];
		$redis_is_connected = get_redis_connection()['redis_is_connected'];

		if($redis_is_connected === true)
		{
			$redis_response = $redis->get('twitch-desk-distribution-weight:'.$_SESSION['user']['desk_ID']);
			if($redis_response !== false)
			{
				$current_user_weight = $redis_response;
			}
			else
			{
				// Nothing set so display default weight
				$current_user_weight = 10;
			}

			return $current_user_weight;
		}
		else
		{
			return '0';
		}
	}
	else
	{
		return '0';
	}
}

function set_redis_distribution_current_user_weight($weight = 10)
{
	if($GLOBALS['use_redis'] === true && $GLOBALS['offer_case_distribution'] === true && isset($_SESSION['case_distribution_enabled']) && $_SESSION['case_distribution_enabled'] === true)
	{
		// Connect to redis
		$redis = get_redis_connection()['redis'];
		$redis_is_connected = get_redis_connection()['redis_is_connected'];

		if($redis_is_connected === true)
		{
			$redis->set('twitch-desk-distribution-weight:'.$_SESSION['user']['desk_ID'], $weight);
		}
	}
}

function renew_redis_key_for_case_distribution_user()
{
	if($GLOBALS['use_redis'] === true && $GLOBALS['offer_case_distribution'] === true)
	{
		// Connect to redis
		$redis = get_redis_connection()['redis'];
		$redis_is_connected = get_redis_connection()['redis_is_connected'];
		$redis_ttl = (10 * 60);

		if($redis_is_connected === true)
		{
			// Check if the key already exists
			$redis_response = $redis->get('twitch-desk-distribution:'.$_SESSION['user']['desk_ID']);
			// Reset TTL (or add it)
			$redis->setex('twitch-desk-distribution:'.$_SESSION['user']['desk_ID'], $redis_ttl, array('username' => $_SESSION['user']['username'], 'desk_ID' => $_SESSION['user']['desk_ID']));
			if($redis_response === false)
			{
				// Doesn't exist so we have to update the last modified time too
				update_redis_key_for_case_distribution_last_modified();
			}
		}
	}
}

function get_redis_distribution_last_modified()
{
	if($GLOBALS['use_redis'] === true && $GLOBALS['offer_case_distribution'] === true && isset($_SESSION['case_distribution_enabled']) && $_SESSION['case_distribution_enabled'] === true)
	{
		// Connect to redis
		$redis = get_redis_connection()['redis'];
		$redis_is_connected = get_redis_connection()['redis_is_connected'];

		if($redis_is_connected === true)
		{
			$redis_distribution_last_modified = 'null';
			$redis_response = $redis->get('twitch-desk-distribution-last-modified');
			if($redis_response !== false)
			{
				$redis_distribution_last_modified = $redis_response;
			}

			return $redis_distribution_last_modified;
		}
		else
		{
			return '0';
		}
	}
	else
	{
		return '0';
	}
}

function update_redis_key_for_case_distribution_last_modified()
{
	if($GLOBALS['use_redis'] === true && $GLOBALS['offer_case_distribution'] === true)
	{
		// Connect to redis
		$redis = get_redis_connection()['redis'];
		$redis_is_connected = get_redis_connection()['redis_is_connected'];

		if($redis_is_connected === true)
		{
			// Set last modified to current time()
			$redis->set('twitch-desk-distribution-last-modified', time());
		}
	}
}

function count_not_TOSd_autoresolves_by_subject()
{
	$counter = 0;
	foreach($_SESSION['auto_resolve_by_subject_array'] as $subject => $resolve_until)
	{
		if(!isset($_SESSION['already_TOSd_array'][$subject]))
		{
			$counter = $counter + 1;
		}
	}
	return $counter;
}

function add_whisper_stats($target_channel, $reporter, $timestamp)
{
	if($GLOBALS['use_redis'] === true && $GLOBALS['enable_whisper_report_stats'] === true)
	{
		$unix_timestamp = strtotime($timestamp);
		if($unix_timestamp !== false &&  $unix_timestamp > (time() - (24 * 60 * 60)))
		{
			$expire_ttl = $unix_timestamp + (24 * 60 * 60) - time(); // Report time + 24h - current time = seconds until the 24h are over from now
			$redis = get_redis_connection()['redis'];
			$redis_is_connected = get_redis_connection()['redis_is_connected'];

			if($redis_is_connected === true)
			{
				// Stats for how often a user has gotten reported
				$result = $redis->set('twitch-desk-whispers-to:'.$target_channel.':'.$reporter, '1', array('nx', 'ex' => $expire_ttl));
				if($result !== true)
				{
					// This combo already exists
					$redis_ttl = $redis->ttl('twitch-desk-whispers-to:'.$target_channel.':'.$reporter);
					if($redis_ttl > 0 && $redis_ttl < $expire_ttl)
					{
						// Update TTL
						$redis->setTimeout('twitch-desk-whispers-to:'.$target_channel.':'.$reporter, $expire_ttl);
					}
				}

				// Stats for how often a user has reported someone
				$result = $redis->set('twitch-desk-whispers-from:'.$reporter.':'.$target_channel, '1', array('nx', 'ex' => $expire_ttl));
				if($result !== true)
				{
					// This combo already exists
					$redis_ttl = $redis->ttl('twitch-desk-whispers-from:'.$reporter.':'.$target_channel);
					if($redis_ttl > 0 && $redis_ttl < $expire_ttl)
					{
						// Update TTL
						$redis->setTimeout('twitch-desk-whispers-from:'.$reporter.':'.$target_channel, $expire_ttl);
					}
				}
			}
		}
		else
		{
			// Whisper report is older than 24 hours so not worth for our stats
		}
	}
}

function get_whisper_stats_for_target($target_channel)
{
	static $redis_response_cache = array();
	if($GLOBALS['use_redis'] === true && $GLOBALS['enable_whisper_report_stats'] === true)
	{
		$redis = get_redis_connection()['redis'];
		$redis_is_connected = get_redis_connection()['redis_is_connected'];

		if($redis_is_connected === true)
		{
			// Check for cached response
			if(isset($redis_response_cache[$target_channel]))
			{
				return $redis_response_cache[$target_channel];
			}
			else
			{
				// Check redis
				// Stats for how often a user has gotten reported
				$redis_keys = $redis->keys('twitch-desk-whispers-to:'.$target_channel.':*');
				if($redis_keys !== false && count($redis_keys) > 0)
				{
					$redis_response_cache[$target_channel] = count($redis_keys);
				}
				else
				{
					$redis_response_cache[$target_channel] = 0;
				}
				return $redis_response_cache[$target_channel];
			}
		}
	}
}

function get_whisper_stats_for_reporter($reporter)
{
	static $redis_response_cache = array();
	if($GLOBALS['use_redis'] === true && $GLOBALS['enable_whisper_report_stats'] === true)
	{
		$redis = get_redis_connection()['redis'];
		$redis_is_connected = get_redis_connection()['redis_is_connected'];

		if($redis_is_connected === true)
		{
			// Check for cached response
			if(isset($redis_response_cache[$reporter]))
			{
				return $redis_response_cache[$reporter];
			}
			else
			{
				// Check redis
				// Stats for how often a user has reported someone
				$redis_keys = $redis->keys('twitch-desk-whispers-from:'.$reporter.':*');
				if($redis_keys !== false && count($redis_keys) > 0)
				{
					$redis_response_cache[$reporter] = count($redis_keys);
				}
				else
				{
					$redis_response_cache[$reporter] = 0;
				}
				return $redis_response_cache[$reporter];
			}
		}
	}
}

function time_to_pst_time($time)
{
	$dateTime = new DateTime(date('c', strtotime($time)), new DateTimeZone(date_default_timezone_get()));
	$dateTime->setTimezone(new DateTimeZone('America/Los_Angeles'));

	$return = $dateTime->format('Y-m-d H:i:s T');
	return $return;
}

function gen_csrf_token($length = 32)
{
	if(function_exists('random_bytes'))
	{
		return substr(bin2hex(random_bytes($length)), 0, $length);
	}

	if(function_exists('mcrypt_create_iv'))
	{
		return substr(bin2hex(mcrypt_create_iv($length, MCRYPT_DEV_URANDOM)), 0, $length);
	}

    if(function_exists('openssl_random_pseudo_bytes'))
	{
		return substr(bin2hex(openssl_random_pseudo_bytes($length)), 0, $length);
	}
}

function validate_csrf_token($token)
{
	$return = false;
	$log_array = array('timestamp' => date('c'), 'username' => $_SESSION['user']['username']);
	$debug_backtrace = debug_backtrace();
	if(!isset($_SESSION['csrf_token']) || empty($_SESSION['csrf_token']))
	{
		$log_array['reason'] = 'Empty session token';
		$log_array['session_token'] = '';
		$log_array['function_token'] = $token;
		$log_array['backtrace']['file'] = $debug_backtrace[0]['file'];
		$log_array['backtrace']['line'] = $debug_backtrace[0]['line'];
		$return = false;
	}
	elseif(!isset($token) || empty($token))
	{
		$log_array['reason'] = 'Empty function token';
		$log_array['session_token'] = $_SESSION['csrf_token'];
		$log_array['function_token'] = $token;
		$log_array['backtrace']['file'] = $debug_backtrace[0]['file'];
		$log_array['backtrace']['line'] = $debug_backtrace[0]['line'];
		$return = false;
	}
	elseif($_SESSION['csrf_token'] != $token)
	{
		$log_array['reason'] = 'Tokens do not match';
		$log_array['session_token'] = $_SESSION['csrf_token'];
		$log_array['function_token'] = $token;
		$log_array['backtrace']['file'] = $debug_backtrace[0]['file'];
		$log_array['backtrace']['line'] = $debug_backtrace[0]['line'];
		$return = false;
	}
	elseif($_SESSION['csrf_token'] == $token)
	{
		$return = true;
	}
	else
	{
		$log_array['reason'] = 'Unknown error';
		$log_array['session_token'] = $_SESSION['csrf_token'];
		$log_array['function_token'] = $token;
		$log_array['backtrace']['file'] = $debug_backtrace[0]['file'];
		$log_array['backtrace']['line'] = $debug_backtrace[0]['line'];
		$return = false;
	}

	if($return === false)
	{
		// Log the error into a file
		file_put_contents(__DIR__ . '/csrf_token_error.log', json_encode($log_array).PHP_EOL, FILE_APPEND | LOCK_EX);
	}

	return $return;
}

function random_case($string) {
	$rand = mt_rand(0, 1);
	$return = '';
	$string_len = mb_strlen($string);
	for($i = 0; $i < $string_len; $i++) {
		if($i % 2 == $rand) {
			$return .= mb_strtolower(mb_substr($string, $i, 1));
		} else {
			$return .= mb_strtoupper(mb_substr($string, $i, 1));
		}
	}

	return $return;
}

function get_mysql_connection() {
	static $mysqli = null;
	if($mysqli === null)
	{
		$mysqli = @new mysqli('betterdesk-mysql.cunim1xnmwzu.us-west-1.rds.amazonaws.com', 'twitch_betterdesk_sessions', '3mH6TKBpezim4F7u', 'twitch_betterdesk_sessions');
		if($mysqli->connect_errno)
		{
			$mysqli = false;
			return false;
		}
	}
	return $mysqli;
}

function log_session_stats_to_db() {
	if(isset($_SESSION['session_stats']) && isset($_SESSION['session_stats']['sessionID']))
	{
		$mysqli = get_mysql_connection();
		if($mysqli !== false)
		{
			$mysqli->query("INSERT INTO `session_stats` (`sessionID`, `admin_deskID`, `admin_username`, `unique_cases`, `report_cases`, `whisper_cases`, `channel_feed_cases`, `clip_cases`, `other_cases`, `autoresolve_by_channel`, `autoresolve_by_reporter`, `autoresolve_own_strike`, `autoresolve_by_age`, `resolved_cases`, `banned_cases`, `pm_checked_cases`, `session_start_time`, `session_end_time`) VALUES
			('".$mysqli->real_escape_string($_SESSION['session_stats']['sessionID'])."',
			'".$mysqli->real_escape_string($_SESSION['user']['desk_ID'])."',
			'".$mysqli->real_escape_string($_SESSION['user']['username'])."',
			'".$mysqli->real_escape_string((count($_SESSION['session_stats']['cases_overall']) - count($_SESSION['session_stats']['duplicate_cases'])))."',
			'".$mysqli->real_escape_string((count($_SESSION['session_stats']['report_cases']) - count($_SESSION['session_stats']['duplicate_cases'])))."',
			'".$mysqli->real_escape_string(count($_SESSION['session_stats']['whisper_cases']))."',
			'".$mysqli->real_escape_string(count($_SESSION['session_stats']['channel_feed_cases']))."',
			'".$mysqli->real_escape_string(count($_SESSION['session_stats']['clip_cases']))."',
			'".$mysqli->real_escape_string((count($_SESSION['session_stats']['cases_overall']) - (count($_SESSION['session_stats']['report_cases']) + count($_SESSION['session_stats']['whisper_cases']) + count($_SESSION['session_stats']['channel_feed_cases']) + count($_SESSION['session_stats']['clip_cases']))))."',
			'".$mysqli->real_escape_string(count($_SESSION['session_stats']['auto_resolved_subject_cases']))."',
			'".$mysqli->real_escape_string(count($_SESSION['session_stats']['auto_resolved_reporter_cases']))."',
			'".$mysqli->real_escape_string(count($_SESSION['session_stats']['auto_resolved_own_tos_cases']))."',
			'".$mysqli->real_escape_string(count($_SESSION['session_stats']['auto_resolved_by_age_cases']))."',
			'".$mysqli->real_escape_string(count($_SESSION['session_stats']['resolved_cases']))."',
			'".$mysqli->real_escape_string(count($_SESSION['session_stats']['TOSd_cases']))."',
			'".$mysqli->real_escape_string(count($_SESSION['session_stats']['staff_assigned_pm_check_cases']))."',
			FROM_UNIXTIME(".$mysqli->real_escape_string($_SESSION['session_stats']['session_start_time'])."),
			FROM_UNIXTIME(".$mysqli->real_escape_string($_SESSION['session_stats']['session_end_time'])."))
			ON DUPLICATE KEY UPDATE `admin_deskID`=VALUES(`admin_deskID`),`admin_username`=VALUES(`admin_username`),`unique_cases`=VALUES(`unique_cases`),`report_cases`=VALUES(`report_cases`),`whisper_cases`=VALUES(`whisper_cases`),
			`channel_feed_cases`=VALUES(`channel_feed_cases`),`clip_cases`=VALUES(`clip_cases`),`other_cases`=VALUES(`other_cases`),`autoresolve_by_channel`=VALUES(`autoresolve_by_channel`),`autoresolve_by_reporter`=VALUES(`autoresolve_by_reporter`),`autoresolve_own_strike`=VALUES(`autoresolve_own_strike`),
			`autoresolve_by_age`=VALUES(`autoresolve_by_age`),`resolved_cases`=VALUES(`resolved_cases`),`banned_cases`=VALUES(`banned_cases`),`pm_checked_cases`=VALUES(`pm_checked_cases`),`session_start_time`=VALUES(`session_start_time`),
			`session_end_time`=VALUES(`session_end_time`)");
		}
	}
}
