<?php
// äüö - UTF8 FTW
// Only allow including of this file
if(preg_match('/clips_overview\.php/i', $_SERVER['PHP_SELF']) === 1)
{
	exit();
}

if(isset($_GET['iframe']) && $_GET['iframe'] == 'true')
{
	$clips_array = array();
	$timespan = 10 * 60; // in seconds (before and after the GET timestamp)
	// Check if a channel has been submitted
	if(!isset($_GET['channel']) || empty($_GET['channel']))
	{
		echo 'No channel submitted.';
		exit();
	}

	// Check if we have a timestamp
	if(!isset($_GET['timestamp']) || empty($_GET['timestamp']) || !is_numeric($_GET['timestamp']))
	{
		echo 'No timestamp submitted.';
		exit();
	}
	$_GET['timestamp'] = intval($_GET['timestamp']);


	// Make API request till we have what we need
	curl_reset($global_curl);
	curl_setopt($global_curl, CURLOPT_TIMEOUT, 10);
	curl_setopt($global_curl, CURLOPT_CONNECTTIMEOUT, 5);
	curl_setopt($global_curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
	curl_setopt($global_curl, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($global_curl, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/json'));
	curl_setopt($global_curl, CURLOPT_ENCODING, '');
	curl_setopt($global_curl, CURLOPT_FOLLOWLOCATION, false);
	curl_setopt($global_curl, CURLOPT_AUTOREFERER, false);
	curl_setopt($global_curl, CURLOPT_USERAGENT, 'Better Desk by commanderroot@twitch.tv');
	// SSL stuff
	curl_setopt($global_curl, CURLOPT_SSL_VERIFYPEER, true);
	curl_setopt($global_curl, CURLOPT_SSL_VERIFYHOST, 2);
	curl_setopt($global_curl, CURLOPT_CAINFO, __DIR__.'/cacert.pem');
	curl_setopt($global_curl, CURLOPT_CAPATH, __DIR__);
	curl_setopt($global_curl, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);

	$found_end = false;
	$org_request_url = 'https://clips.twitch.tv/api/v1/channels/'.rawurlencode(strtolower(trim($_GET['channel']))).'?limit=1000';
	$request_url = $org_request_url.'&_='.time();
	while($found_end === false)
	{
		curl_setopt($global_curl, CURLOPT_URL, $request_url);

		$curl_output = curl_exec($global_curl);
		$curl_info = curl_getinfo($global_curl);
		if($curl_output === false)
		{
			echo 'Error getting info from the API'.PHP_EOL;
			exit();
		}
		elseif($curl_info['http_code'] == 200)
		{
			// Request was successful
			$json_decode = json_decode($curl_output, true);
			if($json_decode !== null)
			{
				if($json_decode['clips'] == null || count($json_decode['clips']) == 0)
				{
					$found_end = true;
				}
				else
				{
					foreach($json_decode['clips'] as $clip)
					{
						if(strtotime($clip['created_at']) >= ($_GET['timestamp'] + $timespan))
						{
							// The clip is newer than we need
							continue;
						}
						elseif(strtotime($clip['created_at']) <= ($_GET['timestamp'] - $timespan))
						{
							// The clip is older than we need
							$found_end = true;
							continue;
						}
						else
						{
							$clips_array[] = $clip;
							continue;
						}
					}

					if(isset($json_decode['cursor']) && !empty($json_decode['cursor']))
					{
						$request_url = $org_request_url.'&cursor='.rawurlencode($json_decode['cursor']).'&_='.time();
					}
					else
					{
						$found_end = true;
					}
				}
			}
			else
			{
				echo 'Json error in API response'.PHP_EOL;
				exit();
			}
		}
		else
		{
			echo 'API error ('.$curl_info['http_code'].')'.PHP_EOL;
			exit();
		}
	}

	if(count($clips_array) > 0)
	{
		?><!DOCTYPE HTML>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<?php
	if(isset($_COOKIE['dark_mode']) && $_COOKIE['dark_mode'] == 'on')
	{
		echo PHP_EOL.'<link href="css/darkmode.css" rel="stylesheet">'.PHP_EOL;
		echo '<style>a { color: #337ab7; text-decoration: none; background-color: transparent; }</style>'.PHP_EOL;
	}
	?>
	<script type="text/javascript" src="js/jquery.min.js"></script>
	<script type="text/javascript">
	<!--
	"use strict";
	function check_clip_status(broadcaster, emote_string) {
		$.ajax({
			url: "url_resolver.php?js_head_check=true&url=" + encodeURIComponent("https://clips.twitch.tv/embed?clip=" + broadcaster + "/" + emote_string + "&_=" + Math.floor(Date.now() / 1000)),
			type: "HEAD",
			cache: false,
			success: function(result, textStatus, jqXHR) {
				$("#clip_status_" + emote_string).html('<span style="color:#000000; background-color:#009900">OK</span>');
			},
			error: function(jqXHR, textStatus, errorThrown) {
				if(jqXHR.status == 404) {
					$("#clip_status_" + emote_string).html('<span style="color:#000000; background-color:#ff0000">Disabled</span>');
				} else {
					$("#clip_status_" + emote_string).text('Unknown error');
				}
			}
		});
	}

	$(document).ready(function () {
		$(".clip_status").each(function(i, e){
			check_clip_status($(e).data("channel"), e.id.split("_")[2]);
		});
	});
	-->
	</script>
</head>
<body>
<div class="well">
	<table border="1">
		<thead>
			<tr>
				<th style="max-width:160px;width:160px;text-align:center;">Clip creator</th>
				<th style="max-width:420px;width:420px;text-align:center;">Clip-URL</th>
				<th style="max-width:200px;width:200px;text-align:center;">Created at</th>
				<th style="max-width:60px;width:60px;text-align:center;">Status</th>
			</tr>
		</thead>
		<tbody>
		<?php
		foreach($clips_array as $clip)
		{
			echo '<tr>';
			echo '<td><a href="https://www-origin.twitch.tv/'.rawurlencode($clip['curator_login']).'" target="_blank" rel="noreferrer">'.htmlspecialchars($clip['curator_login'], ENT_QUOTES|ENT_HTML5).'</a></td>';
			echo '<td><a href="'.$clip['clip_url'].'" target="_blank" rel="noreferrer">'.htmlspecialchars($clip['clip_url'], ENT_QUOTES|ENT_HTML5).'</a></td>';
			echo '<td style="max-width:230px;width:230px;text-align:right;">'.htmlspecialchars(time_to_pst_time($clip['created_at']), ENT_QUOTES|ENT_HTML5).'</td>';
			$emote_url_string_explode = explode('/', $clip['clip_url']);
			echo '<td style="text-align:center;" class="clip_status" id="clip_status_'.rawurlencode($emote_url_string_explode[count($emote_url_string_explode) - 1]).'" data-channel="'.rawurlencode($emote_url_string_explode[count($emote_url_string_explode) - 2]).'"></td>';
			echo '</tr>'.PHP_EOL;
		}
		?>
	</tbody>
	</table>
</div>
</body>
</html>
<?php
	}
	else
	{
		echo 'No clips found for this user at this timestamp.';
		exit();
	}
}
elseif(isset($_GET['iframe2']) && $_GET['iframe2'] == 'true')
{
	$clips_array = array();
	$timestamp = null;
	$timespan = 10 * 60; // in seconds (before and after the GET timestamp)
	// Check if a channel has been submitted
	if(!isset($_GET['channel']) || empty($_GET['channel']))
	{
		echo 'No channel submitted.';
		exit();
	}

	// Check if we have a timestamp
	if(!isset($_GET['emote_string']) || empty($_GET['emote_string']))
	{
		echo 'No emote_string submitted.';
		exit();
	}


	// Make API request till we have what we need
	curl_reset($global_curl);
	curl_setopt($global_curl, CURLOPT_TIMEOUT, 10);
	curl_setopt($global_curl, CURLOPT_CONNECTTIMEOUT, 5);
	curl_setopt($global_curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
	curl_setopt($global_curl, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($global_curl, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/json'));
	curl_setopt($global_curl, CURLOPT_ENCODING, '');
	curl_setopt($global_curl, CURLOPT_FOLLOWLOCATION, false);
	curl_setopt($global_curl, CURLOPT_AUTOREFERER, false);
	curl_setopt($global_curl, CURLOPT_USERAGENT, 'Better Desk by commanderroot@twitch.tv');
	// SSL stuff
	curl_setopt($global_curl, CURLOPT_SSL_VERIFYPEER, true);
	curl_setopt($global_curl, CURLOPT_SSL_VERIFYHOST, 2);
	curl_setopt($global_curl, CURLOPT_CAINFO, __DIR__.'/cacert.pem');
	curl_setopt($global_curl, CURLOPT_CAPATH, __DIR__);
	curl_setopt($global_curl, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);

	$found_end = false;
	$org_request_url = 'https://clips.twitch.tv/api/v1/channels/'.rawurlencode(strtolower(trim($_GET['channel']))).'?limit=1000';
	$request_url = $org_request_url.'&_='.time();
	while($found_end === false)
	{
		curl_setopt($global_curl, CURLOPT_URL, $request_url);

		$curl_output = curl_exec($global_curl);
		$curl_info = curl_getinfo($global_curl);
		if($curl_output === false)
		{
			echo 'Error getting info from the API'.PHP_EOL;
			exit();
		}
		elseif($curl_info['http_code'] == 200)
		{
			// Request was successful
			$json_decode = json_decode($curl_output, true);
			if($json_decode !== null)
			{
				if($json_decode['clips'] == null || count($json_decode['clips']) == 0)
				{
					$found_end = true;
				}
				else
				{
					foreach($json_decode['clips'] as $clip)
					{
						if(strpos($clip['clip_url'], $_GET['emote_string']) !== false)
						{
							// Found the clip we want to base our timestamp on
							$timestamp = strtotime($clip['created_at']);
						}

						if(!empty($timestamp) && strtotime($clip['created_at']) >= ($timestamp + $timespan))
						{
							// The clip is newer than we need
							continue;
						}
						elseif(!empty($timestamp) && strtotime($clip['created_at']) <= ($timestamp - $timespan))
						{
							// The clip is older than we need
							$found_end = true;
							continue;
						}
						else
						{
							$clips_array[] = $clip;
							continue;
						}
					}

					if(isset($json_decode['cursor']) && !empty($json_decode['cursor']))
					{
						$request_url = $org_request_url.'&cursor='.rawurlencode($json_decode['cursor']).'&_='.time();
					}
					else
					{
						$found_end = true;
					}
				}
			}
			else
			{
				echo 'Json error in API response'.PHP_EOL;
				exit();
			}
		}
		else
		{
			echo 'API error ('.$curl_info['http_code'].')'.PHP_EOL;
			exit();
		}
	}


	// Filter our results
	if(empty($timestamp))
	{
		// We didn't find the start clip so we can't return anything
		$clips_array = array();
	}
	else
	{
		// Filter based on the $timestamp
		foreach($clips_array as $array_id => $clip)
		{
			if(strtotime($clip['created_at']) >= ($timestamp + $timespan))
			{
				// The clip is newer than we need
				unset($clips_array[$array_id]);
			}
			elseif(strtotime($clip['created_at']) <= ($timestamp - $timespan))
			{
				// The clip is older than we need
				unset($clips_array[$array_id]);
			}
		}
	}

	if(count($clips_array) > 0)
	{
		?><!DOCTYPE HTML>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<?php
	if(isset($_COOKIE['dark_mode']) && $_COOKIE['dark_mode'] == 'on')
	{
		echo PHP_EOL.'<link href="css/darkmode.css" rel="stylesheet">'.PHP_EOL;
		echo '<style>a { color: #337ab7; text-decoration: none; background-color: transparent; }</style>'.PHP_EOL;
	}
	?>
	<script type="text/javascript" src="js/jquery.min.js"></script>
	<script type="text/javascript">
	<!--
	"use strict";
	function check_clip_status(broadcaster, emote_string) {
		$.ajax({
			url: "url_resolver.php?js_head_check=true&url=" + encodeURIComponent("https://clips.twitch.tv/embed?clip=" + broadcaster + "/" + emote_string + "&_=" + Math.floor(Date.now() / 1000)),
			type: "HEAD",
			cache: false,
			success: function(result, textStatus, jqXHR) {
				$("#clip_status_" + emote_string).html('<span style="color:#000000; background-color:#009900">OK</span>');
			},
			error: function(jqXHR, textStatus, errorThrown) {
				if(jqXHR.status == 404) {
					$("#clip_status_" + emote_string).html('<span style="color:#000000; background-color:#ff0000">Disabled</span>');
				} else {
					$("#clip_status_" + emote_string).text('Unknown error');
				}
			}
		});
	}

	$(document).ready(function () {
		$(".clip_status").each(function(i, e){
			check_clip_status($(e).data("channel"), e.id.split("_")[2]);
		});
	});
	-->
	</script>
</head>
<body>
<div class="well">
	<table border="1">
		<thead>
			<tr>
				<th style="max-width:160px;width:160px;text-align:center;">Clip creator</th>
				<th style="max-width:420px;width:420px;text-align:center;">Clip-URL</th>
				<th style="max-width:200px;width:200px;text-align:center;">Created at</th>
				<th style="max-width:60px;width:60px;text-align:center;">Status</th>
			</tr>
		</thead>
		<tbody>
		<?php
		foreach($clips_array as $clip)
		{
			echo '<tr>';
			echo '<td><a href="https://www-origin.twitch.tv/'.rawurlencode($clip['curator_login']).'" target="_blank" rel="noreferrer">'.htmlspecialchars($clip['curator_login'], ENT_QUOTES|ENT_HTML5).'</a></td>';
			if(strpos($clip['clip_url'], $_GET['emote_string']) !== false)
			{
				// Mark the initial one so the admin knows where to go from
				echo '<td style="background-color:#009900">';
			}
			else
			{
				echo '<td>';
			}
			echo '<a href="'.$clip['clip_url'].'" target="_blank" rel="noreferrer">'.htmlspecialchars($clip['clip_url'], ENT_QUOTES|ENT_HTML5).'</a></td>';
			echo '<td style="max-width:230px;width:230px;text-align:right;">'.htmlspecialchars(time_to_pst_time($clip['created_at']), ENT_QUOTES|ENT_HTML5).'</td>';
			$emote_url_string_explode = explode('/', $clip['clip_url']);
			echo '<td style="text-align:center;" class="clip_status" id="clip_status_'.rawurlencode($emote_url_string_explode[count($emote_url_string_explode) - 1]).'" data-channel="'.rawurlencode($emote_url_string_explode[count($emote_url_string_explode) - 2]).'"></td>';
			echo '</tr>'.PHP_EOL;
		}
		?>
	</tbody>
	</table>
</div>
</body>
</html>
<?php
	}
	else
	{
		echo 'No clips found for this user at this timestamp.';
		exit();
	}
}
else
{
?><!DOCTYPE HTML>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<title>Clips overview</title>
	<?php
	if(isset($_COOKIE['dark_mode']) && $_COOKIE['dark_mode'] == 'on')
	{
		echo PHP_EOL.'<link href="css/darkmode.css" rel="stylesheet">'.PHP_EOL;
		echo '<style>a { color: #337ab7; text-decoration: none; background-color: transparent; }</style>'.PHP_EOL;
	}
	?>
	<script type="text/javascript" src="js/jquery.min.js"></script>
	<script type="text/javascript">
	<!--
	"use strict";
	function check_clip_status(broadcaster, emote_string) {
		$.ajax({
			url: "url_resolver.php?js_head_check=true&url=" + encodeURIComponent("https://clips.twitch.tv/embed?clip=" + broadcaster + "/" + emote_string + "&_=" + Math.floor(Date.now() / 1000)),
			type: "HEAD",
			cache: false,
			success: function(result, textStatus, jqXHR) {
				$("#clip_status_" + emote_string).html('<span style="color:#000000; background-color:#009900">OK</span>');
			},
			error: function(jqXHR, textStatus, errorThrown) {
				if(jqXHR.status == 404) {
					$("#clip_status_" + emote_string).html('<span style="color:#000000; background-color:#ff0000">Disabled</span>');
				} else {
					$("#clip_status_" + emote_string).text('Unknown error');
				}
			}
		});
	}

	$(document).ready(function () {
		$(".clip_status").each(function(i, e){
			check_clip_status($(e).data("channel"), e.id.split("_")[2]);
		});
	});
	-->
	</script>
</head>
<body>
<div class="well">
<form id="clips_overview_form" action="" method="GET">
<input type="hidden" name="clips_overview" value="true">
<input type="text" name="channel" value="<?php if(isset($_GET['channel']) && !empty(trim($_GET['channel']))) echo rawurlencode(strtolower(trim($_GET['channel']))); ?>" size="25" maxlength="250" placeholder="Channel">
<button type="Submit">Check clip history</button>
</form>
<br>
<table border="1">
<thead>
	<tr>
		<th style="max-width:160px;width:160px;text-align:left;">Broadcaster</th>
		<th style="max-width:160px;width:160px;text-align:center;">Clip creator</th>
		<th style="max-width:420px;width:420px;text-align:center;">Clip-URL</th>
		<th style="max-width:200px;width:200px;text-align:center;">Created at</th>
		<th style="max-width:60px;width:60px;text-align:center;">Status</th>
	</tr>
</thead>
<tbody>
<?php
if(isset($_GET['channel']) && !empty(trim($_GET['channel'])))
{
	// Get the clip history from the API
	curl_reset($global_curl);
	curl_setopt($global_curl, CURLOPT_TIMEOUT, 10);
	curl_setopt($global_curl, CURLOPT_CONNECTTIMEOUT, 5);
	curl_setopt($global_curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
	curl_setopt($global_curl, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($global_curl, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/json'));
	curl_setopt($global_curl, CURLOPT_ENCODING, '');
	curl_setopt($global_curl, CURLOPT_FOLLOWLOCATION, false);
	curl_setopt($global_curl, CURLOPT_AUTOREFERER, false);
	curl_setopt($global_curl, CURLOPT_USERAGENT, 'Better Desk by commanderroot@twitch.tv');
	// SSL stuff
	curl_setopt($global_curl, CURLOPT_SSL_VERIFYPEER, true);
	curl_setopt($global_curl, CURLOPT_SSL_VERIFYHOST, 2);
	curl_setopt($global_curl, CURLOPT_CAINFO, __DIR__.'/cacert.pem');
	curl_setopt($global_curl, CURLOPT_CAPATH, __DIR__);
	curl_setopt($global_curl, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);


	$request_url = 'https://clips.twitch.tv/api/v1/channels/'.rawurlencode(strtolower(trim($_GET['channel']))).'?limit=250&_='.time();
	if(isset($_GET['cursor']) && !empty($_GET['cursor']))
	{
		$request_url .= '&cursor='.rawurlencode($_GET['cursor']);
	}
	curl_setopt($global_curl, CURLOPT_URL, $request_url);

	$curl_output = curl_exec($global_curl);
	$curl_info = curl_getinfo($global_curl);
	if($curl_output === false)
	{
		echo 'Error getting info from the API'.PHP_EOL;
	}
	elseif($curl_info['http_code'] == 200)
	{
		// Request was successful
		$json_decode = json_decode($curl_output, true);
		if($json_decode !== null)
		{
			foreach($json_decode['clips'] as $clip)
			{
				echo '<tr>';
				echo '<td><a href="https://www-origin.twitch.tv/'.rawurlencode($clip['broadcaster_login']).'" target="_blank" rel="noreferrer">'.htmlspecialchars($clip['broadcaster_login'], ENT_QUOTES|ENT_HTML5).'</a></td>';
				echo '<td><a href="https://www-origin.twitch.tv/'.rawurlencode($clip['curator_login']).'" target="_blank" rel="noreferrer">'.htmlspecialchars($clip['curator_login'], ENT_QUOTES|ENT_HTML5).'</a></td>';
				echo '<td><a href="'.$clip['clip_url'].'" target="_blank" rel="noreferrer">'.htmlspecialchars($clip['clip_url'], ENT_QUOTES|ENT_HTML5).'</a></td>';
				echo '<td style="max-width:230px;width:230px;text-align:right;">'.htmlspecialchars(time_to_pst_time($clip['created_at']), ENT_QUOTES|ENT_HTML5).'</td>';
				$emote_url_string_explode = explode('/', $clip['clip_url']);
				echo '<td style="text-align:center;" class="clip_status" id="clip_status_'.rawurlencode($emote_url_string_explode[count($emote_url_string_explode) - 1]).'" data-channel="'.rawurlencode($emote_url_string_explode[count($emote_url_string_explode) - 2]).'"></td>';
				echo '</tr>'.PHP_EOL;
			}
		}
		else
		{
			echo 'Json error in API response'.PHP_EOL;
		}
	}
	else
	{
		echo 'API error ('.$curl_info['http_code'].')'.PHP_EOL;
	}
}
?>
</tbody>
</table>
<?php
if(isset($json_decode) && isset($json_decode['cursor']) && !empty($json_decode['cursor']))
{
	echo '<br><a href="/index.php?clips_overview=true&channel='.rawurlencode(strtolower(trim($_GET['channel']))).'&cursor='.rawurlencode($json_decode['cursor']).'">Next Page</a><br><br>';
}
?>
<br>
</body>
</html>
<?php
}
