"use strict";
// äüö UTF8 - FTW

function check_jquery_status()
{
	if (window.jQuery) {
		// jQuery is loaded
		console.log("jQuery is loaded");
		check_if_partner();
		remove_default_options();
	} else {
		// jQuery is not loaded
		console.log("jQuery is NOT loaded");
		setTimeout(function () { check_jquery_status(); }, 50);
	}
}


function check_if_partner()
{
	var username = window.location.pathname.split("/")[1];
	if(window.location.host.match(/^.*\.twitch\.tv$/i) !== null && username !== undefined)
	{
		display_user_check();
		$.getJSON("https://api.twitch.tv/kraken/channels/" + username + "?client_id=m5xvoc1c72mnurm5wi5lmrvz7xnjz0d&callback=?", function() {})
			.done(function(json) {
				console.log(json);
				if(json.partner === true)
				{
					user_type = 'partner';
				}
				else if(json.partner === false)
				{
					user_type = 'non-partner';
				}
				else if(json.status == 422 && json.message.indexOf(" is unavailable") != -1)
				{
					user_type = 'banned';
				}
				else if(json.status == 422 && json.message.indexOf(" is not available on Twitch") != -1)
				{
					user_type = 'jtv';
				}
				update_user_type();
			})
			.fail(function(jqXHR, textStatus, error) {
				var err = jqXHR.status + ", " + textStatus + ", " + error;
				console.log( "Request Failed: " + err );
				user_type = 'API_error';
				update_user_type();
			});
	}
	else if(window.location.host.match(/^twitch\-desk\.rootonline\.de$/i) !== null)
	{
		// On Better Desk so it's a partnerconduct, display it always
		remove_user_check_display();
		add_stuff_to_report_form();
	}
}

function update_user_type()
{
	if(user_type == 'partner')
	{
		$("#user_type_check").html('<br><br><br>This user is a <b>Partner</b>! If you want to Strike anyway then <a href="javascript:remove_user_check_display();add_stuff_to_report_form();">click here</a>.<br><br>If you want to report the user to partnerconduct instead <a href="https://leviathan.moderation.twitch.tv/reports/partnerconduct_report?reported_user=' + window.location.pathname.split('/')[1] + '&' + window.location.search.substring(1) + '">click here</a>.');
	}
	else if(user_type == 'non-partner')
	{
		// Just display the form as usual
		remove_user_check_display();
		add_stuff_to_report_form();
	}
	else if(user_type == 'banned')
	{
		$("#user_type_check").html('<br><br><br>This user is already <b>banned</b>! If you want to Strike anyway then <a href="javascript:remove_user_check_display();add_stuff_to_report_form();">click here</a>.');
	}
	else if(user_type == 'jtv')
	{
		$("#user_type_check").html('<br><br><br>This user is a <b>JTV</b> account! If you want to Strike anyway then <a href="javascript:remove_user_check_display();add_stuff_to_report_form();">click here</a>.');
	}
	else if(user_type == 'API_error')
	{
		$("#user_type_check").html('<br><br><br>There wasn an <b>API error</b>! Please <a href="javascript:window.location.reload();">click here</a> to refresh the page to try again. Or <a href="javascript:remove_user_check_display();add_stuff_to_report_form();">click here</a> to Strike anyway.');
	}
	else
	{
		// Shouldn't happen so give out unknown error
		$("#user_type_check").html('<br><br><br>There wasn an <b>unknown error</b>! Please <a href="javascript:window.location.reload();">click here</a> to refresh the page to try again. Or <a href="javascript:remove_user_check_display();add_stuff_to_report_form();">click here</a> to Strike anyway.');
	}
}

function display_user_check()
{
	$("#report_form").append('<div id="user_type_check"><br><br><br>Checking the user type / status ... please stand by.</div>');
}

function remove_user_check_display()
{
	$("#user_type_check").remove();
}

function gen_description_header(content, detailed_reason, ip_ban, permanent_ban, clear_images)
{
	var reason_header = "";
	reason_header = reason_header + "Content: " + content + "\n";
	reason_header = reason_header + "Detailed Reason: " + detailed_reason + "\n";
	reason_header = reason_header + "IP Block: ";
	if(ip_ban === true)
	{
		reason_header = reason_header + "true\n";
	}
	else if(ip_ban === false)
	{
		reason_header = reason_header + "false\n";
	}
	reason_header = reason_header + "Suspension: ";
	if(permanent_ban === true)
	{
		reason_header = reason_header + "indefinite\n";
	}
	else if(permanent_ban === false)
	{
		reason_header = reason_header + "temporary\n";
	}
	reason_header = reason_header + "Cleared Images: ";
	if(clear_images === true)
	{
		reason_header = reason_header + "true\n";
	}
	else if(clear_images === false)
	{
		reason_header = reason_header + "false\n";
	}
	reason_header = reason_header + "----------------------------------------\n\n";

	// Return the reason header text
	return reason_header;
}

function check_for_chatlogs_in_description()
{
	if($("#description").val().match(/\b201[5-9]\-[01][0-9]\-[0123][0-9]\b\s\b[01][0-9]:[0-5][0-9]:[0-5][0-9]\b\s\b[AP]M\b/i) === null && // <-- Normal chat logs
		$("#description").val().match(/\(#[a-z0-9_]+\) [a-z0-9_]+: /i) === null) // <-- George's live feed
	{
		// No chatlogs found
	}
	else
	{
		// Remove the chatlogs placeholder
		$("#description").val($("#description").val().replace("ᐸCHATLOG_COPY_PASTAᐳ", ""));
	}
}

function check_for_whisperlogs_in_description()
{
	if($("#description").val().match(/\b201[5-9]\-[01][0-9]\-[0123][0-9] [012][0-9]:[0-5][0-9]:[0-5][0-9] [a-z]+\t[a-z0-9_]+\t/i) === null) // <-- Whisper logs
	{
		// No whisperlogs found
	}
	else
	{
		// Remove the whisperlogs placeholder
		$("#description").val($("#description").val().replace("ᐸWHISPERLOG_COPY_PASTAᐳ", ""));
	}
}

function check_for_screenshot_in_description()
{
	if($("#description").val().match(/https:\/\/s3\.amazonaws\.com\/uploads\.hipchat.com\/51098\/[0-9]+\/.*\/.*\.[a-z]{3}/i) === null && // <-- Hipchat file upload
		$("#description").val().match(/https:\/\/slack\-files\.com\/files\-pub\/.*\/.*\.[a-z]{3}/i) === null && // <-- Slack file upload
		$("#description").val().match(/https:\/\/s3\-us\-west\-1\.amazonaws\.com\/ttv\-moderation\/screenshots\/[a-z0-9]{16}\/.*\-\-.*\.[a-z]{3,4}/i) === null && // <-- Twitch S3 bucket
		$("#description").val().match(/https:\/\/leviathan\.moderation\.twitch\.tv\/file\-uploads\/[a-z0-9]{16}\/.*--.*\.[a-z]{3,4}/i) === null) // <-- Leviathan
	{
		// No screenshots found
	}
	else
	{
		// Remove the screenshot placeholder
		$("#description").val($("#description").val().replace("ᐸSCREENSHOT_LINKᐳ", ""));
	}
}

function check_for_ORIG_REPORT_CASEID_in_description()
{
	// Check if "Original Report ID: 132" exists
	if($("#description").val().match(/Original Report ID: [0-9]+/) !== null)
	{
		var original_reportID = $("#description").val().match(/Original Report ID: ([0-9]+)/);
		console.log("Found case ID: " + original_reportID[1]);
		// Remove this line
		$("#description").val($("#description").val().replace(/Original Report ID: [0-9]+[\r]?[\n]?/, ""));
		// Edit the placeholder
		$("#description").val($("#description").val().replace("ᐸORIG_REPORT_CASEIDᐳ", original_reportID[1]));
	}
	else
	{
		// Can't replace because the info is not available
	}
}

function remove_default_options()
{
	// Remove stuff so we can add it later -----------------------------------
	// Label for reason
	$("label[for=reason]").remove();
	// Reason
	$("#reason").remove();
	// Label for description
	$("label[for=description]").remove();
	// Description
	$("#description").remove();
	// Label for ip_ban
	$("label[for=ip_ban]").remove();
	// ip_ban
	$("#ip_ban").remove();
	// Label for permanent
	$("label[for=permanent]").remove();
	// permanent
	$("#permanent").remove();
	// Label for clear_images
	$("label[for=clear_images]").remove();
	// clear_images
	$("#clear_images").remove();
	// Label for delete_vod
	$("label[for=delete_vod]").remove();
	// delete_vod
	$("#delete_vod").remove();
	// Buttons
	$(".buttons").remove();
	// Remove X because it doesn't do anything
	$("#subwindow_close").remove();
	// Remove an un-used image
	$("#report_form_spinner").remove();
	// Remove empty div's
	$("div").each(function (i, e) {
			if($(e).html().trim() == "")
			{
				$(e).remove();
			}
		});
}

function add_stuff_to_report_form()
{
	// Add url parse function to jQuery
	$.extend({
		getUrlVars: function(){
			var vars = [], hash;
			var hashes = window.location.href.slice(window.location.href.indexOf("?") + 1).split("&");
			for(var i = 0; i < hashes.length; i++)
			{
				hash = hashes[i].split("=");
				vars.push(hash[0]);
				vars[hash[0]] = hash[1];
			}
			return vars;
		},
		getUrlVar: function(name){
			return $.getUrlVars()[name];
		}
	});

	String.prototype.insertAt=function(index, string) {
		return this.substr(0, index) + string + this.substr(index);
	}


	// Add placeholder replace selector div
	$("body").append('<div id="placeholder_replace_selector" style="position: absolute; visibility: hidden; z-index: 1000; top: -10000px; left: -10000px; background-image: none;"></div>');
	// Track mouse movement
	track_mouse_movement();

	// Add Quick select drop down
	add_quick_select_options();

	// Add hidden input for partnerconduct reports
	$("#report_form").append('<input id="detailed_reason_title" name="detailed_reason_title" type="hidden" value="" />');
	// Add content select
	$("#report_form").append('<div id="content_div"><label for="content">Select Content</label><div id="content_select"><select class="field" id="content" name="content" autocomplete="off"><option value="">Select one...</option>' + gen_content_selector() + '</select></div></div>');
	// OnChange for content selector
	$("#content").change(function() {
		console.log("Content: " + $(this).val());

		// First remove all possible existing reasons, detailed reasons, ... basically reset the form
		// Reason
		$("#reason_div").remove();
		// Detailed Reason
		$("#detailed_reason_div").remove();
		// Description
		$("#description_div").remove();
		// Suspend options (IP ban, Permanent, ...)
		$("#suspend_options_div").remove();
		// Send Button
		$("#send_button_div").remove();
		// Reset hidden detailed reason input
		$('input[name="detailed_reason_title"]').val("");

		// Now add the selector for the reasons of the selected content
		if($(this).val() != "")
		{
			add_reasons($(this).val());
		}
	});

	// Check if the content was set via an URL parameter
	if($.getUrlVar("content") !== undefined && typeof suspension_guide[$.getUrlVar("content")] != "undefined")
	{
		console.log("Trying to set content to: " + $.getUrlVar("content"));
		// Set new selected option
		$("select#content").val($.getUrlVar("content")).change();
	}

	// Check if there is a quick select option in the URL parameter
	if($.getUrlVar("quick-select") !== undefined && $.getUrlVar("quick-select").split("-").length == 3)
	{
		console.log("Trying to set quick-select to: " + $.getUrlVar("quick-select"));
		// Set new quick-select option
		$("select#quickselect").val($.getUrlVar("quick-select")).change();
	}
}

function add_quick_select_options()
{
	$("#report_form").append('<div id="quickselect_div" style="text-align:right">\
			<div id="quickselect_select">\
			<select class="field" id="quickselect" name="quickselect" autocomplete="off">\
			<option value="">Quick Select...</option>\
			<option value="general-offensive_username-inappropriate_username">[GENERAL] Offensive or inappropriate username</option>\
			<option value="channel_images-porn-sexual_suggestive_content">[CHANNEL IMAGES] Sexual suggestive content</option>\
			<option value="channel_text-spam-spam_bots">[CHANNEL TEXT] Spam bots</option>\
			<option value="chat-chat_ban_evasion-channel_chat_ban_evasion">[CHAT] Channel ban evasion (3 or more accounts)</option>\
			<option value="chat-harassment-repeat_harassment">[CHAT] Repeat chat harassment: In 2 or more different channels</option>\
			<option value="chat-spam-spam_bots">[CHAT] Spam bots</option>\
			<option value="panel-spam-rs_malicious_content">[PANEL] RuneScape phishing</option>\
			<option value="panel-spam-spam_bots">[PANEL] Spam bots</option>\
			<option value="live-cheating-pokemon_go_cheating">[LIVE] Pokemon GO cheating or GPS spoofing</option>\
			<option value="live-porn-sexual_content">[LIVE] Sexual content on stream, not a part of gameplay</option>\
			<option value="live-other-csgo_gambling_content">[LIVE] CS:GO gambling on stream</option>\
			<option value="live-nongaming-movies_and_tv_shows">[LIVE] Non-Gaming: (movies / anime / tv / sports / etc)</option>\
			<option value="live-music_conduct-music_category_violation_static_image">[LIVE] In the Music category: Music-only/radio streams with static image…</option>\
			<option value="live-other-non_gaming_talk_show">[LIVE] Prolonged non-gaming talk show content in gaming talk shows</option>\
			<option value="whisper-spam-spam_bots">[WHISPER] Spam bots</option>\
			</select>\
			</div></div>');

	// OnChange for quick select selector
	$("#quickselect").change(function() {
		console.log("Quick Select: " + $(this).val());

		// Select the content, reason and detailed reason based on the selected quick select
		if($(this).val() != null && $(this).val() != "")
		{
			var parts = $(this).val().split("-");
			if(parts.length == 3) // Sanity check so we are sure we have all
			{
				console.log("Quick Select parts: " + parts);

				// Select content
				if(typeof suspension_guide[parts[0]] != "undefined")
				{
					console.log("Trying to set content to: " + parts[0]);
					// Set new selected option
					$("select#content").val(parts[0]).change();
				}

				// Select reason
				if(typeof suspension_guide[parts[0]].reasons[parts[1]] != "undefined")
				{
					console.log("Trying to set reason to: " + parts[1]);
					// Set new selected option
					$("select#reason").val(parts[1]).change();
				}

				// Select detailed reason
				if(typeof suspension_guide[parts[0]].reasons[parts[1]].detailed_reasons[parts[2]] != "undefined")
				{
					console.log("Trying to set detailed reason to: " + parts[2]);
					// Set new selected option
					$("select#detailed_reason").val(parts[2]).change();
				}


				// Extra placeholder replacement reason
				if($(this).val() == "channel_images-porn-sexual_suggestive_content" &&
					$.getUrlVar("placeholder[LOCATION_OF_CONTENT]") !== undefined)
				{
					replace_placeholder_in_description("ᐸLOCATION_OF_CONTENTᐳ", decodeURIComponent($.getUrlVar("placeholder[LOCATION_OF_CONTENT]")));
				}
				else if($(this).val() == "channel_text-spam-spam_bots" &&
					$.getUrlVar("placeholder[LOCATION_OF_CONTENT]") !== undefined)
				{
					replace_placeholder_in_description("<title / bio>", decodeURIComponent($.getUrlVar("placeholder[LOCATION_OF_CONTENT]")));
					if($.getUrlVar("description") !== undefined)
					{
						// Remove the ᐸCONTENT_COPY_PASTAᐳ placeholder
						replace_placeholder_in_description("ᐸCONTENT_COPY_PASTAᐳ", "");
					}
				}
			}
		}
		else
		{
			// Use it as option to reset the form (aka clear it)
			$("select#content").val("").change();
		}
	});

}

function gen_content_selector()
{
	var return_string = "";
	$.each(suspension_guide, function (name, value) {
			return_string = return_string + '<option value="' + name + '">' + htmlEncode(value.description) + '</option>';
		});
	return return_string;
}

function add_reasons(content)
{
	var reason_string = "";
	$.each(suspension_guide[content].reasons, function (name, value) {
			reason_string = reason_string + '<option value="' + name + '">' + htmlEncode(value.description) + '</option>';
		});
	// Add the reasons to the page
	$("#report_form").append('<div id="reason_div"><label for="reason">Select Reason</label><div id="reason_select"><select class="field" id="reason" name="reason" autocomplete="off"><option value="">Select one...</option>' + reason_string + '</select></div></div>');

	// OnChange for reason selector
	$("#reason").change(function() {
		console.log("Reason: " + $(this).val());

		// First remove all possible existing detailed reasons, description ... basically reset the form until this part
		// Detailed Reason
		$("#detailed_reason_div").remove();
		// Description
		$("#description_div").remove();
		// Suspend options (IP ban, Permanent, ...)
		$("#suspend_options_div").remove();
		// Send Button
		$("#send_button_div").remove();
		// Reset hidden detailed reason input
		$('input[name="detailed_reason_title"]').val("");

		// Now add the selector for the reasons of the selected content
		if($(this).val() != "")
		{
			add_detailed_reasons(content, $(this).val());

			// Check if this reason has only 1 detailed reason under this content. If so select it
			select_detailed_reason_if_only_one(content, $(this).val());
		}
	});

	// Check if the reason was set via an URL parameter
	if($.getUrlVar("reason") !== undefined && typeof suspension_guide[content].reasons[$.getUrlVar("reason")] != "undefined")
	{
		console.log("Trying to set reason to: " + $.getUrlVar("reason"));
		// Set new selected option
		$("select#reason").val($.getUrlVar("reason")).change();

	}
}

function add_detailed_reasons(content, reason)
{
	var detailed_reason_string = "";
	$.each(suspension_guide[content].reasons[reason].detailed_reasons, function (name, value) {
			detailed_reason_string = detailed_reason_string + '<option value="' + name + '">' + htmlEncode(value.title) + '</option>';
		});
	// Add the detailed reasons to the page
	$("#report_form").append('<div id="detailed_reason_div"><label for="detailed_reason">Select Detailed Reason</label><div id="detailed_reason_select"><select class="field" id="detailed_reason" name="detailed_reason" autocomplete="off"><option value="">Select one...</option>' + detailed_reason_string + '</select></div></div>');

	// OnChange for reason selector
	$("#detailed_reason").change(function() {
		console.log("Detailed Reason: " + $(this).val());

		// First remove all possible existing detailed reasons, description ... basically reset the form until this part
		// Description
		$("#description_div").remove();
		// Suspend options (IP ban, Permanent, ...)
		$("#suspend_options_div").remove();
		// Send Button
		$("#send_button_div").remove();
		// Reset hidden detailed reason input
		$('input[name="detailed_reason_title"]').val("");

		// Add all the stuff again (this way it's reset)
		if($(this).val() != "")
		{
			// Set hidden detailed reason input
			$('input[name="detailed_reason_title"]').val(suspension_guide[content].reasons[reason].detailed_reasons[$(this).val()].title);
			// Description
			add_description(content, reason, $(this).val());
			// Add Placeholder selector on mouse up on description
			add_mouseup_selection_on_description(content, reason, $(this).val());
			// Suspension options
			add_suspension_options(content, reason, $(this).val());
			// Happened in Creative?
			if(content == "channel_text" || content == "live" || content == "vod")
			{
				add_happened_in_creative(content, reason, $(this).val());
			}
			// Add the "Send" button
			add_send_button();
			// Try to add the strike for note
			add_strike_form_note(content, reason, $(this).val());
		}
	});

	// Check if the detailed reason was set via an URL parameter
	if($.getUrlVar("detailed_reason") !== undefined && typeof suspension_guide[content].reasons[reason].detailed_reasons[$.getUrlVar("detailed_reason")] != "undefined")
	{
		console.log("Trying to set detailed reason to: " + $.getUrlVar("detailed_reason"));
		// Set new selected option
		$("select#detailed_reason").val($.getUrlVar("detailed_reason")).change();
	}
}

function add_strike_form_note(content, reason, detailed_reason)
{
	// Check if a strike note is present for this content => reason => detailed_reason
	if(typeof suspension_guide[content].reasons[reason].detailed_reasons[detailed_reason].strike_form_note != "undefined" && suspension_guide[content].reasons[reason].detailed_reasons[detailed_reason].strike_form_note.length > 0)
	{
		console.log("Setting strike_form_note: " + suspension_guide[content].reasons[reason].detailed_reasons[detailed_reason].strike_form_note);
		// Add the text to the send button div
		$("#send_button_div").append('<span id="strike_form_note"><b>Note:</b> ' + htmlEncode(suspension_guide[content].reasons[reason].detailed_reasons[detailed_reason].strike_form_note) + '</span>');
		// Move it a bit to the right, make it red
		$("#strike_form_note").css({"margin-left": "25px", "color": "red"});
	}
}

function add_description(content, reason, detailed_reason)
{
	// Add the description box
	$("#report_form").append('<div id="description_div"><label for="description">Description</label><div><textarea autocomplete="off" class="field textarea" id="description" name="description"></textarea></div></div>');
	// Make textarea bigger so you can actually read what's in it
	$("#description").css({"margin": "0px", "width": "500px", "height": "220px"});
	// Make description required client side too
	$("#description").attr("required", "required");
	// Fill it with the detailed reason template
	$("#description").val(gen_description_header(content,
			detailed_reason,
			suspension_guide[content].reasons[reason].detailed_reasons[detailed_reason].ip_ban,
			suspension_guide[content].reasons[reason].detailed_reasons[detailed_reason].permanent,
			suspension_guide[content].reasons[reason].detailed_reasons[detailed_reason].clear_images) + suspension_guide[content].reasons[reason].detailed_reasons[detailed_reason].report_details);

	// Check if the description was set via an URL parameter
	if($.getUrlVar("description") !== undefined)
	{
		// Add the description to the current header / rest of the current description content
		$("#description").val($("#description").val() + decodeURIComponent($.getUrlVar("description").replace(/\+/g, "%20")));

		// Try to find the placeholders and remove them if we have the data in the description
		check_for_ORIG_REPORT_CASEID_in_description();
		check_for_screenshot_in_description();
		check_for_chatlogs_in_description();
		check_for_whisperlogs_in_description();
	}
}

function add_suspension_options(content, reason, detailed_reason)
{
	// Add the suspension options
	$("#report_form").append('<div id="suspend_options_div"><div><input id="ip_ban" name="ip_ban" type="checkbox" value="true" /><label for="ip_ban" style="display: inline">Ban IP?</label></div><div><input id="permanent" name="permanent" type="checkbox" value="true" /><label for="permanent" style="display: inline">Permanent Ban?</label></div><div><input id="clear_images" name="clear_images" type="checkbox" value="true" /><label for="clear_images" style="display: inline">Clear Images?</label></div></div>');
	// Add delete_vod input on VOD reports with a vod_id
	if(content == "vod" && $.getUrlVar("vod_id") !== undefined && $.getUrlVar("vod_id").length > 2)
	{
		$("#suspend_options_div").append('<div><input id="delete_vod" name="delete_vod" type="hidden" value="true" /></div>');
	}
	// Set the buttons according to the selected detailed reason
	$("#ip_ban").prop("checked", suspension_guide[content].reasons[reason].detailed_reasons[detailed_reason].ip_ban);
	$("#permanent").prop("checked", suspension_guide[content].reasons[reason].detailed_reasons[detailed_reason].permanent);
	$("#clear_images").prop("checked", suspension_guide[content].reasons[reason].detailed_reasons[detailed_reason].clear_images);

	// Bind function to ip_ban button
	$("#ip_ban").click(function()
	{
		// Check if the description "header" exists and where it is
		var header_end_pos = $("#description").val().indexOf("----------------------------------------");
		// Check if the "ip_ban" header exists
		var ip_ban_header_pos = $("#description").val().indexOf("IP Block: ");
		if(header_end_pos != -1 && ip_ban_header_pos != -1 && ip_ban_header_pos < header_end_pos) /* Both exist and ip_ban is "above" the end of the header */
		{
			if($(this).is(":checked"))
			{
				if($("#description").val().indexOf("IP Block: false") == ip_ban_header_pos)
				{
					// Change it to true
					$("#description").val($("#description").val().replace("IP Block: false", "IP Block: true"));
				}
			}
			else
			{
				if($("#description").val().indexOf("IP Block: true") == ip_ban_header_pos)
				{
					// Change it to false
					$("#description").val($("#description").val().replace("IP Block: true", "IP Block: false"));
				}
			}
		}
	});

	// Bind function to permanent button
	$("#permanent").click(function()
	{
		// Check if the description "header" exists and where it is
		var header_end_pos = $("#description").val().indexOf("----------------------------------------");
		// Check if the "permanent" header exists
		var permanent_header_pos = $("#description").val().indexOf("Suspension: ");
		if(header_end_pos != -1 && permanent_header_pos != -1 && permanent_header_pos < header_end_pos) /* Both exist and permanent is "above" the end of the header */
		{
			if($(this).is(":checked"))
			{
				if($("#description").val().indexOf("Suspension: temporary") == permanent_header_pos)
				{
					// Change it to indefinite
					$("#description").val($("#description").val().replace("Suspension: temporary", "Suspension: indefinite"));
				}
			}
			else
			{
				if($("#description").val().indexOf("Suspension: indefinite") == permanent_header_pos)
				{
					// Change it to temporary
					$("#description").val($("#description").val().replace("Suspension: indefinite", "Suspension: temporary"));
				}
			}
		}
	});

	// Bind function to clear_images button
	$("#clear_images").click(function()
	{
		// Check if the description "header" exists and where it is
		var header_end_pos = $("#description").val().indexOf("----------------------------------------");
		// Check if the "clear_images" header exists
		var clear_images_header_pos = $("#description").val().indexOf("Cleared Images: ");
		if(header_end_pos != -1 && clear_images_header_pos != -1 && clear_images_header_pos < header_end_pos) /* Both exist and clear_images is "above" the end of the header */
		{
			if($(this).is(":checked"))
			{
				if($("#description").val().indexOf("Cleared Images: false") == clear_images_header_pos)
				{
					// Change it to true
					$("#description").val($("#description").val().replace("Cleared Images: false", "Cleared Images: true"));
				}
			}
			else
			{
				if($("#description").val().indexOf("Cleared Images: true") == clear_images_header_pos)
				{
					// Change it to false
					$("#description").val($("#description").val().replace("Cleared Images: true", "Cleared Images: false"));
				}
			}
		}
	});
}

function add_happened_in_creative(content, reason, detailed_reason)
{
	// Add creative? button
	$("#suspend_options_div").append('<div><input id="creative_directory" type="checkbox" /><label for="creative_directory" style="display: inline">Happened in Creative?</label></div>');

	// Bind function to creative button
	$("#creative_directory").click(function()
	{
		// Check if the description "header" exists and where it is
		var header_end_pos = $("#description").val().indexOf("----------------------------------------");
		// Check if the "creative_directory" header exists
		var creative_directory_header_pos = $("#description").val().indexOf("In Creative: true\n");
		if(header_end_pos != -1 && creative_directory_header_pos != -1 && creative_directory_header_pos < header_end_pos) /* Both exist and creative_directory is "above" the end of the header */
		{
			if($(this).is(":checked"))
			{
				// Already good how it is
				console.log('The "In Creative" header already exists so it is all good.');
			}
			else
			{
				// Remove the line
				$("#description").val($("#description").val().replace("In Creative: true\n", ""));
				console.log('Removed the "In Creative" header');
			}
		}
		else if(header_end_pos != -1 && (creative_directory_header_pos == -1 || creative_directory_header_pos > header_end_pos)) /* Header exists but either Creative header doesn't or is not in the header */
		{
			if($(this).is(":checked"))
			{
				// Add the creative header to the description header
				$("#description").val($("#description").val().insertAt($("#description").val().indexOf("----------------------------------------"), "In Creative: true\n"));
				console.log('Added the "In Creative" header');
			}
			else
			{
				console.log('This should not happen with the "In Creative" header');
			}
		}
	});

	// Check if we should check the creative_directory checkbox
	if(typeof suspension_guide[content].reasons[reason].detailed_reasons[detailed_reason].happened_in_creative != "undefined" && suspension_guide[content].reasons[reason].detailed_reasons[detailed_reason].happened_in_creative === true)
	{
		// Set to false but then click to make it true (this way the function above runs for sure)
		$("#creative_directory").prop("checked", false).click();
	}
}

function add_send_button()
{
	$("#report_form").append('<div id="send_button_div"><button class="primary button" id="report_form_submit" type="submit"><span>Send</span></button></div>');
	// Add margin-top to the send button so you don't accidentally click "Permanent Ban?" and then the button
	$("#send_button_div").css({"margin-top": "30px"});
	// Disable Send button on Submit and set the other stuff to read only
	$("form#report_form").submit(function() {
		$("#description").attr("readonly", "readonly");
		$("#report_form_submit").prop("disabled", true);
	});
}

function select_detailed_reason_if_only_one(content, reason)
{
	if(Object.keys(suspension_guide[content].reasons[reason].detailed_reasons).length == 1)
	{
		// No need to do each because it's the only one but still the easiest to get the first
		$.each(suspension_guide[content].reasons[reason].detailed_reasons, function (name, value) {
			console.log("This reason only has 1 detailed reason under this content: " + name);
			// Set new selected option
			$("select#detailed_reason").val(name).change();
		});
	}
}

function htmlEncode(value)
{
	// create a in-memory div, set it's inner text (which jQuery automatically encodes)
	// then grab the encoded contents back out. The div never exists on the page.
	return $("<div/>").text(value).html();
}

function htmlDecode(value)
{
	return $("<div/>").html(value).text();
}

function getTextSelectionFromDescription()
{
	var field = document.getElementById("description");
	if(field !== null)
	{
		var startPos = field.selectionStart;
		var endPos = field.selectionEnd;
		var selectedText = field.value.substring(startPos, endPos);
	}
	else
	{
		var selectedText = "";
	}
	return selectedText;
}

function add_mouseup_selection_on_description(content, reason, detailed_reason)
{
	$("#description").mouseup(function() {
		var selected_text = getTextSelectionFromDescription();
		console.log("Selected text: " + selected_text);

		// Only do something if it's empty, else make it empty (to avoid double showing filling)
		if($("#placeholder_replace_selector").html() == "")
		{
			if(add_placeholder_replace_selector_content(content, reason, detailed_reason, selected_text) === true)
			{
				show_placeholder_replace_selector_div();
			}
			else
			{
				hide_placeholder_replace_selector_div();
			}
		}
		else
		{
			hide_placeholder_replace_selector_div();
		}
	});
}

function add_placeholder_replace_selector_content(content, reason, detailed_reason, selected_text)
{
	if(content == "channel_images" && selected_text == "ᐸLOCATION_OF_CONTENTᐳ")
	{
		$("#placeholder_replace_selector").append([
			$("<div/>").append([
				$("<button/>", { "type": "button", onclick: "replace_placeholder_in_description('" + selected_text + "', 'profile image')" }).append("Profile Image")
			]),
			$("<div/>").append([
				$("<button/>", { "type": "button", onclick: "replace_placeholder_in_description('" + selected_text + "', 'profile banner')" }).append("Profile Banner")
			]),
			$("<div/>").append([
				$("<button/>", { "type": "button", onclick: "replace_placeholder_in_description('" + selected_text + "', 'offline image')" }).append("Offline Image")
			])
		]);
		return true;
	}
	else if(content == "live" && detailed_reason == "movies_and_tv_shows" && selected_text == "ᐸTYPE_OF_CONTENTᐳ ")
	{
		$("#placeholder_replace_selector").append([
			$("<div/>").append([
				$("<button/>", { "type": "button", onclick: "replace_placeholder_in_description('" + selected_text + "', 'tv show ')" }).append("TV Show")
			]),
			$("<div/>").append([
				$("<button/>", { "type": "button", onclick: "replace_placeholder_in_description('" + selected_text + "', 'movie ')" }).append("Movie")
			]),
			$("<div/>").append([
				$("<button/>", { "type": "button", onclick: "replace_placeholder_in_description('" + selected_text + "', 'anime ')" }).append("Anime")
			]),
			$("<div/>").append([
				$("<button/>", { "type": "button", onclick: "replace_placeholder_in_description('" + selected_text + "', 'live tv (soccer) ')" }).append("Soccer")
			]),
			$("<div/>").append([
				$("<button/>", { "type": "button", onclick: "replace_placeholder_in_description('" + selected_text + "', 'sports ')" }).append("Sports")
			])
		]);
		return true;
	}
	return false;
}

function track_mouse_movement()
{
	$(document).mousemove(function(event) {
		currentMousePos.x = event.pageX;
		currentMousePos.y = event.pageY;
	});
}

function show_placeholder_replace_selector_div()
{
	// Change position and visibility
	$("#placeholder_replace_selector").css({visibility: "visible", left: (currentMousePos.x + 20) + "px", top: (currentMousePos.y + 15) + "px"});
}

function hide_placeholder_replace_selector_div()
{
	// Clear the div
	$("#placeholder_replace_selector").empty();
	// Change position and visibility
	$("#placeholder_replace_selector").css({visibility: "hidden", top: "-10000px", left: "-10000px"});
}

function replace_placeholder_in_description(placeholder, replacement)
{
	$("#description").val($("#description").val().replace(placeholder, replacement));
	// Hide selector
	hide_placeholder_replace_selector_div();
}


// Variables
var currentMousePos = { x: -1, y: -1 };
var user_type;


// Suspension Guide as Object
var suspension_guide = {"general":{"reasons":{"bits_violation":{"detailed_reasons":{"soliciting_bits_fraud_money_laundering":{"title":"[BITS-PARTNER] soliciting bits for fraud or money laundering","report_details":"- Provide evidence","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"exchanging_bits_for_money":{"title":"[BITS-VIEWER] exchanging cheer\/bits for money, such a currency, bitcoins, or gift cards","report_details":"- Provide evidence\n- Type of money\/currency\n- Rate of exchange","ip_ban":true,"permanent":true,"clear_images":false},"soliciting_bits_for_money":{"title":"[BITS-PARTNER] soliciting cheer\/bits for money, such as currency, bitcoins, or gift cards","report_details":"- Provide evidence\n- Type of money\/currency\n- Rate of exchange","ip_ban":true,"permanent":true,"clear_images":false},"soliciting_bits_for_alcohol_tobacco":{"title":"[BITS-PARTNER] soliciting cheer\/bits in exchange for alcohol or tobacco","report_details":"- Provide evidence","ip_ban":true,"permanent":true,"clear_images":false},"soliciting_bits_for_goods_services":{"title":"[BITS-PARTNER] soliciting cheer\/bits for a direct, 1-to-1 exchange of goods or services","report_details":"- Provide evidence\n- Goods\/services being exchanged","ip_ban":false,"permanent":false,"clear_images":false},"soliciting_bits_facilitate_gambling_on_twitch":{"title":"[BITS-PARTNER] soliciting cheer\/bits to facilitate gambling, a bet, or a wager","report_details":"- Provide evidence","ip_ban":true,"permanent":true,"clear_images":false},"soliciting_money_for_bits":{"title":"[BITS-PARTNER] soliciting money, such as currency, bitcoins, or gift cards for cheer\/bits","report_details":"- Provide evidence\n- Type of money\/currency\n- Rate of exchange","ip_ban":true,"permanent":true,"clear_images":false},"soliciting_bits_for_sex_porn":{"title":"[BITS-PARTNER] soliciting cheer\/bits in exchange for sexual services or pornographic content","report_details":"- Provide evidence","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"soliciting_bits_for_drugs":{"title":"[BITS-PARTNER] soliciting cheer\/bits in exchange for drugs or other controlled substances","report_details":"- Provide evidence","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"soliciting_bits_for_contest_entry":{"title":"[BITS-PARTNER] soliciting cheer\/bits in exchange for entry to a contest, competition, or raffle","report_details":"- Provide evidence","ip_ban":false,"permanent":false,"clear_images":false},"soliciting_bits_for_digital_goods":{"title":"[BITS-PARTNER] soliciting cheer\/bits in exchange for digital goods, such as games, videos, music, art, applications, etc...","report_details":"- Provide evidence\n- Specify the digital goods being exchanged","ip_ban":false,"permanent":false,"clear_images":false},"soliciting_bits_for_ingame_items":{"title":"[BITS-PARTNER] soliciting cheer\/bits in exchange for in-game items","report_details":"- Provide evidence\n- Specify the in-game items being exchanged","ip_ban":false,"permanent":false,"clear_images":false},"soliciting_bits_for_twitch_interaction":{"title":"[BITS-PARTNER] soliciting cheer\/bits in exchange for following, friending, or other interaction on Twitch","report_details":"- Provide evidence\n- Specify the action on Twitch being exchanged","ip_ban":false,"permanent":false,"clear_images":false},"soliciting_bits_for_other_interaction":{"title":"[BITS-PARTNER] soliciting cheer\/bits in exchange for following, friending, or other interaction on other social media, services, or platforms","report_details":"- Provide evidence\n- Specify the action being exchanged","ip_ban":false,"permanent":false,"clear_images":false},"soliciting_bits_for_private_messages_groups":{"title":"[BITS-PARTNER] soliciting cheer\/bits in exchange for access to private messages, conversations, or groups","report_details":"- Provide evidence","ip_ban":false,"permanent":false,"clear_images":false},"soliciting_bits_for_game_server_group":{"title":"[BITS-PARTNER] soliciting cheer\/bits in exchange for access to game server, match, session, lobby, or group","report_details":"- Provide evidence","ip_ban":false,"permanent":false,"clear_images":false},"soliciting_bits_for_coaching_training":{"title":"[BITS-PARTNER] soliciting cheer\/bits in exchange for coaching, training, or teaching sessions\/lessons","report_details":"- Provide evidence","ip_ban":false,"permanent":false,"clear_images":false},"soliciting_bits_for_shots":{"title":"[BITS-PARTNER] soliciting cheer\/bits for drinks or shots of alcohol","report_details":"- Provide evidence","ip_ban":false,"permanent":false,"clear_images":false},"soliciting_bits_for_dares_challenges":{"title":"[BITS-PARTNER] soliciting cheer\/bits for dares or challenges","report_details":"- Provide evidence","ip_ban":false,"permanent":false,"clear_images":false},"soliciting_bits_for_non_endemic_content":{"title":"[BITS-PARTNER] soliciting cheer\/bits to broadcast movies, sports, shows, music videos, or other non-endemic content","report_details":"- Provide evidence","ip_ban":false,"permanent":false,"clear_images":false},"soliciting_bits_raising_money":{"title":"[BITS-PARTNER] soliciting cheer\/bits to raise money, for any purpose","report_details":"- Provide evidence","ip_ban":false,"permanent":false,"clear_images":false},"soliciting_bits_raising_gamble":{"title":"[BITS-PARTNER] soliciting cheer\/bits to raise money for a gamble, bet, or wager","report_details":"- Provide evidence","ip_ban":true,"permanent":true,"clear_images":false},"soliciting_bits_raising_sex_porn":{"title":"[BITS-PARTNER] soliciting cheer\/bits to raise money for sexual services or pornographic content","report_details":"- Provide evidence","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"soliciting_bits_raising_drugs":{"title":"[BITS-PARTNER] soliciting cheer\/bits to raise money for drugs or other controlled substances","report_details":"- Provide evidence","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"soliciting_bits_raising_broadcasting":{"title":"[BITS-PARTNER] soliciting cheer\/bits to raise money for broadcasting equipment or furniture","report_details":"- Provide evidence","ip_ban":false,"permanent":false,"clear_images":false},"soliciting_bits_raising_games":{"title":"[BITS-PARTNER] soliciting cheer\/bits to raise money for games","report_details":"- Provide evidence","ip_ban":false,"permanent":false,"clear_images":false},"soliciting_bits_raising_food_drink":{"title":"[BITS-PARTNER] soliciting cheer\/bits to raise money for food, drinks, or snacks","report_details":"- Provide evidence","ip_ban":false,"permanent":false,"clear_images":false},"soliciting_bits_raising_events":{"title":"[BITS-PARTNER] soliciting cheer\/bits to raise money for events, trips, or vacations","report_details":"- Provide evidence","ip_ban":false,"permanent":false,"clear_images":false},"soliciting_bits_raising_necessities":{"title":"[BITS-PARTNER] soliciting cheer\/bits to raise money for rent, utilities, groceries, or other necessities","report_details":"- Provide evidence","ip_ban":false,"permanent":false,"clear_images":false},"soliciting_bits_raising_healthcare":{"title":"[BITS-PARTNER] soliciting cheer\/bits to raise money for health care, such as tests, surgeries, or prescriptions","report_details":"- Provide evidence","ip_ban":false,"permanent":false,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"soliciting_bits_raising_debt":{"title":"[BITS-PARTNER] soliciting cheer\/bits to raise money to pay off debt","report_details":"- Provide evidence","ip_ban":true,"permanent":true,"clear_images":false},"soliciting_bits_raising_alcohol_tobacco":{"title":"[BITS-PARTNER] soliciting cheer\/bits to raise money for alcohol or tobacco","report_details":"- Provide evidence","ip_ban":false,"permanent":false,"clear_images":false},"soliciting_bits_raising_contest_entry":{"title":"[BITS-PARTNER] soliciting cheer\/bits to raise money for a contest, competition, or raffle","report_details":"- Provide evidence","ip_ban":false,"permanent":false,"clear_images":false},"referring_to_bits_as_donations_tips":{"title":"[BITS-PARTNER] referring to cheering\/bits as donations, tips, or money","report_details":"- Provide evidence","ip_ban":false,"permanent":false,"clear_images":false},"giving_bits_fraud_money_laundering":{"title":"[BITS-VIEWER] giving bits for fraud or money laundering","report_details":"- Provide evidence","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"giving_bits_facilitate_gambling_on_twitch":{"title":"[BITS-VIEWER] giving cheer\/bits to facilitate gambling, a bet, or a wager","report_details":"- Provide evidence","ip_ban":true,"permanent":true,"clear_images":false},"giving_bits_for_money":{"title":"[BITS-VIEWER] giving cheer\/bits for money, such as currency, bitcoins, or gift cards","report_details":"- Provide evidence\n- Type of money\/currency\n- Rate of exchange","ip_ban":true,"permanent":true,"clear_images":false},"giving_money_for_bits":{"title":"[BITS-VIEWER] giving money, such as currency, bitcoins, or gift cards for cheer\/bits","report_details":"- Provide evidence\n- Type of money\/currency\n- Rate of exchange","ip_ban":true,"permanent":true,"clear_images":false},"giving_bits_for_sex_porn":{"title":"[BITS-VIEWER] giving cheer\/bits in exchange for sexual services or pornographic content","report_details":"- Provide evidence","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"giving_bits_for_drugs":{"title":"[BITS-VIEWER] giving cheer\/bits in exchange for drugs or other controlled substances","report_details":"- Provide evidence","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"giving_bits_for_shots":{"title":"[BITS-VIEWER] giving cheer\/bits for drinks or shots of alcohol","report_details":"- Provide evidence","ip_ban":false,"permanent":false,"clear_images":false},"giving_bits_for_dares_challenges":{"title":"[BITS-VIEWER] giving cheer\/bits for dares or challenges","report_details":"- Provide evidence","ip_ban":false,"permanent":false,"clear_images":false},"giving_bits_raising_gamble":{"title":"[BITS-VIEWER] giving cheer\/bits to raise money for a gamble, bet, or wager","report_details":"- Provide evidence","ip_ban":true,"permanent":true,"clear_images":false},"giving_bits_raising_sex_porn":{"title":"[BITS-VIEWER] giving cheer\/bits to raise money for sexual services or pornographic content","report_details":"- Provide evidence","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"giving_bits_raising_drugs":{"title":"[BITS-VIEWER] giving cheer\/bits to raise money for drugs or other controlled substances","report_details":"- Provide evidence","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"giving_bits_raising_debt":{"title":"[BITS-VIEWER] giving cheer\/bits to raise money to pay off debt","report_details":"- Provide evidence","ip_ban":true,"permanent":true,"clear_images":false}},"description":"Bits Acceptable Use Policy Violation"},"impersonation":{"detailed_reasons":{"staff_impersonation_via_username":{"title":"[GENERAL] Impersonating staff via username","report_details":"impersonating Twitch \u1438staff\/admin\/global mod\/other\u1433 via username","ip_ban":false,"permanent":true,"clear_images":false}},"description":"Impersonation"},"offensive_username":{"detailed_reasons":{"inappropriate_username":{"title":"[GENERAL] Offensive or inappropriate username","report_details":"inappropriate username","ip_ban":false,"permanent":true,"clear_images":false},"inappropriate_username_non_english":{"title":"[GENERAL] Offensive or inappropriate username (non-english)","report_details":"inappropriate username, \u1438TRANSLATION\u1433","ip_ban":false,"permanent":true,"clear_images":false},"harassment_via_username":{"title":"[GENERAL] Harassment via username","report_details":"harassment via username","ip_ban":false,"permanent":true,"clear_images":false},"harassment_via_username_non_english":{"title":"[GENERAL] Harassment via username (non-english)","report_details":"harassment via username, \u1438TRANSLATION\u1433","ip_ban":false,"permanent":true,"clear_images":false}},"description":"Offensive Username"},"other":{"detailed_reasons":{"sold_account":{"title":"[GENERAL] Confirmed sold, shared, or given-away account","report_details":"\u1438sold\/shared\/given-away\u1433 account","ip_ban":false,"permanent":true,"clear_images":false}},"description":"Other Terms of Service Violation"},"tos_ban_evasion":{"detailed_reasons":{"tos_strike_ban_evasion":{"title":"[GENERAL] Site-wide: striked channel evading strike","report_details":"site strike evasion\n\n\u1438CHAT LOG AND\/OR ALT LOOKUP PROOF\u1433","ip_ban":true,"permanent":true,"clear_images":false},"tos_perma_ban_evasion":{"title":"[GENERAL] Site-wide: permabanned channel evading permaban","report_details":"site ban evasion\n\n\u1438CHAT LOG AND\/OR ALT LOOKUP PROOF\u1433","ip_ban":true,"permanent":true,"clear_images":false}},"description":"Site Suspension Evasion"},"spam":{"detailed_reasons":{"false_reporting":{"title":"[GENERAL] User sending a mass (20+) of fake reports","report_details":"spaming false reports","ip_ban":true,"permanent":false,"clear_images":false}},"description":"Spam, Scams, or Other Malicious Content"}},"description":"General \/ Other"},"channel_images":{"reasons":{"harm":{"detailed_reasons":{"serious_violent_threats":{"title":"[CHANNEL IMAGES] Serious violent threats against another person","report_details":"serious violent threats via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"ddos_threats":{"title":"[CHANNEL IMAGES] DDOS threats","report_details":"ddos threats via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":true},"swatting_threats":{"title":"[CHANNEL IMAGES] SWAT threats","report_details":"swatting threats via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":true},"releasing_private_information":{"title":"[CHANNEL IMAGES] Releasing Personally Identifying Information","report_details":"releasing private information via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":true},"hacking_threats":{"title":"[CHANNEL IMAGES] Hacking threats","report_details":"hacking threats via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":true}},"description":"Attempts or Threats to Harm"},"cheating":{"detailed_reasons":{"lol_elo_boosting_advertisement":{"title":"[CHANNEL IMAGES] LoL Elo boosting: Advertising paid elo boosting (playing on an account that isn\u2019t yours)","report_details":"\u1438selling \/ advertising\u1433 LoL Elo boosting via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":true},"advertising_lol_refferal_services":{"title":"[CHANNEL IMAGES] Advertising paid LoL referral services","report_details":"advertising LoL referral services via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":true},"csgo_rank_boosting_advertisement":{"title":"[CHANNEL IMAGES] CS:GO rank boosting: Advertising CS:GO rank boosting (playing on an account that isn\u2019t yours)","report_details":"\u1438selling \/ advertising\u1433 CS:GO boosting via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":true},"pokemon_go_cheating_advertisement":{"title":"[CHANNEL IMAGES] Pokemon GO cheating or GPS spoofing promotion","report_details":"Pokemon GO advertisement via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":true}},"description":"Cheating in Online Game"},"gore":{"detailed_reasons":{"gore_media":{"title":"[CHANNEL IMAGES] Gore, bodily fluids, or excessive blood on channel","report_details":"\u1438gore \/ bodily fluids \/ excessive blood\u1433, \u1438DETAILS\u1433 via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":true}},"description":"Gore or Other Obscene Content"},"harassment":{"detailed_reasons":{"instigate_false_reports":{"title":"[CHANNEL IMAGES] Asking others to fake report another user","report_details":"instigate false reporting via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":true},"stream_sniping_to_harass":{"title":"[CHANNEL IMAGES] Admitting or showcasing stream sniping of another broadcaster with the intent to harass","report_details":"stream sniping with the intent to harass via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":true}},"description":"Harassment"},"hate_speech":{"detailed_reasons":{"racist_symbols":{"title":"[CHANNEL IMAGES] Swastika (or any other racist symbols)","report_details":"racist symbols (\u1438DETAILS\u1433) via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":true}},"description":"Hate Speech"},"impersonation":{"detailed_reasons":{"staff_impersonation":{"title":"[CHANNEL IMAGES] Impersonating staff in other ways","report_details":"staff impersonation via \u1438LOCATION_OF_CONTENT\u1433, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":true},"impersonation_another_user_via_username":{"title":"[CHANNEL IMAGES] Impersonating another person via username","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via username, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":true},"impersonation_another_user":{"title":"[CHANNEL IMAGES] Impersonating another person in other ways","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via \u1438LOCATION_OF_CONTENT\u1433, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":true},"impersonation_a_company_via_username":{"title":"[CHANNEL IMAGES] Impersonating or falsely representing a company\/organization via username","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via username, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":true},"impersonation_a_company":{"title":"[CHANNEL IMAGES] Impersonating or falsely representing a company\/organization in other ways","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via \u1438LOCATION_OF_CONTENT\u1433, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":true}},"description":"Impersonation"},"other":{"detailed_reasons":{"terrorist_propaganda":{"title":"[CHANNEL IMAGES] Terrorist propaganda and\/or recruitment","report_details":"terrorist \u1438propaganda \/ recruitment\u1433 via \u1438LOCATION_OF_CONTENT\u1433, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":true},"child_porn":{"title":"[CHANNEL IMAGES] Child porn","report_details":"child porn via \u1438LOCATION_OF_CONTENT\u1433\n\nNO LOGS \/ NO SCREENSHOT","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"beastiality":{"title":"[CHANNEL IMAGES] Bestiality","report_details":"beastiality porn via \u1438LOCATION_OF_CONTENT\u1433\n\nNO LOGS \/ NO SCREENSHOT","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"male_without_shirt":{"title":"[CHANNEL IMAGES] Male without shirt, and flaunting it or being lewd","report_details":"male top nude and \u1438flaunting \/ lewd\u1433 via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":true},"piracy":{"title":"[CHANNEL IMAGES] Piracy: Torrenting movies, games, etc...","report_details":"piracy, torrenting \u1438DETAILS\u1433 via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":true},"viewbotting_admission":{"title":"[CHANNEL IMAGES] Viewerbotting: If the user admits\/shows it","report_details":"viewbotting admission via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":true},"viewbotting_advertisement":{"title":"[CHANNEL IMAGES] Viewerbotting: If it\u2019s a viewbot advertisement","report_details":"viewbot advertising via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":true},"selling_twitch_services":{"title":"[CHANNEL IMAGES] Selling of Twitch services","report_details":"selling twitch services \u1438DETAILS\u1433 via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":true},"real_money_raffle":{"title":"[CHANNEL IMAGES] Pay to enter contest or sweepstakes (raffle \/ giveaway)","report_details":"real money \u1438raffle \/ giveaway\u1433 via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":true},"rs_gambling":{"title":"[CHANNEL IMAGES] Runescape gambling: Bigboibets and other third party sites integrating gambling with the game","report_details":"rs gambling via \u1438LOCATION_OF_CONTENT\u1433, \u1438SITE_NAME\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":true},"betting_on_sports":{"title":"[CHANNEL IMAGES] Betting on sports matches","report_details":"betting on \u1438DETAILS_OF_ACTION\u1433 via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":true}},"description":"Other Terms of Service Violation"},"porn":{"detailed_reasons":{"sexual_content":{"title":"[CHANNEL IMAGES] Sexual content","report_details":"sexual content via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":true},"sexual_suggestive_content":{"title":"[CHANNEL IMAGES] Sexual suggestive content","report_details":"sexual suggestive content via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":true}},"description":"Porn or Other Sexually Explicit Content"},"selfharm":{"detailed_reasons":{"threats_of_suicide":{"title":"[CHANNEL IMAGES] Threats of suicide","report_details":"suicide threats via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":true},"self_harm":{"title":"[CHANNEL IMAGES] Self harm","report_details":"self harm via \u1438LOCATION_OF_CONTENT\u1433, \u1438DETAILS_OF_ACTION\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":true},"threats_of_self_harm":{"title":"[CHANNEL IMAGES] Threats of self harm","report_details":"threatening with self harm via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":true}},"description":"Self-Harm"},"spam":{"detailed_reasons":{"malicious_content":{"title":"[CHANNEL IMAGES] Phishing or distributing viruses","report_details":"malicious content via \u1438LOCATION_OF_CONTENT\u1433, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":true},"distributing_ip_grabber":{"title":"[CHANNEL IMAGES] Distributing IP grabber links","report_details":"distributing IP grabber links via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":true},"fraud":{"title":"[CHANNEL IMAGES] Fraud","report_details":"fraud via \u1438LOCATION_OF_CONTENT\u1433, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":true},"fake_giveaway":{"title":"[CHANNEL IMAGES] Confirmed fake giveaway w\/ evidence","report_details":"fake giveway via \u1438LOCATION_OF_CONTENT\u1433, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":true},"rs_malicious_content":{"title":"[CHANNEL IMAGES] RuneScape phishing","report_details":"malicious content via \u1438LOCATION_OF_CONTENT\u1433, runescape phishing\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":true},"rs_doubling_money_scam":{"title":"[CHANNEL IMAGES] Runescape doubling money scam","report_details":"rs doubling money scam via \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":true}},"description":"Spam, Scams, or Other Malicious Content"},"underaged":{"detailed_reasons":{"underaged":{"title":"[CHANNEL IMAGES] Underaged","report_details":"underage via \u1438LOCATION_OF_CONTENT\u1433, \u1438AGE\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":true}},"description":"Underaged (person under the age of 13)"}},"description":"Channel Images"},"channel_text":{"reasons":{"harm":{"detailed_reasons":{"serious_violent_threats":{"title":"[CHANNEL TEXT] Serious violent threats against another person","report_details":"serious violent threats via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"ddos_threats":{"title":"[CHANNEL TEXT] DDOS threats","report_details":"ddos threats via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"swatting_threats":{"title":"[CHANNEL TEXT] SWAT threats","report_details":"swatting threats via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"releasing_private_information":{"title":"[CHANNEL TEXT] Posting Personally Identifying Information","report_details":"releasing private information via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"hacking_threats":{"title":"[CHANNEL TEXT] Hacking threats","report_details":"hacking threats via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false}},"description":"Attempts or Threats to Harm"},"cheating":{"detailed_reasons":{"lol_elo_boosting_advertisement":{"title":"[CHANNEL TEXT] LoL Elo boosting: Advertising paid elo boosting (playing on an account that isn\u2019t yours)","report_details":"\u1438selling \/ advertising\u1433 LoL Elo boosting via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"advertising_lol_refferal_services":{"title":"[CHANNEL TEXT] Advertising paid LoL referral services","report_details":"advertising LoL referral services via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"csgo_rank_boosting_advertisement":{"title":"[CHANNEL TEXT] CS:GO rank boosting: Advertising CS:GO rank boosting (playing on an account that isn\u2019t yours)","report_details":"\u1438selling \/ advertising\u1433 CS:GO boosting via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"pokemon_go_cheating_advertisement":{"title":"[CHANNEL TEXT] Pokemon GO cheating or GPS spoofing promotion","report_details":"Pokemon GO advertisement via <title \/ bio>\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Cheating in Online Game"},"gore":{"detailed_reasons":{"gore_media":{"title":"[CHANNEL TEXT] Gore, bodily fluids, or excessive blood","report_details":"\u1438gore \/ bodily fluids \/ excessive blood\u1433, \u1438DETAILS\u1433 via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false}},"description":"Gore or Other Obscene Content"},"harassment":{"detailed_reasons":{"broadcaster_raiding_without_permission":{"title":"[CHANNEL TEXT] Broadcaster raiding other channels with viewers without permission (if the raided channel complains)","report_details":"raiding \u1438CHANNEL\u1433 without permission via \u1438title \/ bio\u1433, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"instigate_false_reports":{"title":"[CHANNEL TEXT] Asking others to fake report another user","report_details":"instigate false reporting via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"distributing_screamer":{"title":"[CHANNEL TEXT] Posting \u201cscreamer\u201d or linking it","report_details":"screamer via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"harassment_broadcast_title":{"title":"[CHANNEL TEXT] Harassing others","report_details":"harassment of others via \u1438title \/ bio\u1433 \u1438with avoiding word filter \/ \u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"stream_sniping_to_harass":{"title":"[CHANNEL TEXT] Admitting or showcasing stream sniping of another broadcaster with the intent to harass","report_details":"stream sniping with the intent to harass via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Harassment"},"hate_speech":{"detailed_reasons":{"racist_symbols":{"title":"[CHANNEL TEXT] Swastika (or any other racist symbols)","report_details":"racist symbols (\u1438DETAILS\u1433) via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"hate_speech_broadcast_title":{"title":"[CHANNEL TEXT] Using hate speech or terroristic words","report_details":"hate speech \u1438with avoiding word filter \/ \u1433 via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Hate Speech"},"impersonation":{"detailed_reasons":{"staff_impersonation":{"title":"[CHANNEL TEXT] Impersonating staff in other ways","report_details":"staff impersonation via \u1438title \/ bio\u1433, \u1438DETAILS\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"impersonation_another_user_via_username":{"title":"[CHANNEL TEXT] Impersonating another person via username","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via username, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false},"impersonation_another_user":{"title":"[CHANNEL TEXT] Impersonating another person in other ways","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via \u1438title \/ bio\u1433, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"impersonation_a_company_via_username":{"title":"[CHANNEL TEXT] Impersonating or falsely representing a company\/organization via username","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via username, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false},"impersonation_a_company":{"title":"[CHANNEL TEXT] Impersonating or falsely representing a company\/organization in other ways","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via \u1438title \/ bio\u1433, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false}},"description":"Impersonation"},"other":{"detailed_reasons":{"terrorist_propaganda":{"title":"[CHANNEL TEXT] Terrorist propaganda and\/or recruitment","report_details":"terrorist \u1438propaganda \/ recruitment\u1433 via \u1438title \/ bio\u1433, \u1438DETAILS\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"intentional_wrong_trending_category":{"title":"[CHANNEL TEXT] Intentionally streaming under the wrong category (miscategorization): Trending categories: (Music, Game Dev, Poker, Talk Shows, Creative, Twitch Plays)","report_details":"intentional miscategorization via \u1438title \/ bio\u1433, \u1438DETAILS\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"child_porn":{"title":"[CHANNEL TEXT] Child porn","report_details":"child porn via \u1438title \/ bio\u1433\n\nNO LOGS \/ NO SCREENSHOT","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"beastiality":{"title":"[CHANNEL TEXT] Bestiality","report_details":"beastiality porn via \u1438title \/ bio\u1433\n\nNO LOGS \/ NO SCREENSHOT","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"piracy":{"title":"[CHANNEL TEXT] Piracy: Torrenting movies, games, etc...","report_details":"piracy, torrenting via \u1438title \/ bio\u1433, \u1438DETAILS\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"viewbotting_admission":{"title":"[CHANNEL TEXT] Viewerbotting: If the user admits\/shows it","report_details":"viewbotting admission via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"viewbotting_advertisement":{"title":"[CHANNEL TEXT] Viewerbotting: If it\u2019s a viewbot advertisement","report_details":"viewbot advertising via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"selling_twitch_services":{"title":"[CHANNEL TEXT] Selling of Twitch services","report_details":"selling twitch services \u1438DETAILS\u1433 via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"real_money_raffle":{"title":"[CHANNEL TEXT] Pay to enter contest or sweepstakes (raffle \/ giveaway)","report_details":"real money \u1438raffle \/ giveaway\u1433 via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"rs_gambling":{"title":"[CHANNEL TEXT] Runescape gambling: Bigboibets and other third party sites integrating gambling with the game","report_details":"rs gambling via \u1438title \/ bio\u1433, \u1438SITE_NAME\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"betting_on_sports":{"title":"[CHANNEL TEXT] Betting on sports matches","report_details":"betting on \u1438DETAILS_OF_ACTION\u1433 via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Other Terms of Service Violation"},"porn":{"detailed_reasons":{"sexual_content":{"title":"[CHANNEL TEXT] Sexual content, not a part of gameplay (videos, sounds, gifs, static images, etc...)","report_details":"sexual content via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"sexual_suggestive_content":{"title":"[CHANNEL TEXT] Sexual suggestive content, not a part of gameplay (videos, sounds, gifs, static images, etc...)","report_details":"sexual suggestive content via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Porn or Other Sexually Explicit Content"},"selfharm":{"detailed_reasons":{"threats_of_suicide":{"title":"[CHANNEL TEXT] Threats of suicide","report_details":"suicide threats via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"threats_of_self_harm":{"title":"[CHANNEL TEXT] Threats of self harm","report_details":"threatening with self harm via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false}},"description":"Self-Harm"},"social_eating_violation":{"detailed_reasons":{"social_eating_in_creative":{"title":"[CHANNEL TEXT] Social Eating in Twitch Creative","report_details":"Content:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"social_eating_in_game_directory":{"title":"[CHANNEL TEXT] Social Eating in a game directory","report_details":"Content:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"social_eating_in_music":{"title":"[CHANNEL TEXT] Social Eating in Music","report_details":"Content:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Social Eating Conduct Violation"},"spam":{"detailed_reasons":{"spam_bots":{"title":"[CHANNEL TEXT] Spam bots","report_details":"spam bot via <title \/ bio>\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":true,"clear_images":false},"malicious_content":{"title":"[CHANNEL TEXT] Phishing or distributing viruses","report_details":"malicious content via \u1438title \/ bio\u1433, \u1438DETAILS\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"distributing_ip_grabber":{"title":"[CHANNEL TEXT] Distributing IP grabber links","report_details":"distributing IP grabber links via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"fraud":{"title":"[CHANNEL TEXT] Fraud","report_details":"fraud via \u1438title \/ bio\u1433, \u1438DETAILS\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"fake_giveaway":{"title":"[CHANNEL TEXT] Confirmed fake giveaway w\/ evidence","report_details":"fake giveway via \u1438title \/ bio\u1433, \u1438DETAILS\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"rs_malicious_content":{"title":"[CHANNEL TEXT] RuneScape phishing via chat \/ panel \/ bio \/ stream","report_details":"malicious content via \u1438title \/ bio\u1433, runescape phishing\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false},"rs_doubling_money_scam":{"title":"[CHANNEL TEXT] Runescape doubling money scam","report_details":"rs doubling money scam via \u1438title \/ bio\u1433\n\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Spam, Scams, or Other Malicious Content"},"underaged":{"detailed_reasons":{"underaged":{"title":"[CHANNEL TEXT] Underaged","report_details":"underage via \u1438title \/ bio\u1433, \u1438AGE\u1433\nContent:\n\u1438CONTENT_COPY_PASTA\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false}},"description":"Underaged (person under the age of 13)"}},"description":"Channel Text"},"chat":{"reasons":{"harm":{"detailed_reasons":{"serious_violent_threats":{"title":"[CHAT] Serious violent threats against another person","report_details":"serious violent threats via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"ddos_threats":{"title":"[CHAT] DDOS threats","report_details":"ddos threats via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"swatting_threats":{"title":"[CHAT] SWAT threats","report_details":"swatting threats via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"releasing_private_information":{"title":"[CHAT] Posting Personally Identifying Information","report_details":"releasing private information via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"hacking_threats":{"title":"[CHAT] Hacking threats","report_details":"hacking threats via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false}},"description":"Attempts or Threats to Harm"},"chat_ban_evasion":{"detailed_reasons":{"channel_chat_ban_evasion":{"title":"[CHAT] Channel ban evasion (3 or more accounts)","report_details":"channel chat ban evasion in \u1438CHANNEL\u1433\n\nChat activity output:\n\u1438CHAT_ACTIVITY_OUTPUT\u1433","ip_ban":true,"permanent":false,"clear_images":false}},"description":"Chat Ban Evasion"},"cheating":{"detailed_reasons":{"lol_elo_boosting_advertisement":{"title":"[CHAT] LoL Elo boosting: Advertising paid elo boosting (playing on an account that isn\u2019t yours)","report_details":"\u1438selling \/ advertising\u1433 LoL Elo boosting via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false},"advertising_lol_refferal_services":{"title":"[CHAT] Advertising paid LoL referral services","report_details":"advertising LoL referral services via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false},"csgo_rank_boosting_advertisement":{"title":"[CHAT] CS:GO rank boosting: Advertising CS:GO rank boosting (playing on an account that isn\u2019t yours)","report_details":"selling \/ advertising CS:GO boosting via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false},"pokemon_go_cheating_advertisement":{"title":"[CHAT] Pokemon GO cheating or GPS spoofing promotion","report_details":"Pokemon GO advertisement via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Cheating in Online Game"},"gore":{"detailed_reasons":{"gore_media":{"title":"[CHAT] Gore, bodily fluids, or excessive blood via chat by a broadcaster or mod","report_details":"\u1438gore \/ bodily fluids \/ excessive blood\u1433 link via chat\n\nChat Log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false}},"description":"Gore or Other Obscene Content"},"harassment":{"detailed_reasons":{"broadcaster_raiding_without_permission":{"title":"[CHAT] Broadcaster raiding other channels with viewers without permission (if the raided channel complains)","report_details":"raiding \u1438CHANNEL\u1433 without permission via chat, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false},"instigate_false_reports":{"title":"[CHAT] Asking others to fake report another user","report_details":"instigate false reporting via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false},"repeat_harassment":{"title":"[CHAT] Repeat chat harassment: Obvious harassment in 2 or more different channels in a row","report_details":"multi chat harassment\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false},"4chan_style_harassment":{"title":"[CHAT] Repeat chat harassment: 4chan-style raid participants","report_details":"4chan-style raid via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false},"distributing_screamer":{"title":"[CHAT] Posting \u201cscreamer\u201d by a broadcaster or mod","report_details":"screamer as \u1438mod \/ broadcaster\u1433 via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false},"stream_sniping_to_harass":{"title":"[CHAT] Admitting or showcasing stream sniping of another broadcaster with the intent to harass","report_details":"stream sniping with the intent to harass via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Harassment"},"hate_speech":{"detailed_reasons":{"racist_symbols":{"title":"[CHAT] Swastika (or any other racist symbols) in chat as mod or broadcaster","report_details":"racist symbols (\u1438DETAILS\u1433) via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Hate Speech"},"impersonation":{"detailed_reasons":{"staff_impersonation":{"title":"[CHAT] Impersonating staff in other ways","report_details":"staff impersonation via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false},"impersonation_another_user_via_username":{"title":"[CHAT] Impersonating another person via username","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via username, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":true,"clear_images":false},"impersonation_another_user":{"title":"[CHAT] Impersonating another person in other ways","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via chat, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false},"impersonation_a_company_via_username":{"title":"[CHAT] Impersonating or falsely representing a company\/organization via username","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via username, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":true,"clear_images":false},"impersonation_a_company":{"title":"[CHAT] Impersonating or falsely representing a company\/organization in other ways","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via chat, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false}},"description":"Impersonation"},"other":{"detailed_reasons":{"terrorist_propaganda":{"title":"[CHAT] Terrorist propaganda and\/or recruitment","report_details":"terrorist \u1438propaganda \/ recruitment\u1433 via chat, \u1438DETAILS\u1433\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"child_porn":{"title":"[CHAT] Child porn","report_details":"child porn via chat in channel: \u1438CHANNEL\u1433\n\nNO LOGS \/ NO SCREENSHOT","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"beastiality":{"title":"[CHAT] Bestiality","report_details":"beastiality porn via chat in channel: \u1438CHANNEL\u1433\n\nNO LOGS \/ NO SCREENSHOT","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"piracy":{"title":"[CHAT] Piracy: Linking to torrents or other piracy sites as broadcaster or mod","report_details":"linking to piracy content via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false},"viewbotting_admission":{"title":"[CHAT] Viewerbotting: User admits\/shows it via chat","report_details":"viewbotting admission via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"viewbotting_advertisement":{"title":"[CHAT] Viewerbotting: If it\u2019s a viewbot advertisement","report_details":"viewbot advertising via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"selling_twitch_services":{"title":"[CHAT] Selling of Twitch services","report_details":"selling twitch services \u1438DETAILS\u1433 via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false},"real_money_raffle":{"title":"[CHAT] Pay to enter contest or sweepstakes (raffle\/giveaway)","report_details":"real money \u1438raffle \/ giveaway\u1433 via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Other Terms of Service Violation"},"porn":{"detailed_reasons":{"sexual_content":{"title":"[CHAT] Sexual content via chat by a broadcaster or mod","report_details":"sexual content in chat by a \u1438mod\/broadcaster\u1433\n\nChat Log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Porn or Other Sexually Explicit Content"},"selfharm":{"detailed_reasons":{"threats_of_suicide":{"title":"[CHAT] Threats of suicide","report_details":"suicide threats via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"threats_of_self_harm":{"title":"[CHAT] Threats of self harm","report_details":"threatening with self harm via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false}},"description":"Self-Harm"},"spam":{"detailed_reasons":{"spam_bots":{"title":"[CHAT] Spam bots","report_details":"spam bot via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":true,"clear_images":false},"flood_bots":{"title":"[CHAT] Floodbots","report_details":"flood bot via chat in \u1438CHANNEL\u1433\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":true,"clear_images":false},"massive_spamming":{"title":"[CHAT] Massive spamming (25+) chat rooms (not a spam bot)","report_details":"mass spamming via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false},"malicious_content":{"title":"[CHAT] Phishing or distributing viruses","report_details":"malicious content via chat, \u1438DETAILS\u1433\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"distributing_ip_grabber":{"title":"[CHAT] Distributing IP grabber links","report_details":"distributing IP grabber links via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"fraud":{"title":"[CHAT] Fraud","report_details":"fraud via chat, \u1438DETAILS\u1433\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"fake_giveaway":{"title":"[CHAT] Confirmed fake giveaway w\/ evidence","report_details":"fake giveway via chat, \u1438DETAILS\u1433\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false},"rs_malicious_content":{"title":"[CHAT] RuneScape phishing","report_details":"malicious content via chat, runescape phishing\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":true,"clear_images":false},"rs_doubling_money_scam":{"title":"[CHAT] Runescape doubling money scam","report_details":"rs doubling money scam via chat\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Spam, Scams, or Other Malicious Content"},"underaged":{"detailed_reasons":{"underaged":{"title":"[CHAT] Underaged","report_details":"underage via chat, \u1438AGE\u1433\n\nChat log:\n\u1438CHATLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":true,"clear_images":false}},"description":"Underaged (person under the age of 13)"}},"description":"Chat"},"clip":{"reasons":{"harm":{"detailed_reasons":{"serious_violent_threats":{"title":"[CLIP] Serious violent threats against another person","report_details":"serious violent threats on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"ddos_threats":{"title":"[CLIP] DDOS threats","report_details":"ddos threats on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"swatting_threats":{"title":"[CLIP] SWAT threats","report_details":"swatting threats on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"releasing_private_information":{"title":"[CLIP] Releasing Personally Identifying Information","report_details":"releasing private information on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"hacking_threats":{"title":"[CLIP] Hacking threats","report_details":"hacking threats on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"brandishing_real_weapons":{"title":"[CLIP] Brandishing OR using real weapons (guns, swords, crossbows, ...)","report_details":"brandishing weapons on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false}},"description":"Attempts or Threats to Harm"},"cheating":{"detailed_reasons":{"hacking_in_multiplayer_game":{"title":"[CLIP] Hacking \/ Cheating \/ Modding with multiplayer influence","report_details":"\u1438hacking \/ cheating\u1433 in \u1438GAME\u1433 on Clip \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"botting_in_multiplayer_game":{"title":"[CLIP] Botting in a multiplayer game to get an advantage","report_details":"botting in \u1438GAME\u1433 on Clip \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"lol_elo_boosting_advertisement":{"title":"[CLIP] LoL Elo boosting: Advertising paid elo boosting (playing on an account that isn\u2019t yours)","report_details":"\u1438selling \/ advertising\u1433 LoL Elo boosting on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"lol_elo_boosting":{"title":"[CLIP] LoL Elo boosting: Elo boosting on stream (playing on an account that isn\u2019t yours)","report_details":"LoL Elo boosting on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"advertising_lol_refferal_services":{"title":"[CLIP] Advertising paid LoL referral services","report_details":"advertising LoL referral services on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"csgo_rank_boosting_advertisement":{"title":"[CLIP] CS:GO rank boosting: Advertising CS:GO rank boosting (playing on an account that isn\u2019t yours)","report_details":"\u1438selling \/ advertising\u1433 CS:GO boosting on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"csgo_rank_boosting":{"title":"[CLIP] CS:GO rank boosting: CS:GO rank boosting on Clip (playing on an account that isn\u2019t yours)","report_details":"CS:GO boosting on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"pokemon_go_cheating":{"title":"[CLIP] Pokemon GO cheating or GPS spoofing","report_details":"Pokemon GO cheating on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"pokemon_go_cheating_advertisement":{"title":"[CLIP] Pokemon GO cheating or GPS spoofing promotion","report_details":"Pokemon GO advertisement on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Cheating in Online Game"},"creative_conduct":{"detailed_reasons":{"creative_conduct_bob_ross_rebroadcast":{"title":"[CLIP] Bob Ross re-broadcast without creating or commentary","report_details":"creative category violation on Clip, bob ross rebroadcast without creation or commentary\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_non_creative":{"title":"[CLIP] Non-Creative Content","report_details":"creative category violation on Clip, \u1438TYPE_OF_CONTENT\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_reading_aloud":{"title":"[CLIP] Reading aloud","report_details":"creative category violation on Clip, \u1438TYPE_OF_CONTENT\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_unattended":{"title":"[CLIP] Unattended webcam for >1hr","report_details":"creative category violation on Clip, unattended webcam > 1hr, \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_homework":{"title":"[CLIP] Homework or non-Creative school project","report_details":"creative category violation on Clip, non-Creative school work \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_teaching":{"title":"[CLIP] Teaching, tutorials, or talks on non-Creative subject","report_details":"creative category violation on Clip, non-Creative teaching \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_podcasts":{"title":"[CLIP] non-Creative Podcasts","report_details":"creative category violation on Clip, non-Creative podcast \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_unboxing":{"title":"[CLIP] Unboxings","report_details":"creative category violation on Clip, unboxing \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_reassembling":{"title":"[CLIP] Reassembling premade object for >1hr","report_details":"creative category violation on Clip, extended re-assembly \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"home_decoration_creative_violation":{"title":"[CLIP] Home making, decorating, or cleaning","report_details":"creative conduct violation on Clip, home making \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_film_or_photo_shoot":{"title":"[CLIP] Film or photo shoot","report_details":"creative category violation on Clip, \u1438film \/ photo\u1433 shoot \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_piercings":{"title":"[CLIP] Piercings","report_details":"creative category violation on Clip, body piercing\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_body_art":{"title":"[CLIP] Body-art that violates inappropriate attire guidelines","report_details":"creative category violation on Clip, body art involving nudity or inappropriate \u1438behavior \/ attire\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_self_maintenance":{"title":"[CLIP] Self-grooming or maintaining hygiene","report_details":"creative category violation on Clip, grooming or hygiene maintenance, \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_eating":{"title":"[CLIP] Focus on eating for >30min","report_details":"creative category violation on Clip, eating-focused broadcast\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_music_violation":{"title":"[CLIP] Music violation in Creative","report_details":"creative category violation on Clip, music violation in creative \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_pseudoscience_performance":{"title":"[CLIP] Pseudoscience or divination performance","report_details":"creative category violation on Clip, divination or pseudoscience performance, \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_asmr":{"title":"[CLIP] ASMR","report_details":"creative category violation on Clip, ASMR performance\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_puzzle_assembling":{"title":"[CLIP] Assembling puzzle","report_details":"creative category violation on Clip, puzzle assembly\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_pictionary_games":{"title":"[CLIP] Pictionary games","report_details":"creative category violation on Clip, pictionary game\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_distilling_alcohol":{"title":"[CLIP] Distilling alcohol","report_details":"creative category violation on Clip, distilling alcohol\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_focus_on_gameplay":{"title":"[CLIP] Majority gameplay content","report_details":"creative category violation on Clip, focus on gameplay, \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true}},"description":"Creative Conduct Violation"},"gore":{"detailed_reasons":{"gore_media":{"title":"[CLIP] Gore, bodily fluids, or excessive blood","report_details":"\u1438gore \/ bodily fluids \/ excessive blood\u1433, \u1438DETAILS\u1433 via \u1438image \/ gif \/ video\u1433 on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false}},"description":"Gore or Other Obscene Content"},"harassment":{"detailed_reasons":{"broadcaster_raiding_without_permission":{"title":"[CLIP] Broadcaster raiding other channels with viewers without permission (if the raided channel complains)","report_details":"raiding \u1438CHANNEL\u1433 without permission on Clip, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"instigate_false_reports":{"title":"[CLIP] Asking others to fake report another user","report_details":"instigate false reporting on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"distributing_screamer":{"title":"[CLIP] Distributing \u201cscreamer\u201d or showing them","report_details":"screamer on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"prank_calling":{"title":"[CLIP] Prank calling","report_details":"prank calling on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"text_to_speech":{"title":"[CLIP] Text, Text to Speech, Call-Ins that contains general swearing\/racial slurs in offensive context, broadcaster ignores or approves","report_details":"inappropriate \u1438text to speech \/ audio\u1433 on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"harassment_broadcast_title":{"title":"[CLIP] Harassing others in title","report_details":"harassment of others via Clip title \u1438with avoiding word filter \/ \u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"stream_sniping_to_harass":{"title":"[CLIP] Admitting or showcasing stream sniping of another broadcaster with the intent to harass","report_details":"stream sniping with the intent to harass on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Harassment"},"hate_speech":{"detailed_reasons":{"racist_symbols":{"title":"[CLIP] Swastika (or any other racist symbols)","report_details":"racist symbols (\u1438DETAILS\u1433) in a Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"hate_speech_broadcast_title":{"title":"[CLIP] Using hate speech or terroristic words in a title","report_details":"hate speech in title \u1438with avoiding word filter \/ \u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"frequent_hate_speech_or_harassment":{"title":"[CLIP] Frequent use of hate speech for general or targeted harassment on broadcast","report_details":"frequent use of hate speech\n\nClip URL:\n\u1438CLIP_URL\u1433","ip_ban":true,"permanent":false,"clear_images":false}},"description":"Hate Speech"},"impersonation":{"detailed_reasons":{"staff_impersonation":{"title":"[CLIP] Impersonating staff in other ways","report_details":"staff impersonation, \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"impersonation_another_user_via_username":{"title":"[CLIP] Impersonating another person via username","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via username, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false},"impersonation_another_user":{"title":"[CLIP] Impersonating another person in other ways","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via Clip, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"impersonation_a_company_via_username":{"title":"[CLIP] Impersonating or falsely representing a company\/organization via username","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via username, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false},"impersonation_a_company":{"title":"[CLIP] Impersonating or falsely representing a company\/organization in other ways","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via Clip, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false}},"description":"Impersonation"},"music_conduct":{"detailed_reasons":{"music_violation_without_visual_performance":{"title":"[CLIP] Outside of the Music category: Music performance or creation without video of the artist and\/or instruments.","report_details":"music violation on Clip, \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_violation_static_image":{"title":"[CLIP] Outside of the Music category: Music-only\/radio streams with static image(s), equalizers, visualizers, etc\u2026, except for those pre-approved (such as Monstercat).","report_details":"music violation on Clip, static image\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_violation_intro_or_outro_or_breaks":{"title":"[CLIP] Outside of the Music category: Music-only intros, breaks, and outros longer than 30 minutes, unless actively in-game (playing and\/or waiting in queue).","report_details":"music violation on Clip, \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_violation_non_creation":{"title":"[CLIP] Outside of the Music category: Streams that focus on karaoke (not \u201cJust Dance\u201d or similar), dancing to another\u2019s music, and\/or lip-sync\/impersonation.","report_details":"music violation on Clip, \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_violation_recorded_content":{"title":"[CLIP] Outside of the Music category: Recorded\/live concerts","report_details":"music violation on Clip, recorded live concert\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_category_violation_without_visual_performance":{"title":"[CLIP] In the Music category: Music performance or creation without video of the artist and\/or instruments.","report_details":"music category violation on Clip, \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_category_violation_static_image":{"title":"[CLIP] In the Music category: Music-only\/radio streams with static image(s), equalizers, visualizers, etc\u2026, except for those pre-approved (such as Monstercat).","report_details":"music category violation on Clip, static image\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_category_violation_intro_or_outro_or_breaks":{"title":"[CLIP] In the Music category: Music-only intros, breaks, and outros longer than 30 minutes, unless actively in-game (playing and\/or waiting in queue).","report_details":"music category violation on Clip, \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_category_violation_non_creation":{"title":"[CLIP] In the Music category: Streams that focus on karaoke (not \u201cJust Dance\u201d or similar), dancing to another\u2019s music, and\/or lip-sync\/impersonation.","report_details":"music category violation on Clip, \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_category_violation_recorded_content":{"title":"[CLIP] In the Music category: Recorded\/live concerts","report_details":"music category violation on Clip, recorded live concert\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Music Conduct Violation"},"nongaming":{"detailed_reasons":{"randomized_video_chat":{"title":"[CLIP] Chatroulette \/ Omegle","report_details":"randomized video chat on Clip, \u1438SITE_NAME\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"driving_while_streaming":{"title":"[CLIP] Non-Gaming: driving while streaming","report_details":"driving while streaming on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"movies_and_tv_shows":{"title":"[CLIP] Non-Gaming: (movies \/ anime \/ tv \/ sports \/ etc) *","report_details":"\u1438TYPE_OF_CONTENT\u1433 on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"hacking_related_programming":{"title":"[CLIP] Non-Gaming: hacking related programming","report_details":"programming \u1438TYPE_OF_CONTENT\u1433 on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"sleeping":{"title":"[CLIP] AFK\/Sleeping, If the user is actually sleeping on cam","report_details":"sleeping on stream on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"sexual_gestures":{"title":"[CLIP] Twerking or other sexually suggestive dancing\/gesturing","report_details":"sexual gestures on Clip, \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"ps4_playroom":{"title":"[CLIP] Playroom, not just another game listed under Playroom","report_details":"ps4 playroom on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"advertisement_stream":{"title":"[CLIP] Hitbox (or any other streaming platform) advertisement streams (static images)","report_details":"advertisement stream on Clip, \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Non-Gaming Content"},"other":{"detailed_reasons":{"terrorist_propaganda":{"title":"[CLIP] Terrorist propaganda and\/or recruitment","report_details":"terrorist \u1438propaganda \/ recruitment\u1433 in Clip, \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"child_porn":{"title":"[CLIP] Child porn","report_details":"child porn on Clip\n\nNO LOGS \/ NO SCREENSHOT","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"beastiality":{"title":"[CLIP] Bestiality","report_details":"beastiality porn on Clip\n\nNO LOGS \/ NO SCREENSHOT","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"being_swatted":{"title":"[CLIP] Being SWAT-ed","report_details":"getting swatted\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"underwear_on_stream":{"title":"[CLIP] Male or female broadcaster wearing only underwear or equiv (bathing suite) OR intentionally flashing underwear or equiv","report_details":"streaming in underwear on Clip, \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"male_without_shirt":{"title":"[CLIP] Male without shirt, and flaunting it or being lewd","report_details":"male top nude and \u1438flaunting \/ lewd\u1433 on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"piracy":{"title":"[CLIP] Piracy: Torrenting movies, games, etc...","report_details":"piracy, torrenting \u1438DETAILS\u1433 on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"restreaming":{"title":"[CLIP] Re-streaming another user from Twitch and the restreamed person complains","report_details":"re-streaming \u1438USER\u1433 without permission on Clip, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"viewbotting_admission":{"title":"[CLIP] Viewerbotting: If the user admits\/shows it on stream or chat","report_details":"viewbotting admission on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"viewbotting_advertisement":{"title":"[CLIP] Viewerbotting: If it\u2019s a viewbot advertisement stream","report_details":"viewbot advertising on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"selling_twitch_services":{"title":"[CLIP] Selling of Twitch services","report_details":"selling twitch services \u1438DETAILS\u1433 via Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"real_money_raffle":{"title":"[CLIP] Pay to enter contest or sweepstakes (raffle \/ giveaway)","report_details":"real money \u1438raffle \/ giveaway\u1433 on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"rs_gambling":{"title":"[CLIP] Runescape gambling: Bigboibets and other third party sites integrating gambling with the game","report_details":"rs gambling on Clip, \u1438SITE_NAME\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"rs_staking_for_others":{"title":"[CLIP] Runescape staking for friends or for viewers","report_details":"rs staking for others on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"betting_on_sports":{"title":"[CLIP] Betting on sports matches","report_details":"betting on \u1438DETAILS_OF_ACTION\u1433 on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"csgo_gambling_content":{"title":"[CLIP] CS:GO gambling content","report_details":"doing cs:go gambling\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"csgo_gambling_promotion":{"title":"[CLIP] CS:GO gambling site advertisement","report_details":"advertising cs:go gambling site or services, \u1438SITE_NAME\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false}},"description":"Other Terms of Service Violation"},"porn":{"detailed_reasons":{"sexual_content":{"title":"[CLIP] Sexual content on Clip, not a part of gameplay (videos, sounds, gifs, static images, etc...)","report_details":"sexual \u1438image \/ gif \/ video\u1433 on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"sexual_suggestive_content":{"title":"[CLIP] Sexual suggestive content on Clip, not a part of gameplay (videos, sounds, gifs, static images, etc...)","report_details":"sexual suggestive \u1438image \/ gif \/ video\u1433 on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"nude_mods":{"title":"[CLIP] Permitted game, but using nude mods","report_details":"nude mod on Clip, \u1438GAME\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"porn_game":{"title":"[CLIP] Sexually suggestive or explicit game with sex\/nudity as core focus or feature","report_details":"sexual game on Clip, \u1438GAME\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Porn or Other Sexually Explicit Content"},"prohibited":{"detailed_reasons":{"prohibited_game":{"title":"[CLIP] Prohibited game","report_details":"prohibited game on Clip, \u1438GAME\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"sexual_gaming_content":{"title":"[CLIP] Sexually explicit gaming content","report_details":"sexual gaming content on Clip, \u1438GAME\u1433 \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Prohibited Game"},"selfharm":{"detailed_reasons":{"attempted_suicide":{"title":"[CLIP] Attempted suicide","report_details":"attempted suicide in Clip, \u1438DETAILS_OF_ACTION\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"threats_of_suicide":{"title":"[CLIP] Threats of suicide","report_details":"suicide threats in Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"self_harm":{"title":"[CLIP] Self harm","report_details":"self harm in Clip, \u1438DETAILS_OF_ACTION\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"threats_of_self_harm":{"title":"[CLIP] Threats of self harm","report_details":"threatening with self harm on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"doing_hard_drugs":{"title":"[CLIP] Drugs: doing hard drugs","report_details":"doing \u1438DRUG_NAME\u1433 on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"passed_out_on_stream":{"title":"[CLIP] Self harm: passed out on stream from drinking \/ drugs","report_details":"passed out on stream from \u1438drugs \/ drinking\u1433 on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"harmful_dares_for_donations":{"title":"[CLIP] Harmful and\/or focus on dares\/challenges","report_details":"harmful dares for donations on Clip, \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"operating_moving_vehicle":{"title":"[CLIP] Operating a moving vehicle while broadcasting","report_details":"operating a moving vehicle on Clip, \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Self-Harm"},"social_eating_violation":{"detailed_reasons":{"social_eating_primarily_junk_food":{"title":"[CLIP] primarily eating junk foods in Social Eating","report_details":"Food: \n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"social_eating_primarily_drinking_alcohol":{"title":"[CLIP] primarily drinking alcoholic beverages in Social Eating","report_details":"Activity: \n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"social_eating_inedible_food":{"title":"[CLIP] eating items or food not meant for human consumption  in Social Eating","report_details":"Food: \n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"social_eating_vomit":{"title":"[CLIP] eating food or in a manner that leads to vomiting in Social Eating","report_details":"Food: \nVomiting Occurred: Y\/N\nEvidence for Intent: \n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"social_eating_offensive_food":{"title":"[CLIP] eating food or in a manner intended to disgust, shock, or offend others in Social Eating","report_details":"Food: \n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"social_eating_challenges":{"title":"[CLIP] doing food challenges or contests in Social Eating","report_details":"Food: \nChallenge: \n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"social_eating_challenges_for_goods_services":{"title":"[CLIP] doing food challenges or contests in exchange for goods or services in Social Eating","report_details":"Food: \nChallenge: \nExchanging: \n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"social_eating_challenges_for_money":{"title":"[CLIP] doing food challenges or contests in exchange for money in Social Eating","report_details":"Food: \nChallenge: \n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"social_eating_primarily_feeding_others":{"title":"[CLIP] primarily feeding others in Social Eating","report_details":"Clip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"social_eating_other_content":{"title":"[CLIP] broadcasting other content while eating in Social Eating","report_details":"Content Type: \n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"social_eating_no_visible_food":{"title":"[CLIP] food being eaten is not visibile in Social Eating","report_details":"Clip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"social_eating_no_visible_person":{"title":"[CLIP] person eating is not visible in Social Eating","report_details":"Clip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"social_eating_primarily_gameplay":{"title":"[CLIP] primarily playing games in Social Eating","report_details":"Clip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"social_eating_no_eating":{"title":"[CLIP] not eating in Social Eating","report_details":"Clip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"social_eating_no_interaction":{"title":"[CLIP] not talking to or interacting with chat while eating in Social Eating","report_details":"Clip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Social Eating Conduct Violation"},"spam":{"detailed_reasons":{"malicious_content":{"title":"[CLIP] Phishing or distributing viruses","report_details":"malicious content on Clip, \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"distributing_ip_grabber":{"title":"[CLIP] Distributing IP grabber links","report_details":"distributing IP grabber links via Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"fraud":{"title":"[CLIP] Fraud","report_details":"fraud on Clip, \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"fake_giveaway":{"title":"[CLIP] Confirmed fake giveaway w\/ evidence","report_details":"fake giveway on Clip, \u1438DETAILS\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"rs_malicious_content":{"title":"[CLIP] RuneScape phishing","report_details":"malicious content on Clip, runescape phishing\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false},"rs_doubling_money_scam":{"title":"[CLIP] Runescape doubling money scam","report_details":"rs doubling money scam on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"rs_swapping":{"title":"[CLIP] Runescape swapping in game","report_details":"rs swapping on Clip\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Spam, Scams, or Other Malicious Content"},"underaged":{"detailed_reasons":{"underaged":{"title":"[CLIP] Underaged","report_details":"underage on Clip, \u1438AGE\u1433\n\nClip URL:\n\u1438CLIP_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false}},"description":"Underaged (person under the age of 13)"}},"description":"Clip"},"feed":{"reasons":{"harm":{"detailed_reasons":{"serious_violent_threats":{"title":"[FEED] Serious violent threats against another person","report_details":"serious violent threats via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"ddos_threats":{"title":"[FEED] DDOS threats","report_details":"ddos threats via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"swatting_threats":{"title":"[FEED] SWAT threats","report_details":"swatting threats via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"releasing_private_information":{"title":"[FEED] Posting Personally Identifying Information","report_details":"releasing private information via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"hacking_threats":{"title":"[FEED] Hacking threats","report_details":"hacking threats via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false}},"description":"Attempts or Threats to Harm"},"cheating":{"detailed_reasons":{"lol_elo_boosting_advertisement":{"title":"[FEED] LoL Elo boosting: Advertising paid elo boosting (playing on an account that isn\u2019t yours)","report_details":"\u1438selling \/ advertising\u1433 LoL Elo boosting via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false},"advertising_lol_refferal_services":{"title":"[FEED] Advertising paid LoL referral services","report_details":"advertising LoL referral services via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false},"csgo_rank_boosting_advertisement":{"title":"[FEED] CS:GO rank boosting: Advertising CS:GO rank boosting (playing on an account that isn\u2019t yours)","report_details":"\u1438selling \/ advertising\u1433 CS:GO boosting via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false},"[FEED] Pokemon GO cheating or GPS spoofing promotion":{"title":"pokemon_go_cheating_advertisement","report_details":"Pokemon GO advertisement via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Cheating in Online Game"},"gore":{"detailed_reasons":{"gore_media":{"title":"[FEED] Gore, bodily fluids, or excessive blood on a feed","report_details":"\u1438gore \/ bodily fluids \/ excessive blood\u1433 via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false}},"description":"Gore or Other Obscene Content"},"harassment":{"detailed_reasons":{"broadcaster_raiding_without_permission":{"title":"[FEED] Broadcaster raiding other channels with viewers without permission (if the raided channel complains)","report_details":"raiding \u1438CHANNEL\u1433 without permission via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false},"instigate_false_reports":{"title":"[FEED] Asking others to fake report another user","report_details":"instigate false reporting via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false},"harassment_of_others":{"title":"[FEED] Harassing others","report_details":"harassment of others via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false},"stream_sniping_to_harass":{"title":"[FEED] Admitting or showcasing stream sniping of another broadcaster with the intent to harass","report_details":"stream sniping with the intent to harass via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Harassment"},"hate_speech":{"detailed_reasons":{"racist_symbols":{"title":"[FEED] Swastika (or any other racist symbols)","report_details":"racist symbols (\u1438DETAILS\u1433) via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false},"hate_speech_in_feed":{"title":"[FEED] Using hate speech or terroristic words in a feed","report_details":"hate speech in feed \u1438with avoiding word filter \/ \u1433, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Hate Speech"},"impersonation":{"detailed_reasons":{"staff_impersonation":{"title":"[FEED] Impersonating staff in other ways","report_details":"staff impersonation, \u1438DETAILS\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false},"impersonation_another_user_via_username":{"title":"[FEED] Impersonating another person via username","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via username, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":true,"clear_images":false},"impersonation_another_user":{"title":"[FEED] Impersonating another person in other ways","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false},"impersonation_a_company_via_username":{"title":"[FEED] Impersonating or falsely representing a company\/organization via username","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via username, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":true,"clear_images":false},"impersonation_a_company":{"title":"[FEED] Impersonating or falsely representing a company\/organization in other ways","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false}},"description":"Impersonation"},"other":{"detailed_reasons":{"terrorist_propaganda":{"title":"[FEED] Terrorist propaganda and\/or recruitment","report_details":"terrorist \u1438propaganda \/ recruitment\u1433 via feed, \u1438DETAILS\u1433, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"child_porn":{"title":"[FEED] Child porn","report_details":"child porn via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nNO LOGS \/ NO SCREENSHOT","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"beastiality":{"title":"[FEED] Bestiality","report_details":"beastiality porn via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nNO LOGS \/ NO SCREENSHOT","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"male_without_shirt":{"title":"[FEED] Male without shirt, and flaunting it or being lewd","report_details":"male top nude and \u1438flaunting \/ lewd\u1433 via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false},"piracy":{"title":"[FEED] Piracy: Torrenting movies, games, etc...","report_details":"piracy, torrenting \u1438DETAILS\u1433 via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false},"viewbotting_admission":{"title":"[FEED] Viewerbotting: If the user admits\/shows it on stream or chat","report_details":"viewbotting admission via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"viewbotting_advertisement":{"title":"[FEED] Viewerbotting: If it\u2019s a viewbot advertisement","report_details":"viewbot advertising via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"selling_twitch_services":{"title":"[FEED] Selling of Twitch services","report_details":"selling twitch services \u1438DETAILS\u1433 via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false},"real_money_raffle":{"title":"[FEED] Pay to enter contest or sweepstakes (raffle \/ giveaway)","report_details":"real money \u1438raffle \/ giveaway\u1433 via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false},"rs_gambling":{"title":"[FEED] Runescape gambling: Bigboibets and other third party sites integrating gambling with the game","report_details":"rs gambling, \u1438SITE_NAME\u1433 via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false},"betting_on_sports":{"title":"[FEED] Betting on sports matches","report_details":"betting on \u1438DETAILS_OF_ACTION\u1433 via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Other Terms of Service Violation"},"porn":{"detailed_reasons":{"sexual_content":{"title":"[FEED] Sexual content on a feed","report_details":"sexual content via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false},"sexual_suggestive_content":{"title":"[FEED] Sexual suggestive content on a feed","report_details":"sexual suggestive content via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Porn or Other Sexually Explicit Content"},"selfharm":{"detailed_reasons":{"threats_of_suicide":{"title":"[FEED] Threats of suicide","report_details":"suicide threats via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"threats_of_self_harm":{"title":"[FEED] Threats of self harm","report_details":"threatening with self harm, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false}},"description":"Self-Harm"},"spam":{"detailed_reasons":{"spam_bots":{"title":"[FEED] Spam bots","report_details":"spam bot via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":true,"clear_images":false},"flood_bots":{"title":"[FEED] Floodbots","report_details":"flood bot via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":true,"clear_images":false},"massive_spamming":{"title":"[FEED] Massive spamming (25+) feeds (not a spam bot)","report_details":"mass spamming via feed, original case IDs: \u1438ORIG_REPORT_CASEIDS\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false},"malicious_content":{"title":"[FEED] Phishing or distributing viruses","report_details":"malicious content via feed, \u1438DETAILS\u1433, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"distributing_ip_grabber":{"title":"[FEED] Distributing IP grabber links","report_details":"distributing IP grabber links via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"fraud":{"title":"[FEED] Fraud","report_details":"fraud via feed, \u1438DETAILS\u1433, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"fake_giveaway":{"title":"[FEED] Confirmed fake giveaway w\/ evidence","report_details":"fake giveway via feed, \u1438DETAILS\u1433, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false},"rs_malicious_content":{"title":"[FEED] RuneScape phishing","report_details":"malicious content via feed, runescape phishing, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":true,"clear_images":false},"rs_doubling_money_scam":{"title":"[FEED] Runescape doubling money scam","report_details":"rs doubling money scam via feed, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Spam, Scams, or Other Malicious Content"},"underaged":{"detailed_reasons":{"underaged":{"title":"[FEED] Underaged","report_details":"underage via feed, \u1438AGE\u1433, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nFeed content:\n\u1438PANELCONTENT_COPY_PASTA\u1433","ip_ban":false,"permanent":true,"clear_images":false}},"description":"Underaged (person under the age of 13)"}},"description":"Feed"},"panel":{"reasons":{"harm":{"detailed_reasons":{"serious_violent_threats":{"title":"[PANEL] Serious violent threats against another person","report_details":"serious violent threats via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"ddos_threats":{"title":"[PANEL] DDOS threats","report_details":"ddos threats via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"swatting_threats":{"title":"[PANEL] SWAT threats","report_details":"swatting threats via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"releasing_private_information":{"title":"[PANEL] Posting Personally Identifying Information","report_details":"releasing private information via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"hacking_threats":{"title":"[PANEL] Hacking threats","report_details":"hacking threats via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false}},"description":"Attempts or Threats to Harm"},"cheating":{"detailed_reasons":{"lol_elo_boosting_advertisement":{"title":"[PANEL] LoL Elo boosting: Advertising paid elo boosting (playing on an account that isn\u2019t yours)","report_details":"\u1438selling \/ advertising\u1433 LoL Elo boosting via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"advertising_lol_refferal_services":{"title":"[PANEL] Advertising paid LoL referral services","report_details":"advertising LoL referral services via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"csgo_rank_boosting_advertisement":{"title":"[PANEL] CS:GO rank boosting: Advertising CS:GO rank boosting (playing on an account that isn\u2019t yours)","report_details":"\u1438selling \/ advertising\u1433 CS:GO boosting via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"pokemon_go_cheating_advertisement":{"title":"[PANEL] Pokemon GO cheating or GPS spoofing promotion","report_details":"Pokemon GO advertisement via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Cheating in Online Game"},"gore":{"detailed_reasons":{"gore_media":{"title":"[PANEL] Gore, bodily fluids, or excessive blood on a panel","report_details":"\u1438gore \/ bodily fluids \/ excessive blood\u1433, \u1438DETAILS\u1433 via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false}},"description":"Gore or Other Obscene Content"},"harassment":{"detailed_reasons":{"instigate_false_reports":{"title":"[PANEL] Asking others to fake report another user","report_details":"instigate false reporting via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"distributing_screamer":{"title":"[PANEL] Linking \u201cscreamer\u201d on a panel","report_details":"screamer on a panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"stream_sniping_to_harass":{"title":"[PANEL] Admitting or showcasing stream sniping of another broadcaster with the intent to harass","report_details":"stream sniping with the intent to harass via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Harassment"},"hate_speech":{"detailed_reasons":{"racist_symbols":{"title":"[PANEL] Swastika (or any other racist symbols)","report_details":"racist symbols (\u1438DETAILS\u1433) on a panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Hate Speech"},"impersonation":{"detailed_reasons":{"staff_impersonation":{"title":"[PANEL] Impersonating staff in other ways","report_details":"staff impersonation via panel, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"impersonation_another_user_via_username":{"title":"[PANEL] Impersonating another person via username","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via username, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false},"impersonation_another_user":{"title":"[PANEL] Impersonating another person in other ways","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 on a panel via \u1438DETAILS\u1433, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"impersonation_a_company_via_username":{"title":"[PANEL] Impersonating or falsely representing a company\/organization via username","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via username, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false},"impersonation_a_company":{"title":"[PANEL] Impersonating or falsely representing a company\/organization in other ways","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 on a panel via \u1438DETAILS\u1433, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false}},"description":"Impersonation"},"other":{"detailed_reasons":{"terrorist_propaganda":{"title":"[PANEL] Terrorist propaganda and\/or recruitment","report_details":"terrorist \u1438propaganda \/ recruitment\u1433 via panel, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"child_porn":{"title":"[PANEL] Child porn","report_details":"child porn in a panel\n\nNO LOGS \/ NO SCREENSHOT","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"beastiality":{"title":"[PANEL] Bestiality","report_details":"beastiality porn in a panel\n\nNO LOGS \/ NO SCREENSHOT","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"male_without_shirt":{"title":"[PANEL] Male without shirt, and flaunting it or being lewd","report_details":"male top nude and \u1438flaunting \/ lewd\u1433 via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"piracy":{"title":"[PANEL] Piracy: Torrenting movies, games, etc...","report_details":"piracy, torrenting \u1438DETAILS\u1433 via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"viewbotting_admission":{"title":"[PANEL] Viewerbotting: If the user admits\/shows it","report_details":"viewbotting admission via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"viewbotting_advertisement":{"title":"[PANEL] Viewerbotting: If it\u2019s a viewbot advertisement","report_details":"viewbot advertising via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"selling_twitch_services":{"title":"[PANEL] Selling of Twitch services","report_details":"selling twitch services \u1438DETAILS\u1433 via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"real_money_raffle":{"title":"[PANEL] Pay to enter contest or sweepstakes(raffle\/giveaway)","report_details":"real money \u1438raffle \/ giveaway\u1433 via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"betting_on_sports":{"title":"[PANEL] Betting on sports matches","report_details":"betting on \u1438DETAILS_OF_ACTION\u1433 via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Other Terms of Service Violation"},"porn":{"detailed_reasons":{"sexual_content":{"title":"[PANEL] Sexual content in a panel","report_details":"sexual content in a panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"sexual_suggestive_content":{"title":"[PANEL] Sexual suggestive content in a panel","report_details":"sexual suggestive content in a panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Porn or Other Sexually Explicit Content"},"selfharm":{"detailed_reasons":{"threats_of_suicide":{"title":"[PANEL] Threats of suicide","report_details":"suicide threats via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"self_harm":{"title":"[PANEL] Self harm","report_details":"self harm via panel, \u1438DETAILS_OF_ACTION\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"threats_of_self_harm":{"title":"[PANEL] Threats of self harm","report_details":"threatening with self harm via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false}},"description":"Self-Harm"},"spam":{"detailed_reasons":{"spam_bots":{"title":"[PANEL] Spam bots","report_details":"spam bot via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false},"malicious_content":{"title":"[PANEL] Phishing or distributing viruses","report_details":"malicious content via panel, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"distributing_ip_grabber":{"title":"[PANEL] Distributing IP grabber links","report_details":"distributing IP grabber links via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"fraud":{"title":"[PANEL] Fraud","report_details":"fraud via panel, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"fake_giveaway":{"title":"[PANEL] Confirmed fake giveaway w\/ evidence","report_details":"fake giveway via panel, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"rs_malicious_content":{"title":"[PANEL] RuneScape phishing","report_details":"malicious content via panel, runescape phishing\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false},"rs_doubling_money_scam":{"title":"[PANEL] Runescape doubling money scam","report_details":"rs doubling money scam via panel\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Spam, Scams, or Other Malicious Content"},"underaged":{"detailed_reasons":{"underaged":{"title":"[PANEL] Underaged","report_details":"underage via panel, \u1438AGE\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false}},"description":"Underaged (person under the age of 13)"}},"description":"Panel"},"live":{"reasons":{"harm":{"detailed_reasons":{"serious_violent_threats":{"title":"[LIVE] Serious violent threats against another person","report_details":"serious violent threats on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"ddos_threats":{"title":"[LIVE] DDOS threats","report_details":"ddos threats on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"swatting_threats":{"title":"[LIVE] SWAT threats","report_details":"swatting threats on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"releasing_private_information":{"title":"[LIVE] Releasing Personally Identifying Information","report_details":"releasing private information on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"hacking_threats":{"title":"[LIVE] Hacking threats","report_details":"hacking threats on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"brandishing_real_weapons":{"title":"[LIVE] Brandishing OR using real weapons (guns, swords, crossbows, ...)","report_details":"brandishing weapons on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false}},"description":"Attempts or Threats to Harm"},"cheating":{"detailed_reasons":{"hacking_in_multiplayer_game":{"title":"[LIVE] Hacking \/ Cheating \/ Modding with multiplayer influence","report_details":"\u1438hacking \/ cheating\u1433 on stream in \u1438GAME\u1433 \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"botting_in_multiplayer_game":{"title":"[LIVE] Botting in a multiplayer game to get an advantage","report_details":"botting on stream in \u1438GAME\u1433 \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"lol_elo_boosting_advertisement":{"title":"[LIVE] LoL Elo boosting: Advertising paid elo boosting (playing on an account that isn\u2019t yours)","report_details":"\u1438selling \/ advertising\u1433 LoL Elo boosting on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"lol_elo_boosting":{"title":"[LIVE] LoL Elo boosting: Elo boosting on stream (playing on an account that isn\u2019t yours)","report_details":"LoL Elo boosting on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"advertising_lol_refferal_services":{"title":"[LIVE] Advertising paid LoL referral services","report_details":"advertising LoL referral services on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"csgo_rank_boosting_advertisement":{"title":"[LIVE] CS:GO rank boosting: Advertising CS:GO rank boosting (playing on an account that isn\u2019t yours)","report_details":"\u1438selling \/ advertising\u1433 CS:GO boosting on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"csgo_rank_boosting":{"title":"[LIVE] CS:GO rank boosting: CS:GO rank boosting on stream (playing on an account that isn\u2019t yours)","report_details":"CS:GO boosting on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"pokemon_go_cheating":{"title":"[LIVE] Pokemon GO cheating or GPS spoofing","report_details":"Pokemon GO cheating on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"pokemon_go_cheating_advertisement":{"title":"[LIVE] Pokemon GO cheating or GPS spoofing promotion","report_details":"Pokemon GO advertisement on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Cheating in Online Game"},"creative_conduct":{"detailed_reasons":{"creative_conduct_bob_ross_rebroadcast":{"title":"[LIVE] Bob Ross re-broadcast without creating or commentary","report_details":"creative category violation, bob ross rebroadcast without creation or commentary on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_non_creative":{"title":"[LIVE] Non-Creative Content","report_details":"creative category violation on stream, \u1438TYPE_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_reading_aloud":{"title":"[LIVE] Reading aloud","report_details":"creative category violation on stream, \u1438TYPE_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_unattended":{"title":"[LIVE] Unattended webcam for >1hr","report_details":"creative category violation on stream, unattended webcam > 1hr, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_homework":{"title":"[LIVE] Homework or non-Creative school project","report_details":"creative category violation on stream, non-Creative school work, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_teaching":{"title":"[LIVE] Teaching, tutorials, or talks on non-Creative subject","report_details":"creative category violation on stream, non-Creative teaching, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_podcasts":{"title":"[LIVE] non-Creative Podcasts","report_details":"creative category violation on stream, non-Creative podcast, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_unboxing":{"title":"[LIVE] Unboxings","report_details":"creative category violation on stream, unboxing \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_reassembling":{"title":"[LIVE] Reassembling premade object for >1hr","report_details":"creative category violation on stream, extended re-assembly \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"home_decoration_creative_violation":{"title":"[LIVE] Home making, decorating, or cleaning","report_details":"creative conduct violation on stream, home making, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_film_or_photo_shoot":{"title":"[LIVE] Film or photo shoot","report_details":"creative category violation on stream, \u1438film \/ photo\u1433 shoot, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_piercings":{"title":"[LIVE] Piercings","report_details":"creative category violation on stream, body piercing\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_body_art":{"title":"[LIVE] Body-art that violates inappropriate attire guidelines","report_details":"creative category violation on stream, body art involving nudity or inappropriate \u1438behavior \/ attire\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_self_maintenance":{"title":"[LIVE] Self-grooming or maintaining hygiene","report_details":"creative category violation on stream, grooming or hygiene maintenance, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_eating":{"title":"[LIVE] Focus on eating for >30min","report_details":"creative category violation on stream, eating-focused broadcast\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_music_violation":{"title":"[LIVE] Music violation in Creative","report_details":"creative category violation on stream, music violation in creative \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_pseudoscience_performance":{"title":"[LIVE] Pseudoscience or divination performance","report_details":"creative category violation on stream, divination or pseudoscience performance, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_asmr":{"title":"[LIVE] ASMR","report_details":"creative category violation on stream, ASMR performance\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_puzzle_assembling":{"title":"[LIVE] Assembling puzzle","report_details":"creative category violation on stream, puzzle assembly\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_pictionary_games":{"title":"[LIVE] Pictionary games","report_details":"creative category violation on stream, pictionary game\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_distilling_alcohol":{"title":"[LIVE] Distilling alcohol","report_details":"creative category violation on stream, distilling alcohol\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_focus_on_gameplay":{"title":"[LIVE] Majority gameplay content","report_details":"creative category violation on stream, focus on gameplay, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true}},"description":"Creative Conduct Violation"},"gore":{"detailed_reasons":{"gore_media":{"title":"[LIVE] Gore, bodily fluids, or excessive blood on stream","report_details":"\u1438gore \/ bodily fluids \/ excessive blood\u1433 on stream, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false}},"description":"Gore or Other Obscene Content"},"harassment":{"detailed_reasons":{"broadcaster_raiding_without_permission":{"title":"[LIVE] Broadcaster raiding other channels with viewers without permission (if the raided channel complains)","report_details":"raiding \u1438CHANNEL\u1433 without permission on stream, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"instigate_false_reports":{"title":"[LIVE] Asking others to fake report another user","report_details":"instigate false reporting on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"distributing_screamer":{"title":"[LIVE] Distributing or using \u201cscreamer\u201d on stream","report_details":"screamer on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"prank_calling":{"title":"[LIVE] Prank calling","report_details":"prank calling on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"text_to_speech":{"title":"[LIVE] Text, Text to Speech, Call-Ins that contains general swearing\/racial slurs in offensive context, broadcaster ignores or approves","report_details":"inappropriate \u1438text to speech \/ audio\u1433 on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"stream_sniping_to_harass":{"title":"[LIVE] Admitting or showcasing stream sniping of another broadcaster with the intent to harass","report_details":"stream sniping with the intent to harass on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Harassment"},"hate_speech":{"detailed_reasons":{"racist_symbols":{"title":"[LIVE] Swastika (or any other racist symbols)","report_details":"racist symbols (\u1438DETAILS\u1433) on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Hate Speech"},"impersonation":{"detailed_reasons":{"staff_impersonation":{"title":"[LIVE] Impersonating staff in other ways","report_details":"staff impersonation on stream, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"impersonation_another_user_via_username":{"title":"[LIVE] Impersonating another person via username","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via username, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false},"impersonation_another_user":{"title":"[LIVE] Impersonating another person in other ways","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 on stream, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"impersonation_a_company_via_username":{"title":"[LIVE] Impersonating or falsely representing a company\/organization via username","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via username, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false},"impersonation_a_company":{"title":"[LIVE] Impersonating or falsely representing a company\/organization in other ways","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 on stream, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false}},"description":"Impersonation"},"music_conduct":{"detailed_reasons":{"music_violation_without_visual_performance":{"title":"[LIVE] Outside of the Music category: Music performance or creation without video of the artist and\/or instruments.","report_details":"music violation on stream, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_violation_static_image":{"title":"[LIVE] Outside of the Music category: Music-only\/radio streams with static image(s), equalizers, visualizers, etc\u2026, except for those pre-approved (such as Monstercat).","report_details":"music violation on stream, static image\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_violation_intro_or_outro_or_breaks":{"title":"[LIVE] Outside of the Music category: Music-only intros, breaks, and outros longer than 30 minutes, unless actively in-game (playing and\/or waiting in queue).","report_details":"music violation on stream, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_violation_non_creation":{"title":"[LIVE] Outside of the Music category: Streams that focus on karaoke (not \u201cJust Dance\u201d or similar), dancing to another\u2019s music, and\/or lip-sync\/impersonation.","report_details":"music violation on stream, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_violation_recorded_content":{"title":"[LIVE] Outside of the Music category: Recorded\/live concerts","report_details":"music violation on stream, recorded live concert\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_category_violation_without_visual_performance":{"title":"[LIVE] In the Music category: Music performance or creation without video of the artist and\/or instruments.","report_details":"music category violation on stream, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_category_violation_static_image":{"title":"[LIVE] In the Music category: Music-only\/radio streams with static image(s), equalizers, visualizers, etc\u2026, except for those pre-approved (such as Monstercat).","report_details":"music category violation on stream, static image\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_category_violation_intro_or_outro_or_breaks":{"title":"[LIVE] In the Music category: Music-only intros, breaks, and outros longer than 30 minutes, unless actively in-game (playing and\/or waiting in queue).","report_details":"music category violation on stream, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_category_violation_non_creation":{"title":"[LIVE] In the Music category: Streams that focus on karaoke (not \u201cJust Dance\u201d or similar), dancing to another\u2019s music, and\/or lip-sync\/impersonation.","report_details":"music category violation on stream, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_category_violation_recorded_content":{"title":"[LIVE] In the Music category: Recorded\/live concerts","report_details":"music category violation on stream, recorded live concert\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Music Conduct Violation"},"nongaming":{"detailed_reasons":{"randomized_video_chat":{"title":"[LIVE] Chatroulette \/ Omegle","report_details":"randomized video chat on stream, \u1438SITE_NAME\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"general_non_gaming":{"title":"[LIVE] Non-Gaming: non-dmca stuff, if longer than ~ 1 hour","report_details":"\u1438TYPE_OF_CONTENT\u1433 on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"driving_while_streaming":{"title":"[LIVE] Non-Gaming: driving while streaming","report_details":"driving while streaming\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"movies_and_tv_shows":{"title":"[LIVE] Non-Gaming: (movies \/ anime \/ tv \/ sports \/ etc)","report_details":"\u1438TYPE_OF_CONTENT\u1433 on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"browsing_questionable_sites":{"title":"[LIVE] Non-Gaming: Web browsing with risk of sexual content","report_details":"browsing \u1438SITE NAME\u1433 on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"hacking_related_programming":{"title":"[LIVE] Non-Gaming: hacking related programming","report_details":"programming \u1438TYPE_OF_CONTENT\u1433 on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"sleeping":{"title":"[LIVE] AFK\/Sleeping, If the user is actually sleeping on cam","report_details":"sleeping on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"afk_stream":{"title":"[LIVE] AFK\/Sleeping, General unattended streams\/left on while taking a break (> 1 hours)","report_details":"afk stream, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"sexual_gestures":{"title":"[LIVE] Twerking or other sexually suggestive dancing\/gesturing","report_details":"sexual gestures on stream, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"ps4_playroom":{"title":"[LIVE] Playroom, not just another game listed under Playroom","report_details":"ps4 playroom on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"advertisement_stream":{"title":"[LIVE] Hitbox (or any other streaming platform) advertisement streams (static images)","report_details":"advertisement stream, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Non-Gaming Content"},"other":{"detailed_reasons":{"terrorist_propaganda":{"title":"[LIVE] Terrorist propaganda and\/or recruitment","report_details":"terrorist \u1438propaganda \/ recruitment\u1433 on stream, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"child_porn":{"title":"[LIVE] Child porn","report_details":"child porn on stream\n\nNO LOGS \/ NO SCREENSHOT","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"beastiality":{"title":"[LIVE] Bestiality","report_details":"beastiality porn on stream\n\nNO LOGS \/ NO SCREENSHOT","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"non_gaming_talk_show":{"title":"[LIVE] Prolonged non-gaming talk show content in gaming talk shows","report_details":"non-gaming talk show in Gaming Talk Shows\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"being_swatted":{"title":"[LIVE] Being SWAT-ed","report_details":"getting swatted on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"underwear_on_stream":{"title":"[LIVE] Male or female broadcaster wearing only underwear or equiv (bathing suite) OR intentionally flashing underwear or equiv","report_details":"streaming in underwear on stream, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"male_without_shirt":{"title":"[LIVE] Male without shirt, and flaunting it or being lewd","report_details":"male top nude and \u1438flaunting \/ lewd\u1433 on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"piracy":{"title":"[LIVE] Piracy: Torrenting movies, games, etc...","report_details":"piracy, torrenting \u1438DETAILS\u1433 on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"restreaming":{"title":"[LIVE] Re-streaming another user from Twitch and the restreamed person complains","report_details":"re-streaming \u1438USER\u1433 without permission on stream, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"viewbotting_admission":{"title":"[LIVE] Viewerbotting: If the user admits\/shows it on stream or chat","report_details":"viewbotting admission on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"viewbotting_advertisement":{"title":"[LIVE] Viewerbotting: If it\u2019s a viewbot advertisement stream","report_details":"viewbot advertising stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"selling_twitch_services":{"title":"[LIVE] Selling of Twitch services","report_details":"selling twitch services \u1438DETAILS\u1433 on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"real_money_raffle":{"title":"[LIVE] Pay to enter contest or sweepstakes (raffle\/giveaway)","report_details":"real money \u1438raffle \/ giveaway\u1433 on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"rs_gambling":{"title":"[LIVE] Runescape gambling: Bigboibets and other third party sites integrating gambling with the game","report_details":"rs gambling on stream, \u1438SITE_NAME\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"rs_staking_for_others":{"title":"[LIVE] Runescape staking for friends or for viewers","report_details":"rs staking for others\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"betting_on_sports":{"title":"[LIVE] Betting on sports matches","report_details":"betting on \u1438DETAILS_OF_ACTION\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"csgo_gambling_content":{"title":"[LIVE] CS:GO gambling content","report_details":"cs:go gambling content\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"csgo_gambling_promotion":{"title":"[LIVE] CS:GO gambling site advertisement","report_details":"cs:go gambling site advertisement or promotion, \u1438SITE_NAME\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false}},"description":"Other Terms of Service Violation"},"porn":{"detailed_reasons":{"sexual_content":{"title":"[LIVE] Sexual content on stream, not a part of gameplay (videos, sounds, gifs, static images, etc...)","report_details":"sexual \u1438image \/ gif \/ video\u1433 on stream, \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"sexual_suggestive_content":{"title":"[LIVE] Sexual suggestive content on stream, not a part of gameplay (videos, sounds, gifs, static images, etc...)","report_details":"sexual suggestive \u1438image \/ gif \/ video\u1433 on stream, \u1438LOCATION_OF_CONTENT\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"nude_mods":{"title":"[LIVE] Permitted game, but using nude mods","report_details":"nude mod on stream, \u1438GAME\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"porn_game":{"title":"[LIVE] Sexually suggestive or explicit game with sex\/nudity as core focus or feature","report_details":"sexual game on stream, \u1438GAME\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Porn or Other Sexually Explicit Content"},"prohibited":{"detailed_reasons":{"prohibited_game":{"title":"[LIVE] Prohibited game","report_details":"prohibited game on stream, \u1438GAME\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"sexual_gaming_content":{"title":"[LIVE] Sexually explicit gaming content","report_details":"sexual gaming content on stream, \u1438GAME\u1433 \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Prohibited Game"},"selfharm":{"detailed_reasons":{"attempted_suicide":{"title":"[LIVE] Attempted suicide","report_details":"attempted suicide on stream, \u1438DETAILS_OF_ACTION\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"threats_of_suicide":{"title":"[LIVE] Threats of suicide","report_details":"suicide threats on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"self_harm":{"title":"[LIVE] Self harm","report_details":"self harm on stream, \u1438DETAILS_OF_ACTION\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"threats_of_self_harm":{"title":"[LIVE] Threats of self harm","report_details":"threatening with self harm on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"doing_hard_drugs":{"title":"[LIVE] Drugs: doing hard drugs","report_details":"doing \u1438DRUG_NAME\u1433 on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"passed_out_on_stream":{"title":"[LIVE] Passed out on stream from drinking \/ drugs","report_details":"passed out on stream from \u1438drugs \/ drinking\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"harmful_dares_for_donations":{"title":"[LIVE] Harmful and\/or focus on dares\/challenges","report_details":"harmful dares for donations on stream, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"operating_moving_vehicle":{"title":"[LIVE] Operating a moving vehicle while broadcasting","report_details":"operating a moving vehicle on stream, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Self-Harm"},"social_eating_violation":{"detailed_reasons":{"social_eating_primarily_junk_food":{"title":"[LIVE] primarily eating junk foods in Social Eating","report_details":"Food: \n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"social_eating_primarily_drinking_alcohol":{"title":"[LIVE] primarily drinking alcoholic beverages in Social Eating","report_details":"Activity: \n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"social_eating_inedible_food":{"title":"[LIVE] eating items or food not meant for human consumption  in Social Eating","report_details":"Food: \n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"social_eating_vomit":{"title":"[LIVE] eating food or in a manner that leads to vomiting in Social Eating","report_details":"Food: \nVomiting Occurred: Y\/N\nEvidence for Intent: \n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"social_eating_offensive_food":{"title":"[LIVE] eating food or in a manner intended to disgust, shock, or offend others in Social Eating","report_details":"Food: \n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"social_eating_challenges":{"title":"[LIVE] doing food challenges or contests in Social Eating","report_details":"Food: \nChallenge: \n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"social_eating_challenges_for_goods_services":{"title":"[LIVE] doing food challenges or contests in exchange for goods or services in Social Eating","report_details":"Food: \nChallenge: \nExchanging: \n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"social_eating_challenges_for_money":{"title":"[LIVE] doing food challenges or contests in exchange for money in Social Eating","report_details":"Food: \nChallenge: \n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"social_eating_primarily_feeding_others":{"title":"[LIVE] primarily feeding others in Social Eating","report_details":"Screenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"social_eating_other_content":{"title":"[LIVE] broadcasting other content while eating in Social Eating","report_details":"Content Type: \n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"social_eating_no_visible_food":{"title":"[LIVE] food being eaten is not visibile in Social Eating","report_details":"Screenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"social_eating_no_visible_person":{"title":"[LIVE] person eating is not visible in Social Eating","report_details":"Screenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"social_eating_primarily_gameplay":{"title":"[LIVE] primarily playing games in Social Eating","report_details":"Screenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"social_eating_no_eating":{"title":"[LIVE] not eating in Social Eating","report_details":"Screenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"social_eating_no_interaction":{"title":"[LIVE] not talking to or interacting with chat while eating in Social Eating","report_details":"Screenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Social Eating Conduct Violation"},"spam":{"detailed_reasons":{"malicious_content":{"title":"[LIVE] Phishing or distributing viruses","report_details":"malicious content on stream, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"distributing_ip_grabber":{"title":"[LIVE] Distributing IP grabber links","report_details":"distributing IP grabber links on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"fraud":{"title":"[LIVE] Fraud","report_details":"fraud on stream, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"fake_giveaway":{"title":"[LIVE] Confirmed fake giveaway w\/ evidence","report_details":"fake giveway on stream, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"rs_malicious_content":{"title":"[LIVE] RuneScape phishing","report_details":"malicious content on stream, runescape phishing\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false},"rs_doubling_money_scam":{"title":"[LIVE] Runescape doubling money scam","report_details":"rs doubling money scam on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"rs_swapping":{"title":"[LIVE] Runescape swapping in game","report_details":"rs swapping on stream\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Spam, Scams, or Other Malicious Content"},"underaged":{"detailed_reasons":{"underaged":{"title":"[LIVE] Underaged","report_details":"underage on stream, \u1438AGE\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false}},"description":"Underaged (person under the age of 13)"}},"description":"Live"},"vod":{"reasons":{"harm":{"detailed_reasons":{"serious_violent_threats":{"title":"[VOD] Serious violent threats against another person","report_details":"serious violent threats on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"ddos_threats":{"title":"[VOD] DDOS threats","report_details":"ddos threats on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"swatting_threats":{"title":"[VOD] SWAT threats","report_details":"swatting threats on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"releasing_private_information":{"title":"[VOD] Releasing Personally Identifying Information","report_details":"releasing private information on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"hacking_threats":{"title":"[VOD] Hacking threats","report_details":"hacking threats on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"brandishing_real_weapons":{"title":"[VOD] Brandishing OR using real weapons (guns, swords, crossbows, ...)","report_details":"brandishing weapons on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false}},"description":"Attempts or Threats to Harm"},"cheating":{"detailed_reasons":{"hacking_in_multiplayer_game":{"title":"[VOD] Hacking \/ Cheating \/ Modding with multiplayer influence","report_details":"\u1438hacking \/ cheating\u1433 in \u1438GAME\u1433 on VOD \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"botting_in_multiplayer_game":{"title":"[VOD] Botting in a multiplayer game to get an advantage","report_details":"botting in \u1438GAME\u1433 on VOD \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"lol_elo_boosting_advertisement":{"title":"[VOD] LoL Elo boosting: Advertising paid elo boosting (playing on an account that isn\u2019t yours)","report_details":"\u1438selling \/ advertising\u1433 LoL Elo boosting on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"lol_elo_boosting":{"title":"[VOD] LoL Elo boosting: Elo boosting on stream (playing on an account that isn\u2019t yours)","report_details":"LoL Elo boosting on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"advertising_lol_refferal_services":{"title":"[VOD] Advertising paid LoL referral services","report_details":"advertising LoL referral services on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"csgo_rank_boosting_advertisement":{"title":"[VOD] CS:GO rank boosting: Advertising CS:GO rank boosting (playing on an account that isn\u2019t yours)","report_details":"\u1438selling \/ advertising\u1433 CS:GO boosting on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"csgo_rank_boosting":{"title":"[VOD] CS:GO rank boosting: CS:GO rank boosting on VOD (playing on an account that isn\u2019t yours)","report_details":"CS:GO boosting on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"pokemon_go_cheating":{"title":"[VOD] Pokemon GO cheating or GPS spoofing","report_details":"Pokemon GO cheating on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"pokemon_go_cheating_advertisement":{"title":"[VOD] Pokemon GO cheating or GPS spoofing promotion","report_details":"Pokemon GO advertisement on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Cheating in Online Game"},"creative_conduct":{"detailed_reasons":{"creative_conduct_bob_ross_rebroadcast":{"title":"[VOD] Bob Ross re-broadcast without creating or commentary","report_details":"creative category violation on VOD, bob ross rebroadcast without creation or commentary\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_non_creative":{"title":"[VOD] Non-Creative Content","report_details":"creative category violation on VOD, \u1438TYPE_OF_CONTENT\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_reading_aloud":{"title":"[VOD] Reading aloud","report_details":"creative category violation on VOD, \u1438TYPE_OF_CONTENT\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_unattended":{"title":"[VOD] Unattended webcam for >1hr","report_details":"creative category violation on VOD, unattended webcam > 1hr, \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_homework":{"title":"[VOD] Homework or non-Creative school project","report_details":"creative category violation on VOD, non-Creative school work \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_teaching":{"title":"[VOD] Teaching, tutorials, or talks on non-Creative subject","report_details":"creative category violation on VOD, non-Creative teaching \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_podcasts":{"title":"[VOD] non-Creative Podcasts","report_details":"creative category violation on VOD, non-Creative podcast \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_unboxing":{"title":"[VOD] Unboxings","report_details":"creative category violation on VOD, unboxing \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_reassembling":{"title":"[VOD] Reassembling premade object for >1hr","report_details":"creative category violation on VOD, extended re-assembly \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"home_decoration_creative_violation":{"title":"[VOD] Home making, decorating, or cleaning","report_details":"creative conduct violation on VOD, home making \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_film_or_photo_shoot":{"title":"[VOD] Film or photo shoot","report_details":"creative category violation on VOD, \u1438film \/ photo\u1433 shoot \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_piercings":{"title":"[VOD] Piercings","report_details":"creative category violation on VOD, body piercing\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_body_art":{"title":"[VOD] Body-art that violates inappropriate attire guidelines","report_details":"creative category violation on VOD, body art involving nudity or inappropriate \u1438behavior \/ attire\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_self_maintenance":{"title":"[VOD] Self-grooming or maintaining hygiene","report_details":"creative category violation on VOD, grooming or hygiene maintenance, \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_eating":{"title":"[VOD] Focus on eating for >30min","report_details":"creative category violation on VOD, eating-focused broadcast\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_music_violation":{"title":"[VOD] Music violation in Creative","report_details":"creative category violation on VOD, music violation in creative \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_pseudoscience_performance":{"title":"[VOD] Pseudoscience or divination performance","report_details":"creative category violation on VOD, divination or pseudoscience performance, \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_asmr":{"title":"[VOD] ASMR","report_details":"creative category violation on VOD, ASMR performance\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_puzzle_assembling":{"title":"[VOD] Assembling puzzle","report_details":"creative category violation on VOD, puzzle assembly\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_pictionary_games":{"title":"[VOD] Pictionary games","report_details":"creative category violation on VOD, pictionary game\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_distilling_alcohol":{"title":"[VOD] Distilling alcohol","report_details":"creative category violation on VOD, distilling alcohol\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true},"creative_conduct_focus_on_gameplay":{"title":"[VOD] Majority gameplay content","report_details":"creative category violation on VOD, focus on gameplay, \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"happened_in_creative":true}},"description":"Creative Conduct Violation"},"gore":{"detailed_reasons":{"gore_media":{"title":"[VOD] Gore, bodily fluids, or excessive blood","report_details":"\u1438gore \/ bodily fluids \/ excessive blood\u1433, \u1438DETAILS\u1433 via \u1438image \/ gif \/ video\u1433 on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"gore_media_as_custom_thumbnail":{"title":"[VOD] Gore, bodily fluids, or excessive blood on a custom VOD thumbnail","report_details":"\u1438gore \/ bodily fluids \/ excessive blood\u1433, \u1438DETAILS\u1433 via \u1438image \/ gif \/ video\u1433 on a custom VOD thumbnail\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false}},"description":"Gore or Other Obscene Content"},"harassment":{"detailed_reasons":{"broadcaster_raiding_without_permission":{"title":"[VOD] Broadcaster raiding other channels with viewers without permission (if the raided channel complains)","report_details":"raiding \u1438CHANNEL\u1433 without permission on VOD, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"instigate_false_reports":{"title":"[VOD] Asking others to fake report another user","report_details":"instigate false reporting on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"distributing_screamer":{"title":"[VOD] Distributing \u201cscreamer\u201d or showing them","report_details":"screamer on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"prank_calling":{"title":"[VOD] Prank calling","report_details":"prank calling on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"text_to_speech":{"title":"[VOD] Text, Text to Speech, Call-Ins that contains general swearing\/racial slurs in offensive context, broadcaster ignores or approves","report_details":"inappropriate \u1438text to speech \/ audio\u1433 on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"harassment_broadcast_title":{"title":"[VOD] Harassing others in title","report_details":"harassment of others via VOD title \u1438with avoiding word filter \/ \u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"stream_sniping_to_harass":{"title":"[VOD] Admitting or showcasing stream sniping of another broadcaster with the intent to harass","report_details":"stream sniping with the intent to harass on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Harassment"},"hate_speech":{"detailed_reasons":{"racist_symbols":{"title":"[VOD] Swastika (or any other racist symbols)","report_details":"racist symbols (\u1438DETAILS\u1433) in a VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"racist_symbols_as_custom_thumbnail":{"title":"[VOD] Swastika (or any other racist symbols) in a custom VOD thumbnail","report_details":"racist symbols (\u1438DETAILS\u1433) as custom VOD thumbnail\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"hate_speech_broadcast_title":{"title":"[VOD] Using hate speech or terroristic words in a title","report_details":"hate speech in title \u1438with avoiding word filter \/ \u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"frequent_hate_speech_or_harassment":{"title":"[VOD] Frequent use of hate speech for general or targeted harassment on broadcast","report_details":"frequent use of hate speech\n\nVOD URL:\n\u1438VOD_URL\u1433","ip_ban":true,"permanent":false,"clear_images":false}},"description":"Hate Speech"},"impersonation":{"detailed_reasons":{"staff_impersonation":{"title":"[VOD] Impersonating staff in other ways","report_details":"staff impersonation, \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"impersonation_another_user_via_username":{"title":"[VOD] Impersonating another person via username","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via username, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false},"impersonation_another_user":{"title":"[VOD] Impersonating another person in other ways","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via VOD, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"impersonation_a_company_via_username":{"title":"[VOD] Impersonating or falsely representing a company\/organization via username","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via username, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false},"impersonation_a_company":{"title":"[VOD] Impersonating or falsely representing a company\/organization in other ways","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via VOD, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false}},"description":"Impersonation"},"music_conduct":{"detailed_reasons":{"music_violation_without_visual_performance":{"title":"[VOD] Outside of the Music category: Music performance or creation without video of the artist and\/or instruments.","report_details":"music violation on VOD, \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_violation_static_image":{"title":"[VOD] Outside of the Music category: Music-only\/radio streams with static image(s), equalizers, visualizers, etc\u2026, except for those pre-approved (such as Monstercat).","report_details":"music violation on VOD, static image\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_violation_intro_or_outro_or_breaks":{"title":"[VOD] Outside of the Music category: Music-only intros, breaks, and outros longer than 30 minutes, unless actively in-game (playing and\/or waiting in queue).","report_details":"music violation on VOD, \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_violation_non_creation":{"title":"[VOD] Outside of the Music category: Streams that focus on karaoke (not \u201cJust Dance\u201d or similar), dancing to another\u2019s music, and\/or lip-sync\/impersonation.","report_details":"music violation on VOD, \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_violation_recorded_content":{"title":"[VOD] Outside of the Music category: Recorded\/live concerts","report_details":"music violation on VOD, recorded live concert\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_category_violation_without_visual_performance":{"title":"[VOD] In the Music category: Music performance or creation without video of the artist and\/or instruments.","report_details":"music category violation on VOD, \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_category_violation_static_image":{"title":"[VOD] In the Music category: Music-only\/radio streams with static image(s), equalizers, visualizers, etc\u2026, except for those pre-approved (such as Monstercat).","report_details":"music category violation on VOD, static image\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_category_violation_intro_or_outro_or_breaks":{"title":"[VOD] In the Music category: Music-only intros, breaks, and outros longer than 30 minutes, unless actively in-game (playing and\/or waiting in queue).","report_details":"music category violation on VOD, \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_category_violation_non_creation":{"title":"[VOD] In the Music category: Streams that focus on karaoke (not \u201cJust Dance\u201d or similar), dancing to another\u2019s music, and\/or lip-sync\/impersonation.","report_details":"music category violation on VOD, \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"music_category_violation_recorded_content":{"title":"[VOD] In the Music category: Recorded\/live concerts","report_details":"music category violation on VOD, recorded live concert\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Music Conduct Violation"},"nongaming":{"detailed_reasons":{"randomized_video_chat":{"title":"[VOD] Chatroulette \/ Omegle","report_details":"randomized video chat on VOD, \u1438SITE_NAME\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"general_non_gaming":{"title":"[VOD] Non-Gaming: non-dmca stuff, if longer than ~ 1 hour","report_details":"\u1438TYPE_OF_CONTENT\u1433 on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"driving_while_streaming":{"title":"[VOD] Non-Gaming: driving while streaming","report_details":"driving while streaming on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"movies_and_tv_shows":{"title":"[VOD] Non-Gaming: (movies \/ anime \/ tv \/ sports \/ etc) *","report_details":"\u1438TYPE_OF_CONTENT\u1433 on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"browsing_questionable_sites":{"title":"[VOD] Non-Gaming: Web browsing with risk of sexual content","report_details":"browsing \u1438SITE NAME\u1433 on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"hacking_related_programming":{"title":"[VOD] Non-Gaming: hacking related programming","report_details":"programming \u1438TYPE_OF_CONTENT\u1433 on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"sleeping":{"title":"[VOD] AFK\/Sleeping, If the user is actually sleeping on cam","report_details":"sleeping on stream on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"afk_stream":{"title":"[VOD] AFK\/Sleeping, General unattended streams\/left on while taking a break (> 1 hours)","report_details":"afk stream on VOD, \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"sexual_gestures":{"title":"[VOD] Twerking or other sexually suggestive dancing\/gesturing","report_details":"sexual gestures on VOD, \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"ps4_playroom":{"title":"[VOD] Playroom, not just another game listed under Playroom","report_details":"ps4 playroom on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"advertisement_stream":{"title":"[VOD] Hitbox (or any other streaming platform) advertisement streams (static images)","report_details":"advertisement stream on VOD, \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Non-Gaming Content"},"other":{"detailed_reasons":{"terrorist_propaganda":{"title":"[VOD] Terrorist propaganda and\/or recruitment","report_details":"terrorist \u1438propaganda \/ recruitment\u1433 in VOD, \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"intentional_wrong_trending_category":{"title":"[VOD] Intentionally streaming under the wrong category (miscategorization): Trending categories: (Music, Game Dev, Poker, Talk Shows, Creative, Twitch Plays)","report_details":"intentional miscategorization on VOD, \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"child_porn":{"title":"[VOD] Child porn","report_details":"child porn on VOD\n\nNO LOGS \/ NO SCREENSHOT","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"beastiality":{"title":"[VOD] Bestiality","report_details":"beastiality porn on VOD\n\nNO LOGS \/ NO SCREENSHOT","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"non_gaming_talk_show":{"title":"[VOD] Prolonged non-gaming talk show content in gaming talk shows","report_details":"non-gaming talk show on VOD in Gaming Talk Shows\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"being_swatted":{"title":"[VOD] Being SWAT-ed","report_details":"getting swatted\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"underwear_on_stream":{"title":"[VOD] Male or female broadcaster wearing only underwear or equiv (bathing suite) OR intentionally flashing underwear or equiv","report_details":"streaming in underwear on VOD, \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"male_without_shirt":{"title":"[VOD] Male without shirt, and flaunting it or being lewd","report_details":"male top nude and \u1438flaunting \/ lewd\u1433 on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"piracy":{"title":"[VOD] Piracy: Torrenting movies, games, etc...","report_details":"piracy, torrenting \u1438DETAILS\u1433 on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"restreaming":{"title":"[VOD] Re-streaming another user from Twitch and the restreamed person complains","report_details":"re-streaming \u1438USER\u1433 without permission on VOD, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"viewbotting_admission":{"title":"[VOD] Viewerbotting: If the user admits\/shows it on stream or chat","report_details":"viewbotting admission on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"viewbotting_advertisement":{"title":"[VOD] Viewerbotting: If it\u2019s a viewbot advertisement stream","report_details":"viewbot advertising on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"selling_twitch_services":{"title":"[VOD] Selling of Twitch services","report_details":"selling twitch services \u1438DETAILS\u1433 via VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"real_money_raffle":{"title":"[VOD] Pay to enter contest or sweepstakes (raffle \/ giveaway)","report_details":"real money \u1438raffle \/ giveaway\u1433 on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"rs_gambling":{"title":"[VOD] Runescape gambling: Bigboibets and other third party sites integrating gambling with the game","report_details":"rs gambling on VOD, \u1438SITE_NAME\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"rs_staking_for_others":{"title":"[VOD] Runescape staking for friends or for viewers","report_details":"rs staking for others on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"betting_on_sports":{"title":"[VOD] Betting on sports matches","report_details":"betting on \u1438DETAILS_OF_ACTION\u1433 on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"csgo_gambling_content":{"title":"[VOD] CS:GO gambling content","report_details":"cs:go gambling content\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433\n","ip_ban":false,"permanent":false,"clear_images":false},"csgo_gambling_promotion":{"title":"[VOD] CS:GO gambling site advertisement","report_details":"cs:go gambling site advertisement or promotion, \u1438SITE_NAME\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false}},"description":"Other Terms of Service Violation"},"porn":{"detailed_reasons":{"sexual_content":{"title":"[VOD] Sexual content on VOD, not a part of gameplay (videos, sounds, gifs, static images, etc...)","report_details":"sexual \u1438image \/ gif \/ video\u1433 on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"sexual_content_as_custom_thumbnail":{"title":"[VOD] Sexual content on a custom thumbnail","report_details":"sexual image as custom VOD thumbnail\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"sexual_suggestive_content":{"title":"[VOD] Sexual suggestive content on VOD, not a part of gameplay (videos, sounds, gifs, static images, etc...)","report_details":"sexual suggestive \u1438image \/ gif \/ video\u1433 on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"sexual_suggestive_content_as_custom_thumbnail":{"title":"[VOD] Sexual suggestive content on a custom thumbnail","report_details":"sexual suggestive image as custom VOD thumbnail\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"nude_mods":{"title":"[VOD] Permitted game, but using nude mods","report_details":"nude mod on VOD, \u1438GAME\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"porn_game":{"title":"[VOD] Sexually suggestive or explicit game with sex\/nudity as core focus or feature","report_details":"sexual game on VOD, \u1438GAME\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Porn or Other Sexually Explicit Content"},"prohibited":{"detailed_reasons":{"prohibited_game":{"title":"[VOD] Prohibited game","report_details":"prohibited game on VOD, \u1438GAME\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"sexual_gaming_content":{"title":"[VOD] Sexually explicit gaming content","report_details":"sexual gaming content on VOD, \u1438GAME\u1433 \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Prohibited Game"},"selfharm":{"detailed_reasons":{"attempted_suicide":{"title":"[VOD] Attempted suicide","report_details":"attempted suicide in VOD, \u1438DETAILS_OF_ACTION\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"threats_of_suicide":{"title":"[VOD] Threats of suicide","report_details":"suicide threats in VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"self_harm":{"title":"[VOD] Self harm","report_details":"self harm in VOD, \u1438DETAILS_OF_ACTION\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"threats_of_self_harm":{"title":"[VOD] Threats of self harm","report_details":"threatening with self harm on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"doing_hard_drugs":{"title":"[VOD] Drugs: doing hard drugs","report_details":"doing \u1438DRUG_NAME\u1433 on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"passed_out_on_stream":{"title":"[VOD] Self harm: passed out on stream from drinking \/ drugs","report_details":"passed out on stream from \u1438drugs \/ drinking\u1433 on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"harmful_dares_for_donations":{"title":"[VOD] Harmful and\/or focus on dares\/challenges","report_details":"harmful dares for donations on VOD, \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"operating_moving_vehicle":{"title":"[VOD] Operating a moving vehicle while broadcasting","report_details":"operating a moving vehicle on VOD, \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Self-Harm"},"social_eating_violation":{"detailed_reasons":{"social_eating_primarily_junk_food":{"title":"[VOD] primarily eating junk foods in Social Eating","report_details":"Food: \n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"social_eating_primarily_drinking_alcohol":{"title":"[VOD] primarily drinking alcoholic beverages in Social Eating","report_details":"Activity: \n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"social_eating_inedible_food":{"title":"[VOD] eating items or food not meant for human consumption  in Social Eating","report_details":"Food: \n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"social_eating_vomit":{"title":"[VOD] eating food or in a manner that leads to vomiting in Social Eating","report_details":"Food: \nVomiting Occurred: Y\/N\nEvidence for Intent: \n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"social_eating_offensive_food":{"title":"[VOD] eating food or in a manner intended to disgust, shock, or offend others in Social Eating","report_details":"Food: \n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"social_eating_challenges":{"title":"[VOD] doing food challenges or contests in Social Eating","report_details":"Food: \nChallenge: \n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"social_eating_challenges_for_goods_services":{"title":"[VOD] doing food challenges or contests in exchange for goods or services in Social Eating","report_details":"Food: \nChallenge: \nExchanging: \n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"social_eating_challenges_for_money":{"title":"[VOD] doing food challenges or contests in exchange for money in Social Eating","report_details":"Food: \nChallenge: \n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"social_eating_primarily_feeding_others":{"title":"[VOD] primarily feeding others in Social Eating","report_details":"VOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"social_eating_other_content":{"title":"[VOD] broadcasting other content while eating in Social Eating","report_details":"Content Type: \n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"social_eating_no_visible_food":{"title":"[VOD] food being eaten is not visibile in Social Eating","report_details":"VOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"social_eating_no_visible_person":{"title":"[VOD] person eating is not visible in Social Eating","report_details":"VOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"social_eating_primarily_gameplay":{"title":"[VOD] primarily playing games in Social Eating","report_details":"VOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"social_eating_no_eating":{"title":"[VOD] not eating in Social Eating","report_details":"VOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"social_eating_no_interaction":{"title":"[VOD] not talking to or interacting with chat while eating in Social Eating","report_details":"VOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Social Eating Conduct Violation"},"spam":{"detailed_reasons":{"malicious_content":{"title":"[VOD] Phishing or distributing viruses","report_details":"malicious content on VOD, \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"distributing_ip_grabber":{"title":"[VOD] Distributing IP grabber links","report_details":"distributing IP grabber links via VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"fraud":{"title":"[VOD] Fraud","report_details":"fraud on VOD, \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"fake_giveaway":{"title":"[VOD] Confirmed fake giveaway w\/ evidence","report_details":"fake giveway on VOD, \u1438DETAILS\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"rs_malicious_content":{"title":"[VOD] RuneScape phishing","report_details":"malicious content on VOD, runescape phishing\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false},"rs_doubling_money_scam":{"title":"[VOD] Runescape doubling money scam","report_details":"rs doubling money scam on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"rs_swapping":{"title":"[VOD] Runescape swapping in game","report_details":"rs swapping on VOD\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Spam, Scams, or Other Malicious Content"},"underaged":{"detailed_reasons":{"underaged":{"title":"[VOD] Underaged","report_details":"underage on VOD, \u1438AGE\u1433\n\nVOD URL:\n\u1438VOD_URL\u1433\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false}},"description":"Underaged (person under the age of 13)"}},"description":"VOD"},"pm":{"reasons":{"harm":{"detailed_reasons":{"serious_violent_threats":{"title":"[PM] Serious violent threats against another person","report_details":"serious violent threats via pm\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"ddos_threats":{"title":"[PM] DDOS threats","report_details":"ddos threats via pm\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"swatting_threats":{"title":"[PM] SWAT threats","report_details":"swatting threats via pm\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"releasing_private_information":{"title":"[PM] Posting Personally Identifying Information","report_details":"releasing private information via pm\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"hacking_threats":{"title":"[PM] Hacking threats","report_details":"hacking threats via pm\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false}},"description":"Attempts or Threats to Harm"},"cheating":{"detailed_reasons":{"lol_elo_boosting_advertisement":{"title":"[PM] LoL Elo boosting: Advertising paid elo boosting (playing on an account that isn\u2019t yours)","report_details":"\u1438selling \/ advertising\u1433 LoL Elo boosting via pm\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"advertising_lol_refferal_services":{"title":"[PM] Advertising paid LoL referral services","report_details":"advertising LoL referral services via pm\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"csgo_rank_boosting_advertisement":{"title":"[PM] CS:GO rank boosting: Advertising CS:GO rank boosting (playing on an account that isn\u2019t yours)","report_details":"\u1438selling \/ advertising\u1433 CS:GO boosting via pm\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Cheating in Online Game"},"gore":{"detailed_reasons":{"gore_spam":{"title":"[PM] User spamming links to gore \/ gratuitous violence","report_details":"gore pm spam\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Gore or Other Obscene Content"},"harassment":{"detailed_reasons":{"asking_to_spam_others":{"title":"[PM] Asking others to spam another user","report_details":"asking to spam others via pm\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"repeat_harassment":{"title":"[PM] Repeat harassment: Obvious harassment to 2 or more different users","report_details":"multi user pm harassment, original case IDs: \u1438ORIG_REPORT_CASEIDs\u1433\n\nScreenshots:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"4chan_style_harassment":{"title":"[PM] Repeat harassment: 4chan-style raid participants","report_details":"4chan-style raid via pm\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"stream_sniping_to_harass":{"title":"[PM] Admitting or showcasing stream sniping of another broadcaster with the intent to harass","report_details":"stream sniping with the intent to harass via pm\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Harassment"},"impersonation":{"detailed_reasons":{"staff_impersonation":{"title":"[PM] Impersonating staff in other ways","report_details":"staff impersonation via pm, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"impersonation_another_user_via_username":{"title":"[PM] Impersonating another person via username","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via username, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false},"impersonation_another_user":{"title":"[PM] Impersonating another person in other ways","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via pm, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"impersonation_a_company_via_username":{"title":"[PM] Impersonating or falsely representing a company\/organization via username","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via username, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false},"impersonation_a_company":{"title":"[PM] Impersonating or falsely representing a company\/organization in other ways","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via pm, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false}},"description":"Impersonation"},"other":{"detailed_reasons":{"terrorist_propaganda":{"title":"[PM] Terrorist propaganda and\/or recruitment","report_details":"terrorist \u1438propaganda \/ recruitment\u1433 via pm, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"child_porn":{"title":"[PM] Child porn","report_details":"child porn via pm\n\nNO LOGS \/ NO SCREENSHOT","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"beastiality":{"title":"[PM] Bestiality","report_details":"beastiality porn via pm\n\nNO LOGS \/ NO SCREENSHOT","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"viewbotting_admission":{"title":"[PM] Viewerbotting: If the user admits\/shows it via pm","report_details":"viewbotting admission via pm\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"viewbotting_advertisement":{"title":"[PM] Viewerbotting: If it\u2019s a viewbot advertisement","report_details":"viewbot advertising via pm\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"selling_twitch_services":{"title":"[PM] Selling of Twitch services","report_details":"selling twitch services \u1438DETAILS\u1433 via pm\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"real_money_raffle":{"title":"[PM] Pay to enter contest or sweepstakes (raffle\/giveaway)","report_details":"real money \u1438raffle \/ giveaway\u1433 via pm\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Other Terms of Service Violation"},"porn":{"detailed_reasons":{"porn_spam":{"title":"[PM] User spamming links to porn \/ sexually explicit content","report_details":"porn spam\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Porn or Other Sexually Explicit Content"},"selfharm":{"detailed_reasons":{"threats_of_suicide":{"title":"[PM] Threats of suicide","report_details":"suicide threats via pm\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"threats_of_self_harm":{"title":"[PM] Threats of self harm","report_details":"threatening with self harm via pm\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false}},"description":"Self-Harm"},"spam":{"detailed_reasons":{"spam_bots":{"title":"[PM] Spam bots","report_details":"spam bot via pm\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false},"massive_spamming":{"title":"[PM] Massive spamming (25+) users (not a spam bot)","report_details":"mass spamming via pm\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":false,"clear_images":false},"malicious_content":{"title":"[PM] Phishing or distributing viruses","report_details":"malicious content via pm, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"distributing_ip_grabber":{"title":"[PM] Distributing IP grabber links","report_details":"distributing IP grabber links via pm\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"fraud":{"title":"[PM] Fraud","report_details":"fraud via pm, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":true,"permanent":true,"clear_images":false},"fake_giveaway":{"title":"[PM] Confirmed fake giveaway w\/ evidence","report_details":"fake giveway via pm, \u1438DETAILS\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false},"rs_malicious_content":{"title":"[PM] RuneScape phishing","report_details":"malicious content via pm, runescape phishing\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false},"rs_doubling_money_scam":{"title":"[PM] Runescape doubling money scam","report_details":"rs doubling money scam via pm\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Spam, Scams, or Other Malicious Content"},"underaged":{"detailed_reasons":{"underaged":{"title":"[PM] Underaged","report_details":"underage via pm, \u1438AGE\u1433\n\nScreenshot:\n\u1438SCREENSHOT_LINK\u1433","ip_ban":false,"permanent":true,"clear_images":false}},"description":"Underaged (person under the age of 13)"}},"description":"PM"},"whisper":{"reasons":{"harm":{"detailed_reasons":{"serious_violent_threats":{"title":"[WHISPER] Serious violent threats against another person","report_details":"serious violent threats via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"ddos_threats":{"title":"[WHISPER] DDOS threats","report_details":"ddos threats via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"swatting_threats":{"title":"[WHISPER] SWAT threats","report_details":"swatting threats via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"releasing_private_information":{"title":"[WHISPER] Posting Personally Identifying Information","report_details":"releasing private information via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"hacking_threats":{"title":"[WHISPER] Hacking threats","report_details":"hacking threats via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false}},"description":"Attempts or Threats to Harm"},"cheating":{"detailed_reasons":{"lol_elo_boosting_advertisement":{"title":"[WHISPER] LoL Elo boosting: Advertising paid elo boosting (playing on an account that isn\u2019t yours)","report_details":"\u1438selling \/ advertising\u1433 LoL Elo boosting via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false},"advertising_lol_refferal_services":{"title":"[WHISPER] Advertising paid LoL referral services","report_details":"advertising LoL referral services via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false},"csgo_rank_boosting_advertisement":{"title":"[WHISPER] CS:GO rank boosting: Advertising CS:GO rank boosting (playing on an account that isn\u2019t yours)","report_details":"\u1438selling \/ advertising\u1433 CS:GO boosting via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Cheating in Online Game"},"gore":{"detailed_reasons":{"gore_spam":{"title":"[WHISPER] User spamming links to gore \/ gratuitous violence","report_details":"gore spam, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Gore or Other Obscene Content"},"harassment":{"detailed_reasons":{"asking_to_spam_others":{"title":"[WHISPER] Asking others to spam another user","report_details":"asking to spam others via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false},"repeat_harassment":{"title":"[WHISPER] Obvious harassment to 2 or more different users","report_details":"multi user whisper harassment, original case IDs: \u1438ORIG_REPORT_CASEIDs\u1433\n\nWhisper logs:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false},"4chan_style_harassment":{"title":"[WHISPER] Repeat harassment: 4chan-style raid participants","report_details":"4chan-style raid via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false},"stream_sniping_to_harass":{"title":"[WHISPER] Admitting or showcasing stream sniping of another broadcaster with the intent to harass","report_details":"stream sniping with the intent to harass via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Harassment"},"impersonation":{"detailed_reasons":{"staff_impersonation":{"title":"[WHISPER] Impersonating staff in other ways","report_details":"staff impersonation, \u1438DETAILS\u1433, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false},"impersonation_another_user_via_username":{"title":"[WHISPER] Impersonating another person via username","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via username, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":true,"clear_images":false},"impersonation_another_user":{"title":"[WHISPER] Impersonating another person in other ways","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false},"impersonation_a_company_via_username":{"title":"[WHISPER] Impersonating or falsely representing a company\/organization via username","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via username, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":true,"clear_images":false},"impersonation_a_company":{"title":"[WHISPER] Impersonating or falsely representing a company\/organization in other ways","report_details":"impersonating \u1438IMPERSONATED_NAME\u1433 via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false}},"description":"Impersonation"},"other":{"detailed_reasons":{"terrorist_propaganda":{"title":"[WHISPER] Terrorist propaganda and\/or recruitment","report_details":"terrorist \u1438propaganda \/ recruitment\u1433 via whispers, \u1438DETAILS\u1433, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"child_porn":{"title":"[WHISPER] Child porn","report_details":"child porn via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nNO LOGS \/ NO SCREENSHOT","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"beastiality":{"title":"[WHISPER] Bestiality","report_details":"beastiality porn via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nNO LOGS \/ NO SCREENSHOT","ip_ban":true,"permanent":true,"clear_images":false,"strike_form_note":"Email [HIGH IMPORTANCE]\nTO:vukraintsev@twitch.tv\nCC:rkennedy@twitch.tv"},"viewbotting_admission":{"title":"[WHISPER] Viewerbotting: User admits\/shows it via whispers","report_details":"viewbotting admission via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"viewbotting_advertisement":{"title":"[WHISPER] Viewerbotting: If it\u2019s a viewbot advertisement","report_details":"viewbot advertising via title via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"selling_twitch_services":{"title":"[WHISPER] Selling of Twitch services","report_details":"selling twitch services \u1438DETAILS\u1433 via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false},"real_money_raffle":{"title":"[WHISPER] Pay to enter contest or sweepstakes (raffle\/giveaway)","report_details":"real money \u1438raffle \/ giveaway\u1433 via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Other Terms of Service Violation"},"porn":{"detailed_reasons":{"porn_spam":{"title":"[WHISPER] User spamming links to porn \/ sexually explicit content","report_details":"porn spam, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Porn or Other Sexually Explicit Content"},"selfharm":{"detailed_reasons":{"threats_of_suicide":{"title":"[WHISPER] Threats of suicide","report_details":"suicide threats via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"threats_of_self_harm":{"title":"[WHISPER] Threats of self harm","report_details":"threatening with self harm via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false}},"description":"Self-Harm"},"spam":{"detailed_reasons":{"spam_bots":{"title":"[WHISPER] Spam bots","report_details":"spam bot via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":true,"clear_images":false},"flood_bots":{"title":"[WHISPER] Floodbots","report_details":"flood bot via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":true,"clear_images":false},"massive_spamming":{"title":"[WHISPER] User Whisper Spam (not a spambot)","report_details":"whisper spamming multiple users, original case IDs: \u1438ORIG_REPORT_CASEIDs\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":false,"clear_images":false},"malicious_content":{"title":"[WHISPER] Phishing or distributing viruses","report_details":"malicious content via whispers, \u1438DETAILS\u1433, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"distributing_ip_grabber":{"title":"[WHISPER] Distributing IP grabber links","report_details":"distributing IP grabber links via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"fraud":{"title":"[WHISPER] Fraud","report_details":"fraud via whispers, \u1438DETAILS\u1433, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":true,"permanent":true,"clear_images":false},"fake_giveaway":{"title":"[WHISPER] Confirmed fake giveaway w\/ evidence","report_details":"fake giveway via whispers, \u1438DETAILS\u1433, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false},"rs_malicious_content":{"title":"[WHISPER] RuneScape phishing","report_details":"malicious content via whispers, runescape phishing, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":true,"clear_images":false},"rs_doubling_money_scam":{"title":"[WHISPER] Runescape doubling money scam","report_details":"rs doubling money scam via whispers, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":false,"clear_images":false}},"description":"Spam, Scams, or Other Malicious Content"},"underaged":{"detailed_reasons":{"underaged":{"title":"[WHISPER] Underaged","report_details":"underage via whispers, \u1438AGE\u1433, original case ID: \u1438ORIG_REPORT_CASEID\u1433\n\nWhisper log:\n\u1438WHISPERLOG_COPY_PASTA\u1433","ip_ban":false,"permanent":true,"clear_images":false}},"description":"Underaged (person under the age of 13)"}},"description":"Whisper"}};


check_jquery_status();
