// ==UserScript==
// @name         Better Clip Deletion
// @namespace    CommanderTos/BetterClipDeletion
// @description  Be able to disable multiple clips at once
// @copyright    CommanderRoot
// @author       CommanderRoot
// @grant        none
// @downloadURL  https://leviathan.moderation.twitch.tv/js/better_clip_deletion.user.js
// @updateURL    https://leviathan.moderation.twitch.tv/js/better_clip_deletion.meta.js
// @include      https://clips.twitch.tv/commanderroot/MakeTwitchGreatAgain
// @version      0.0.7
// ==/UserScript==
"use strict";

// Global vars
var clips_disable_started = 0;
var clips_disable_done = 0;

// Add JQuery to the page so we can do stuff more easily
function add_jquery() {
  var script = document.createElement("script");
  script.type = "text/javascript";
  script.src = "https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js";
  var head = document.getElementsByTagName("head")[0];
  if (head)
    head.appendChild(script);
}
add_jquery();

// Add the JS cookie script so we can easily read cookies
function add_js_cookie_js() {
  var script = document.createElement("script");
  script.type = "text/javascript";
  script.src = "https://leviathan.moderation.twitch.tv/js/js.cookie.js";
  var head = document.getElementsByTagName("head")[0];
  if (head)
    head.appendChild(script);
}
add_js_cookie_js();

// Check the JQuery status and only start the main reforming once it's loaded
function check_jquery_status() {
  if (window.jQuery && window.Cookies) {
    // jQuery is loaded
    console.log("jQuery is loaded");
    replace_page_content();
  } else {
    // jQuery is not loaded
    console.log("jQuery is NOT loaded");
    setTimeout(function () { check_jquery_status(); }, 50);
  }
}
check_jquery_status();

// Add the form and other logic
function replace_page_content() {
  document.title = 'Multi clip disable tool';
  $("body").html('<div class="header">' +
    '<div>' +
      'Multi clip disable tool' +
    '</div>' +
    '<div>' +
      '<textarea id="paste" wrap="off"></textarea><br>' +
    '</div>' +
    '<button id="send_button" type="submit"><span>Burn them</span></button><br><br>' +
  '</div>');

  // Make textarea bigger so you can actually read what's in it
  $("#paste").css({"margin": "0px", "width": "950px", "height": "250px"});

  // Bind the parse function to the send button
  $("#send_button").on("click", function() {
    console.log("Send button clicked");
    $("#send_button").prop("disabled", true);
    parse_textarea_input();
  });
}

function parse_textarea_input() {
  var textarea_lines = $("#paste").val().split(/\r|\n/);
  var counter = 0;
  $(textarea_lines).each(function(i, e) {
    let slug_from_line = get_clip_slug_from_line(e);
    if(slug_from_line !== false) {
      disable_clip_by_slug(slug_from_line);
      counter = counter + 1;
    }
  });

  if(counter == 0) {
    // Nothing was done so we just enable the send button again (because we don't have to wait for request to be finished)
    $("#send_button").prop("disabled", false);
    alert("Nothing was done. Are you sure these are valid clip links?");
  }
}

function get_clip_slug_from_line(line) {
  var slug = false;
  console.log('Parsing: ' + line);
  var regexp_match = line.match(/^(.*)(https:\/\/clips\.twitch\.tv\/)([a-z0-9_]+\/[a-z0-9_]+)(.*)$/i);
  if(regexp_match !== null && regexp_match[3].length > 0) { // 3 is the slug part (username/emote_string)
    slug = regexp_match[3];
  }
  console.log('Found slug: ' + slug);
  return slug;
}

function disable_clip_by_slug(slug) {
  console.log('Disabling: ' + slug);
  clips_disable_started = clips_disable_started + 1;

  $.ajax({
    url: "https://clips.twitch.tv/" + slug + "/disable",
    type: "POST",
    data: '{}',
    contentType: "application/json;charset=UTF-8",
    headers: {'Twitch-Api-Token': Cookies.get("api_token")},
    success: function(result) {
      console.log("Successfully disabled: " + slug);
      remove_slug_from_list(slug);
      add_done_disable_count();
    },
    error: function(jqXHR, textStatus, errorThrown) {
      add_done_disable_count();
      let err = jqXHR.status + ", " + textStatus + ", " + errorThrown;
      console.log("Request Failed: " + err);
      alert('Error while disabling' + slug);
    }
  });
}

function add_done_disable_count() {
  clips_disable_done = clips_disable_done + 1;
  if(clips_disable_started <= clips_disable_done) {
    $("#send_button").prop("disabled", false);
    alert('Done with the disabling.');
  }
}

function remove_slug_from_list(slug) {
  var org_textarea_lines = $("#paste").val().split(/\r\n|\r|\n/);
  var new_textarea = "";
  $(org_textarea_lines).each(function(i, e) {
    // Only add it to the new textarea var if it's not matching the slug
    if(e.indexOf(slug) == -1) {
      new_textarea += e + "\n";
    }
  });

  // Set new textarea
  $("#paste").val(new_textarea.trim());
}
