// ==UserScript==
// @name            Better Report Reasons
// @namespace       CommanderTos
// @description     Have better report reasons
// @copyright       CommanderRoot
// @author          CommanderRoot
// @grant           GM_getValue
// @grant           GM_setValue
// @grant           GM_xmlhttpRequest
// @connect         leviathan.moderation.twitch.tv
// @downloadURL     https://leviathan.moderation.twitch.tv/js/better_report_reasons.user.js
// @updateURL       https://leviathan.moderation.twitch.tv/js/better_report_reasons.meta.js
// @include         *://*.twitch.tv/*/report_form?tos_ban=*
// @run-at document-end
// @version         0.0.14
// ==/UserScript==
"use strict";

// Vars ------------------------------------------------------------------
var local_etag = GM_getValue("script_etag");
var local_script = GM_getValue("script_content");
var script_url = "https://leviathan.moderation.twitch.tv/suspension_guide/addon.js";

// Functions -------------------------------------------------------------
// This function is needed to avoid a HTTP 400 error because the referrer is too large
function add_no_referrer() {
  var meta = document.createElement("meta");
  meta.setAttribute("name", "referrer");
  meta.setAttribute("content", "never");
  var head = document.getElementsByTagName("head")[0];
  if (head)
    head.appendChild(meta);
}
function add_jquery() {
  var script = document.createElement("script");
  script.type = "text/javascript";
  script.src = "https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js";
  var head = document.getElementsByTagName("head")[0];
  if (head)
    head.appendChild(script);
}
function load_script_into_page(script_content) {
  var script = document.createElement("script");
  script.type = "text/javascript";
  script.text = script_content;
  var head = document.getElementsByTagName("head")[0];
  if (head)
    head.appendChild(script);
}
function load_local_version() {
  if (local_script !== undefined) {
    load_script_into_page(local_script);
  }
}
function update_cached_version(content, etag) {
  GM_setValue("script_etag", etag);
  GM_setValue("script_content", content);
}
function get_etag_from_headers(responseHeaders) {
  var header = responseHeaders.split("\n");
  for (var i = 0; i < header.length; i++) {
    if (header[i].substring(0, 6).toLowerCase() == "etag: ") {
      return header[i].substring(6).trim();
    }
  }
  return "";
}

function check_reason_script_version() {
  GM_xmlhttpRequest({
    method : "HEAD",
    timeout : 5000,
    url : script_url + "?_=" + Math.floor(Date.now() / 30000),
    onload : function (response) {
      if (response.status == 200) {
        var request_etag = get_etag_from_headers(response.responseHeaders);
        if (request_etag !== "" && request_etag != local_etag) {
          get_reason_script();
        } else {
          // Use "cached" version if available
          load_local_version();
        }
      } else {
        // Use "cached" version if available
        load_local_version();
      }
    },
    ontimeout : function (response) {
      console.log("Timeout while loading the Better Reason script ... loading cached version");
      load_local_version();
    },
    onerror : function (response) {
      console.log("Error while loading the Better Reason script ... loading cached version");
      load_local_version();
    }
  });
}

function get_reason_script() {
  GM_xmlhttpRequest({
    method : "GET",
    timeout : 5000,
    url : script_url + "?_=" + Math.floor(Date.now() / 30000),
    onload : function (response) {
      if (response.status == 200) {
        var request_etag = get_etag_from_headers(response.responseHeaders);
        if (request_etag !== "") {
          update_cached_version(response.responseText, request_etag);
        }
        load_script_into_page(response.responseText);
      } else {
        // Use "cached" version if available
        load_local_version();
      }
    },
    ontimeout : function (response) {
      console.log("Timeout while loading the Better Reason script ... loading cached version");
      load_local_version();
    },
    onerror : function (response) {
      console.log("Error while loading the Better Reason script ... loading cached version");
      load_local_version();
    }
  });
}

add_no_referrer();
add_jquery();
check_reason_script_version();
