"use strict";

// relative time from unix timestamp
function relativeDate(from, to) {
	// takes a unix timestamp, spits out relative time

	var then = new Date(from * 1000)
	.getTime(),
	now = to || new Date().getTime();
	
	var switched = false;
	if(then > now)
	{
		var new_then = now;
		var new_now = then;
		switched = true;

		then = new_then;
		now = new_now;
	}

	var seconds = Math.floor(((now - then) / 1000) % 60), //every 60 seconds, reset to 0
	minutes = Math.floor(((now - then) / 1000) / 60 % 60), //every 60 minutes, reset to 0
	hours = Math.floor(((now - then) / 1000) / 60 / 60 % 24), //every 24 hours, reset to 0
	days = Math.floor(((now - then) / 1000) / 60 / 60 / 24 % 7), //every 7 days, reset to 0
	weeks = Math.floor(((now - then) / 1000) / 60 / 60 / 24 / 7 % 4), //every 4 weeks, reset to 0
	months = Math.floor(((now - then) / 1000) / 60 / 60 / 24 / 7 / 4 % 12), // every 12 months, reset to 0
	years = Math.floor(((now - then) / 1000) / 60 / 60 / 24 / 7 / 52); // every 52 weeks, reset to 0. More accurate years than using months.

	//string building through ternary abuse so we don't have to use an if latter or another function
	// returns 0m if there is 1 hour because 1h 0m 24s is prefferable to 1h 24s
	return (!!years || false ? years + "yr " : "") +
	(!!months || false ? months + "mo " : "") +
	(!!weeks || false ? weeks + "wk " : "") +
	(!!days || false ? days + "d " : "") +
	(!!hours || false ? hours + "h " : "") +
	(!!hours || false ? (!!minutes || false ? minutes + "m " : "0m ") : (!!minutes || false ? minutes + "m " : "")) +
	seconds + "s" +
	(switched === false ? " ago" : "");
}

// time function
function updateTime()
{
	//make a single date object for comparison, get the unix milisecond time from it
	// this is far more performant than making a new date object for every pass
	var now = new Date().getTime();

	//get all the cases, then get their friendly time elements
	$(".panel")
		.find(".time-friendly")
		.each(function(i, e) {
			switch (e.tagName) {
				case "DIV":
					//get the unixtime data attribute from their sibling exact element
					//then get the relative conversion from that and set it as text content
					if(typeof $(e).parent().attr("class") !== "undefined" && $(e).parent().attr("class") == "list-group-item")
					{
						if($(e).siblings(".time-exact").data("unixtime") * 1000 < now)
						{
							// Remove the entry from the auto resolve list (just visibly) as it's run out
							$(e).parent().remove();
							break;
						}
					}
					$(e)
						.text("(" + relativeDate($(e)
							.siblings(".time-exact")
							.data("unixtime"), now) + ")");
					break;
				case "SPAN":
					// don't instantiate new jQuery objects a bunch
					var jQe = $(e);

					// hack(?) to not show garbage on Offline channels
					// sorting an array by default sorts elements in lexical order
					// numbers come first, then Capital Letters in alphabetical order, then lowercase letters
					// so actual durations, then NaN, then Offline
					// ["3h 23m 59s ago", "Offline"]
					// ["NaNs ago", "Offline"]
					//
					// Solution: Lowercase duration result before sorting
					// ["Offline", "nans ago"]
					var selection = [
						relativeDate(
						//get the createdat data attribute from their preview parent element
						//then get the relative conversion from that
						jQe
							.parent() //uptime div
							.parent() //preview info div
							.parent() //stream preview div
							.parent() //entire report panel, yeah this is stupid
							.find(".stream-preview-image")
							.children("img")
							.data("createdat"),
							now
						).toLowerCase(),
						"Offline"
					].sort()[0];

					// set the relative time or Offline result as text content
					jQe.text(selection);

						// remove the timer class if it's offline, no sense checking this every second
						if ( selection === "Offline" ) { jQe.removeClass("time-friendly") }
					break;
			}
		})
}

function create_stream_preview(case_id, channel)
{
	if($("#stream_preview_" + case_id).html().length === 0)
	{
		$("#stream_preview_" + case_id).html('<div id="video_preview_title_' + case_id + '"></div><br> <iframe src="https://player.twitch.tv/?channel=' + channel + '" height="360" width="640" frameborder="0" scrolling="no" allowfullscreen="true"></iframe> <a href="javascript:remove_stream_preview(' + case_id + ', \'' + channel + '\');"><span class="glyphicon glyphicon-remove pull-right"></span></a><hr>');
		get_stream_title(case_id, channel);
	}
	else
	{
		$("#stream_preview_" + case_id).html("");
	}
}

function get_stream_title(case_id, channel)
{
	$.getJSON("https://api.twitch.tv/kraken/channels/" + channel + "?client_id=" + twitch_oauth_client_id + "&callback=?", function() {})
		.done(function(json) {
			$("#video_preview_title_" + case_id).append([
					$("<div/>", { "class": case_id + "_user" }).append([
					$("<strong/>", { text: "User: " }),
					$("<span/>", { text: json.name })
				]),
					$("<div/>", { "class": case_id + "_title" }).append([
					$("<strong/>", { text: "Title: " }),
					$("<span/>", { text: json.status })
				]),
					$("<div/>", { "class": case_id + "_game" }).append([
					$("<strong/>", { text: "Game: " }),
					$("<span/>", { text: json.game })
				]),
					$("<div/>", { "class": case_id + "_uptime" }).append([
					$("<strong/>", { text: "Stream started: " }),
					$("<span/>", { text: "Update in less than 1 second", "class": "time-friendly" })
				])
			]);
		})
		.fail(function(jqXHR, textStatus, error) {
			var err = jqXHR.status + ", " + textStatus + ", " + error;
			console.log( "Request Failed: " + err );
			// Try again
			get_stream_title(case_id, channel);
		});
}

function create_profile_image_preview(case_id, channel, via_autoload)
{
	var via_autoload = typeof via_autoload !== 'undefined' ? via_autoload : false;

	if($("#profile_image_preview_" + case_id).html().length === 0)
	{
		$("#profile_image_preview_" + case_id).html("Loading ...<hr>");
		$.getJSON("https://api.twitch.tv/kraken/users/" + channel + "?client_id=" + twitch_oauth_client_id + "&callback=?", function() {})
			.done(function(json) {
				if(typeof json.logo !== "undefined" && json.logo !== null && json.logo.length > 0) {
					// Clear it first
					$("#profile_image_preview_" + case_id).html("");
					// Add the content
					$("#profile_image_preview_" + case_id).append([
						// Upload and get report link button
						$("<span/>", { class: "pull-right", id: "profile_image_upload_" + case_id, html: '<a class="btn btn-xs btn-default btn-link" href="javascript:upload_channel_image(\'' + case_id + '\', \'' + channel + '\', \'profile_image\', \'' + json.logo.replace("-300x300.", "-600x600.").replace("https://static-cdn.jtvnw.net/", "https://twitch-desk.rootonline.de/stream-preview-image/") + '\');">Upload and gen report link</a>' } ),
						// Normal Data output
							$("<div/>").append([
							$("<strong/>", { text: "User: " }),
							$("<span/>", { text: json.name })
						]),
							$("<div/>").append([
							$("<strong/>", { text: "Profile image: " })
						]),
							$("<div/>").append([
							$("<img/>", { src: json.logo.replace("-300x300.", "-600x600.").replace("https://static-cdn.jtvnw.net/", "https://twitch-desk.rootonline.de/stream-preview-image/"), width: "600", height: "600" }),
						]),
							$("<div/>").append([
							$("<hr/>")
						])
					]);
				} else if(typeof json.error !== "undefined" && json.error !== null & typeof json.status !== "undefined" && json.status !== null && json.status == 422 && json.message.indexOf(" is unavailable") != -1)	{
					// Clear it first
					$("#profile_image_preview_" + case_id).html("");
					// Add the content
					$("#profile_image_preview_" + case_id).append([
							$("<div/>", { "class": case_id + "_user" }).append([
							$("<strong/>", { text: "User: " }),
							$("<span/>", { text: channel })
						]),
							$("<div/>").append([
							$("<span/>", { text: "This user is TOS'd." })
						]),
							$("<div/>").append([
							$("<hr/>")
						])
					]);
				} else if(typeof json.error !== "undefined" && json.error !== null & typeof json.status !== "undefined" && json.status !== null && json.status == 422 && json.message.indexOf(" is not available on Twitch") != -1) {
					// Clear it first
					$("#profile_image_preview_" + case_id).html("");
					// Add the content
					$("#profile_image_preview_" + case_id).append([
							$("<div/>").append([
							$("<strong/>", { text: "User: " }),
							$("<span/>", { text: channel })
						]),
							$("<div/>").append([
							$("<span/>", { text: "This user is a JTV account." })
						]),
							$("<div/>").append([
							$("<hr/>")
						])
					]);
				} else {
					// Clear it first
					$("#profile_image_preview_" + case_id).html("");
					// Add the content
					$("#profile_image_preview_" + case_id).append([
							$("<div/>").append([
							$("<strong/>", { text: "User: " }),
							$("<span/>", { text: channel })
						]),
							$("<div/>").append([
							$("<strong/>", { text: "Profile image: " })
						]),
							$("<div/>").append([
							$("<span/>", { text: "This user doesn't have a profile image." })
						]),
							$("<div/>").append([
							$("<hr/>")
						])
					]);
				}
			})
			.fail(function(jqXHR, textStatus, error) {
				var err = jqXHR.status + ", " + textStatus + ", " + error;
				console.log( "Request Failed: " + err );
				// Try again
				create_profile_image_preview(case_id, channel);
			});
	}
	else
	{
		if(via_autoload === false)
		{
			$("#profile_image_preview_" + case_id).html("");
		}
	}
}

function create_profile_banner_preview(case_id, channel, via_autoload)
{
	var via_autoload = typeof via_autoload !== 'undefined' ? via_autoload : false;

	if($("#profile_banner_preview_" + case_id).html().length === 0)
	{
		$("#profile_banner_preview_" + case_id).html("Loading ...<hr>");
		$.getJSON("https://api.twitch.tv/kraken/channels/" + channel + "?client_id=" + twitch_oauth_client_id + "&callback=?", function() {})
			.done(function(json) {
				if(typeof json.profile_banner !== "undefined" && json.profile_banner !== null && json.profile_banner.length > 0) {
					// Clear it first
					$("#profile_banner_preview_" + case_id).html("");
					// Add the content
					$("#profile_banner_preview_" + case_id).append([
						// Upload and get report link button
						$("<span/>", { class: "pull-right", id: "profile_banner_upload_" + case_id, html: '<a class="btn btn-xs btn-default btn-link" href="javascript:upload_channel_image(\'' + case_id + '\', \'' + channel + '\', \'profile_banner\', \'' + json.profile_banner.replace("https://static-cdn.jtvnw.net/", "https://twitch-desk.rootonline.de/stream-preview-image/") + '\');">Upload and gen report link</a>' } ),
						// Normal Data output
							$("<div/>").append([
							$("<strong/>", { text: "User: " }),
							$("<span/>", { text: json.name })
						]),
							$("<div/>").append([
							$("<strong/>", { text: "Profile banner: " })
						]),
							$("<div/>").append([
							$("<img/>", { src: json.profile_banner.replace("https://static-cdn.jtvnw.net/", "https://twitch-desk.rootonline.de/stream-preview-image/"), style: "max-width:550px;" }),
						]),
							$("<div/>").append([
							$("<hr/>")
						])
					]);
				} else if(typeof json.error !== "undefined" && json.error !== null & typeof json.status !== "undefined" && json.status !== null && json.status == 422 && json.message.indexOf(" is unavailable") != -1)	{
					// Clear it first
					$("#profile_banner_preview_" + case_id).html("");
					// Add the content
					$("#profile_banner_preview_" + case_id).append([
							$("<div/>", { "class": case_id + "_user" }).append([
							$("<strong/>", { text: "User: " }),
							$("<span/>", { text: channel })
						]),
							$("<div/>").append([
							$("<span/>", { text: "This user is TOS'd." })
						]),
							$("<div/>").append([
							$("<hr/>")
						])
					]);
				} else if(typeof json.error !== "undefined" && json.error !== null & typeof json.status !== "undefined" && json.status !== null && json.status == 422 && json.message.indexOf(" is not available on Twitch") != -1) {
					// Clear it first
					$("#profile_banner_preview_" + case_id).html("");
					// Add the content
					$("#profile_banner_preview_" + case_id).append([
							$("<div/>").append([
							$("<strong/>", { text: "User: " }),
							$("<span/>", { text: channel })
						]),
							$("<div/>").append([
							$("<span/>", { text: "This user is a JTV account." })
						]),
							$("<div/>").append([
							$("<hr/>")
						])
					]);
				} else {
					// Clear it first
					$("#profile_banner_preview_" + case_id).html("");
					// Add the content
					$("#profile_banner_preview_" + case_id).append([
							$("<div/>").append([
							$("<strong/>", { text: "User: " }),
							$("<span/>", { text: channel })
						]),
							$("<div/>").append([
							$("<strong/>", { text: "Profile banner: " })
						]),
							$("<div/>").append([
							$("<span/>", { text: "This user doesn't have a profile banner." })
						]),
							$("<div/>").append([
							$("<hr/>")
						])
					]);
				}
			})
			.fail(function(jqXHR, textStatus, error) {
				var err = jqXHR.status + ", " + textStatus + ", " + error;
				console.log( "Request Failed: " + err );
				// Try again
				create_profile_banner_preview(case_id, channel);
			});
	}
	else
	{
		if(via_autoload === false)
		{
			$("#profile_banner_preview_" + case_id).html("");
		}
	}
}

function create_offline_image_preview(case_id, channel, via_autoload)
{
	var via_autoload = typeof via_autoload !== 'undefined' ? via_autoload : false;

	if($("#offline_image_preview_" + case_id).html().length === 0)
	{
		$("#offline_image_preview_" + case_id).html("Loading ...<hr>");
		$.getJSON("https://api.twitch.tv/kraken/channels/" + channel + "?client_id=" + twitch_oauth_client_id + "&callback=?", function() {})
			.done(function(json) {
				if(typeof json.video_banner !== "undefined" && json.video_banner !== null && json.video_banner.length > 0) {
					// Clear it first
					$("#offline_image_preview_" + case_id).html("");
					// Add the content
					$("#offline_image_preview_" + case_id).append([
						// Upload and get report link button
						$("<span/>", { class: "pull-right", id: "offline_image_upload_" + case_id, html: '<a class="btn btn-xs btn-default btn-link" href="javascript:upload_channel_image(\'' + case_id + '\', \'' + channel + '\', \'offline_image\', \'' + json.video_banner.replace("https://static-cdn.jtvnw.net/", "https://twitch-desk.rootonline.de/stream-preview-image/") + '\');">Upload and gen report link</a>' } ),
						// Normal Data output
							$("<div/>").append([
							$("<strong/>", { text: "User: " }),
							$("<span/>", { text: json.name })
						]),
							$("<div/>").append([
							$("<strong/>", { text: "Offline image: " })
						]),
							$("<div/>").append([
							$("<img/>", { src: json.video_banner.replace("https://static-cdn.jtvnw.net/", "https://twitch-desk.rootonline.de/stream-preview-image/"), width: "650", height: "366" }),
						]),
							$("<div/>").append([
							$("<hr/>")
						])
					]);
				} else if(typeof json.error !== "undefined" && json.error !== null & typeof json.status !== "undefined" && json.status !== null && json.status == 422 && json.message.indexOf(" is unavailable") != -1)	{
					// Clear it first
					$("#offline_image_preview_" + case_id).html("");
					// Add the content
					$("#offline_image_preview_" + case_id).append([
							$("<div/>", { "class": case_id + "_user" }).append([
							$("<strong/>", { text: "User: " }),
							$("<span/>", { text: channel })
						]),
							$("<div/>").append([
							$("<span/>", { text: "This user is TOS'd." })
						]),
							$("<div/>").append([
							$("<hr/>")
						])
					]);
				} else if(typeof json.error !== "undefined" && json.error !== null & typeof json.status !== "undefined" && json.status !== null && json.status == 422 && json.message.indexOf(" is not available on Twitch") != -1) {
					// Clear it first
					$("#offline_image_preview_" + case_id).html("");
					// Add the content
					$("#offline_image_preview_" + case_id).append([
							$("<div/>").append([
							$("<strong/>", { text: "User: " }),
							$("<span/>", { text: channel })
						]),
							$("<div/>").append([
							$("<span/>", { text: "This user is a JTV account." })
						]),
							$("<div/>").append([
							$("<hr/>")
						])
					]);
				} else {
					// Clear it first
					$("#offline_image_preview_" + case_id).html("");
					// Add the content
					$("#offline_image_preview_" + case_id).append([
							$("<div/>").append([
							$("<strong/>", { text: "User: " }),
							$("<span/>", { text: channel })
						]),
							$("<div/>").append([
							$("<strong/>", { text: "Offline image: " })
						]),
							$("<div/>").append([
							$("<span/>", { text: "This user doesn't have an offline image." })
						]),
							$("<div/>").append([
							$("<hr/>")
						])
					]);
				}
			})
			.fail(function(jqXHR, textStatus, error) {
				var err = jqXHR.status + ", " + textStatus + ", " + error;
				console.log( "Request Failed: " + err );
				// Try again
				create_offline_image_preview(case_id, channel);
			});
	}
	else
	{
		if(via_autoload === false)
		{
			$("#offline_image_preview_" + case_id).html("");
		}
	}
}

function create_user_bio_preview(case_id, channel, via_autoload)
{
	var via_autoload = typeof via_autoload !== 'undefined' ? via_autoload : false;

	if($("#user_bio_preview_" + case_id).html().length === 0)
	{
		$("#user_bio_preview_" + case_id).html("Loading ...<hr>");
		$.getJSON("https://api.twitch.tv/kraken/users/" + channel + "?client_id=" + twitch_oauth_client_id + "&callback=?", function() {})
			.done(function(json) {
				if(typeof json.bio !== "undefined" && json.bio !== null && json.bio.length > 0) {
					// Clear it first
					$("#user_bio_preview_" + case_id).html("");
					// Add the content
					$("#user_bio_preview_" + case_id).append([
						// Upload and get report link button
						$("<span/>", { class: "pull-right", id: "user_bio_report_" + case_id, html: '<a class="btn btn-xs btn-default btn-link" href="https://www-origin.twitch.tv/' + channel + '/report_form?tos_ban=true&quick-select=channel_text-spam-spam_bots&placeholder[LOCATION_OF_CONTENT]=bio&description=' + encodeURIComponent(json.bio) + '" target="_blank" rel="noreferrer">Report the bio</a>' } ),
						// Normal Data output
							$("<div/>").append([
							$("<strong/>", { text: "User: " }),
							$("<span/>", { text: json.name })
						]),
							$("<div/>").append([
							$("<strong/>", { text: "Bio: " })
						]),
							$("<div/>").append([
							$("<span/>", { text: json.bio }),
						]),
							$("<div/>").append([
							$("<hr/>")
						])
					]);
				} else if(typeof json.error !== "undefined" && json.error !== null & typeof json.status !== "undefined" && json.status !== null && json.status == 422 && json.message.indexOf(" is unavailable") != -1)	{
					// Clear it first
					$("#user_bio_preview_" + case_id).html("");
					// Add the content
					$("#user_bio_preview_" + case_id).append([
							$("<div/>", { "class": case_id + "_user" }).append([
							$("<strong/>", { text: "User: " }),
							$("<span/>", { text: channel })
						]),
							$("<div/>").append([
							$("<span/>", { text: "This user is TOS'd." })
						]),
							$("<div/>").append([
							$("<hr/>")
						])
					]);
				} else if(typeof json.error !== "undefined" && json.error !== null & typeof json.status !== "undefined" && json.status !== null && json.status == 422 && json.message.indexOf(" is not available on Twitch") != -1) {
					// Clear it first
					$("#user_bio_preview_" + case_id).html("");
					// Add the content
					$("#user_bio_preview_" + case_id).append([
							$("<div/>").append([
							$("<strong/>", { text: "User: " }),
							$("<span/>", { text: channel })
						]),
							$("<div/>").append([
							$("<span/>", { text: "This user is a JTV account." })
						]),
							$("<div/>").append([
							$("<hr/>")
						])
					]);
				} else {
					// Clear it first
					$("#user_bio_preview_" + case_id).html("");
					// Add the content
					$("#user_bio_preview_" + case_id).append([
							$("<div/>").append([
							$("<strong/>", { text: "User: " }),
							$("<span/>", { text: channel })
						]),
							$("<div/>").append([
							$("<strong/>", { text: "Bio: " })
						]),
							$("<div/>").append([
							$("<span/>", { text: "This user doesn't have a bio." })
						]),
							$("<div/>").append([
							$("<hr/>")
						])
					]);
				}
			})
			.fail(function(jqXHR, textStatus, error) {
				var err = jqXHR.status + ", " + textStatus + ", " + error;
				console.log( "Request Failed: " + err );
				// Try again
				create_user_bio_preview(case_id, channel);
			});
	}
	else
	{
		if(via_autoload === false)
		{
			$("#user_bio_preview_" + case_id).html("");
		}
	}
}

function get_channel_status_after_stream_request_response(case_id, channel)
{
	$.getJSON("https://api.twitch.tv/kraken/channels/" + channel + "?client_id=" + twitch_oauth_client_id + "&callback=?", function() {
		})
		.done(function(json) {
			// Check if there is an existing cache entry which we update
			var delete_other = false;
			for (var i = 0; i < stream_preview_image_request_cache.length; i++) {
				if(typeof stream_preview_image_request_cache[i] !== "undefined" && stream_preview_image_request_cache[i]["channel"] == channel && delete_other === false)
				{
					stream_preview_image_request_cache[i]["requestPending"] = false;
					stream_preview_image_request_cache[i]["requestTime"] = Math.floor(Date.now() / 1000);
					stream_preview_image_request_cache[i]["json"] = json;
					// console.log("Updated old cache entry for " + channel);
					delete_other = true;
				}
				else if(typeof stream_preview_image_request_cache[i] !== "undefined" && stream_preview_image_request_cache[i]["channel"] == channel && delete_other === true)
				{
					// Delete double entry, how ever it even existed in the first place
					stream_preview_image_request_cache[i].delete;
					// console.log("Deleting double cache object for channel: " + channel);
				}
			}
			
			if(typeof json.error !== "undefined" && json.error !== null & typeof json.status !== "undefined" && json.status !== null && json.status == 422 && json.message.indexOf(" is unavailable") != -1) {
				// Get all cases for this channel
				$('.panel-default div[data-channel="' + channel + '"]')
					.each(function(i, e) {
						var e_caseID = e.id.split("_")[3];
						// Add a space so it doesn't get resolved multiple times
						$("#channel_status_" + e_caseID).html('<span class="label label-danger" style="margin-right: 5px;">TOS&#039;d</span> ');
						// Add a space so it's marked as done if it's empty
						if($("#stream_preview_image_" + e_caseID).html() == "")
						{
							$("#stream_preview_image_" + e_caseID).html(" ");
						}
						if(auto_resolve_TOSd_channels === true)
						{
							assign_and_resolve(e_caseID);
						}
					});
			}
			else if(typeof json.error !== "undefined" && json.error !== null & typeof json.status !== "undefined" && json.status !== null && json.status == 422 && json.message.indexOf(" is not available on Twitch") != -1) {
				// Get all cases for this channel
				$('.panel-default div[data-channel="' + channel + '"]')
					.each(function(i, e) {
						var e_caseID = e.id.split("_")[3];
						// Add a space so it doesn't get resolved multiple times
						$("#channel_status_" + e_caseID).html('<span class="label label-warning" style="margin-right: 5px;">JTV ACC</span> ');
						// Add a space so it's marked as done if it's empty
						if($("#stream_preview_image_" + e_caseID).html() == "")
						{
							$("#stream_preview_image_" + e_caseID).html(" ");
						}
					});
			}
			else
			{
				// Add a space so it doesn't get resolved multiple times
				$("#stream_preview_image_" + case_id).html(" ");
			}
		})
		.fail(function(jqXHR, textStatus, error) {
			var err = jqXHR.status + ", " + textStatus + ", " + error;
			console.log( "Request Failed: " + err );
			// Try again
			// get_channel_status_after_stream_request_response(case_id, channel);
		});
	
}

function get_stream_preview_image(case_id, channel)
{
	// Only do stuff if it's not already set
	if($("#stream_preview_image_" + case_id).length > 0 && $("#stream_preview_image_" + case_id).html().length == 0)
	{
		var do_new_request = true;
		var now = Math.floor(Date.now() / 1000);
		// Check if we have a cached entry for it already
		for (var i = 0; i < stream_preview_image_request_cache.length; i++) {
			if(typeof stream_preview_image_request_cache[i] !== "undefined" && stream_preview_image_request_cache[i]["channel"] == channel)
			{
				if(stream_preview_image_request_cache[i]["requestPending"] === false)
				{
					if(stream_preview_image_request_cache[i]["requestTime"] <= (now - randomIntFromInterval(30, 40))) // 30 - 40 seconds to span it out and possible stop lots of requests at once
					{
						// Cache is too old so we delete it and request a new one
						stream_preview_image_request_cache[i].delete;
						do_new_request = true;
						// console.log("Preview cache for " + channel + " was too old (" + (now - stream_preview_image_request_cache[i]["requestTime"]) +  ")");
					}
					else
					{
						// console.log("Preview cache for " + channel + " found (" + (now - stream_preview_image_request_cache[i]["requestTime"]) +  " seconds old)");
						// It's not too old so we can use it
						var json = stream_preview_image_request_cache[i]["json"];
						if(typeof json.stream !== "undefined" && json.stream !== null && typeof json.stream.preview.large !== "undefined" && json.stream.preview.large.length > 0)
						{
							var parser = document.createElement("a");
							parser.href = json.stream.preview.large;
							var preview_url = parser.pathname;
							if(preview_url.substr(0, 1) == "/") /* Fix for Internet Explorer */
							{
								preview_url = preview_url.substr(1);
							}
							$("#stream_preview_image_" + case_id).html('<img src="/stream-preview-image/' + preview_url + '?_=' + now + '" width="320" height="180" data-createdAt="' + moment(json.stream.created_at).unix() + '"><hr>');
						}
						else if(typeof json.error !== "undefined" && json.error !== null & typeof json.status !== "undefined" && json.status !== null && json.status == 422)
						{
							// Thanks to the api we can't know if it's a JTV account or if it's really TOS'd here
							$("#stream_preview_image_" + case_id).html(" ");
							stream_preview_image_request_cache[i]["requestPending"] = true;
							get_channel_status_after_stream_request_response(case_id, channel);
						}
						else if(typeof json.error !== "undefined" && json.error !== null & typeof json.status !== "undefined" && json.status !== null && json.status == 404)
						{
							$("#channel_status_" + case_id).html('<span class="label label-danger" style="margin-right: 5px;">Deleted</span> ');
						}
						do_new_request = false;
					}
				}
				else
				{
					do_new_request = false;
					// console.log("Already a request pending for channel: " + channel);
				}
				break;
			}
		}
		
		if(do_new_request === true)
		{
			var new_index = stream_preview_image_request_cache.length;
			stream_preview_image_request_cache[new_index] = new Object();
			stream_preview_image_request_cache[new_index]["channel"] = channel;
			stream_preview_image_request_cache[new_index]["requestPending"] = true;
			get_stream_preview_image_request(channel);
			// console.log("No preview cache for " + channel + " found");
		}
	}
}

function get_stream_preview_image_request(channel)
{
	$.getJSON("https://api.twitch.tv/kraken/streams/" + channel + "?client_id=" + twitch_oauth_client_id + "&callback=?", function() {
		})
		.done(function(json) {
			var cache_updated = false;
			// Save the json with the current time etc in the cache --
			// Check if there is an existing cache entry which we update
			var delete_other = false;
			for (var i = 0; i < stream_preview_image_request_cache.length; i++) {
				if(typeof stream_preview_image_request_cache[i] !== "undefined" && stream_preview_image_request_cache[i]["channel"] == channel && delete_other === false)
				{
					stream_preview_image_request_cache[i]["requestPending"] = false;
					stream_preview_image_request_cache[i]["requestTime"] = Math.floor(Date.now() / 1000);
					stream_preview_image_request_cache[i]["json"] = json;
					cache_updated = true;
					// console.log("Updated old cache entry for " + channel);
					delete_other = true;
				}
				else if(typeof stream_preview_image_request_cache[i] !== "undefined" && stream_preview_image_request_cache[i]["channel"] == channel && delete_other === true)
				{
					// Delete double entry, how ever it even existed in the first place
					stream_preview_image_request_cache[i].delete;
					// console.log("Deleting double cache object for channel: " + channel);
				}
			}
			
			// Create a new entry
			if(cache_updated === false)
			{
				var new_index = stream_preview_image_request_cache.length;
				stream_preview_image_request_cache[new_index] = new Object();
				stream_preview_image_request_cache[new_index]["channel"] = channel;
				stream_preview_image_request_cache[new_index]["requestPending"] = false;
				stream_preview_image_request_cache[new_index]["requestTime"] = Math.floor(Date.now() / 1000);
				stream_preview_image_request_cache[new_index]["json"] = json;
				// console.log("Created new cache entry for " + channel);
			}


			// Call the get_stream_preview_image() for every case with this channel
			$(".stream-preview-image").each(function(i, obj) {
				var caseID = obj.id.split("_")[3];
				var caseChannel = $("#" + obj.id).data("channel");
				if(caseChannel == channel)
				{
					get_stream_preview_image(caseID, channel);
				}
			});
			
		})
		.fail(function(jqXHR, textStatus, error) {
			var err = jqXHR.status + ", " + textStatus + ", " + error;
			console.log( "Request Failed: " + err );
			// Try again
			// get_stream_preview_image_request(channel);
		});
}

function update_all_stream_preview_images()
{
	$(".stream-preview-image").each(function(i, obj) {
		var caseID = obj.id.split("_")[3];
		var channel = $("#" + obj.id).data("channel");
		get_stream_preview_image(caseID, channel);
	});
}

function translate_popup(url, case_id){
	var popup_window = window.open(url, "Translate_popup_" + case_id, "width=865,height=475,resizable=yes");
	popup_window.focus();
	return false;
}

function check_for_reload() {
	// First update the html => head => title with the new case count
	update_case_number_in_title();
	// Now check if a page reload is needed
	if(case_counter <= 0)
	{
		setTimeout(function () { window.location.reload(); }, 1000);
	}
}

function remove_stream_preview(case_id, channel)
{
	$("#stream_preview_" + case_id).html("");
}

function remove_case(case_id)
{
	$("#desk_case_" + case_id).remove();
	$("#desk_case_" + case_id + "_hr").remove();
	
	if(fade_on_resolve_enabled === true) {
		// Remove it from the #airLock
		$("#airLock").children().filter("#desk_case_" + case_id).remove();
		
		// update page title with new case count, ignore hr elements
		window.case_counter = $(".col-md-9")
			.children()
			.filter(".panel")
			.length;
		// update_case_number_in_title();
		check_for_reload();
	}
}

function resolve_all_cases()
{
	// Not the best but atm this is always there so we can use it
	$(".stream-preview-image").each(function(i, obj) {
		var caseID = obj.id.split("_")[3];
		assign_and_resolve(caseID);
	});
}

function scroll_to_next_case(current_caseID)
{
	var use_next_ID = false;
	$(".col-md-9").children().filter(".panel").each(function(i, obj) {
		var caseID = obj.id.split("_")[2];
		if(use_next_ID === true)
		{
			// Check if the Resolve button is disable (only scroll to it if it isn't)
			if($("#assign_and_resolve_" + caseID).attr("disabled") === undefined)
			{
				// console.log("Scrolling to: " + obj.id);
				$("html, body").animate({ scrollTop: ($("#" + obj.id).offset().top - 75) }, 500);
				use_next_ID = false;
				return false;
			}
		}
		if(caseID == current_caseID)
		{
			use_next_ID = true;
		}
	});
}

function randomIntFromInterval(min, max)
{
	return Math.floor(Math.random()*(max-min+1)+min);
}

function check_case_distribution_last_update_difference(current)
{
	if(current != null && current != "null" && case_distribution_last_modified != null && case_distribution_last_modified != "null")
	{
		if(current > case_distribution_last_modified)
		{
			// check if there isn't already a box and if there isn't display one
			if($(".modal-dialog").length == 0)
			{
				bootbox.confirm('Another admin has enabled multi user mode, are you ready to reload the page?<br>If not please click &quot;Cancel&quot; and reload it manually after you&#039;re done with your current case.', function(result) { if(result === true) { window.location.reload(); } });
				// Set the page value to the current value so this popoup doesn't come up again unless the value changes again
				case_distribution_last_modified = current;
			}
		}
	}
}

function check_all_cases_report_description_height()
{
	// Check each report description
	$(".report-description").each(function(i, obj) {
		if($("#" + obj.id).data("heightchecked") !== "done")
		{
			var div_height = $("#" + obj.id).height();
			// Only do stuff if it's too large
			if(div_height > 180)
			{
				// console.log("#" + obj.id + " => " + $("#" + obj.id).height());
				// Limit the height of the report description div
				$("#" + obj.id).css({"overflow": "hidden", "text-overflow": "ellipsis", "max-height": "140px"});
				
				// Add the Show more button
				$("#" + obj.id).parent(".well").append('<span class="pull-left report-description-show-more"><a href="javascript:show_full_report_description(\'' + obj.id + '\');">Show more</a></span>');
			}
			
			// Mark as checked, but only if it's above 0 height (0 only happens in #airlock with fade resolve mode)
			if(div_height > 0)
			{
				$("#" + obj.id).data("heightchecked", "done");
			}
		}
	});
}

function show_full_report_description(ID)
{
	// Remove attributes which hide it
	$("#" + ID).css({"overflow": "", "max-height": "", "text-overflow": ""});
	
	// Remove Show more "button"
	$("#" + ID).closest(".well").children(".report-description-show-more").remove();
}

function set_distribution_weight(weight)
{
	window.location.href = window.location.protocol + "//" + window.location.host + window.location.pathname + "?set_distribution_weight=" + weight + "&csrf_token=" + csrf_token;
}

function isInt(n)
{
	return Number(n) === n && n % 1 === 0;
}

function isFloat(n)
{
	return n === Number(n) && n % 1 !== 0;
}

function get_vod_timestamp_url(case_id, channel, time)
{
	$.ajax({url:"vod_timestamp.php?channel=" + channel + "&time=" + time,
		type: "GET",
		cache: true,
		success:function(result, textStatus, jqXHR){
			$("#vod_link_" + case_id).html(result);
		},
		error:function(jqXHR, textStatus, errorThrown){
			// Error
			$("#vod_link_" + case_id).html("Error getting info from API.");
		},
	});
	$("#vod_link_" + case_id).html("Requesting ...");
}

function add_do_not_autoresolve_reporter(reporter)
{
	window.location.href = window.location.protocol + "//" + window.location.host + window.location.pathname + "?do_not_autoresolve_reporter_add=" + reporter + "&csrf_token=" + csrf_token;
}

function resolve_other_case_against_channel(channel, current_caseID)
{
	$('.panel-default div[data-channel="' + channel + '"]')
		.each(function(i, e) {
			var e_caseID = e.id.split("_")[3];
			// Only do something if it's not the current case
			if(e_caseID != current_caseID) {
				// Disable resolve other button
				$("#resolve_others_" + e_caseID).attr("disabled", "disabled");
				// Assign and resolve if it's not already resolved
				if($("#assign_and_resolve_" + e_caseID).attr("disabled") === undefined)
				{
					assign_and_resolve(e_caseID, false);
				}
			}
		});
}

function upload_channel_image(case_id, channel, image_type, image_url) {
	$.ajax({
		url: "screenshot_upload.php",
		type: "POST",
		data: { channel: channel, url: image_url, ajax: "true", csrf_token: csrf_token },
		success: function(result, textStatus, jqXHR) {
			$("#" + image_type + "_upload_" + case_id).html(result);
		},
		error: function(jqXHR, textStatus, errorThrown) {
			// Error
			$("#" + image_type + "_upload_" + case_id).html("There was some kind of error");
		},
	});
	$("#" + image_type + "_upload_" + case_id).html("Uploading ...");
}

function show_clips_timestamp_history(channel, timestamp) {
	bootbox.alert({
		size: 'large',
		message: '<iframe src="index.php?clips_overview=true&amp;iframe=true&amp;channel=' + channel + '&amp;timestamp=' + timestamp + '" height="500px" width="850px" frameborder="0"></iframe>'
	});
}

function show_clips_timestamp_history2(channel, emote_string) {
	bootbox.alert({
		size: 'large',
		message: '<iframe src="index.php?clips_overview=true&amp;iframe2=true&amp;channel=' + channel + '&amp;emote_string=' + emote_string + '" height="500px" width="850px" frameborder="0"></iframe>'
	});
}

function check_clip_status(case_id, emote_string) {
	// Clear the span so we don't do double requests
	$("#clip_status_" + case_id).html('');

	// Make the Ajax request to check the clip status
	$.ajax({
		url: "https://clips.twitch.tv/embed?clip=" + emote_string,
		type: "HEAD",
		cache: false,
		success: function(result, textStatus, jqXHR) {
			$("#clip_status_" + case_id).html('<span style="color:#000000; background-color:#009900">(OK)</span>');
		},
		error: function(jqXHR, textStatus, errorThrown) {
			if(jqXHR.status == 404) {
				$("#clip_status_" + case_id).html('<span style="color:#000000; background-color:#ff0000">(Disabled)</span>');
			} else {
				$("#clip_status_" + case_id).text("(Unknown error)");
			}
		}
	});
}

function show_clip_preview(case_id, emote_string) {
	if($("#clip_preview_" + case_id).html().length === 0)
	{
		$("#clip_preview_" + case_id).html('<b>Clip:</b> ' + emote_string + '<br><iframe src="https://clips.twitch.tv/embed?clip=' + emote_string + '&_=' + Math.floor(Date.now() / 1000) + '" height="360" width="640" frameborder="0" scrolling="no" allowfullscreen="true"></iframe><hr>');
	}
	else
	{
		$("#clip_preview_" + case_id).html('');
	}
}
