<?php
// äüö - UTF8 FTW
$display_login_form = false;
$login_error_msg = '';

// App Login redirect
if(isset($_GET['app_login']))
{
	try {
		$oauth = new OAuth($DESK_API_KEY, $DESK_API_SECRET, OAUTH_SIG_METHOD_HMACSHA1, OAUTH_AUTH_TYPE_URI);
		$request_token_info = $oauth->getRequestToken('https://help.twitch.tv/oauth/request_token', 'https://twitch-desk.rootonline.de/index.php');
		$_SESSION['oauth_secret'] = $request_token_info['oauth_token_secret'];
		if(isset($_GET['login_redirect']) && !empty($_GET['login_redirect']))
		{
			$_SESSION['oauth_login_redirect'] = $_GET['login_redirect'];
		}
		header('Location: https://help.twitch.tv/oauth/authorize?oauth_token='.$request_token_info['oauth_token'], true, 302);
		exit();
	} catch(OAuthException $E) {
		// print_r($E);
	}
}

if($_SERVER['REQUEST_METHOD'] == 'GET' && isset($_GET['oauth_token']) && !empty($_GET['oauth_token']) && isset($_GET['oauth_verifier']) && !empty($_GET['oauth_verifier']))
{
	// Get Access token now
	try {
		$oauth = new OAuth($DESK_API_KEY, $DESK_API_SECRET, OAUTH_SIG_METHOD_HMACSHA1);
		$oauth->setToken($_GET['oauth_token'], $_SESSION['oauth_secret']);
		$access_token_info = $oauth->getAccessToken('https://help.twitch.tv/oauth/access_token', '', $_GET['oauth_verifier']);	
		unset($_SESSION['oauth_secret']);
		// print_r($access_token_info);
		$oauth->setToken($access_token_info['oauth_token'], $access_token_info['oauth_token_secret']);
		
		$oauth_request_header = $oauth->getRequestHeader('GET', 'https://help.twitch.tv/api/v2/users/current');
	} catch(OAuthException $E) {
		// print_r($E);
	}
	
	$login_check = check_for_valid_login('oauth', $oauth_request_header);
	if($login_check === true)
	{
		$_SESSION['auth'] = true;
		$_SESSION['user']['oauth_token'] = $access_token_info['oauth_token'];
		$_SESSION['user']['oauth_token_secret'] = $access_token_info['oauth_token_secret'];
		$_SESSION['login_method'] = 'oauth';
		// Generate a new csrf_token, just to be safe
		$_SESSION['csrf_token'] = gen_csrf_token();

		$redirect_after_login_uri = '';
		if(isset($_SESSION['oauth_login_redirect']) && !empty($_SESSION['oauth_login_redirect']))
		{
			if($_SESSION['oauth_login_redirect'] == 'report_history')
			{
				$redirect_after_login_uri = str_replace('//', '/', dirname($_SERVER['PHP_SELF']).'/report_history.php');
			}
			elseif($_SESSION['oauth_login_redirect'] == 'do_not_ban_management')
			{
				$redirect_after_login_uri = str_replace('//', '/', dirname($_SERVER['PHP_SELF']).'/index.php?do_not_ban_management');
			}
			elseif($_SESSION['oauth_login_redirect'] == 'whisper_report_history')
			{
				$redirect_after_login_uri = str_replace('//', '/', dirname($_SERVER['PHP_SELF']).'/whisper_report_history.php');
			}
			elseif($_SESSION['oauth_login_redirect'] == 'partnerconduct_report')
			{
				$redirect_after_login_uri = str_replace('//', '/', dirname($_SERVER['PHP_SELF']).'/index.php?partnerconduct_report=true');
			}
			elseif($_SESSION['oauth_login_redirect'] == 'chatlogs')
			{
				$redirect_after_login_uri = str_replace('//', '/', dirname($_SERVER['PHP_SELF']).'/chatlogs/');
			}
		}
		
		if(isset($redirect_after_login_uri) && !empty($redirect_after_login_uri))
		{
			header('Location: '.$http_or_https.'://'.$_SERVER['HTTP_HOST'].$redirect_after_login_uri, true, 302);
		}
		else
		{
			header('Location: '.$http_or_https.'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
		}
		// Delete the session variable as it's not needed anymore
		if(isset($_SESSION['oauth_login_redirect'])) unset($_SESSION['oauth_login_redirect']);
		exit();
	}
	else
	{
		$login_error_msg .= '<div class="alert alert-danger alert-dismissible text-center" id="login_error" role="alert">'.PHP_EOL;
		$login_error_msg .= '<button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>'.PHP_EOL;
		$login_error_msg .= 'Something didn&#039;t work with oauth auth'.PHP_EOL;
		$login_error_msg .= '</div>'.PHP_EOL;
		$display_login_form = true;
	}
	
}


if($_SERVER['REQUEST_METHOD'] == 'POST' && $display_login_form === false)
{
	// CSRF Token check
	if((!isset($_SESSION['csrf_token']) || empty($_SESSION['csrf_token'])) || (!isset($_POST['csrf_token']) || empty($_POST['csrf_token'])) || validate_csrf_token($_POST['csrf_token']) === false)
	{
		$login_error_msg .= '<div class="alert alert-danger alert-dismissible text-center" id="login_error" role="alert">'.PHP_EOL;
		$login_error_msg .= 'Error verifying your request.'.PHP_EOL;
		$login_error_msg .= '</div>'.PHP_EOL;
		$display_login_form = true;
	}
	
	
	if(isset($_POST['email']) && !empty($_POST['email']))
	{
		$post_email = $_POST['email'];
	}
	else
	{
		$login_error_msg .= '<div class="alert alert-danger alert-dismissible text-center" id="login_error" role="alert">'.PHP_EOL;
		$login_error_msg .= 'You need to insert an email!'.PHP_EOL;
		$login_error_msg .= '</div>'.PHP_EOL;
		$display_login_form = true;
	}
	
	if(isset($_POST['pwd']) && !empty($_POST['pwd']))
	{
		$post_pwd = $_POST['pwd'];
	}
	else
	{
		$login_error_msg .= '<div class="alert alert-danger alert-dismissible text-center" id="login_error" role="alert">'.PHP_EOL;
		$login_error_msg .= 'You need to insert a password!'.PHP_EOL;
		$login_error_msg .= '</div>'.PHP_EOL;
		$display_login_form = true;
	}
	
	// Redirect after login
	$redirect_after_login_uri = '';
	if(isset($_POST['login_redirect']) && !empty($_POST['login_redirect']))
	{
		if($_POST['login_redirect'] == 'report_history')
		{
			$redirect_after_login_uri = str_replace('//', '/', dirname($_SERVER['PHP_SELF']).'/report_history.php');
		}
		elseif($_POST['login_redirect'] == 'do_not_ban_management')
		{
			$redirect_after_login_uri = str_replace('//', '/', dirname($_SERVER['PHP_SELF']).'/index.php?do_not_ban_management');
		}
		elseif($_POST['login_redirect'] == 'whisper_report_history')
		{
			$redirect_after_login_uri = str_replace('//', '/', dirname($_SERVER['PHP_SELF']).'/whisper_report_history.php');
		}
		elseif($_POST['login_redirect'] == 'partnerconduct_report')
		{
			$redirect_after_login_uri = str_replace('//', '/', dirname($_SERVER['PHP_SELF']).'/index.php?partnerconduct_report=true');
		}
		elseif($_POST['login_redirect'] == 'chatlogs')
		{
			$redirect_after_login_uri = str_replace('//', '/', dirname($_SERVER['PHP_SELF']).'/chatlogs/');
		}
	}
	elseif(isset($_GET['do_not_ban_management']))
	{
		$redirect_after_login_uri = str_replace('//', '/', dirname($_SERVER['PHP_SELF']).'/index.php?do_not_ban_management');
	}
	elseif(isset($_GET['partnerconduct_report']))
	{
		$redirect_after_login_uri = str_replace('//', '/', dirname($_SERVER['PHP_SELF']).'/index.php?partnerconduct_report=true');
	}
	
	// Only check if there are both email and pwd
	if($display_login_form === false)
	{
		$login_check = check_for_valid_login('user_pwd', $post_email.':'.$post_pwd);
		if($login_check === true)
		{
			$_SESSION['auth'] = true;
			$_SESSION['user']['email'] = $post_email;
			$_SESSION['user']['pwd'] = $post_pwd;
			$_SESSION['login_method'] = 'user_pwd';
			// Generate a new csrf_token, just to be safe
			$_SESSION['csrf_token'] = gen_csrf_token();
			
			if(isset($redirect_after_login_uri) && !empty($redirect_after_login_uri))
			{
				header('Location: '.$http_or_https.'://'.$_SERVER['HTTP_HOST'].$redirect_after_login_uri, true, 302);
			}
			else
			{
				header('Location: '.$http_or_https.'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
			}
			exit();
		}
		else
		{
			$login_error_msg .= '<div class="alert alert-danger alert-dismissible text-center" id="login_error" role="alert">'.PHP_EOL;
			$login_error_msg .= 'Wrong email / pwd combination'.PHP_EOL;
			$login_error_msg .= '</div>'.PHP_EOL;
			$display_login_form = true;
			// Generate a new csrf_token, just to be safe
			$_SESSION['csrf_token'] = gen_csrf_token();
		}
	}
	
}
else
{
	$display_login_form = true;
}

if($display_login_form === true)
{
?>
<!DOCTYPE HTML>
<html>
<head>
	<meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<meta name="referrer" content="origin">
	<link id="favicon" rel="icon" type="image/x-icon" href="favicon.ico">
	<link href="css/bootstrap.css" rel="stylesheet">
	<link href="css/signin.css" rel="stylesheet">
	<title>Twitch Desk - Login</title>
</head>
<body>
<?php
if($http_or_https == 'http')
{
?>
<div align="center">
<h2 style="color:red;">Warning:</h2> <h3>You are currently using this website on normal http, please change to <a href="<?php echo 'https://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']; ?>">https</a> to enable encryption.</h3>
</div>
<br>
<?php
}
?>
<div class="container">
<?php
if(isset($login_error_msg) && !empty($login_error_msg)) echo $login_error_msg;
?>
	<form id="form" action="" method="post" class="form-signin" role="form">
		<h2 class="form-signin-heading">Login with your Desk credentials</h2>
		<input type="hidden" name="csrf_token" value="<?php if(isset($_SESSION['csrf_token']) && !empty($_SESSION['csrf_token'])) echo $_SESSION['csrf_token']; ?>">
		<input type="hidden" name="login_redirect" value="<?php if(isset($_GET['login_redirect']) && !empty($_GET['login_redirect'])) echo rawurlencode($_GET['login_redirect']); ?>">
		<input class="form-control" type="email" name="email" value="" placeholder="Email address" id="email" size="40" autofocus required>
		<input class="form-control" type="password" name="pwd" value="" placeholder="Password" id="pwd" size="40" required>
		<button class="btn btn-lg btn-primary btn-block" type="submit">Sign in</button>
	</form>
	<div class="form-signin">
	<a class="btn btn-lg btn-primary btn-block" href="<?php echo $http_or_https.'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']; ?>?app_login<?php if(isset($_GET['login_redirect']) && !empty($_GET['login_redirect'])) { echo '&amp;login_redirect='.rawurlencode($_GET['login_redirect']); } elseif(isset($_GET['do_not_ban_management'])) { echo '&amp;login_redirect=do_not_ban_management'; } elseif(isset($_GET['partnerconduct_report'])) { echo '&amp;login_redirect=partnerconduct_report'; } ?>">Or Login via Desk APP</a>
	</div>
</div>
</body>
</html>
<?php
}
?>