<?php
//  UTF8-FTW
require_once __DIR__ . '/RedisSessionHandler.php';
$sessHandler = new RedisSessionHandler(null, null, null, null, true);
session_set_save_handler($sessHandler);
session_start();
// We don't change anything in the session so we can close writes here
@session_write_close();

require_once __DIR__ . '/_functions.php';

if(isset($_SERVER['HTTP_X_SCHEME']) && !empty($_SERVER['HTTP_X_SCHEME']))
{
	if($_SERVER['HTTP_X_SCHEME'] == 'https')
	{
		$http_or_https = 'https';
	}
	else
	{
		$http_or_https = 'http';
	}
}
elseif(!empty($_SERVER['HTTPS']))
{
	$http_or_https = 'https';
}
else
{
	$http_or_https = 'http';
}

if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true)
{
	// Connect to redis
	$redis = get_redis_connection()['redis'];
	$redis_is_connected = get_redis_connection()['redis_is_connected'];

	if(isset($_GET['twitch_name_violation_speed']) && is_numeric($_GET['twitch_name_violation_speed']) && intval($_GET['twitch_name_violation_speed']) >= 0 && intval($_GET['twitch_name_violation_speed']) <= 25000)
	{
		// Set to new value
		if($redis_is_connected === true)
		{
			$redis->set('twitch_name_violation_speed', intval($_GET['twitch_name_violation_speed']));
			header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['SERVER_NAME'].$_SERVER['PHP_SELF'], true, 302);
			exit();
		}
		else
		{
			echo 'Error setting new value. Please try again.'.PHP_EOL;
			exit();
		}
	}

	if($redis_is_connected === true)
	{
		$redis_twitch_name_violation_speed = 0;
		$redis_response = $redis->get('twitch_name_violation_speed');
		if($redis_response !== false)
		{
			$redis_twitch_name_violation_speed = $redis_response;
		}
	}
	else
	{
		exit();
	}
?><!DOCTYPE HTML>
<html>
<head>
<title>Name violation speed setter</title>
</head>
<body>
<form action="" method="get" oninput="display.value=twitch_name_violation_speed.value">
	<h2>Set your speed</h2><br>
	The number means accounts checked per min, 100 - 150 new accounts are created per min so it should be above that in normal conditions to not get behind real time.<br>
	(Doesn&#039;t hurt to set it to 25000 if we are all cought up)<br>
	While we are getting back to real speed ~1000 looks like a good value to not get too much reports at once but still finish the backlog in a reasonable time.<br>
	There is a hard limit of 3 reports per min, don&#039;t worry you won&#039;t get flooded.<br><br>
	<input id="twitch_name_violation_speed" name="twitch_name_violation_speed" type="range" min="0" max="25000" value="<?php echo $redis_twitch_name_violation_speed; ?>" step="25" style="width: 500px;"/>
	<output id="display"><?php echo $redis_twitch_name_violation_speed; ?></output><br><br>
	<button type="submit">Set</button>
</form>
<br><br>
</body>
</html>
<?php
}
elseif(isset($_GET['auth_token']) && $_GET['auth_token'] == 'bFndXkHLOpBftYr9OBT8w2CrNr_Xl-V1' && isset($_GET['get_speed']))
{
	// Connect to redis
	$redis = get_redis_connection()['redis'];
	$redis_is_connected = get_redis_connection()['redis_is_connected'];

	if($redis_is_connected === true)
	{
		$redis_twitch_name_violation_speed = 0;
		$redis_response = $redis->get('twitch_name_violation_speed');
		if($redis_response !== false)
		{
			$redis_twitch_name_violation_speed = $redis_response;
		}
		echo json_encode(array('twitch_name_violation_speed' => $redis_twitch_name_violation_speed));
	}
	else
	{
		echo json_encode(array('twitch_name_violation_speed' => 0));
	}
	exit();
}
else
{
	echo 'Authentication failed!<br>'.PHP_EOL;
	echo 'Please <a href="index.php">login</a>'.PHP_EOL;
}
