<?php
// äüö - UTF8 FTW
// Only allow including of this file
if(preg_match('/session_stats_history\.php/i', $_SERVER['PHP_SELF']) === 1)
{
	exit();
}

$mysqli = get_mysql_connection();
?><!DOCTYPE HTML>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<title>Session stats history</title>
</head>
<body>
Table is sorted by recent to oldest start time.
<br>
<table border="1">
<thead>
	<tr>
		<th style="max-width:120px;width:120px;text-align:left;">Admin</th>
		<th>Unique cases</th>
		<th>Report cases</th>
		<th>Whisper cases</th>
		<th>Channel feed cases</th>
		<th>Clip cases</th>
		<th>Other cases</th>
		<th>Auto resolved by channel</th>
		<th>Auto resolved by reporter</th>
		<th>Auto resolved own strikes</th>
		<th>Auto resolved by age</th>
		<th>Resolved cases</th>
		<th>Banned cases</th>
		<th>PM checked cases</th>
		<th style="max-width:230px;width:230px;text-align:center;">Shift start time</th>
		<th style="max-width:230px;width:230px;text-align:center;">Shift end time</th>
	</tr>
</thead>
<tbody>
<?php
// Show all admin to these 3 users
if(in_array($_SESSION['user']['desk_ID'], array(21812684 /* CommanderRoot */, 21812880 /* S0N0S */, 23803097 /* Simple */)))
{
	$result = $mysqli->query("SELECT * FROM `session_stats` ORDER BY `ID` DESC");
}
else
{
	// Show only their own histories
	$result = $mysqli->query("SELECT * FROM `session_stats` WHERE `admin_deskID` = '".$mysqli->real_escape_string($_SESSION['user']['desk_ID'])."' ORDER BY `ID` DESC");
}

if($result && $result->num_rows > 0)
{
	while($row = $result->fetch_assoc())
	{
		echo '<tr>';
		echo '<td style="max-width:120px;width:120px;text-align:left;">'.htmlspecialchars($row['admin_username'], ENT_QUOTES|ENT_HTML5).'</td>';
		echo '<td>'.htmlspecialchars($row['unique_cases'], ENT_QUOTES|ENT_HTML5).'</td>';
		echo '<td>'.htmlspecialchars($row['report_cases'], ENT_QUOTES|ENT_HTML5).'</td>';
		echo '<td>'.htmlspecialchars($row['whisper_cases'], ENT_QUOTES|ENT_HTML5).'</td>';
		echo '<td>'.htmlspecialchars($row['channel_feed_cases'], ENT_QUOTES|ENT_HTML5).'</td>';
		echo '<td>'.htmlspecialchars($row['clip_cases'], ENT_QUOTES|ENT_HTML5).'</td>';
		echo '<td>'.htmlspecialchars($row['other_cases'], ENT_QUOTES|ENT_HTML5).'</td>';
		echo '<td>'.htmlspecialchars($row['autoresolve_by_channel'], ENT_QUOTES|ENT_HTML5).'</td>';
		echo '<td>'.htmlspecialchars($row['autoresolve_by_reporter'], ENT_QUOTES|ENT_HTML5).'</td>';
		echo '<td>'.htmlspecialchars($row['autoresolve_own_strike'], ENT_QUOTES|ENT_HTML5).'</td>';
		echo '<td>'.htmlspecialchars($row['autoresolve_by_age'], ENT_QUOTES|ENT_HTML5).'</td>';
		echo '<td>'.htmlspecialchars($row['resolved_cases'], ENT_QUOTES|ENT_HTML5).'</td>';
		echo '<td>'.htmlspecialchars($row['banned_cases'], ENT_QUOTES|ENT_HTML5).'</td>';
		echo '<td>'.htmlspecialchars($row['pm_checked_cases'], ENT_QUOTES|ENT_HTML5).'</td>';
		echo '<td style="max-width:230px;width:230px;text-align:right;">'.htmlspecialchars(time_to_pst_time($row['session_start_time']), ENT_QUOTES|ENT_HTML5).'</td>';
		if(strtotime($row['session_end_time']) > 0)
		{
			echo '<td style="max-width:230px;width:230px;text-align:right;">'.htmlspecialchars(time_to_pst_time($row['session_end_time']), ENT_QUOTES|ENT_HTML5).'</td>';
		}
		echo '</tr>'.PHP_EOL;

    }
    /* free result set */
    $result->close();
}
?>
</tbody>
</table>
<br>
</body>
</html>