<?php
// äüö - UTF8 FTW
// Only allow including of this file
if(preg_match('/target_user_whisper_report_history\.php/i', $_SERVER['PHP_SELF']))
{
	exit();
}

function get_history_overview($target_user)
{
	$ch = &$GLOBALS['global_curl'];
	$page = 1;
	$per_page = 25;
	
	// Search for history of the user as non-partner and partner
	$request_url = 'https://help.twitch.tv/api/v2/cases/search?q='.rawurlencode('group:"Whisper Reports" casesubject:("Whisper Report concerning '.$target_user.'" OR "Whisper Report concerning \[P\] '.$target_user.'")').'&sort_field=created_at&sort_direction=desc&per_page='.$per_page.'&page='.$page;

	apply_curl_defaults($ch);
	curl_setopt($ch, CURLOPT_URL, $request_url);
	// A bit higher timeout here because if we have a lot of open / new cases it can take longer than ususal
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
	if(isset($_SESSION['login_method']) && $_SESSION['login_method'] === 'oauth')
	{
		$oauth_request_header = $GLOBALS['global_oauth']->getRequestHeader('GET', $request_url);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/json', 'Authorization: '.$oauth_request_header));
	}
	$curl_output = curl_exec($ch);
	$curl_info = curl_getinfo($ch);
	if($curl_output === false)
	{
		echo 'Curl error on "'.$curl_info['url'].'" => '.curl_error($ch);
		
		// Add a 5 sec javascript auto reload here so it still continue to update
		echo PHP_EOL.'<script type="text/javascript">setTimeout(function () { window.location.reload(); }, 5000);</script>';
		exit();
	}
	else
	{
		$curl_parse = parse_desk_curl_output($curl_output);
		if($curl_info['http_code'] >= 200 && $curl_info['http_code'] <= 204)
		{
			// Request was successful
		}
		elseif($curl_info['http_code'] == 304)
		{
			// Never happens as I don't use ETAG's but if I did it would be successful
		}
		elseif($curl_info['http_code'] == 429)
		{
			echo 'DESK: hit rate limit on URL: '.$curl_info['url'];
			
			// Add a 10 sec javascript auto reload here so it still continue to update
			echo PHP_EOL.'<script type="text/javascript">setTimeout(function () { window.location.reload(); }, 10000);</script>';
			exit();
		}
		elseif($curl_info['http_code'] == 401)
		{
			echo 'Invalid desk credentials!<br>'.PHP_EOL;
			do_logout(false);
		}
		else
		{
			// Some other HTTP error => Try again
			echo 'CURL: HTTP ERROR: '.$curl_info['url'].PHP_EOL.print_r($curl_parse, true);
			
			// Add a 5 sec javascript auto reload here so it still continue to update
			echo PHP_EOL.'<script type="text/javascript">setTimeout(function () { window.location.reload(); }, 5000);</script>';
			exit();
		}
		
		$GLOBALS['curl_request_info_string'] .= '<!-- '.htmlspecialchars($curl_info['url'], ENT_QUOTES|ENT_HTML5).' took => DNS: '.htmlspecialchars($curl_info['namelookup_time'], ENT_QUOTES|ENT_HTML5).' / Connect: '.htmlspecialchars($curl_info['connect_time'], ENT_QUOTES|ENT_HTML5).' / Total: '.htmlspecialchars($curl_info['total_time'], ENT_QUOTES|ENT_HTML5).' seconds -->'.PHP_EOL;
		$GLOBALS['global_api_request_time'] = $GLOBALS['global_api_request_time'] + $curl_info['total_time'];

		$json_decode = json_decode($curl_parse['content'], true);
		if($json_decode !== NULL)
		{
			if(!isset($case_id_array)) $case_id_array = array();
			foreach($json_decode['_embedded']['entries'] as $case)
			{
				// Check if it's really against the user and Desk isn't giving us wrong data
				if(trim($case['subject']) == 'Whisper Report concerning '.$target_user || trim($case['subject']) == 'Whisper Report concerning [P] '.$target_user)
				{
					$case_id_array[] = $case['id'];
				}
				else
				{
					$GLOBALS['curl_request_info_string'] .= '<!-- Not the user I searched for: "'.htmlspecialchars($case['subject'], ENT_QUOTES|ENT_HTML5).'" -->'.PHP_EOL;
				}
			}
		}
		else
		{
			echo 'Json decode error while getting history overview!<br>'.PHP_EOL;
			exit();
		}
		
		return $case_id_array;
	}
}

function get_and_gen_history($cases_overview)
{
	$history_string = '';
	$ch = &$GLOBALS['global_curl'];
	if($GLOBALS['use_redis'] === true)
	{
		// Connect to redis
		$redis = get_redis_connection()['redis'];
		$redis_is_connected = get_redis_connection()['redis_is_connected'];
		$redis_ttl = 600;
		$redis_messageID_ttl = (3 * 24 * 60 * 60);
		$redis_prefix = 'twitch-desk-case:';
		if($redis_is_connected === true)
		{
			$redis->setOption(Redis::OPT_PREFIX, $redis_prefix);
		}
	}
	
	foreach($cases_overview as $caseID)
	{
		// Check if it's already cached
		if(isset($json_decode)) unset($json_decode);
		if($GLOBALS['use_redis'] === true)
		{
			if($redis_is_connected === true)
			{
				$redis_response_time_start = microtime(true);
				$redis_response = $redis->get($caseID);
				if($redis_response !== false)
				{
					$json_decode = $redis_response;
					// Reset the TTL of the key
					$redis->setTimeout($caseID, $redis_ttl);
					$GLOBALS['curl_request_info_string'] .= '<!-- Found case message for ID: "'.htmlspecialchars($caseID, ENT_QUOTES|ENT_HTML5).'" in cache (redis ('.(microtime(true) - $redis_response_time_start).')) -->'.PHP_EOL;
				}
				unset($redis_response);
			}
		}

		if(!isset($json_decode) || empty($json_decode))
		{
			redo_request:
			$request_url = 'https://help.twitch.tv/api/v2/cases/'.$caseID.'/message?fields=subject,headers,body_text,body';
			apply_curl_defaults($ch);
			curl_setopt($ch, CURLOPT_URL, $request_url);
			if(isset($_SESSION['login_method']) && $_SESSION['login_method'] === 'oauth')
			{
				$oauth_request_header = $GLOBALS['global_oauth']->getRequestHeader('GET', $request_url);
				curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/json', 'Authorization: '.$oauth_request_header));
			}
			$curl_output = curl_exec($ch);
			$curl_info = curl_getinfo($ch);
			if($curl_output === false)
			{
				echo 'Curl error on "'.$curl_info['url'].'" => '.curl_error($ch).'<br>'.PHP_EOL;
				goto redo_request;
			}

			$curl_parse = parse_desk_curl_output($curl_output);
			if($curl_info['http_code'] >= 200 && $curl_info['http_code'] <= 204)
			{
				// Request was successful
			}
			elseif($curl_info['http_code'] == 304)
			{
				// Never happens as I don't use ETAG's but if I did it would be successful
			}
			elseif($curl_info['http_code'] == 429)
			{
				header('HTTP/1.1 429 Desk Rate Limit', true, 429);
				echo 'DESK: hit rate limit on URL: '.$curl_info['url'];
				
				// Add a 5 sec javascript auto reload here so it still continue to update
				echo PHP_EOL.'<script type="text/javascript">setTimeout(function () { window.location.reload(); }, 5000);</script>';
				exit();
			}
			elseif($curl_info['http_code'] == 401)
			{
				echo 'Invalid desk credentials!<br>'.PHP_EOL;
				do_logout(false);
			}
			else
			{
				// Some other HTTP error => Try again
				echo 'CURL: HTTP ERROR: '.$curl_info['url'].PHP_EOL.print_r($curl_parse, true);

				// Add a 5 sec javascript auto reload here so it still continue to update
				echo PHP_EOL.'<script type="text/javascript">setTimeout(function () { window.location.reload(); }, 5000);</script>';
				exit();
			}

			$GLOBALS['curl_request_info_string'] .= '<!-- '.htmlspecialchars($curl_info['url'], ENT_QUOTES|ENT_HTML5).' took => DNS: '.htmlspecialchars($curl_info['namelookup_time'], ENT_QUOTES|ENT_HTML5).' / Connect: '.htmlspecialchars($curl_info['connect_time'], ENT_QUOTES|ENT_HTML5).' / Total: '.htmlspecialchars($curl_info['total_time'], ENT_QUOTES|ENT_HTML5).' seconds -->'.PHP_EOL;
			$GLOBALS['global_api_request_time'] = $GLOBALS['global_api_request_time'] + $curl_info['total_time'];

			$json_decode = json_decode($curl_parse['content'], true);

			if($GLOBALS['use_redis'] === true)
			{
				if($redis_is_connected === true && $json_decode !== NULL)
				{
					$redis->setex($caseID, $redis_ttl, $json_decode);
				}
			}
		}

		if($json_decode !== NULL)
		{
			if(!isset($json_decode['body_text']) || empty($json_decode['body_text']))
			{
				$mail_body_content = $json_decode['body'];
			}
			else
			{
				$mail_body_content = $json_decode['body_text'];
			}

			// Only add the case to the array if it's not set to false because another action was already taken
			$history_string .= 'Case ID: '.$caseID.'<br>'.PHP_EOL.nl2br(htmlspecialchars($mail_body_content, ENT_QUOTES|ENT_HTML5), false).'<br>'.PHP_EOL.'<br>'.PHP_EOL.'<hr>'.PHP_EOL.'<br>'.PHP_EOL;
		}
		else
		{
			echo 'Json decode error while getting case!<br>'.PHP_EOL;
			goto redo_request;
		}
	}

	return $history_string;
}

if(isset($_GET['target_user']) && !empty($_GET['target_user']))
{
	// Get history for this user
	$history_caseID_array = get_history_overview(strtolower(trim($_GET['target_user'])));
	if(count($history_caseID_array) > 0)
	{
		// Request each caseID
		$history_output_string = get_and_gen_history($history_caseID_array);
	}
	else
	{
		$history_output_string = 'No whisper report history found against '.htmlspecialchars(strtolower(trim('"'.$_GET['target_user'].'".')), ENT_QUOTES|ENT_HTML5).PHP_EOL;
	}
	unset($history_caseID_array);
}

?><!DOCTYPE HTML>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<title>Whisper report history for target checker</title>
</head>
<body>
<h2>Check whisper reports against target</h2>
<form id="form" action="" method="GET">
<input type="hidden" name="target_user_whisper_report_history" value="true">
<table>
<tr>
	<td>
		Target: <input type="text" name="target_user" size="35" placeholder="username" value="<?php if(isset($_GET['target_user']) && !empty(trim($_GET['target_user']))) echo htmlspecialchars(strtolower(trim($_GET['target_user'])), ENT_QUOTES|ENT_HTML5); ?>" required>
	</td>
</tr>
<tr>
	<td>
		<br>
		<input type="Submit" value="Check" />
	</td>
</tr>
</table>
</form>
<br>
<?php
if(isset($history_output_string) && !empty($history_output_string))
{
?>
<br>
<h3>Whisper report history:</h3>
<?php
	echo $history_output_string.PHP_EOL;
}
if(isset($_SESSION['show_debug']) && $_SESSION['show_debug'] === true)
{
	if(isset($curl_request_info_string) && !empty($curl_request_info_string)) echo PHP_EOL.$curl_request_info_string;
}
?>
</body>
</html>