<?php
// ÜÖÄ UTF8-FTW
ignore_user_abort(false);

require_once __DIR__ . '/RedisSessionHandler.php';
$sessHandler = new RedisSessionHandler(null, null, null, null, true);
session_set_save_handler($sessHandler);
session_start();
// We don't change anything in the session so we can close writes here
@session_write_close();

// header('Cache-Control: no-store, no-cache, must-revalidate');
// header('Expires: Sat, 26 Jul 1997 05:00:00 GMT');
// header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
// header('Pragma: no-cache');

if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true)
{
	if(isset($_GET['channel']) && !empty($_GET['channel']) && isset($_GET['time']) && !empty($_GET['time']))
	{
		if(is_numeric($_GET['time']))
		{
			$time = intval($_GET['time']);
		}
		else
		{
			$time = strtotime(str_replace(' ', '+', $_GET['time']));
		}
		$request_url = 'http://andrewf-clockvod-test-987199465.us-west-2.elb.amazonaws.com/clockvod/'.rawurlencode($_GET['channel']).'/'.date('c', $time);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $request_url);
		curl_setopt($ch, CURLOPT_TIMEOUT, 20);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
		curl_setopt($ch, CURLOPT_AUTOREFERER, false);
		curl_setopt($ch, CURLOPT_USERAGENT, 'Better Desk by commanderroot@twitch.tv');
		curl_setopt($ch, CURLOPT_ENCODING, '');
		$curl_exec = curl_exec($ch);
		$curl_info = curl_getinfo($ch);
		// print_r($curl_info);
		
		if($curl_info['http_code'] == 0)
		{
			echo 'Error: Could not connect to API.'.PHP_EOL;
		}
		elseif($curl_info['http_code'] == 302)
		{
			echo '<a href="'.str_replace(array('http://www.twitch.tv/', 'https://www.twitch.tv/', 'https://secure.twitch.tv/'), 'https://www-origin.twitch.tv/', $curl_info['redirect_url']).'" target="_blank" rel="noreferrer">'.htmlspecialchars(str_replace(array('http://www.twitch.tv/', 'https://www.twitch.tv/', 'https://secure.twitch.tv/'), 'https://www-origin.twitch.tv/', $curl_info['redirect_url']), ENT_QUOTES|ENT_HTML5).'</a>'.PHP_EOL;
		}
		elseif($curl_info['http_code'] == 404)
		{
			echo 'No VOD found for this time.'.PHP_EOL;
		}
		else
		{
			echo 'Received server error '.$curl_info['http_code'].' from the API.'.PHP_EOL;
		}
	}
	else
	{
		echo 'No channel or time provided.'.PHP_EOL;
	}
}
else
{
	echo 'Authentication failed!'.PHP_EOL;
}
?>