<?php
// üöä-UTF8 FTW
ini_set('max_execution_time', '0');

function apply_curl_defaults(&$ch)
{
	// curl_reset($ch);
	curl_setopt($ch, CURLOPT_TIMEOUT, 15);
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
	curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:'));
	curl_setopt($ch, CURLOPT_ENCODING, '');
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
	curl_setopt($ch, CURLOPT_USERAGENT, 'Better Desk by commanderroot@twitch.tv');
	// SSL stuff
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
}

function do_spade_request($json)
{
	$base64 = base64_encode($json);
	curl_setopt($GLOBALS['ch'], CURLOPT_URL, 'https://spade.twitch.tv/?data='.$base64);

	before_request:
	$curl_output = curl_exec($GLOBALS['ch']);
	$curl_info = curl_getinfo($GLOBALS['ch']);
	if($curl_info['http_code'] != 204)
	{
		echo PHP_EOL;
		print_r($curl_info);
		echo PHP_EOL;
		sleep(2);
		// Retry
		goto before_request;
	}
}

function clear_null_properties($array)
{
	foreach($array['properties'] as $id => $property)
	{
		if(is_null($property))
		{
			// Remove if it is null
			unset($array['properties'][$id]);
		}
	}

	return $array;
}

function string_to_boolean($string)
{
	if($string == 'true')
	{
		return true;
	}
	elseif($string == 'false')
	{
		return false;
	}
	else
	{
		return null;
	}
}

function gen_report_mails_json($array)
{
	$return = array('event' => 'user_grief_report', 'properties' => array());

	if($array['desk_caseID'] !== null)
	{
		$return['properties']['desk_case_id'] = intval($array['desk_caseID']);
	}

	$return['properties']['reporting_user_id'] = intval($array['from_user_ID']);
	$return['properties']['reporting_user_type'] = $array['from_user_type'];

	$return['properties']['reported_user_login'] = $array['target_user'];
	$return['properties']['reported_user_is_partner'] = string_to_boolean($array['target_is_partner']);

	if($array['is_strike'] == 'true')
	{
		$return['properties']['is_strike'] = string_to_boolean($array['is_strike']);
	}
	$return['properties']['reported_content_type'] = $array['content'];
	$return['properties']['report_reason'] = $array['report_reason'];
	$return['properties']['report_reason_detailed'] = $array['report_reason_detailed'];
	$return['properties']['report_time'] = intval($array['report_time']);
	$return['properties']['report_description'] = $array['report_description'];

	$return = clear_null_properties($return);

	return json_encode($return, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
}

function gen_channel_feed_json($array)
{
	$return = array('event' => 'user_channel_feed_report', 'properties' => array());

	if($array['desk_caseID'] !== null)
	{
		$return['properties']['desk_case_id'] = intval($array['desk_caseID']);
	}

	$return['properties']['type'] = $array['type'];

	$return['properties']['reporting_user_id'] = intval($array['from_user_ID']);

	$return['properties']['reported_user_id'] = intval($array['target_user_ID']);

	$return['properties']['feed_owner_user_id'] = intval($array['feed_owner_user_ID']);

	$return['properties']['report_reason'] = $array['report_reason'];
	$return['properties']['post_id'] = $array['post_ID'];
	$return['properties']['report_time'] = intval($array['report_time']);

	$return = clear_null_properties($return);

	return json_encode($return, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
}

function gen_clips_json($array)
{
	$return = array('event' => 'user_clip_report', 'properties' => array());

	if($array['desk_caseID'] !== null)
	{
		$return['properties']['desk_case_id'] = intval($array['desk_caseID']);
	}

	$return['properties']['reporting_user_id'] = intval($array['from_user_ID']);

	$return['properties']['clip_broadcaster_login'] = $array['target_user_username'];

	$return['properties']['clip_slug'] = $array['clip_emotestring'];

	$return['properties']['report_reason'] = $array['report_reason'];
	$return['properties']['report_time'] = intval($array['report_time']);
	$return['properties']['report_description'] = $array['report_description'];

	$return = clear_null_properties($return);

	return json_encode($return, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
}

function gen_whisper_json($array)
{
	$return = array('event' => 'user_whisper_report', 'properties' => array());

	if($array['desk_caseID'] !== null)
	{
		$return['properties']['desk_case_id'] = intval($array['desk_caseID']);
	}

	$return['properties']['reporting_user_id'] = intval($array['from_user_ID']);

	$return['properties']['reported_user_id'] = intval($array['target_user_ID']);
	$return['properties']['reported_user_is_partner'] = string_to_boolean($array['target_is_partner']);

	$return['properties']['report_reason'] = $array['report_reason'];
	$return['properties']['report_time'] = intval($array['report_time']);

	$return = clear_null_properties($return);

	return json_encode($return, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
}


$mysqli = new mysqli('betterdesk-mysql.cunim1xnmwzu.us-west-1.rds.amazonaws.com', 'twitch_reports_write', 'QjghE4wuAN8CP55g', 'twitch_reports');
if($mysqli->connect_errno)
{
	// echo 'Report DB is currently not available.';
	echo 'Connection to database failed: '.$mysqli->connect_error;
	exit();
}
if(!$mysqli->set_charset('utf8mb4')) {
	printf("Error loading character set utf8mb4: %s\n", $mysqli->error);
	exit();
} else {
	printf("Current character set: %s\n", $mysqli->character_set_name());
}

$ch = curl_init();
apply_curl_defaults($ch);


echo 'Starting reports / strikes ...'.PHP_EOL;
$last_report_mails_query = $mysqli->query("SELECT `last_added_id` FROM `status` WHERE `ID` = '3' ");
if($last_report_mails_query->num_rows > 0)
{
	while($row = $last_report_mails_query->fetch_assoc())
	{
		$last_report_mails_ID = $row['last_added_id'];
	}
	$last_report_mails_query->close();
}
else
{
	echo 'Couldn\'t get last id for report_mails from DB'.PHP_EOL;
	exit();
}

// Select data in chunks of 100
$found_data = false;
do
{
	$report_query = $mysqli->query("SELECT `ID`, `desk_caseID`, `from_user_ID`, `from_user_type`, `is_strike`, `target_user`, `target_is_partner`, `content`, `report_reason`, `report_reason_detailed`, UNIX_TIMESTAMP(`report_time`) as `report_time`, SUBSTRING(`report_description`, 1, 20000) as `report_description` FROM `report_mails` WHERE `ID` > '".$mysqli->real_escape_string($last_report_mails_ID)."' ORDER BY `ID` ASC LIMIT 100");
	if($report_query->num_rows > 0)
	{
		while($row = $report_query->fetch_assoc())
		{
			echo $row['ID'];
			// Update the last ID var
			$last_report_mails_ID = $row['ID'];

			$json = gen_report_mails_json($row);

			// Make the Spade request
			do_spade_request($json);
			echo '. ';
		}
		$found_data = true;
	}
	else
	{
		$found_data = false;
	}
	$report_query->close();

	// Update the DB entry (just to "quick" save)
	$mysqli->query("UPDATE `status` SET `last_added_id` = '".$mysqli->real_escape_string($last_report_mails_ID)."' WHERE `ID` = '3' ");
} while ($found_data === true);
// ------------------------------------------------------------------------------------------------------------------------------------------------------

/* Spade already has feed reports from another source
echo PHP_EOL.PHP_EOL.'Starting channel_feed_reports ...'.PHP_EOL;
$last_channel_feed_reports_query = $mysqli->query("SELECT `last_added_id` FROM `status` WHERE `ID` = '4' ");
if($last_channel_feed_reports_query->num_rows > 0)
{
	while($row = $last_channel_feed_reports_query->fetch_assoc())
	{
		$last_channel_feed_reports_ID = $row['last_added_id'];
	}
	$last_channel_feed_reports_query->close();
}
else
{
	echo 'Couldn\'t get last id for channel_feed_reports from DB'.PHP_EOL;
	exit();
}

// Select data in chunks of 100
$found_data = false;
do
{
	$report_query = $mysqli->query("SELECT `ID`, `desk_caseID`, `type`, `from_user_ID`, `target_user_ID`, `feed_owner_user_ID`, `report_reason`, `post_ID`, UNIX_TIMESTAMP(`report_time`) as `report_time` FROM `channel_feed_reports` WHERE `ID` > '".$mysqli->real_escape_string($last_channel_feed_reports_ID)."' ORDER BY `ID` ASC LIMIT 100");
	if($report_query->num_rows > 0)
	{
		while($row = $report_query->fetch_assoc())
		{
			echo $row['ID'];
			// Update the last ID var
			$last_channel_feed_reports_ID = $row['ID'];

			$json = gen_channel_feed_json($row);

			// Make the Spade request
			do_spade_request($json);
			echo '. ';
		}
		$found_data = true;
	}
	else
	{
		$found_data = false;
	}
	$report_query->close();

	// Update the DB entry (just to "quick" save)
	$mysqli->query("UPDATE `status` SET `last_added_id` = '".$mysqli->real_escape_string($last_channel_feed_reports_ID)."' WHERE `ID` = '4' ");
} while ($found_data === true);
// ------------------------------------------------------------------------------------------------------------------------------------------------------
*/

echo PHP_EOL.PHP_EOL.'Starting clip_reports ...'.PHP_EOL;
$last_clip_reports_query = $mysqli->query("SELECT `last_added_id` FROM `status` WHERE `ID` = '5' ");
if($last_clip_reports_query->num_rows > 0)
{
	while($row = $last_clip_reports_query->fetch_assoc())
	{
		$last_clip_reports_ID = $row['last_added_id'];
	}
	$last_clip_reports_query->close();
}
else
{
	echo 'Couldn\'t get last id for clip_reports from DB'.PHP_EOL;
	exit();
}

// Select data in chunks of 100
$found_data = false;
do
{
	$report_query = $mysqli->query("SELECT `ID`, `desk_caseID`, `from_user_ID`, `target_user_username`, `clip_emotestring`, `report_reason`, SUBSTRING(`report_description`, 1, 20000) as `report_description`, UNIX_TIMESTAMP(`report_time`) as `report_time` FROM `clip_reports` WHERE `ID` > '".$mysqli->real_escape_string($last_clip_reports_ID)."' ORDER BY `ID` ASC LIMIT 100");
	if($report_query->num_rows > 0)
	{
		while($row = $report_query->fetch_assoc())
		{
			echo $row['ID'];
			// Update the last ID var
			$last_clip_reports_ID = $row['ID'];

			$json = gen_clips_json($row);

			// Make the Spade request
			do_spade_request($json);
			echo '. ';
		}
		$found_data = true;
	}
	else
	{
		$found_data = false;
	}
	$report_query->close();

	// Update the DB entry (just to "quick" save)
	$mysqli->query("UPDATE `status` SET `last_added_id` = '".$mysqli->real_escape_string($last_clip_reports_ID)."' WHERE `ID` = '5' ");
} while ($found_data === true);
// ------------------------------------------------------------------------------------------------------------------------------------------------------


echo PHP_EOL.PHP_EOL.'Starting whisper_reports ...'.PHP_EOL;
$last_whisper_reports_query = $mysqli->query("SELECT `last_added_id` FROM `status` WHERE `ID` = '6' ");
if($last_whisper_reports_query->num_rows > 0)
{
	while($row = $last_whisper_reports_query->fetch_assoc())
	{
		$last_whisper_reports_ID = $row['last_added_id'];
	}
	$last_whisper_reports_query->close();
}
else
{
	echo 'Couldn\'t get last id for whisper_reports from DB'.PHP_EOL;
	exit();
}

// Select data in chunks of 100
$found_data = false;
do
{
	$report_query = $mysqli->query("SELECT `ID`, `desk_caseID`, `from_user_ID`, `target_user_ID`, `target_is_partner`, `report_reason`, UNIX_TIMESTAMP(`report_time`) as `report_time` FROM `whisper_reports` WHERE `ID` > '".$mysqli->real_escape_string($last_whisper_reports_ID)."' ORDER BY `ID` ASC LIMIT 100");
	if($report_query->num_rows > 0)
	{
		while($row = $report_query->fetch_assoc())
		{
			echo $row['ID'];
			// Update the last ID var
			$last_whisper_reports_ID = $row['ID'];

			$json = gen_whisper_json($row);

			// Make the Spade request
			do_spade_request($json);
			echo '. ';
		}
		$found_data = true;
	}
	else
	{
		$found_data = false;
	}
	$report_query->close();

	// Update the DB entry (just to "quick" save)
	$mysqli->query("UPDATE `status` SET `last_added_id` = '".$mysqli->real_escape_string($last_whisper_reports_ID)."' WHERE `ID` = '6' ");
} while ($found_data === true);
// ------------------------------------------------------------------------------------------------------------------------------------------------------

echo PHP_EOL.'Done!'.PHP_EOL;

