<?php
// üäö UTF8-FTW
echo date('r => ').'Script started!'.PHP_EOL;

$redis = new Redis();
if($redis->connect('better-desk.8rs2gm.0001.usw1.cache.amazonaws.com', 6379, 2.5) === false)
{
	echo date('r => ').'Couldn\'t connect to redis!'.PHP_EOL;
	exit();
}
else
{
	echo date('r => ').'Connection to redis done!'.PHP_EOL;
	$redis->setOption(Redis::OPT_SERIALIZER, Redis::SERIALIZER_PHP);
}

run_start:
$run = true;
// First connect to redis to check if we want to run or not
while($run === true)
{
	$redis_response = $redis->get('twitch-desk-option:rootonline_push');
	if($redis_response === false)
	{
		echo date('r => ').'Disabled via setting atm ... sleeping for 10 seconds'.PHP_EOL;
		sleep(10);
	}
	elseif($redis_response === true)
	{
		// Connect to rootonline via pop3
		$imap = imap_open('{62.141.37.142:110/pop3/novalidate-cert}INBOX', 'twitch_reportmails', 'DsRJ_9dyyR9h_vhjWrAH6usT', CL_EXPUNGE);
		if($imap === false)
		{
			echo date('r => ').'POP3: connect error ('.imap_last_error().')'.PHP_EOL;
			sleep(10);
			goto run_start;
		}
		else
		{
			echo date('r => ').'POP3: connection up and running!'.PHP_EOL;
		}

		$imap_message_count = imap_num_msg($imap);
		if($imap_message_count === false)
		{
			echo date('r => ').'IMAP: imap_check == false ===> exit()'.PHP_EOL;
			sleep(10);
			exit();
		}

		echo date('r => ').'IMAP: Current imap message count: '.$imap_message_count.PHP_EOL;
		if($imap_message_count == 0)
		{
			// All emails are already imported
			echo date('r => ').'No new emails to import atm ... sleeping 10 seconds ...'.PHP_EOL;
			imap_close($imap, CL_EXPUNGE);
			for($i = 10; $i > 0; $i--)
			{
				echo date('r => ').'Sleep: Script goes on in '.$i.PHP_EOL;
				sleep(1);
			}
			goto run_start;
		}

		for($imap_message_number_start = 0; $imap_message_number_start < $imap_message_count; $imap_message_number_start = $imap_message_number_start + 250)
		{
			if($imap_message_number_start == 0)
			{
				$imap_message_number_start = 1;
			}
			$imap_message_number = $imap_message_number_start;
			$imap_until_number = $imap_message_number_start + 249;
			if($imap_until_number > $imap_message_count)
			{
				$imap_until_number = $imap_message_count;
			}

			$imap_fetch_overview_start_time = microtime(true);
			echo date('r => ').'IMAP: imap_fetch_overview: '.$imap_message_number_start.':'.$imap_until_number.PHP_EOL;
			$imap_result = imap_fetch_overview($imap, $imap_message_number_start.':'.$imap_until_number, 0);
			if(count($imap_result) == 0)
			{
				echo date('r => ').'IMAP: Imap_fetch_overwiev result count is 0'.PHP_EOL;
				sleep(10);
				exit();
			}
			echo 'IMAP fetch overview time: '.round(microtime(true) - $imap_fetch_overview_start_time, 4).' seconds'.PHP_EOL;

			foreach($imap_result as $imap_header)
			{
				// Check if the messageID is already listed in redis
				echo date('r => ').'Checking redis for: '.'twitch-desk-case-messageID:'.$imap_header->message_id.PHP_EOL;
				$redis_response = $redis->exists('twitch-desk-case-messageID:'.$imap_header->message_id);
				if($redis_response === false)
				{
					// Only insert the mail if it's a report
					if(strpos($imap_header->subject, 'Abuse report concerning ') !== false || strpos($imap_header->subject, 'Strike concerning ') !== false)
					{
						echo date('r => ').$imap_message_number.' ('.$imap_header->uid.')/'.$imap_message_count.' -> '.$imap_header->date.' => '.$imap_header->subject.PHP_EOL;

						// Get message structure info for encoding and stuff
						$imap_message_structure_start_time = microtime(true);
						$imap_message_structure = imap_fetchstructure($imap, $imap_header->uid, FT_UID);
						if($imap_message_structure === false)
						{
							echo date('r => ').'IMAP: imap_message_structure == false => exit()'.PHP_EOL;
							sleep(10);
							exit();
						}
						// Get mail body
						$imap_mail_body = imap_body($imap, $imap_header->uid, FT_UID);
						// Depending on the encoding we need to do stuff first to get in in text form
						if($imap_message_structure->encoding == 3 /* BASE64 */)
						{
							$imap_mail_body = base64_decode($imap_mail_body);
						}
						elseif($imap_message_structure->encoding == 4 /* QUOTED-PRINTABLE */)
						{
							$imap_mail_body = quoted_printable_decode($imap_mail_body);
						}

						if(empty($imap_mail_body))
						{
							echo date('r => ').'IMAP: imap_mail_body is empty!'.PHP_EOL;
							sleep(10);
							exit();
						}
						echo 'IMAP fetch time: '.round(microtime(true) - $imap_message_structure_start_time, 4).' seconds'.PHP_EOL;


						// Send the report to desk now
						$post_array = array();
						$post_array['type'] = 'email';
						$post_array['subject'] = $imap_header->subject;
						$post_array['status'] = 'new';
						$post_array['_links']['customer']['href'] = '/api/v2/customers/297808280';
						$post_array['_links']['customer']['class'] = 'customer';
						$post_array['_links']['assigned_group']['href'] = '/api/v2/groups/396524';
						$post_array['_links']['assigned_group']['class'] = 'group';
						$post_array['message']['direction'] = 'in';
						$post_array['message']['status'] = 'received';
						$post_array['message']['to'] = 'report@twitch.tv';
						$post_array['message']['from'] = 'report-script@rootonline.de';
						$post_array['message']['subject'] = $imap_header->subject;
						$post_array['message']['body'] = json_encode(array('Message-ID' => $imap_header->message_id, 'Date' => $imap_header->date))."\r\n\r\n".$imap_mail_body;
						$post_array['message']['created_at'] = date('c', strtotime($imap_header->date));
						$post_array['message']['suppress_rules'] = false;

						// Add to redis queue
						$redis->rPush('desk_insert_queue', array('post_array' => $post_array, 'Message-ID' => $imap_header->message_id, 'Date' => $imap_header->date));
						echo date('r => ').'REDIS: Added the case to the redis queue'.PHP_EOL;
						imap_delete($imap, $imap_header->uid, FT_UID);

						// Just to be safe remove the mail after it's done
						unset($imap_mail_body, $imap_message_structure, $post_array);
					}
					elseif(strpos($imap_header->subject, 'Clip report concerning ') !== false)
					{
						// A clip report
						echo date('r => ').$imap_message_number.' ('.$imap_header->uid.')/'.$imap_message_count.' -> '.$imap_header->date.' => '.$imap_header->subject.PHP_EOL;

						// Get message structure info for encoding and stuff
						$imap_message_structure_start_time = microtime(true);
						$imap_message_structure = imap_fetchstructure($imap, $imap_header->uid, FT_UID);
						if($imap_message_structure === false)
						{
							echo date('r => ').'IMAP: imap_message_structure == false => exit()'.PHP_EOL;
							sleep(10);
							exit();
						}
						// Get mail body
						$imap_mail_body = imap_fetchbody($imap, $imap_header->uid, '1', FT_UID); // To only get the TEXT and not the HTML part
						// Depending on the encoding we need to do stuff first to get in in text form
						if($imap_message_structure->parts[0]->encoding == 3 /* BASE64 */)
						{
							$imap_mail_body = base64_decode($imap_mail_body);
						}
						elseif($imap_message_structure->parts[0]->encoding == 4 /* QUOTED-PRINTABLE */)
						{
							$imap_mail_body = quoted_printable_decode($imap_mail_body);
						}

						if(empty($imap_mail_body))
						{
							echo date('r => ').'IMAP: imap_mail_body is empty!'.PHP_EOL;
							sleep(10);
							exit();
						}
						echo 'IMAP fetch time: '.round(microtime(true) - $imap_message_structure_start_time, 4).' seconds'.PHP_EOL;


						// Send the report to desk now
						$post_array = array();
						$post_array['type'] = 'email';
						$post_array['subject'] = $imap_header->subject;
						$post_array['status'] = 'new';
						$post_array['_links']['customer']['href'] = '/api/v2/customers/297808280';
						$post_array['_links']['customer']['class'] = 'customer';
						$post_array['_links']['assigned_group']['href'] = '/api/v2/groups/599060';
						$post_array['_links']['assigned_group']['class'] = 'group';
						$post_array['message']['direction'] = 'in';
						$post_array['message']['status'] = 'received';
						$post_array['message']['to'] = 'report@twitch.tv';
						$post_array['message']['from'] = 'report-script@rootonline.de';
						$post_array['message']['subject'] = $imap_header->subject;
						$post_array['message']['body'] = json_encode(array('Message-ID' => $imap_header->message_id, 'Date' => $imap_header->date))."\r\n\r\n".$imap_mail_body;
						$post_array['message']['created_at'] = date('c', strtotime($imap_header->date));
						$post_array['message']['suppress_rules'] = false;

						// Add to redis queue
						$redis->rPush('desk_insert_queue', array('post_array' => $post_array, 'Message-ID' => $imap_header->message_id, 'Date' => $imap_header->date));
						echo date('r => ').'REDIS: Added the case to the redis queue'.PHP_EOL;
						imap_delete($imap, $imap_header->uid, FT_UID);

						// Just to be safe remove the mail after it's done
						unset($imap_mail_body, $imap_message_structure, $post_array);
					}
					else
					{
						echo date('r => ').'Subject: "'.$imap_header->subject.'" is not a report or strike!'.PHP_EOL;
						imap_delete($imap, $imap_header->uid, FT_UID);
					}
				}
				else
				{
					echo date('r => ').'Email: '.$imap_header->message_id.' already exists in redis'.PHP_EOL;
					imap_delete($imap, $imap_header->uid, FT_UID);
				}
				unset($redis_response);
				$imap_message_number++;

				// Check if I should keep this script running
				$redis_response = $redis->get('twitch-desk-option:rootonline_push');
				if($redis_response === false)
				{
					echo date('r => ').'Setting tells me to stop this script!'.PHP_EOL.PHP_EOL;
					exit();
				}
				unset($redis_response);
			}
		}
		echo date('r => ').'Closing connection and expunging done reports ...'.PHP_EOL;
		imap_close($imap, CL_EXPUNGE);
		echo date('r => ').'^ Done'.PHP_EOL;
	}
}

?>