<?php
// üäö UTF8-FTW
echo date('r => ').'Script started!'.PHP_EOL;

$DESK_API_KEY = 'QIpVTAyrppviIfEKg5Nj';
$DESK_API_SECRET = 'fM3KQ8MUovELgKofqA4l4HVZgdnSIJxrb1S9Ht1E';
$DESK_oauth_token = 'm7v9wufXtN8J8aqD302g';
$DESK_oauth_token_secret = '4Pu2VuvqWDC944muwv4xgKO07d0XxweHu5SBnvBQ';
try {
	$global_oauth = new OAuth($DESK_API_KEY, $DESK_API_SECRET, OAUTH_SIG_METHOD_HMACSHA1);
	$global_oauth->setToken($DESK_oauth_token, $DESK_oauth_token_secret);
	} catch(OAuthException $E) {
		print_r($E);
		exit();
	}
$desk_rate_limit = array();

function parse_desk_curl_output($curl_output)
{
	$curl_explode = explode("\r", $curl_output);
	$is_still_header = true;
	$header = '';
	$content = '';
	$header_array = array();
	// Split into header and content
	foreach($curl_explode as $row)
	{
		if($is_still_header === true)
		{
			if($row != "\r" && $row != "\r\n" && $row != '' && $row != "\n")
			{
				$header .= trim($row).PHP_EOL;
				$header_array[] = trim($row);
			}
			else
			{
				// It wasn't a normal header therefor we are now at the border to content
				$is_still_header = false;
			}
		}
		else
		{
			// If it's not the header it's the content
			$content .= trim($row).PHP_EOL;
		}
	}
	
	// Parse headers into an array
	$header_array_parsed = array();
	for($i = 0; $i < count($header_array); $i++)
	{
		if($i == 0)
		{
			// First line in HTTP is always the HTTP status code
			// Example: HTTP/1.1 200 OK
			$pos = strpos($header_array[$i], ' ');
			if($pos !== false)
			{
				$header_array_parsed['HTTP_CODE'] = substr($header_array[$i], ($pos+1));
			}
			else
			{
				echo 'Error while parsing HTTP header 0! ('.$header_array[$i].')'.PHP_EOL;
			}
		}
		else
		{
			// Example: X-Rate-Limit-Limit: 300
			$pos = strpos($header_array[$i], ': ');
			if($pos !== false)
			{
				$header_array_parsed[substr($header_array[$i], 0, $pos)] = substr($header_array[$i], ($pos+2));
			}
			else
			{
				echo 'Error while parsing HTTP headers > 0! ('.$header_array[$i].')'.PHP_EOL;
			}
		}	
	}
	
	// Add the new rate limit info to the global variable
	if(isset($header_array_parsed['X-Rate-Limit-Remaining']) && isset($header_array_parsed['X-Rate-Limit-Reset']))
	{
		$GLOBALS['desk_rate_limit']['X-Rate-Limit-Remaining'] = $header_array_parsed['X-Rate-Limit-Remaining'];
		$GLOBALS['desk_rate_limit']['X-Rate-Limit-Reset'] = $header_array_parsed['X-Rate-Limit-Reset'];
	
		$GLOBALS['desk_rate_limit']['last_request_time'] = time();
	}
	
	// Return the parsed info as array
	return array('header' => $header, 'content' => $content, 'header_array' => $header_array, 'header_array_parsed' => $header_array_parsed);
}

function check_desk_rate_limit()
{
	if($GLOBALS['desk_rate_limit']['X-Rate-Limit-Remaining'] > 0)
	{
		// No rate limit in sight so good to go
		echo date('r => ').'RATE LIMIT: Nope => '.$GLOBALS['desk_rate_limit']['X-Rate-Limit-Remaining'].' remaining'.PHP_EOL;
		return false;
	}
	else
	{
		// Can't make it now so sleep a bit (maybe)
		$sleep_time = $GLOBALS['desk_rate_limit']['X-Rate-Limit-Reset'] - (time() - $GLOBALS['desk_rate_limit']['last_request_time'] - 1);
		if($sleep_time > 0)
		{
			echo date('r => ').'RATE LIMIT: Sleeping '.$sleep_time.' seconds because of DESK rate limit!'.PHP_EOL;
			for($i = $sleep_time; $i > 0; $i--)
			{
			    echo date('r => ').'Sleep: Script goes on in '.$i.PHP_EOL;
			    sleep(1);
			}
			return true;
		}
		else
		{
			return false;
		}
	}
}

$ch = curl_init();
curl_setopt($ch, CURLOPT_TIMEOUT, 20);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
// curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/json', 'Content-Type: application/json'));
curl_setopt($ch, CURLOPT_URL, 'https://help.twitch.tv/api/v2/cases');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_ENCODING, '');
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
curl_setopt($ch, CURLOPT_AUTOREFERER, false);
curl_setopt($ch, CURLOPT_USERAGENT, 'Better Desk by commanderroot@twitch.tv');
// SSL stuff
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
curl_setopt($ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);
// TCP NO DELAY
// curl_setopt($ch, CURLOPT_TCP_NODELAY, 1);
curl_setopt($ch, CURLOPT_HEADER, true);


$redis = new Redis();
if($redis->connect('better-desk.8rs2gm.0001.usw1.cache.amazonaws.com', 6379, 0) === false)
{
	echo date('r => ').'Couldn\'t connect to redis!'.PHP_EOL;
	exit();
}
else
{
	echo date('r => ').'Connection to redis done!'.PHP_EOL;
	$redis->setOption(Redis::OPT_SERIALIZER, Redis::SERIALIZER_PHP);	
}

$run = true;
// First connect to redis to check if we want to run or not
while($run === true)
{
	$redis_response = $redis->get('twitch-desk-option:rootonline_push');
	if($redis_response === false)
	{
		echo date('r => ').'Disabled via setting atm ... sleeping for 10 seconds'.PHP_EOL;
		sleep(10);
	}
	elseif($redis_response === true)
	{
		// Check if desk_insert_queue has something for us to do
		// Check how long the queue is
		$redis_queue_length = $redis->lLen('desk_insert_queue');
		echo date('r => ').'Current queue length: '.$redis_queue_length.PHP_EOL;
		if($redis_queue_length == 0)
		{
			echo date('r => ').'Nothing in queue atm ... waiting 30 sec for new entry'.PHP_EOL;
		}
		$redis_queue_response = $redis->blPop('desk_insert_queue', 30);
		if($redis_queue_response === false || count($redis_queue_response) == 0)
		{
			echo date('r => ').'Nothing in queue atm ...'.PHP_EOL;
			// sleep(5);
		}
		else
		{
			// Check if it's already in DESK
			echo date('r => ').'Checking redis for: '.'twitch-desk-case-messageID:'.$redis_queue_response[1]['Message-ID'].PHP_EOL;
			$redis_response = $redis->exists('twitch-desk-case-messageID:'.$redis_queue_response[1]['Message-ID']);
			if($redis_response === false)
			{
				// Create a new redis case
				$post_array_encoded = json_encode($redis_queue_response[1]['post_array']);
			
				curl_setopt($ch, CURLOPT_POSTFIELDS, $post_array_encoded);
				check_desk_rate_limit:
				// Oauth header
				$oauth_request_header = $global_oauth->getRequestHeader('POST', 'https://help.twitch.tv/api/v2/cases');
				curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/json', 'Content-Type: application/json', 'Authorization: '.$oauth_request_header));
				check_desk_rate_limit();
				$curl_exec_start_time = microtime(true);
				$curl_output = curl_exec($ch);
				$curl_info = curl_getinfo($ch);
				if($curl_output === false)
				{
					echo date('r => ').'Curl error on "'.$curl_info['url'].'" => '.curl_error($ch).PHP_EOL;
					// Do it again (Most likely a timeout)
					goto check_desk_rate_limit;
				}
				else
				{
					$curl_parse = parse_desk_curl_output($curl_output);
					// log_output("CURL: CURL_PARSE:".PHP_EOL.print_r($curl_parse, true), 10);

					if($curl_info['http_code'] >= 200 && $curl_info['http_code'] <= 204)
					{
						// Request was successful
					}
					elseif($curl_info['http_code'] == 304)
					{
						// Never happens as I don't use ETAG's but if I did it would be successful
					}
					elseif($curl_info['http_code'] == 429)
					{
						echo date('r => ').'DESK: hit rate limit on URL: '.$curl_info['url'].PHP_EOL;
						// Rate limited
						usleep(1000 * 1000);
						goto check_desk_rate_limit;
					}
					elseif($curl_info['http_code'] == 422)
					{
						echo date('r => ').'CURL HTTP error 422 while creating a case'.PHP_EOL.print_r($curl_parse, true).PHP_EOL;
						// Redo request
						usleep(1000 * 1000);
						goto check_desk_rate_limit;
					}
					elseif($curl_info['http_code'] == 409)
					{
						echo date('r => ').'DESK: Conflict: '.$curl_info['url'].PHP_EOL.print_r($curl_parse, true).PHP_EOL;
						// Redo request
						usleep(1000 * 1000);
						goto check_desk_rate_limit;
					}
					elseif($curl_info['http_code'] == 401)
					{
						echo date('r => ').'DESK: Unauthorized: '.$curl_info['url'].PHP_EOL.print_r($curl_parse, true).PHP_EOL;
						// Readd it to the queue
						$redis->rPush('desk_insert_queue', $redis_queue_response[1]);
						exit();
					}
					else
					{
						// Some other HTTP error => Try again
						echo date('r => ').'CURL: HTTP ERROR: '.$curl_info['url'].PHP_EOL.print_r($curl_parse, true).PHP_EOL;
						// Wait a bit before trying again (just so we don't spam Desk in case it's down / 503 / 502 etc)
						usleep(2000 * 1000);
						goto check_desk_rate_limit;
					}

					// Parse response
					$json_decode = json_decode($curl_parse['content'], true);
					if($json_decode !== NULL)
					{
						if(isset($json_decode['id']))
						{
								echo date('r => ').'DESK: case successful created with ID: '.$json_decode['id'].' in '.round(microtime(true) - $curl_exec_start_time, 4).' seconds'.PHP_EOL;
						
								// Add the case directly into redis for caching
								$case_cache_array = array();
								$case_cache_array['created_at'] = $json_decode['created_at'];
								$case_cache_array['body_text'] = NULL;
								$case_cache_array['body'] = ltrim(substr($redis_queue_response[1]['post_array']['message']['body'], strpos($redis_queue_response[1]['post_array']['message']['body'], "\r\n\r\n")));
								$case_cache_array['headers'] = array('Message-ID' => $redis_queue_response[1]['Message-ID'], 'Date' => $redis_queue_response[1]['Date']);
								$case_cache_array['subject'] = $redis_queue_response[1]['post_array']['subject'];

								$redis->set('twitch-desk-case:'.$json_decode['id'], $case_cache_array, array('nx', 'ex' => (8 * 60 *60)));
								unset($case_cache_array);
								echo date('r => ').'REDIS: Added the case to the redis cache'.PHP_EOL;
						}
						else
						{
							// Do it again
							echo date('r => ').'DESK: had an error while creating a case (Empty ID in response)'.PHP_EOL;
							goto check_desk_rate_limit;
						}
					}
					else
					{
						echo date('r => ').'CURL: Json decode error while creating new case'.PHP_EOL;
						goto check_desk_rate_limit;
					}
				}
				unset($post_array_encoded);
			}
			else
			{
				echo date('r => ').'Email: '.$redis_queue_response[1]['Message-ID'].' already exists in redis'.PHP_EOL;
			}
		}
		unset($redis_queue_response);
	}
}

?>