"use strict";

if(navigator.userAgent.toLowerCase().indexOf('firefox') > -1) {
  /* Handle paste events */
  function pasteHandler(e) {
    // We need to check if event.clipboardData is supported (Chrome)
    if (e.clipboardData) {
      // Get the items from the clipboard
      var items = e.clipboardData.items;
        if (items) {
        // Loop through all items, looking for any kind of image
        for (var i = 0; i < items.length; i++) {
          if (items[i].type.indexOf("image") !== -1) {
             // We need to represent the image as a file,
             var blob = items[i].getAsFile();
             // and use a URL or webkitURL (whichever is available to the browser)
             // to create a temporary URL to the object
             var URLObj = window.URL || window.webkitURL;
             var source = URLObj.createObjectURL(blob);

             // The URL can then be used as the source of an image
             createImage(source);
          }
        }
      }
    }
    // This is a cheap trick to make sure we read the data
    // AFTER it has been inserted.
    setTimeout(checkInput, 1);
  }

  /* Parse the input in the paste catcher element */
  function checkInput() {
    var pasteCatcher = document.getElementById("paste_area");
    // Store the pasted content in a variable
    var child = pasteCatcher.childNodes[0];
    console.log(child.src);
    // Clear the inner html to make sure we're always
    // getting the latest inserted content
    pasteCatcher.innerHTML = "";

    document.getElementById('image_paste').value = child.src;
    document.getElementById('pasted_image').src = child.src;
    document.getElementById("paste_area").remove();
  }

  /* Creates a new image from a given source */
  function createImage(source) {
    var pastedImage = new Image();
    pastedImage.onload = function() {
      // You now have the image!
    }
    pastedImage.src = source;
  }

  // Add the paste event listener
  window.addEventListener("paste", pasteHandler);
}


window.onload=function() {
  if(navigator.userAgent.toLowerCase().indexOf('firefox') > -1) {
    // Nothing
  } else {
    // Chrome which is working
    document.getElementById('paste_area').onpaste = function (event) {
      // use event.originalEvent.clipboard for newer chrome versions
      var items = (event.clipboardData  || event.originalEvent.clipboardData).items;
      // console.log(JSON.stringify(items)); // will give you the mime types
      // find pasted image among pasted items
      var blob;
      for (var i = 0; i < items.length; i++) {
        if (items[i].type.indexOf("image") === 0) {
          blob = items[i].getAsFile();
        }
      }
      // load image if there is a pasted image
      if (blob !== null) {
        var reader = new FileReader();
        reader.onload = function(event) {
          // console.log(event.target.result); // data url!
          document.getElementById('image_paste').value = event.target.result;
          document.getElementById('pasted_image').src = event.target.result;
          document.getElementById("paste_area").remove();
        };
        reader.readAsDataURL(blob);
      }
    }
  }
}

$(document).ready(function () {
  $(document).keypress(function(ev) {
    if (ev.keyCode == 13) {
      $('input[type="submit"]').click();
    }
  });
});
