function resolve_report(report_id) {
  $.ajax({
    url: "/reports/" + report_id,
    type: "PATCH",
    timeout: 10000, // sets timeout to 10 seconds
    data: { do_action: "resolve", authenticity_token: $("meta[name=csrf-token]").attr("content") },
    success: function(result, textStatus, jqXHR) {
      $("#assign_and_resolve_" + report_id).html("Report resolved.");
    },
    error: function(jqXHR, textStatus, errorThrown) {
      // Try again
      $("#assign_and_resolve_" + report_id).html(errorThrown + '... Try again');
      $("#assign_and_resolve_" + report_id).removeAttr('disabled');
    }
  });

  $("#assign_and_resolve_" + report_id).html('Resolving ...');
  $("#assign_and_resolve_" + report_id).attr("disabled", "disabled");
  $("#assign_to_staff_" + report_id).attr("disabled", "disabled");
}


function assign_to_staff_for_escalation(report_id) {
  $.ajax({
    url: "/reports/" + report_id,
    type: "PATCH",
    timeout: 10000, // sets timeout to 10 seconds
    data: { do_action: "staff_escalation", authenticity_token: $("meta[name=csrf-token]").attr("content") },
    success: function(result, textStatus, jqXHR) {
      $("#assign_to_staff_" + report_id).html("Report assigned to staff.");
    },
    error: function(jqXHR, textStatus, errorThrown) {
      // Try again
      $("#assign_to_staff_" + report_id).html(errorThrown + '... Try again');
      $("#assign_to_staff_" + report_id).removeAttr('disabled');
    }
  });

  $("#assign_to_staff_" + report_id).html('Assigning ...');
  $("#assign_to_staff_" + report_id).attr("disabled", "disabled");
  $("#assign_and_resolve_" + report_id).attr("disabled", "disabled");
}

function assign_to_staff_for_pm_check(report_id) {
  $.ajax({
    url: "/reports/" + report_id,
    type: "PATCH",
    timeout: 10000, // sets timeout to 10 seconds
    data: { do_action: "pm_check", authenticity_token: $("meta[name=csrf-token]").attr("content") },
    success: function(result, textStatus, jqXHR) {
      $("#assign_to_staff_" + report_id).html("Report assigned for pm check.");
    },
    error: function(jqXHR, textStatus, errorThrown) {
      // Try again
      $("#assign_to_staff_" + report_id).html(errorThrown + '... Try again');
      $("#assign_to_staff_" + report_id).removeAttr('disabled');
    }
  });

  $("#assign_to_staff_" + report_id).html('Assigning ...');
  $("#assign_to_staff_" + report_id).attr("disabled", "disabled");
  $("#assign_and_resolve_" + report_id).attr("disabled", "disabled");
}

function assign_to_check_later(report_id) {
  $.ajax({
    url: "/reports/" + report_id,
    type: "PATCH",
    timeout: 10000, // sets timeout to 10 seconds
    data: { do_action: "check_later", authenticity_token: $("meta[name=csrf-token]").attr("content") },
    success: function(result, textStatus, jqXHR) {
      $("#assign_to_staff_" + report_id).html("Report moved to check later.");
    },
    error: function(jqXHR, textStatus, errorThrown) {
      // Try again
      $("#assign_to_staff_" + report_id).html(errorThrown + '... Try again');
      $("#assign_to_staff_" + report_id).removeAttr('disabled');
    }
  });

  $("#assign_to_staff_" + report_id).html('Assigning ...');
  $("#assign_to_staff_" + report_id).attr("disabled", "disabled");
  $("#assign_and_resolve_" + report_id).attr("disabled", "disabled");
}

function assign_to_admin(report_id) {
  if($("#assign_to_admin_select_" + report_id).val() != "") {
    $.ajax({
      url: "/reports/" + report_id,
      type: "PATCH",
      timeout: 10000, // sets timeout to 10 seconds
      data: { do_action: "assign_to_admin", assign_to: $("#assign_to_admin_select_" + report_id).val(), authenticity_token: $("meta[name=csrf-token]").attr("content") },
      success: function(result, textStatus, jqXHR) {
        if(result.error === false) {
          $("#assign_to_admin_" + report_id).html("Report assigned.");
        } else {
          $("#assign_to_admin_" + report_id).text(result.error_message);
        }
      },
      error: function(jqXHR, textStatus, errorThrown) {
        // Try again
        $("#assign_to_admin_" + report_id).html(errorThrown);
      }
    });

    $("#assign_to_admin_" + report_id).html('Assigning ...');
  }
}

function show_report_comment_create_area() {
  $("#create_new_report_comment_area").css({"display": "block"});
}
