class BanExceptionsController < ApplicationController
  # Let only people with manage_ban_exceptions permission do stuff
  before_action :require_manage_ban_exceptions_permission


  def index
    @ban_exceptions = BanException.order(id: :asc)
  end

  def new
    @ban_exception = BanException.new
  end

  def create
    ban_exception = BanException.new(ban_exception_create_params)

    if ban_exception.target_user_id.blank? && params[:username] && !params[:username].blank?
      # Find id by username
      begin
        target_user = ::TwitchUsersService.get_user_by_username(params[:username])

        if target_user.nil?
          flash[:danger] = "Username not found"
          redirect_to(ban_exceptions_path) and return
        end

        ban_exception.target_user_id = target_user["id"] unless target_user.nil?
      rescue Exception => e
        flash[:danger] = e.message
        redirect_to(ban_exceptions_path) and return
      end
    end

    # Check if a ban exception for this user_id already exists
    unless BanException.find_by(target_user_id: ban_exception.target_user_id)
      ban_exception.created_by = current_user.id

      if ban_exception.save
          # All went well
          flash[:success] = "The ban exception was successfully created."

          audit = {}
          audit[:target_user_id] = ban_exception.target_user_id
          audit[:reason] = ban_exception.reason
          # Add audit entry
          BanExceptionAudit.new(action: "create", action_by: current_user.id, content: audit.to_json, remote_ip: request.remote_ip).save
      else
        # Some error
        flash[:danger] = "There was an error creating the ban exception."
      end
    else
      flash[:danger] = "This user is already on the ban exception list."
    end
    redirect_to(ban_exceptions_path)
  end

  def destroy
    audit = {}
    ban_exception = BanException.find_by(id: params[:id])
    if ban_exception
      if params[:delete_reason] && !params[:delete_reason].blank?
        audit[:target_user_id] = ban_exception.target_user_id
        audit[:delete_reason] = params[:delete_reason]

        ban_exception.destroy!
        flash[:success] = "The ban exception was successfully deleted."

        # Add audit entry
        BanExceptionAudit.new(action: "delete", action_by: current_user.id, content: audit.to_json, remote_ip: request.remote_ip).save
      else
        flash[:danger] = "No delete reason provided."
      end
    else
      flash[:danger] = "The file you want to delete doesn't exist."
    end
    redirect_to(ban_exceptions_path)
  end

  def audits
    @ban_exception_audits = BanExceptionAudit.order(id: :desc).paginate(page: params[:page])
  end


  private

    def ban_exception_create_params
      params.require(:ban_exception).permit(
        :target_user_id,
        :reason
        )
    end

    def require_manage_ban_exceptions_permission
      unless current_user && current_user.has_permission_to?(:manage_ban_exceptions)
        render 'shared/_no_permission' and return
      end
    end
end
