class ReportAdminsController < ApplicationController
  # Let only people with view_reports permission do stuff
  before_action :require_view_reports_permission
  # Always return the current ReportVersion via the header
  after_action :return_report_version_via_header
  # Let only people with view_report_admin_history view the history
  before_action :require_view_report_admin_history_permission, only: [:index]

  def index
    @report_admins = ReportAdmin.order(id: :desc).paginate(page: params[:page])
  end

  def create
    # Check if this current user is already active
    report_admin = ReportAdmin.find_by(admin_id: current_user.id, disabled_at: nil)
    if report_admin
      render(json: { status: 422, message: "You are already set as an active admin."}, :status => 200) and return
    end

    # Create a new entry
    new_report_admin = ReportAdmin.new(admin_id: current_user.id, admin_weight: 10)
    if new_report_admin.save
      # Update report version because distribution changed
      $redis.set("reports:report_version", Time.now.to_i)

      render(json: { status: 200, message: "You are now in the active admin list.", active_admins: active_admins()}, :status => 200) and return
    else
      render(json: { status: 500, message: "You broke something."}, :status => 200) and return
    end
  end

  def update
    report_admin = ReportAdmin.find_by(id: params[:id])
    if report_admin
      # Check action type
      if params[:do_action] && params[:do_action] == "disable"
        # Check if it's still active
        if report_admin.disabled_at.nil?
          report_admin.disabled_at = Time.now
          report_admin.disabled_by = current_user.id
          if report_admin.save
            # Update report version because distribution changed
            $redis.set("reports:report_version", Time.now.to_i)

            render(json: { status: 200, message: "#{User.find_by(id: report_admin.admin_id).email} was successfully removed from active admin list.", active_admins: active_admins()}, :status => 200) and return
          else
            render(json: { status: 500, message: "You broke it."}, :status => 200) and return
          end
        else
          render(json: { status: 404, message: "This admin isn't active anyway."}, :status => 200) and return
        end
      elsif params[:do_action] && params[:do_action] == "modify_weight"
        if params[:weight] && params[:weight].to_i > 0 && params[:weight].to_i <= 100
          if report_admin.disabled_at.nil?
            # First disable the old one
            report_admin.disabled_at = Time.now
            report_admin.disabled_by = current_user.id

            if report_admin.save
              # Create a new one with the new weight
              new_report_admin = ReportAdmin.new(admin_id: report_admin.admin_id, admin_weight: params[:weight].to_i)
              if new_report_admin.save
                # Update report version because distribution changed
                $redis.set("reports:report_version", Time.now.to_i)

                render(json: { status: 200, message: "The new weight for #{User.find_by(id: report_admin.admin_id).email} is set to #{params[:weight]}.", active_admins: active_admins()}, :status => 200) and return
              else
                render(json: { status: 500, message: "You broke something real bad."}, :status => 200) and return
              end
            else
              render(json: { status: 500, message: "You broke something bad."}, :status => 200) and return
            end
          else
            render(json: { status: 422, message: "You can't change the weight of inactive admins."}, :status => 200) and return
          end
        else
          render(json: { status: 422, message: "Invalid weight submitted."}, :status => 200) and return
        end
      else
        render(json: { status: 422, message: "Unknown action."}, :status => 200) and return
      end
    else
      render(json: { status: 404, message: "This entry doesn't exist."}, :status => 200) and return
    end
  end


  private

    def active_admins
      active_admins = []
      db_active_admins = ReportAdmin.where(disabled_at: nil)

      # Get all admin emails for the IDs
      if db_active_admins.length > 0
        user_ids = []
        db_active_admins.each do |admin|
          user_ids << admin.admin_id
        end
        user_ids = user_ids.uniq

        admins = User.where(id: user_ids).pluck(:id, :email)
        admin_emails = {}
        admins.each do |admin|
          admin_emails[admin[0]] = admin[1]
        end
      end

      db_active_admins.each do |admin|
        active_admins << {
          id: admin.id,
          admin_id: admin.admin_id,
          admin_username: admin_emails[admin.admin_id],
          admin_weight: admin.admin_weight
        }
      end

      active_admins
    end

    def require_view_reports_permission
      unless current_user && current_user.has_permission_to?(:view_reports)
        render 'shared/_no_permission' and return
      end
    end

    def require_view_report_admin_history_permission
      unless current_user && current_user.has_permission_to?(:view_report_admin_history)
        render 'shared/_no_permission' and return
      end
    end

    def return_report_version_via_header
      redis_report_version = $redis.get("reports:report_version")
      response.headers["X-Report-Version"] = redis_report_version if redis_report_version
      return true
    end
end
